/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.impl.score.director.easy.EasyScoreCalculator;
import org.optaplanner.examples.common.app.AbstractTurtleTest;

@RunWith(value=Parameterized.class)
public abstract class SolveAllTurtleTest<Solution_>
extends AbstractTurtleTest {
    private static final String MOVE_THREAD_COUNT_OVERRIDE = System.getProperty("moveThreadCount");
    private final String solverConfigResource;

    public SolveAllTurtleTest(String solverConfigResource) {
        this.solverConfigResource = solverConfigResource;
    }

    protected abstract Solution_ readProblem();

    @Test
    public void runFastAndFullAssert() {
        SolveAllTurtleTest.checkRunTurtleTests();
        SolverConfig solverConfig = this.buildSolverConfig();
        Solution_ problem = this.readProblem();
        problem = this.buildAndSolve(solverConfig, EnvironmentMode.NON_INTRUSIVE_FULL_ASSERT, problem, 2L);
        problem = this.buildAndSolve(solverConfig, EnvironmentMode.FAST_ASSERT, problem, 5L);
        problem = this.buildAndSolve(solverConfig, EnvironmentMode.NON_INTRUSIVE_FULL_ASSERT, problem, 3L);
    }

    protected SolverConfig buildSolverConfig() {
        SolverConfig solverConfig = SolverConfig.createFromXmlResource((String)this.solverConfigResource);
        solverConfig.setTerminationConfig(new TerminationConfig());
        if (MOVE_THREAD_COUNT_OVERRIDE != null) {
            solverConfig.setMoveThreadCount(MOVE_THREAD_COUNT_OVERRIDE);
        }
        return solverConfig;
    }

    protected Solution_ buildAndSolve(SolverConfig solverConfig, EnvironmentMode environmentMode, Solution_ problem, long maximumMinutesSpent) {
        solverConfig.getTerminationConfig().setMinutesSpentLimit(Long.valueOf(maximumMinutesSpent));
        solverConfig.setEnvironmentMode(environmentMode);
        Class<EasyScoreCalculator> easyScoreCalculatorClass = this.overwritingEasyScoreCalculatorClass();
        if (easyScoreCalculatorClass != null && environmentMode.isAsserted()) {
            ScoreDirectorFactoryConfig assertionScoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
            assertionScoreDirectorFactoryConfig.setEasyScoreCalculatorClass(easyScoreCalculatorClass);
            solverConfig.getScoreDirectorFactoryConfig().setAssertionScoreDirectorFactory(assertionScoreDirectorFactoryConfig);
        }
        SolverFactory solverFactory = SolverFactory.create((SolverConfig)solverConfig);
        Solver solver = solverFactory.buildSolver();
        return (Solution_)solver.solve(problem);
    }

    protected Class<? extends EasyScoreCalculator> overwritingEasyScoreCalculatorClass() {
        return null;
    }
}

