/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.exhaustivesearch.ExhaustiveSearchPhaseConfig;
import org.optaplanner.core.config.exhaustivesearch.ExhaustiveSearchType;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.examples.common.app.AbstractPhaseTest;
import org.optaplanner.examples.common.persistence.SolutionDao;

@RunWith(value=Parameterized.class)
public abstract class AbstractExhaustiveSearchTest<Solution_>
extends AbstractPhaseTest<Solution_> {
    protected ExhaustiveSearchType exhaustiveSearchType;

    protected static <Solution_> Collection<Object[]> buildParameters(SolutionDao<Solution_> solutionDao, String ... unsolvedFileNames) {
        return AbstractExhaustiveSearchTest.buildParameters(solutionDao, (Enum[])ExhaustiveSearchType.values(), (String[])unsolvedFileNames);
    }

    protected AbstractExhaustiveSearchTest(File dataFile, ExhaustiveSearchType exhaustiveSearchType) {
        super(dataFile);
        this.exhaustiveSearchType = exhaustiveSearchType;
    }

    @Override
    protected SolverFactory<Solution_> buildSolverFactory() {
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)this.createSolverConfigResource());
        SolverConfig solverConfig = solverFactory.getSolverConfig();
        solverConfig.setTerminationConfig(new TerminationConfig());
        ExhaustiveSearchPhaseConfig exhaustiveSearchPhaseConfig = new ExhaustiveSearchPhaseConfig();
        exhaustiveSearchPhaseConfig.setExhaustiveSearchType(this.exhaustiveSearchType);
        solverConfig.setPhaseConfigList(Arrays.asList(exhaustiveSearchPhaseConfig));
        return solverFactory;
    }
}

