/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.impl.score.director.InnerScoreDirectorFactory;
import org.optaplanner.examples.common.app.LoggingTest;
import org.optaplanner.examples.common.persistence.SolutionDao;

public abstract class SolverPerformanceTest<Solution_>
extends LoggingTest {
    protected SolutionDao<Solution_> solutionDao;

    @Before
    public void setUp() {
        this.solutionDao = this.createSolutionDao();
    }

    protected abstract String createSolverConfigResource();

    protected abstract SolutionDao<Solution_> createSolutionDao();

    protected void runSpeedTest(File unsolvedDataFile, String bestScoreLimitString) {
        this.runSpeedTest(unsolvedDataFile, bestScoreLimitString, EnvironmentMode.REPRODUCIBLE);
    }

    protected void runSpeedTest(File unsolvedDataFile, String bestScoreLimitString, EnvironmentMode environmentMode) {
        SolverFactory<Solution_> solverFactory = this.buildSolverFactory(bestScoreLimitString, environmentMode);
        Object problem = this.solutionDao.readSolution(unsolvedDataFile);
        Solver solver = solverFactory.buildSolver();
        Object bestSolution = solver.solve(problem);
        this.assertBestSolution(solver, bestSolution, bestScoreLimitString);
    }

    protected SolverFactory<Solution_> buildSolverFactory(String bestScoreLimitString, EnvironmentMode environmentMode) {
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)this.createSolverConfigResource());
        solverFactory.getSolverConfig().setEnvironmentMode(environmentMode);
        TerminationConfig terminationConfig = new TerminationConfig();
        terminationConfig.setBestScoreLimit(bestScoreLimitString);
        solverFactory.getSolverConfig().setTerminationConfig(terminationConfig);
        return solverFactory;
    }

    private void assertBestSolution(Solver<Solution_> solver, Solution_ bestSolution, String bestScoreLimitString) {
        Assert.assertNotNull(bestSolution);
        InnerScoreDirectorFactory scoreDirectorFactory = (InnerScoreDirectorFactory)solver.getScoreDirectorFactory();
        Score bestScore = scoreDirectorFactory.getSolutionDescriptor().getScore(bestSolution);
        Score bestScoreLimit = scoreDirectorFactory.getScoreDefinition().parseScore(bestScoreLimitString);
        Assert.assertTrue((String)("The bestScore (" + bestScore + ") must be at least the bestScoreLimit (" + bestScoreLimit + ")."), (bestScore.compareTo((Object)bestScoreLimit) >= 0 ? 1 : 0) != 0);
    }
}

