/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.optaplanner.examples.common.app.LoggingTest;
import org.optaplanner.examples.common.business.ProblemFileComparator;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;

@RunWith(value=Parameterized.class)
public abstract class SolutionImporterTest
extends LoggingTest {
    protected AbstractSolutionImporter solutionImporter;
    protected File importFile;

    protected static Collection<Object[]> getInputFilesAsParameters(AbstractSolutionImporter solutionImporter) {
        File importDir = solutionImporter.getInputDir();
        ArrayList<File> fileList = solutionImporter.isInputFileDirectory() ? new ArrayList<File>(Arrays.asList(importDir.listFiles((FileFilter)DirectoryFileFilter.INSTANCE))) : new ArrayList(FileUtils.listFiles((File)importDir, (String[])new String[]{solutionImporter.getInputFileSuffix()}, (boolean)true));
        Collections.sort(fileList, new ProblemFileComparator());
        ArrayList<Object[]> filesAsParameters = new ArrayList<Object[]>();
        for (File file : fileList) {
            filesAsParameters.add(new Object[]{file});
        }
        return filesAsParameters;
    }

    protected SolutionImporterTest(File importFile) {
        this.importFile = importFile;
    }

    @Before
    public void setUp() {
        this.solutionImporter = this.createSolutionImporter();
    }

    protected abstract AbstractSolutionImporter createSolutionImporter();

    @Test
    public void readSolution() {
        this.solutionImporter.readSolution(this.importFile);
    }
}

