/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nqueens.solver.tracking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.move.MoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.ChangeMoveSelectorConfig;
import org.optaplanner.core.config.localsearch.LocalSearchPhaseConfig;
import org.optaplanner.core.config.localsearch.decider.acceptor.AcceptorConfig;
import org.optaplanner.core.config.localsearch.decider.acceptor.AcceptorType;
import org.optaplanner.core.config.localsearch.decider.forager.LocalSearchForagerConfig;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.solver.DefaultSolver;
import org.optaplanner.examples.nqueens.domain.NQueens;
import org.optaplanner.examples.nqueens.persistence.NQueensGenerator;
import org.optaplanner.examples.nqueens.solver.tracking.NQueensAbstractTrackingTest;
import org.optaplanner.examples.nqueens.solver.tracking.NQueensSolutionInitializer;
import org.optaplanner.examples.nqueens.solver.tracking.NQueensStepTracker;
import org.optaplanner.examples.nqueens.solver.tracking.NQueensStepTracking;

public class NQueensLocalSearchTrackingTest
extends NQueensAbstractTrackingTest {
    private static final int N = 6;

    @ParameterizedTest(name="AcceptorType: {0}")
    @MethodSource(value={"parameters"})
    public void trackLocalSearch(AcceptorConfig acceptorConfig, LocalSearchForagerConfig localSearchForagerConfig, List<NQueensStepTracking> expectedCoordinates) {
        SolverConfig solverConfig = SolverConfig.createFromXmlResource((String)"org/optaplanner/examples/nqueens/solver/nqueensSolverConfig.xml");
        NQueensGenerator generator = new NQueensGenerator();
        NQueens problem = NQueensSolutionInitializer.initialize(generator.createNQueens(6));
        LocalSearchPhaseConfig localSearchPhaseConfig = new LocalSearchPhaseConfig();
        localSearchPhaseConfig.setAcceptorConfig(acceptorConfig);
        localSearchPhaseConfig.setForagerConfig(localSearchForagerConfig);
        localSearchPhaseConfig.getForagerConfig().setBreakTieRandomly(Boolean.valueOf(false));
        localSearchPhaseConfig.setMoveSelectorConfig((MoveSelectorConfig)new ChangeMoveSelectorConfig());
        localSearchPhaseConfig.getMoveSelectorConfig().setSelectionOrder(SelectionOrder.ORIGINAL);
        localSearchPhaseConfig.setTerminationConfig(new TerminationConfig().withStepCountLimit(Integer.valueOf(20)));
        solverConfig.getPhaseConfigList().set(1, localSearchPhaseConfig);
        NQueensStepTracker listener = new NQueensStepTracker();
        SolverFactory solverFactory = SolverFactory.create((SolverConfig)solverConfig);
        DefaultSolver solver = (DefaultSolver)solverFactory.buildSolver();
        solver.addPhaseLifecycleListener((PhaseLifecycleListener)listener);
        NQueens bestSolution = (NQueens)solver.solve((Object)problem);
        Assertions.assertThat((Object)bestSolution).isNotNull();
        this.assertTrackingList(expectedCoordinates, listener.getTrackingList());
    }

    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{new AcceptorConfig().withAcceptorTypeList(Arrays.asList(AcceptorType.HILL_CLIMBING)), new LocalSearchForagerConfig().withAcceptedCountLimit(36), Arrays.asList(new NQueensStepTracking(1, 5), new NQueensStepTracking(0, 1), new NQueensStepTracking(4, 3), new NQueensStepTracking(2, 2), new NQueensStepTracking(3, 5), new NQueensStepTracking(1, 4), new NQueensStepTracking(1, 5), new NQueensStepTracking(1, 4), new NQueensStepTracking(1, 5))});
        params.add(new Object[]{new AcceptorConfig().withAcceptorTypeList(Arrays.asList(AcceptorType.ENTITY_TABU)).withEntityTabuSize(Integer.valueOf(5)), new LocalSearchForagerConfig().withAcceptedCountLimit(36), Arrays.asList(new NQueensStepTracking(1, 5), new NQueensStepTracking(0, 1), new NQueensStepTracking(4, 3), new NQueensStepTracking(2, 2), new NQueensStepTracking(3, 5), new NQueensStepTracking(5, 4), new NQueensStepTracking(1, 4), new NQueensStepTracking(0, 0), new NQueensStepTracking(4, 1))});
        params.add(new Object[]{new AcceptorConfig().withAcceptorTypeList(Arrays.asList(AcceptorType.LATE_ACCEPTANCE)).withLateAcceptanceSize(Integer.valueOf(1)), new LocalSearchForagerConfig().withAcceptedCountLimit(1), Arrays.asList(new NQueensStepTracking(0, 1), new NQueensStepTracking(0, 2), new NQueensStepTracking(0, 1), new NQueensStepTracking(0, 2), new NQueensStepTracking(0, 1), new NQueensStepTracking(0, 2))});
        return params;
    }
}

