/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.investment.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningScore;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.solution.ProblemFactCollectionProperty;
import org.optaplanner.core.api.domain.solution.ProblemFactProperty;
import org.optaplanner.core.api.domain.valuerange.CountableValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRangeFactory;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.investment.domain.AssetClass;
import org.optaplanner.examples.investment.domain.AssetClassAllocation;
import org.optaplanner.examples.investment.domain.InvestmentParametrization;
import org.optaplanner.examples.investment.domain.Region;
import org.optaplanner.examples.investment.domain.Sector;
import org.optaplanner.persistence.xstream.api.score.buildin.hardsoftlong.HardSoftLongScoreXStreamConverter;

@PlanningSolution
@XStreamAlias(value="InvestmentSolution")
public class InvestmentSolution
extends AbstractPersistable {
    private InvestmentParametrization parametrization;
    private List<Region> regionList;
    private List<Sector> sectorList;
    private List<AssetClass> assetClassList;
    private List<AssetClassAllocation> assetClassAllocationList;
    @XStreamConverter(value=HardSoftLongScoreXStreamConverter.class)
    private HardSoftLongScore score;

    @ProblemFactProperty
    public InvestmentParametrization getParametrization() {
        return this.parametrization;
    }

    public void setParametrization(InvestmentParametrization parametrization) {
        this.parametrization = parametrization;
    }

    @ProblemFactCollectionProperty
    public List<Region> getRegionList() {
        return this.regionList;
    }

    public void setRegionList(List<Region> regionList) {
        this.regionList = regionList;
    }

    @ProblemFactCollectionProperty
    public List<Sector> getSectorList() {
        return this.sectorList;
    }

    public void setSectorList(List<Sector> sectorList) {
        this.sectorList = sectorList;
    }

    @ProblemFactCollectionProperty
    public List<AssetClass> getAssetClassList() {
        return this.assetClassList;
    }

    public void setAssetClassList(List<AssetClass> assetClassList) {
        this.assetClassList = assetClassList;
    }

    @PlanningEntityCollectionProperty
    public List<AssetClassAllocation> getAssetClassAllocationList() {
        return this.assetClassAllocationList;
    }

    public void setAssetClassAllocationList(List<AssetClassAllocation> assetClassAllocationList) {
        this.assetClassAllocationList = assetClassAllocationList;
    }

    @PlanningScore
    public HardSoftLongScore getScore() {
        return this.score;
    }

    public void setScore(HardSoftLongScore score) {
        this.score = score;
    }

    @ValueRangeProvider(id="quantityMillisRange")
    public CountableValueRange<Long> getQuantityMillisRange() {
        return ValueRangeFactory.createLongValueRange((long)0L, (long)1001L);
    }

    public long calculateExpectedReturnMicros() {
        long expectedReturnMicros = 0L;
        for (AssetClassAllocation allocation : this.assetClassAllocationList) {
            expectedReturnMicros += allocation.getQuantifiedExpectedReturnMicros();
        }
        return expectedReturnMicros;
    }

    public long calculateStandardDeviationMicros() {
        long squaredFemtos = this.calculateStandardDeviationSquaredFemtos();
        return (long)Math.sqrt(squaredFemtos / 1000L);
    }

    public long calculateStandardDeviationSquaredFemtos() {
        long totalFemtos = 0L;
        for (AssetClassAllocation a : this.assetClassAllocationList) {
            for (AssetClassAllocation b : this.assetClassAllocationList) {
                if (a == b) {
                    totalFemtos += a.getQuantifiedStandardDeviationRiskMicros() * b.getQuantifiedStandardDeviationRiskMicros() * 1000L;
                    continue;
                }
                long correlationMillis = a.getAssetClass().getCorrelationMillisMap().get(b.getAssetClass());
                totalFemtos += a.getQuantifiedStandardDeviationRiskMicros() * b.getQuantifiedStandardDeviationRiskMicros() * correlationMillis;
            }
        }
        return totalFemtos;
    }

    public Map<Region, Long> calculateRegionQuantityMillisTotalMap() {
        HashMap<Region, Long> totalMap = new HashMap<Region, Long>(this.regionList.size());
        for (Region region : this.regionList) {
            totalMap.put(region, 0L);
        }
        for (AssetClassAllocation allocation : this.assetClassAllocationList) {
            Long quantityMillis = allocation.getQuantityMillis();
            if (quantityMillis == null) continue;
            totalMap.put(allocation.getRegion(), (Long)totalMap.get(allocation.getRegion()) + quantityMillis);
        }
        return totalMap;
    }

    public Map<Sector, Long> calculateSectorQuantityMillisTotalMap() {
        HashMap<Sector, Long> totalMap = new HashMap<Sector, Long>(this.regionList.size());
        for (Sector sector : this.sectorList) {
            totalMap.put(sector, 0L);
        }
        for (AssetClassAllocation allocation : this.assetClassAllocationList) {
            Long quantityMillis = allocation.getQuantityMillis();
            if (quantityMillis == null) continue;
            totalMap.put(allocation.getSector(), (Long)totalMap.get(allocation.getSector()) + quantityMillis);
        }
        return totalMap;
    }
}

