/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.solver;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.junit.Test;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceParametrization;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceSolution;
import org.optaplanner.examples.conferencescheduling.domain.Room;
import org.optaplanner.examples.conferencescheduling.domain.Speaker;
import org.optaplanner.examples.conferencescheduling.domain.Talk;
import org.optaplanner.examples.conferencescheduling.domain.Timeslot;
import org.optaplanner.test.impl.score.buildin.hardsoft.HardSoftScoreVerifier;

public class ConferenceSchedulingScoreHardConstraintTest {
    private HardSoftScoreVerifier<ConferenceSolution> scoreVerifier = new HardSoftScoreVerifier(SolverFactory.createFromXmlResource((String)"org/optaplanner/examples/conferencescheduling/solver/conferenceSchedulingSolverConfig.xml"));

    @Test
    public void talkTypeOfTimeSlot() {
        Talk talk1 = new Talk(1L).withSpeakerList(Collections.emptyList()).withRequiredRoomTagSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        Talk talk2 = new Talk(2L).withSpeakerList(Collections.emptyList()).withRequiredRoomTagSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        Timeslot slot1 = new Timeslot(1L);
        Timeslot slot2 = new Timeslot(2L);
        String talkType1 = "type1";
        String talkType2 = "type2";
        ConferenceSolution solution = new ConferenceSolution(1L).withTalkList(Arrays.asList(talk1, talk2)).withTimeslotList(Arrays.asList(slot1, slot2)).withRoomList(Collections.emptyList()).withSpeakerList(Collections.emptyList());
        this.scoreVerifier.assertHardWeight("Talk type of timeslot", 0, (Object)solution);
        talk1.withTalkType(talkType1).withTimeslot(slot1);
        slot1.setTalkType(talkType1);
        this.scoreVerifier.assertHardWeight("Talk type of timeslot", 0, (Object)solution);
        talk2.withTalkType(talkType2).withTimeslot(slot2);
        slot2.setTalkType(talkType1);
        this.scoreVerifier.assertHardWeight("Talk type of timeslot", -100, (Object)solution);
    }

    @Test
    public void talkHasUnavailableRoom() {
        String talkType = "type1";
        Talk talk1 = new Talk(1L).withTalkType(talkType).withSpeakerList(Collections.emptyList()).withRequiredRoomTagSet(Collections.emptySet()).withPreferredRoomTagSet(Collections.emptySet()).withProhibitedRoomTagSet(Collections.emptySet()).withUndesiredRoomTagSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        Talk talk2 = new Talk(2L).withTalkType(talkType).withSpeakerList(Collections.emptyList()).withRequiredRoomTagSet(Collections.emptySet()).withPreferredRoomTagSet(Collections.emptySet()).withProhibitedRoomTagSet(Collections.emptySet()).withUndesiredRoomTagSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        Timeslot slot1 = new Timeslot(1L).withTalkType(talkType);
        Timeslot slot2 = new Timeslot(2L).withTalkType(talkType);
        Room room1 = new Room(1L);
        Room room2 = new Room(2L);
        ConferenceSolution solution = new ConferenceSolution(1L).withTalkList(Arrays.asList(talk1, talk2)).withTimeslotList(Arrays.asList(slot1, slot2)).withRoomList(Arrays.asList(room1, room2)).withSpeakerList(Collections.emptyList());
        this.scoreVerifier.assertHardWeight("Room unavailable timeslots", 0, (Object)solution);
        room1.setUnavailableTimeslotSet(Collections.emptySet());
        talk1.withTimeslot(slot1).withRoom(room1);
        this.scoreVerifier.assertHardWeight("Room unavailable timeslots", 0, (Object)solution);
        room1.setUnavailableTimeslotSet(new HashSet<Timeslot>(Arrays.asList(slot2)));
        this.scoreVerifier.assertHardWeight("Room unavailable timeslots", 0, (Object)solution);
        room1.setUnavailableTimeslotSet(new HashSet<Timeslot>(Arrays.asList(slot1)));
        talk1.withTimeslot(slot1).withRoom(room1);
        this.scoreVerifier.assertHardWeight("Room unavailable timeslots", -10, (Object)solution);
        room1.setUnavailableTimeslotSet(new HashSet<Timeslot>(Arrays.asList(slot1, slot2)));
        talk1.withTimeslot(slot1).withRoom(room1);
        this.scoreVerifier.assertHardWeight("Room unavailable timeslots", -10, (Object)solution);
    }

    @Test
    public void roomConflict() {
        String talkType = "type1";
        Talk talk1 = new Talk(1L).withTalkType(talkType).withSpeakerList(Collections.emptyList()).withRequiredRoomTagSet(Collections.emptySet()).withPreferredRoomTagSet(Collections.emptySet()).withProhibitedRoomTagSet(Collections.emptySet()).withUndesiredRoomTagSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        Talk talk2 = new Talk(2L).withTalkType(talkType).withSpeakerList(Collections.emptyList()).withRequiredRoomTagSet(Collections.emptySet()).withPreferredRoomTagSet(Collections.emptySet()).withProhibitedRoomTagSet(Collections.emptySet()).withUndesiredRoomTagSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        LocalDateTime start1 = LocalDateTime.of(2018, 1, 1, 9, 0);
        LocalDateTime end1 = LocalDateTime.of(2018, 1, 1, 10, 0);
        LocalDateTime start2 = LocalDateTime.of(2018, 1, 1, 9, 30);
        LocalDateTime end2 = LocalDateTime.of(2018, 1, 1, 10, 30);
        LocalDateTime start3 = LocalDateTime.of(2018, 1, 1, 10, 0);
        LocalDateTime end3 = LocalDateTime.of(2018, 1, 1, 11, 0);
        Timeslot slot1 = new Timeslot(1L).withTalkType(talkType).withStartDateTime(start1).withEndDateTime(end1);
        Timeslot slot2 = new Timeslot(2L).withTalkType(talkType).withStartDateTime(start2).withEndDateTime(end2);
        Timeslot slot3 = new Timeslot(3L).withTalkType(talkType).withStartDateTime(start3).withEndDateTime(end3);
        Room room1 = new Room(1L).withUnavailableTimeslotSet(Collections.emptySet());
        Room room2 = new Room(2L).withUnavailableTimeslotSet(Collections.emptySet());
        ConferenceSolution solution = new ConferenceSolution(1L).withTalkList(Arrays.asList(talk1, talk2)).withTimeslotList(Arrays.asList(slot1, slot2, slot3)).withRoomList(Arrays.asList(room1, room2)).withSpeakerList(Collections.emptyList());
        this.scoreVerifier.assertHardWeight("Room conflict", 0, (Object)solution);
        talk1.withRoom(room1).withTimeslot(slot1);
        talk2.withRoom(room1).withTimeslot(slot3);
        this.scoreVerifier.assertHardWeight("Room conflict", 0, (Object)solution);
        talk1.withRoom(room2).withTimeslot(slot1);
        talk2.withRoom(room2).withTimeslot(slot2);
        this.scoreVerifier.assertHardWeight("Room conflict", -10, (Object)solution);
        talk1.withRoom(room1).withTimeslot(slot1);
        talk2.withRoom(room2).withTimeslot(slot2);
        this.scoreVerifier.assertHardWeight("Room conflict", 0, (Object)solution);
    }

    @Test
    public void talkWithUnavailableSpeaker() {
        String talkType = "type1";
        Speaker speaker1 = new Speaker(1L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        Speaker speaker2 = new Speaker(2L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        Timeslot slot1 = new Timeslot(1L).withTalkType(talkType);
        Timeslot slot2 = new Timeslot(1L).withTalkType(talkType);
        Talk talk1 = new Talk(1L).withSpeakerList(Collections.emptyList()).withTalkType(talkType).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        ConferenceSolution solution = new ConferenceSolution(1L).withTalkList(Arrays.asList(talk1)).withTimeslotList(Arrays.asList(slot1)).withRoomList(Collections.emptyList()).withSpeakerList(Arrays.asList(speaker1, speaker2));
        this.scoreVerifier.assertHardWeight("Speaker unavailable timeslots", 0, (Object)solution);
        talk1.withSpeakerList(Arrays.asList(speaker1)).withTimeslot(slot1);
        speaker1.setUnavailableTimeslotSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker unavailable timeslots", 0, (Object)solution);
        speaker1.setUnavailableTimeslotSet(new HashSet<Timeslot>(Arrays.asList(slot2)));
        this.scoreVerifier.assertHardWeight("Speaker unavailable timeslots", 0, (Object)solution);
        talk1.withSpeakerList(Arrays.asList(speaker1, speaker2)).withTimeslot(slot1);
        this.scoreVerifier.assertHardWeight("Speaker unavailable timeslots", 0, (Object)solution);
        speaker2.setUnavailableTimeslotSet(new HashSet<Timeslot>(Arrays.asList(slot2)));
        this.scoreVerifier.assertHardWeight("Speaker unavailable timeslots", 0, (Object)solution);
        talk1.withSpeakerList(Arrays.asList(speaker1)).withTimeslot(slot1);
        speaker1.setUnavailableTimeslotSet(new HashSet<Timeslot>(Arrays.asList(slot1)));
        this.scoreVerifier.assertHardWeight("Speaker unavailable timeslots", -1, (Object)solution);
        speaker2.setUnavailableTimeslotSet(Collections.emptySet());
        talk1.withSpeakerList(Arrays.asList(speaker1, speaker2)).withTimeslot(slot1);
        this.scoreVerifier.assertHardWeight("Speaker unavailable timeslots", -1, (Object)solution);
        speaker2.setUnavailableTimeslotSet(new HashSet<Timeslot>(Arrays.asList(slot2)));
        this.scoreVerifier.assertHardWeight("Speaker unavailable timeslots", -1, (Object)solution);
        speaker2.setUnavailableTimeslotSet(new HashSet<Timeslot>(Arrays.asList(slot1, slot2)));
        this.scoreVerifier.assertHardWeight("Speaker unavailable timeslots", -1, (Object)solution);
    }

    @Test
    public void speakerWithConflictingTimeslots() {
        String talkType = "type1";
        Speaker speaker1 = new Speaker(1L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        Talk talk1 = new Talk(1L).withSpeakerList(Collections.emptyList()).withTalkType(talkType).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        Talk talk2 = new Talk(2L).withSpeakerList(Collections.emptyList()).withTalkType(talkType).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        LocalDateTime start1 = LocalDateTime.of(2018, 1, 1, 9, 0);
        LocalDateTime end1 = LocalDateTime.of(2018, 1, 1, 10, 0);
        LocalDateTime start2 = LocalDateTime.of(2018, 1, 1, 9, 30);
        LocalDateTime end2 = LocalDateTime.of(2018, 1, 1, 10, 30);
        LocalDateTime start3 = LocalDateTime.of(2018, 1, 1, 10, 0);
        LocalDateTime end3 = LocalDateTime.of(2018, 1, 1, 11, 0);
        Timeslot slot1 = new Timeslot(1L).withTalkType(talkType).withStartDateTime(start1).withEndDateTime(end1);
        Timeslot slot2 = new Timeslot(2L).withTalkType(talkType).withStartDateTime(start2).withEndDateTime(end2);
        Timeslot slot3 = new Timeslot(3L).withTalkType(talkType).withStartDateTime(start3).withEndDateTime(end3);
        ConferenceSolution solution = new ConferenceSolution(1L).withTalkList(Arrays.asList(talk1, talk2)).withTimeslotList(Arrays.asList(slot1, slot2, slot3)).withRoomList(Collections.emptyList()).withSpeakerList(Arrays.asList(speaker1));
        this.scoreVerifier.assertHardWeight("Speaker conflict", 0, (Object)solution);
        talk1.withSpeakerList(Arrays.asList(speaker1)).withTimeslot(slot1);
        talk2.withSpeakerList(Arrays.asList(speaker1)).withTimeslot(slot3);
        this.scoreVerifier.assertHardWeight("Speaker conflict", 0, (Object)solution);
        talk2.withTimeslot(slot2);
        this.scoreVerifier.assertHardWeight("Speaker conflict", -1, (Object)solution);
    }

    @Test
    public void speakerRequiredTimeSlotTag() {
        String tag1 = "tag1";
        String tag2 = "tag2";
        String tag3 = "tag3";
        String talkType = "type1";
        Speaker speaker1 = new Speaker(1L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        Speaker speaker2 = new Speaker(2L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        Talk talk1 = new Talk(1L).withTalkType(talkType).withSpeakerList(Collections.emptyList()).withPreferredTimeslotTagSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        LocalDateTime start1 = LocalDateTime.of(2018, 1, 1, 9, 0);
        LocalDateTime end1 = LocalDateTime.of(2018, 1, 1, 10, 0);
        Timeslot slot1 = new Timeslot(1L).withTalkType(talkType).withStartDateTime(start1).withEndDateTime(end1);
        ConferenceSolution solution = new ConferenceSolution(1L).withTalkList(Arrays.asList(talk1)).withTimeslotList(Arrays.asList(slot1)).withRoomList(Collections.emptyList()).withSpeakerList(Arrays.asList(speaker1, speaker2));
        talk1.withSpeakerList(Arrays.asList(speaker1)).withTimeslot(slot1);
        slot1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tag", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tag", 0, (Object)solution);
        slot1.setTagSet(Collections.emptySet());
        speaker1.setRequiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tag", -1, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag2, tag3)));
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tag", -1, (Object)solution);
        speaker1.setRequiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tag", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tag", 0, (Object)solution);
        speaker1.setRequiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        slot1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tag", -2, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tag", -1, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tag", 0, (Object)solution);
        talk1.withSpeakerList(Arrays.asList(speaker1, speaker2));
        slot1.setTagSet(Collections.emptySet());
        speaker1.setRequiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        speaker2.setRequiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tag", -2, (Object)solution);
        slot1.setTagSet(Collections.emptySet());
        speaker1.setRequiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        speaker2.setRequiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tag", -4, (Object)solution);
        slot1.setTagSet(Collections.emptySet());
        speaker1.setRequiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        speaker2.setRequiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag3)));
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tag", -4, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tag", -2, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag2)));
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tag", -3, (Object)solution);
    }

    @Test
    public void speakerProhibitedTimeSlotTag() {
        String tag1 = "tag1";
        String tag2 = "tag2";
        String tag3 = "tag3";
        String talkType = "type1";
        Speaker speaker1 = new Speaker(1L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        Speaker speaker2 = new Speaker(2L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        Talk talk1 = new Talk(1L).withTalkType(talkType).withSpeakerList(Collections.emptyList()).withPreferredTimeslotTagSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        LocalDateTime start1 = LocalDateTime.of(2018, 1, 1, 9, 0);
        LocalDateTime end1 = LocalDateTime.of(2018, 1, 1, 10, 0);
        Timeslot slot1 = new Timeslot(1L).withTalkType(talkType).withStartDateTime(start1).withEndDateTime(end1);
        ConferenceSolution solution = new ConferenceSolution(1L).withTalkList(Arrays.asList(talk1)).withTimeslotList(Arrays.asList(slot1)).withRoomList(Collections.emptyList()).withSpeakerList(Arrays.asList(speaker1, speaker2));
        talk1.withSpeakerList(Arrays.asList(speaker1)).withTimeslot(slot1);
        slot1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tag", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tag", 0, (Object)solution);
        speaker1.setProhibitedTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        slot1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tag", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag2)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tag", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tag", -1, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tag", -1, (Object)solution);
        speaker1.setProhibitedTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        slot1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tag", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tag", -1, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tag", -2, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2, tag3)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tag", -2, (Object)solution);
        talk1.withSpeakerList(Arrays.asList(speaker1, speaker2));
        slot1.setTagSet(Collections.emptySet());
        speaker1.setProhibitedTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        speaker2.setProhibitedTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tag", 0, (Object)solution);
        speaker1.setProhibitedTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        speaker2.setProhibitedTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tag", -2, (Object)solution);
        speaker1.setProhibitedTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tag", -2, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tag", -3, (Object)solution);
        speaker2.setProhibitedTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tag", -4, (Object)solution);
        speaker2.setProhibitedTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag3)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tag", -3, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2, tag3)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tag", -4, (Object)solution);
    }

    @Test
    public void talkRequiredTimeslotTag() {
        String tag1 = "tag1";
        String tag2 = "tag2";
        String talkType = "type1";
        Talk talk1 = new Talk(1L).withTalkType(talkType).withSpeakerList(Collections.emptyList()).withPreferredTimeslotTagSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        LocalDateTime start1 = LocalDateTime.of(2018, 1, 1, 9, 0);
        LocalDateTime end1 = LocalDateTime.of(2018, 1, 1, 10, 0);
        Timeslot slot1 = new Timeslot(1L).withTalkType(talkType).withStartDateTime(start1).withEndDateTime(end1);
        ConferenceSolution solution = new ConferenceSolution(1L).withTalkList(Arrays.asList(talk1)).withTimeslotList(Arrays.asList(slot1)).withRoomList(Collections.emptyList()).withSpeakerList(Collections.emptyList());
        slot1.setTagSet(Collections.emptySet());
        talk1.withTimeslot(slot1);
        this.scoreVerifier.assertHardWeight("Talk required timeslot tag", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Talk required timeslot tag", 0, (Object)solution);
        talk1.withRequiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        slot1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Talk required timeslot tag", -1, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag2)));
        this.scoreVerifier.assertHardWeight("Talk required timeslot tag", -1, (Object)solution);
        talk1.withRequiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Talk required timeslot tag", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Talk required timeslot tag", 0, (Object)solution);
        slot1.setTagSet(Collections.emptySet());
        talk1.withRequiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Talk required timeslot tag", -2, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Talk required timeslot tag", -1, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Talk required timeslot tag", 0, (Object)solution);
    }

    @Test
    public void talkProhibitedTimeslotTag() {
        String tag1 = "tag1";
        String tag2 = "tag2";
        String talkType = "type1";
        Talk talk1 = new Talk(1L).withTalkType(talkType).withSpeakerList(Collections.emptyList()).withPreferredTimeslotTagSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        LocalDateTime start1 = LocalDateTime.of(2018, 1, 1, 9, 0);
        LocalDateTime end1 = LocalDateTime.of(2018, 1, 1, 10, 0);
        Timeslot slot1 = new Timeslot(1L).withTalkType(talkType).withStartDateTime(start1).withEndDateTime(end1);
        ConferenceSolution solution = new ConferenceSolution(1L).withTalkList(Arrays.asList(talk1)).withTimeslotList(Arrays.asList(slot1)).withRoomList(Collections.emptyList()).withSpeakerList(Collections.emptyList());
        slot1.setTagSet(Collections.emptySet());
        talk1.withTimeslot(slot1);
        this.scoreVerifier.assertHardWeight("Talk prohibited timeslot tag", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Talk required timeslot tag", 0, (Object)solution);
        slot1.setTagSet(Collections.emptySet());
        talk1.withTimeslot(slot1).withProhibitedTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Talk prohibited timeslot tag", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag2)));
        this.scoreVerifier.assertHardWeight("Talk prohibited timeslot tag", 0, (Object)solution);
        talk1.withTimeslot(slot1).withProhibitedTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Talk prohibited timeslot tag", -1, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Talk prohibited timeslot tag", -1, (Object)solution);
        talk1.withTimeslot(slot1).withProhibitedTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        slot1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Talk prohibited timeslot tag", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Talk prohibited timeslot tag", -1, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Talk prohibited timeslot tag", -2, (Object)solution);
    }

    @Test
    public void speakerRequiredRoomTag() {
        String tag1 = "tag1";
        String tag2 = "tag2";
        String tag3 = "tag3";
        Room room1 = new Room(1L);
        Talk talk1 = new Talk(1L).withSpeakerList(Collections.emptyList()).withPreferredTimeslotTagSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withRequiredRoomTagSet(Collections.emptySet()).withPreferredRoomTagSet(Collections.emptySet()).withProhibitedRoomTagSet(Collections.emptySet()).withUndesiredRoomTagSet(Collections.emptySet());
        Speaker speaker1 = new Speaker(1L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withRequiredRoomTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withPreferredRoomTagSet(Collections.emptySet()).withProhibitedRoomTagSet(Collections.emptySet()).withUndesiredRoomTagSet(Collections.emptySet());
        Speaker speaker2 = new Speaker(2L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withRequiredRoomTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withPreferredRoomTagSet(Collections.emptySet()).withProhibitedRoomTagSet(Collections.emptySet()).withUndesiredRoomTagSet(Collections.emptySet());
        ConferenceSolution solution = new ConferenceSolution(1L).withTalkList(Arrays.asList(talk1)).withTimeslotList(Collections.emptyList()).withRoomList(Arrays.asList(room1)).withSpeakerList(Arrays.asList(speaker1, speaker2));
        room1.setTagSet(Collections.emptySet());
        talk1.withSpeakerList(Arrays.asList(speaker1)).withRoom(room1);
        this.scoreVerifier.assertHardWeight("Speaker required room tag", 0, (Object)solution);
        speaker1.withRequiredRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker required room tag", -1, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag3)));
        this.scoreVerifier.assertHardWeight("Speaker required room tag", -1, (Object)solution);
        speaker1.withRequiredRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker required room tag", 0, (Object)solution);
        speaker1.withRequiredRoomTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker required room tag", -2, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker required room tag", -1, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker required room tag", 0, (Object)solution);
        talk1.withSpeakerList(Arrays.asList(speaker1, speaker2)).withRoom(room1);
        speaker1.withRequiredRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        speaker2.withRequiredRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker required room tag", -2, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker required room tag", 0, (Object)solution);
        speaker2.withRequiredRoomTagSet(new HashSet<String>(Arrays.asList(tag2)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker required room tag", -2, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker required room tag", -1, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker required room tag", 0, (Object)solution);
        speaker2.withRequiredRoomTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker required room tag", -3, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker required room tag", -1, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker required room tag", 0, (Object)solution);
    }

    @Test
    public void speakerProhibitedRoomTag() {
        String tag1 = "tag1";
        String tag2 = "tag2";
        String tag3 = "tag3";
        Room room1 = new Room(1L);
        Talk talk1 = new Talk(1L).withSpeakerList(Collections.emptyList()).withPreferredTimeslotTagSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withRequiredRoomTagSet(Collections.emptySet()).withPreferredRoomTagSet(Collections.emptySet()).withProhibitedRoomTagSet(Collections.emptySet()).withUndesiredRoomTagSet(Collections.emptySet());
        Speaker speaker1 = new Speaker(1L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withRequiredRoomTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withPreferredRoomTagSet(Collections.emptySet()).withProhibitedRoomTagSet(Collections.emptySet()).withUndesiredRoomTagSet(Collections.emptySet());
        Speaker speaker2 = new Speaker(2L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withRequiredRoomTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withPreferredRoomTagSet(Collections.emptySet()).withProhibitedRoomTagSet(Collections.emptySet()).withUndesiredRoomTagSet(Collections.emptySet());
        ConferenceSolution solution = new ConferenceSolution(1L).withTalkList(Arrays.asList(talk1)).withTimeslotList(Collections.emptyList()).withRoomList(Arrays.asList(room1)).withSpeakerList(Arrays.asList(speaker1, speaker2));
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tag", 0, (Object)solution);
        room1.setTagSet(Collections.emptySet());
        talk1.withSpeakerList(Arrays.asList(speaker1)).withRoom(room1);
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tag", 0, (Object)solution);
        speaker1.withProhibitedRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tag", 0, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag3)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tag", 0, (Object)solution);
        speaker1.withProhibitedRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tag", -1, (Object)solution);
        speaker1.withProhibitedRoomTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tag", 0, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tag", -1, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tag", -2, (Object)solution);
        talk1.withSpeakerList(Arrays.asList(speaker1, speaker2)).withRoom(room1);
        speaker1.withProhibitedRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        speaker2.withProhibitedRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tag", 0, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tag", -2, (Object)solution);
        speaker2.withProhibitedRoomTagSet(new HashSet<String>(Arrays.asList(tag2)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tag", 0, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tag", -1, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tag", -2, (Object)solution);
        speaker2.withProhibitedRoomTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tag", 0, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tag", -2, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tag", -3, (Object)solution);
    }

    @Test
    public void talkRequiredRoomTag() {
        String tag1 = "tag1";
        String tag2 = "tag2";
        String talkType = "type1";
        Room room1 = new Room(1L);
        Talk talk1 = new Talk(1L).withTalkType(talkType).withSpeakerList(Collections.emptyList()).withPreferredTimeslotTagSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredRoomTagSet(Collections.emptySet()).withRequiredRoomTagSet(Collections.emptySet()).withProhibitedRoomTagSet(Collections.emptySet()).withUndesiredRoomTagSet(Collections.emptySet());
        ConferenceSolution solution = new ConferenceSolution(1L).withTalkList(Arrays.asList(talk1)).withTimeslotList(Collections.emptyList()).withRoomList(Collections.emptyList()).withSpeakerList(Collections.emptyList());
        room1.setTagSet(Collections.emptySet());
        talk1.withRoom(room1);
        this.scoreVerifier.assertHardWeight("Talk required room tag", 0, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Talk required room tag", 0, (Object)solution);
        talk1.withRequiredRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Talk required room tag", -1, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag2)));
        this.scoreVerifier.assertHardWeight("Talk required room tag", -1, (Object)solution);
        talk1.withRequiredRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Talk required room tag", 0, (Object)solution);
        room1.setTagSet(Collections.emptySet());
        talk1.withRequiredRoomTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Talk required room tag", -2, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Talk required room tag", -1, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Talk required room tag", 0, (Object)solution);
    }

    @Test
    public void talkProhibitedRoomTag() {
        String tag1 = "tag1";
        String tag2 = "tag2";
        String talkType = "type1";
        Room room1 = new Room(1L);
        Talk talk1 = new Talk(1L).withTalkType(talkType).withSpeakerList(Collections.emptyList()).withPreferredTimeslotTagSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredRoomTagSet(Collections.emptySet()).withRequiredRoomTagSet(Collections.emptySet()).withProhibitedRoomTagSet(Collections.emptySet()).withUndesiredRoomTagSet(Collections.emptySet());
        ConferenceSolution solution = new ConferenceSolution(1L).withTalkList(Arrays.asList(talk1)).withTimeslotList(Collections.emptyList()).withRoomList(Collections.emptyList()).withSpeakerList(Collections.emptyList());
        room1.setTagSet(Collections.emptySet());
        talk1.withRoom(room1);
        this.scoreVerifier.assertHardWeight("Talk prohibited room tag", 0, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Talk prohibited room tag", 0, (Object)solution);
        talk1.withProhibitedRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Talk prohibited room tag", 0, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag2)));
        this.scoreVerifier.assertHardWeight("Talk prohibited room tag", 0, (Object)solution);
        talk1.withProhibitedRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Talk prohibited room tag", -1, (Object)solution);
        room1.setTagSet(Collections.emptySet());
        talk1.withProhibitedRoomTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Talk prohibited room tag", 0, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Talk prohibited room tag", -1, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Talk prohibited room tag", -2, (Object)solution);
    }

    @Test
    public void languageDiversity() {
        ConferenceParametrization parametrization = new ConferenceParametrization(1L);
        String talkType = "talktype";
        String language1 = "language1";
        String language2 = "language2";
        LocalDateTime start1 = LocalDateTime.of(2018, 1, 1, 9, 0);
        LocalDateTime end1 = LocalDateTime.of(2018, 1, 1, 10, 0);
        LocalDateTime start2 = LocalDateTime.of(2018, 1, 1, 9, 30);
        LocalDateTime end2 = LocalDateTime.of(2018, 1, 1, 10, 30);
        Timeslot slot1 = new Timeslot(1L).withTalkType(talkType).withStartDateTime(start1).withEndDateTime(end1);
        Timeslot slot2 = new Timeslot(2L).withTalkType(talkType).withStartDateTime(start2).withEndDateTime(end2);
        Talk talk1 = new Talk(1L).withTalkType(talkType).withSpeakerList(Collections.emptyList()).withPreferredTimeslotTagSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet()).withPreferredRoomTagSet(Collections.emptySet()).withRequiredRoomTagSet(Collections.emptySet()).withThemeTagSet(Collections.emptySet()).withSectorTagSet(Collections.emptySet());
        Talk talk2 = new Talk(2L).withTalkType(talkType).withSpeakerList(Collections.emptyList()).withPreferredTimeslotTagSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet()).withPreferredRoomTagSet(Collections.emptySet()).withRequiredRoomTagSet(Collections.emptySet()).withThemeTagSet(Collections.emptySet()).withSectorTagSet(Collections.emptySet());
        ConferenceSolution solution = new ConferenceSolution(1L).withParametrization(parametrization).withTalkList(Arrays.asList(talk1, talk2)).withTimeslotList(Collections.emptyList()).withRoomList(Collections.emptyList()).withSpeakerList(Collections.emptyList());
        this.scoreVerifier.assertHardWeight("Language diversity", 0, (Object)solution);
        parametrization.setLanguageDiversity(1);
        talk1.withTimeslot(slot1).withLanguage(language1);
        talk2.withTimeslot(slot1).withLanguage(language1);
        this.scoreVerifier.assertHardWeight("Language diversity", 0, (Object)solution);
        talk2.withLanguage(language2);
        this.scoreVerifier.assertHardWeight("Language diversity", 1, (Object)solution);
        parametrization.setLanguageDiversity(2);
        this.scoreVerifier.assertHardWeight("Language diversity", 2, (Object)solution);
        talk2.withTimeslot(slot2);
        this.scoreVerifier.assertHardWeight("Language diversity", 0, (Object)solution);
        talk2.withLanguage(language1);
        this.scoreVerifier.assertHardWeight("Language diversity", 0, (Object)solution);
    }
}

