/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.LoggingTest;
import org.optaplanner.examples.common.business.ProblemFileComparator;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;

public abstract class OpenDataFilesTest<Solution_>
extends LoggingTest {
    protected abstract CommonApp<Solution_> createCommonApp();

    private static List<File> getSolutionFiles(CommonApp<?> commonApp) {
        ArrayList<File> fileList = new ArrayList<File>(0);
        File dataDir = CommonApp.determineDataDir((String)commonApp.getDataDirName());
        File unsolvedDataDir = new File(dataDir, "unsolved");
        if (!unsolvedDataDir.exists()) {
            throw new IllegalStateException("The directory unsolvedDataDir (" + unsolvedDataDir.getAbsolutePath() + ") does not exist.");
        }
        String inputFileExtension = commonApp.createSolutionFileIO().getInputFileExtension();
        fileList.addAll(FileUtils.listFiles((File)unsolvedDataDir, (String[])new String[]{inputFileExtension}, (boolean)true));
        File solvedDataDir = new File(dataDir, "solved");
        if (solvedDataDir.exists()) {
            String outputFileExtension = commonApp.createSolutionFileIO().getOutputFileExtension();
            fileList.addAll(FileUtils.listFiles((File)solvedDataDir, (String[])new String[]{outputFileExtension}, (boolean)true));
        }
        fileList.sort((Comparator<File>)new ProblemFileComparator());
        return fileList;
    }

    @TestFactory
    Stream<DynamicTest> readSolution() {
        CommonApp<Solution_> commonApp = this.createCommonApp();
        SolutionFileIO solutionFileIO = commonApp.createSolutionFileIO();
        return OpenDataFilesTest.getSolutionFiles(commonApp).stream().map(solutionFile -> DynamicTest.dynamicTest((String)solutionFile.getName(), () -> this.readSolution((SolutionFileIO<Solution_>)solutionFileIO, (File)solutionFile)));
    }

    private void readSolution(SolutionFileIO<Solution_> solutionFileIO, File solutionFile) {
        solutionFileIO.read(solutionFile);
        this.logger.info("Opened: {}", (Object)solutionFile);
    }
}

