/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.scrabble.optional.score;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.examples.scrabble.domain.ScrabbleCell;
import org.optaplanner.examples.scrabble.domain.ScrabbleWordAssignment;
import org.optaplanner.examples.scrabble.domain.ScrabbleWordDirection;

public class ScrabbleConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.characterConflict(constraintFactory), this.noParallelHorizontalNeighbours(constraintFactory), this.noParallelVerticalNeighbours(constraintFactory), this.outOfGrid(constraintFactory), this.maximizeMergesPerWord(constraintFactory), this.pullToCenter(constraintFactory)};
    }

    private Constraint characterConflict(ConstraintFactory cf) {
        return cf.from(ScrabbleCell.class).filter(sc -> sc.getCharacterSet().size() >= 2).penalize("Character conflict", (Score)HardMediumSoftScore.ONE_HARD, sc -> sc.getCharacterSet().size() - 1);
    }

    private Constraint noParallelHorizontalNeighbours(ConstraintFactory cf) {
        return cf.from(ScrabbleCell.class).filter(sc -> sc.hasWordSet(ScrabbleWordDirection.HORIZONTAL)).ifExists(ScrabbleCell.class, Joiners.equal(ScrabbleCell::getX), Joiners.equal(ScrabbleCell::getY, c -> c.getY() + 1), Joiners.filtering((first, second) -> second.hasWordSet(ScrabbleWordDirection.HORIZONTAL))).penalize("No parallel horizontal neighbours", (Score)HardMediumSoftScore.ONE_HARD);
    }

    private Constraint noParallelVerticalNeighbours(ConstraintFactory cf) {
        return cf.from(ScrabbleCell.class).filter(sc -> sc.hasWordSet(ScrabbleWordDirection.VERTICAL)).ifExists(ScrabbleCell.class, Joiners.equal(ScrabbleCell::getY), Joiners.equal(ScrabbleCell::getX, c -> c.getX() + 1), Joiners.filtering((first, second) -> second.hasWordSet(ScrabbleWordDirection.VERTICAL))).penalize("No parallel vertical neighbours", (Score)HardMediumSoftScore.ONE_HARD);
    }

    private Constraint outOfGrid(ConstraintFactory cf) {
        return cf.from(ScrabbleWordAssignment.class).filter(ScrabbleWordAssignment::isOutOfGrid).penalize("Out of grid", (Score)HardMediumSoftScore.ONE_HARD, swa -> swa.getWord().length());
    }

    private Constraint maximizeMergesPerWord(ConstraintFactory cf) {
        return cf.from(ScrabbleWordAssignment.class).join(ScrabbleCell.class, Joiners.filtering((swa, sc) -> sc.getWordSet().contains(swa) && sc.hasMerge())).groupBy((swa, sc) -> swa.getId(), ConstraintCollectors.countBi()).reward("Maximize merges per word", (Score)HardMediumSoftScore.ONE_MEDIUM, (id, count) -> count * count);
    }

    private Constraint pullToCenter(ConstraintFactory cf) {
        return cf.from(ScrabbleWordAssignment.class).penalize("Pull to the center", (Score)HardMediumSoftScore.ONE_SOFT, ScrabbleWordAssignment::getDistanceToCenter);
    }
}

