/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.app;

import java.io.File;
import org.junit.Test;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.examples.common.app.SolverPerformanceTest;
import org.optaplanner.examples.vehiclerouting.app.VehicleRoutingApp;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;

public class VehicleRoutingPerformanceTest
extends SolverPerformanceTest<VehicleRoutingSolution> {
    protected VehicleRoutingApp createCommonApp() {
        return new VehicleRoutingApp();
    }

    @Test(timeout=600000L)
    public void solveModel_cvrp_32customers() {
        File unsolvedDataFile = new File("data/vehiclerouting/unsolved/cvrp-32customers.xml");
        this.runSpeedTest(unsolvedDataFile, "0hard/-750000soft");
    }

    @Test(timeout=600000L)
    public void solveModel_cvrp_32customersFastAssert() {
        File unsolvedDataFile = new File("data/vehiclerouting/unsolved/cvrp-32customers.xml");
        this.runSpeedTest(unsolvedDataFile, "0hard/-770000soft", EnvironmentMode.FAST_ASSERT);
    }

    @Test(timeout=600000L)
    public void solveModel_cvrptw_100customers_A() {
        File unsolvedDataFile = new File("data/vehiclerouting/unsolved/cvrptw-100customers-A.xml");
        this.runSpeedTest(unsolvedDataFile, "0hard/-1869903soft");
    }

    @Test(timeout=600000L)
    public void solveModel_cvrptw_100customers_AFastAssert() {
        File unsolvedDataFile = new File("data/vehiclerouting/unsolved/cvrptw-100customers-A.xml");
        this.runSpeedTest(unsolvedDataFile, "0hard/-1877466soft", EnvironmentMode.FAST_ASSERT);
    }
}

