/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.solver.score;

import org.optaplanner.core.api.score.buildin.simplelong.SimpleLongScore;
import org.optaplanner.core.impl.score.director.incremental.AbstractIncrementalScoreCalculator;
import org.optaplanner.examples.tsp.domain.Domicile;
import org.optaplanner.examples.tsp.domain.Standstill;
import org.optaplanner.examples.tsp.domain.TspSolution;
import org.optaplanner.examples.tsp.domain.Visit;

public class TspIncrementalScoreCalculator
extends AbstractIncrementalScoreCalculator<TspSolution> {
    private Domicile domicile;
    private long score;

    public void resetWorkingSolution(TspSolution tspSolution) {
        this.domicile = tspSolution.getDomicile();
        this.score = 0L;
        for (Visit visit : tspSolution.getVisitList()) {
            this.insert(visit);
        }
    }

    public void beforeEntityAdded(Object entity) {
    }

    public void afterEntityAdded(Object entity) {
        this.insert((Visit)entity);
    }

    public void beforeVariableChanged(Object entity, String variableName) {
        this.retract((Visit)entity);
    }

    public void afterVariableChanged(Object entity, String variableName) {
        this.insert((Visit)entity);
    }

    public void beforeEntityRemoved(Object entity) {
        this.retract((Visit)entity);
    }

    public void afterEntityRemoved(Object entity) {
    }

    private void insert(Visit visit) {
        Standstill previousStandstill = visit.getPreviousStandstill();
        if (previousStandstill != null) {
            this.score -= visit.getDistanceFromPreviousStandstill();
            this.score += previousStandstill.getDistanceTo(this.domicile);
            this.score -= visit.getDistanceTo(this.domicile);
        }
    }

    private void retract(Visit visit) {
        Standstill previousStandstill = visit.getPreviousStandstill();
        if (previousStandstill != null) {
            this.score += visit.getDistanceFromPreviousStandstill();
            this.score -= previousStandstill.getDistanceTo(this.domicile);
            this.score += visit.getDistanceTo(this.domicile);
        }
    }

    public SimpleLongScore calculateScore() {
        return SimpleLongScore.valueOf((long)this.score);
    }
}

