/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.domain;

import java.util.List;
import java.util.Set;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.entity.PlanningPin;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.conferencescheduling.domain.Room;
import org.optaplanner.examples.conferencescheduling.domain.Speaker;
import org.optaplanner.examples.conferencescheduling.domain.TalkType;
import org.optaplanner.examples.conferencescheduling.domain.Timeslot;

@PlanningEntity
public class Talk
extends AbstractPersistable {
    private String code;
    private String title;
    private TalkType talkType;
    private List<Speaker> speakerList;
    private Set<String> themeTrackTagSet;
    private Set<String> sectorTagSet;
    private Set<String> audienceTypeSet;
    private int audienceLevel;
    private Set<String> contentTagSet;
    private String language;
    private Set<String> requiredTimeslotTagSet;
    private Set<String> preferredTimeslotTagSet;
    private Set<String> prohibitedTimeslotTagSet;
    private Set<String> undesiredTimeslotTagSet;
    private Set<String> requiredRoomTagSet;
    private Set<String> preferredRoomTagSet;
    private Set<String> prohibitedRoomTagSet;
    private Set<String> undesiredRoomTagSet;
    @PlanningPin
    private boolean pinnedByUser = false;
    @PlanningVariable(valueRangeProviderRefs={"timeslotRange"})
    private Timeslot timeslot;
    @PlanningVariable(valueRangeProviderRefs={"roomRange"})
    private Room room;

    public Talk() {
    }

    public Talk(long id) {
        super(id);
    }

    public boolean hasSpeaker(Speaker speaker) {
        return this.speakerList.contains(speaker);
    }

    public boolean hasAnyUnavailableSpeaker() {
        if (this.timeslot == null) {
            return false;
        }
        for (Speaker speaker : this.speakerList) {
            if (!speaker.getUnavailableTimeslotSet().contains(this.timeslot)) continue;
            return true;
        }
        return false;
    }

    public int overlappingThemeTrackCount(Talk other) {
        return (int)this.themeTrackTagSet.stream().filter(tag -> other.themeTrackTagSet.contains(tag)).count();
    }

    public int overlappingSectorCount(Talk other) {
        return (int)this.sectorTagSet.stream().filter(tag -> other.sectorTagSet.contains(tag)).count();
    }

    public int overlappingAudienceTypeCount(Talk other) {
        return (int)this.audienceTypeSet.stream().filter(audienceType -> other.audienceTypeSet.contains(audienceType)).count();
    }

    public int overlappingContentCount(Talk other) {
        return (int)this.contentTagSet.stream().filter(tag -> other.contentTagSet.contains(tag)).count();
    }

    public int missingRequiredTimeslotTagCount() {
        if (this.timeslot == null) {
            return 0;
        }
        return (int)this.requiredTimeslotTagSet.stream().filter(tag -> !this.timeslot.hasTag((String)tag)).count();
    }

    public int missingPreferredTimeslotTagCount() {
        if (this.timeslot == null) {
            return 0;
        }
        return (int)this.preferredTimeslotTagSet.stream().filter(tag -> !this.timeslot.hasTag((String)tag)).count();
    }

    public int prevailingProhibitedTimeslotTagCount() {
        if (this.timeslot == null) {
            return 0;
        }
        return (int)this.prohibitedTimeslotTagSet.stream().filter(tag -> this.timeslot.hasTag((String)tag)).count();
    }

    public int prevailingUndesiredTimeslotTagCount() {
        if (this.timeslot == null) {
            return 0;
        }
        return (int)this.undesiredTimeslotTagSet.stream().filter(tag -> this.timeslot.hasTag((String)tag)).count();
    }

    public int missingRequiredRoomTagCount() {
        if (this.room == null) {
            return 0;
        }
        return (int)this.requiredRoomTagSet.stream().filter(tag -> !this.room.hasTag((String)tag)).count();
    }

    public int missingPreferredRoomTagCount() {
        if (this.room == null) {
            return 0;
        }
        return (int)this.preferredRoomTagSet.stream().filter(tag -> !this.room.hasTag((String)tag)).count();
    }

    public int prevailingProhibitedRoomTagCount() {
        if (this.room == null) {
            return 0;
        }
        return (int)this.prohibitedRoomTagSet.stream().filter(tag -> this.room.hasTag((String)tag)).count();
    }

    public int prevailingUndesiredRoomTagCount() {
        if (this.room == null) {
            return 0;
        }
        return (int)this.undesiredRoomTagSet.stream().filter(tag -> this.room.hasTag((String)tag)).count();
    }

    public int missingSpeakerRequiredTimeslotTagCount() {
        if (this.timeslot == null) {
            return 0;
        }
        return (int)this.speakerList.stream().flatMap(speaker -> speaker.getRequiredTimeslotTagSet().stream()).filter(tag -> !this.timeslot.hasTag((String)tag)).count();
    }

    public int missingSpeakerPreferredTimeslotTagCount() {
        if (this.timeslot == null) {
            return 0;
        }
        return (int)this.speakerList.stream().flatMap(speaker -> speaker.getPreferredTimeslotTagSet().stream()).filter(tag -> !this.timeslot.hasTag((String)tag)).count();
    }

    public int prevailingSpeakerProhibitedTimeslotTagCount() {
        if (this.timeslot == null) {
            return 0;
        }
        return (int)this.speakerList.stream().flatMap(speaker -> speaker.getProhibitedTimeslotTagSet().stream()).filter(tag -> this.timeslot.hasTag((String)tag)).count();
    }

    public int prevailingSpeakerUndesiredTimeslotTagCount() {
        if (this.timeslot == null) {
            return 0;
        }
        return (int)this.speakerList.stream().flatMap(speaker -> speaker.getUndesiredTimeslotTagSet().stream()).filter(tag -> this.timeslot.hasTag((String)tag)).count();
    }

    public int missingSpeakerRequiredRoomTagCount() {
        if (this.room == null) {
            return 0;
        }
        return (int)this.speakerList.stream().flatMap(speaker -> speaker.getRequiredRoomTagSet().stream()).filter(tag -> !this.room.hasTag((String)tag)).count();
    }

    public int missingSpeakerPreferredRoomTagCount() {
        if (this.room == null) {
            return 0;
        }
        return (int)this.speakerList.stream().flatMap(speaker -> speaker.getPreferredRoomTagSet().stream()).filter(tag -> !this.room.hasTag((String)tag)).count();
    }

    public int prevailingSpeakerProhibitedRoomTagCount() {
        if (this.room == null) {
            return 0;
        }
        return (int)this.speakerList.stream().flatMap(speaker -> speaker.getProhibitedRoomTagSet().stream()).filter(tag -> this.room.hasTag((String)tag)).count();
    }

    public int prevailingSpeakerUndesiredRoomTagCount() {
        if (this.room == null) {
            return 0;
        }
        return (int)this.speakerList.stream().flatMap(speaker -> speaker.getUndesiredRoomTagSet().stream()).filter(tag -> this.room.hasTag((String)tag)).count();
    }

    public boolean hasUnavailableRoom() {
        if (this.timeslot == null || this.room == null) {
            return false;
        }
        return this.room.getUnavailableTimeslotSet().contains(this.timeslot);
    }

    @Override
    public String toString() {
        return this.code;
    }

    @ValueRangeProvider(id="timeslotRange")
    public Set<Timeslot> getTimeslotRange() {
        return this.talkType.getCompatibleTimeslotSet();
    }

    @ValueRangeProvider(id="roomRange")
    public Set<Room> getRoomRange() {
        return this.talkType.getCompatibleRoomSet();
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public TalkType getTalkType() {
        return this.talkType;
    }

    public void setTalkType(TalkType talkType) {
        this.talkType = talkType;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public List<Speaker> getSpeakerList() {
        return this.speakerList;
    }

    public Set<String> getThemeTrackTagSet() {
        return this.themeTrackTagSet;
    }

    public void setThemeTrackTagSet(Set<String> themeTrackTagSet) {
        this.themeTrackTagSet = themeTrackTagSet;
    }

    public Set<String> getSectorTagSet() {
        return this.sectorTagSet;
    }

    public void setSectorTagSet(Set<String> sectorTagSet) {
        this.sectorTagSet = sectorTagSet;
    }

    public Set<String> getAudienceTypeSet() {
        return this.audienceTypeSet;
    }

    public void setAudienceTypeSet(Set<String> audienceTypeSet) {
        this.audienceTypeSet = audienceTypeSet;
    }

    public int getAudienceLevel() {
        return this.audienceLevel;
    }

    public void setAudienceLevel(int audienceLevel) {
        this.audienceLevel = audienceLevel;
    }

    public Set<String> getContentTagSet() {
        return this.contentTagSet;
    }

    public void setContentTagSet(Set<String> contentTagSet) {
        this.contentTagSet = contentTagSet;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setSpeakerList(List<Speaker> speakerList) {
        this.speakerList = speakerList;
    }

    public Set<String> getRequiredTimeslotTagSet() {
        return this.requiredTimeslotTagSet;
    }

    public void setRequiredTimeslotTagSet(Set<String> requiredTimeslotTagSet) {
        this.requiredTimeslotTagSet = requiredTimeslotTagSet;
    }

    public Set<String> getPreferredTimeslotTagSet() {
        return this.preferredTimeslotTagSet;
    }

    public void setPreferredTimeslotTagSet(Set<String> preferredTimeslotTagSet) {
        this.preferredTimeslotTagSet = preferredTimeslotTagSet;
    }

    public Set<String> getProhibitedTimeslotTagSet() {
        return this.prohibitedTimeslotTagSet;
    }

    public void setProhibitedTimeslotTagSet(Set<String> prohibitedTimeslotTagSet) {
        this.prohibitedTimeslotTagSet = prohibitedTimeslotTagSet;
    }

    public Set<String> getUndesiredTimeslotTagSet() {
        return this.undesiredTimeslotTagSet;
    }

    public void setUndesiredTimeslotTagSet(Set<String> undesiredTimeslotTagSet) {
        this.undesiredTimeslotTagSet = undesiredTimeslotTagSet;
    }

    public Set<String> getRequiredRoomTagSet() {
        return this.requiredRoomTagSet;
    }

    public void setRequiredRoomTagSet(Set<String> requiredRoomTagSet) {
        this.requiredRoomTagSet = requiredRoomTagSet;
    }

    public Set<String> getPreferredRoomTagSet() {
        return this.preferredRoomTagSet;
    }

    public void setPreferredRoomTagSet(Set<String> preferredRoomTagSet) {
        this.preferredRoomTagSet = preferredRoomTagSet;
    }

    public Set<String> getProhibitedRoomTagSet() {
        return this.prohibitedRoomTagSet;
    }

    public void setProhibitedRoomTagSet(Set<String> prohibitedRoomTagSet) {
        this.prohibitedRoomTagSet = prohibitedRoomTagSet;
    }

    public Set<String> getUndesiredRoomTagSet() {
        return this.undesiredRoomTagSet;
    }

    public void setUndesiredRoomTagSet(Set<String> undesiredRoomTagSet) {
        this.undesiredRoomTagSet = undesiredRoomTagSet;
    }

    public boolean isPinnedByUser() {
        return this.pinnedByUser;
    }

    public void setPinnedByUser(boolean pinnedByUser) {
        this.pinnedByUser = pinnedByUser;
    }

    public Timeslot getTimeslot() {
        return this.timeslot;
    }

    public void setTimeslot(Timeslot timeslot) {
        this.timeslot = timeslot;
    }

    public Room getRoom() {
        return this.room;
    }

    public void setRoom(Room room) {
        this.room = room;
    }

    public Talk withTalkType(TalkType talkType) {
        this.talkType = talkType;
        return this;
    }

    public Talk withSpeakerList(List<Speaker> speakerList) {
        this.speakerList = speakerList;
        return this;
    }

    public Talk withThemeTrackTagSet(Set<String> themeTrackTagSet) {
        this.themeTrackTagSet = themeTrackTagSet;
        return this;
    }

    public Talk withSectorTagSet(Set<String> sectorTagSet) {
        this.sectorTagSet = sectorTagSet;
        return this;
    }

    public Talk withAudienceTypeSet(Set<String> audienceTypeSet) {
        this.audienceTypeSet = audienceTypeSet;
        return this;
    }

    public Talk withAudienceLevel(int audienceLevel) {
        this.audienceLevel = audienceLevel;
        return this;
    }

    public Talk withContentTagSet(Set<String> contentTagSet) {
        this.contentTagSet = contentTagSet;
        return this;
    }

    public Talk withLanguage(String language) {
        this.language = language;
        return this;
    }

    public Talk withRequiredRoomTagSet(Set<String> requiredRoomTagSet) {
        this.requiredRoomTagSet = requiredRoomTagSet;
        return this;
    }

    public Talk withPreferredRoomTagSet(Set<String> preferredRoomTagSet) {
        this.preferredRoomTagSet = preferredRoomTagSet;
        return this;
    }

    public Talk withProhibitedRoomTagSet(Set<String> prohibitedRoomTagSet) {
        this.prohibitedRoomTagSet = prohibitedRoomTagSet;
        return this;
    }

    public Talk withUndesiredRoomTagSet(Set<String> undesiredRoomTagSet) {
        this.undesiredRoomTagSet = undesiredRoomTagSet;
        return this;
    }

    public Talk withRequiredTimeslotTagSet(Set<String> requiredTimeslotTagSet) {
        this.requiredTimeslotTagSet = requiredTimeslotTagSet;
        return this;
    }

    public Talk withProhibitedTimeslotTagSet(Set<String> prohibitedTimeslotTagSet) {
        this.prohibitedTimeslotTagSet = prohibitedTimeslotTagSet;
        return this;
    }

    public Talk withPreferredTimeslotTagSet(Set<String> preferredTimslotTagSet) {
        this.preferredTimeslotTagSet = preferredTimslotTagSet;
        return this;
    }

    public Talk withUndesiredTimeslotTagSet(Set<String> undesiredTimeslotTagSet) {
        this.undesiredTimeslotTagSet = undesiredTimeslotTagSet;
        return this;
    }

    public Talk withTimeslot(Timeslot timeSlot) {
        this.timeslot = timeSlot;
        return this;
    }

    public Talk withRoom(Room room) {
        this.room = room;
        return this;
    }
}

