/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.persistence;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.examples.common.persistence.AbstractXlsxSolutionFileIO;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceParametrization;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceSolution;
import org.optaplanner.examples.conferencescheduling.domain.Room;
import org.optaplanner.examples.conferencescheduling.domain.Speaker;
import org.optaplanner.examples.conferencescheduling.domain.Talk;
import org.optaplanner.examples.conferencescheduling.domain.TalkType;
import org.optaplanner.examples.conferencescheduling.domain.Timeslot;

public class ConferenceSchedulingXlsxFileIO
extends AbstractXlsxSolutionFileIO<ConferenceSolution> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConferenceSolution read(File inputSolutionFile) {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputSolutionFile));){
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)in);
            ConferenceSolution conferenceSolution = new ConferenceSchedulingXlsxReader(workbook).read();
            return conferenceSolution;
        }
        catch (IOException | RuntimeException e) {
            throw new IllegalStateException("Failed reading inputSolutionFile (" + inputSolutionFile + ").", e);
        }
    }

    public void write(ConferenceSolution solution, File outputSolutionFile) {
        try (FileOutputStream out = new FileOutputStream(outputSolutionFile);){
            Workbook workbook = new ConferenceSchedulingXlsxWriter(solution).write();
            workbook.write((OutputStream)out);
        }
        catch (IOException | RuntimeException e) {
            throw new IllegalStateException("Failed writing outputSolutionFile (" + outputSolutionFile + ") for solution (" + solution + ").", e);
        }
    }

    private static class ConferenceSchedulingXlsxWriter
    extends AbstractXlsxSolutionFileIO.AbstractXlsxWriter<ConferenceSolution> {
        public ConferenceSchedulingXlsxWriter(ConferenceSolution solution) {
            super(solution, "org/optaplanner/examples/conferencescheduling/solver/conferenceSchedulingSolverConfig.xml");
        }

        @Override
        public Workbook write() {
            this.writeSetup();
            this.writeConfiguration();
            this.writeTimeslotList();
            this.writeRoomList();
            this.writeSpeakerList();
            this.writeTalkList();
            this.writeInfeasibleView();
            this.writeRoomsView();
            this.writeSpeakersView();
            this.writeThemeTracksView();
            this.writeSectorsView();
            this.writeAudienceTypesView();
            this.writeAudienceLevelsView();
            this.writeContentsView();
            this.writeLanguagesView();
            this.writeScoreView();
            return this.workbook;
        }

        private void writeConfiguration() {
            this.nextSheet("Configuration", 1, 3, false);
            this.nextRow();
            this.nextHeaderCell("Conference name");
            this.nextCell().setCellValue(((ConferenceSolution)this.solution).getConferenceName());
            this.nextRow();
            this.nextRow();
            this.nextHeaderCell("Constraint");
            this.nextHeaderCell("Weight");
            this.nextHeaderCell("Description");
            ConferenceParametrization parametrization = ((ConferenceSolution)this.solution).getParametrization();
            this.writeIntConstraintLine("Theme track conflict", parametrization::getThemeTrackConflict, "Soft penalty per common theme track of 2 talks that have an overlapping timeslot");
            this.writeIntConstraintLine("Sector conflict", parametrization::getSectorConflict, "Soft penalty per common sector of 2 talks that have an overlapping timeslot");
            this.writeIntConstraintLine("Audience type diversity", parametrization::getAudienceTypeDiversity, "Soft reward per 2 talks that have the same timeslot and a different audience type");
            this.writeIntConstraintLine("Audience type theme track conflict", parametrization::getAudienceTypeThemeTrackConflict, "Soft penalty per 2 talks that have a common audience type, have a common theme track and have an overlapping timeslot");
            this.writeIntConstraintLine("Audience level diversity", parametrization::getAudienceLevelDiversity, "Soft reward per 2 talks that have the same timeslot and a different audience level");
            this.writeIntConstraintLine("Audience level flow per content violation", parametrization::getAudienceLevelFlowPerContentViolation, "Soft penalty per common content of 2 talks with a different audience level for which the easier talk isn't scheduled earlier than the other talk");
            this.writeIntConstraintLine("Content conflict", parametrization::getContentConflict, "Soft penalty per common content of 2 talks that have an overlapping timeslot");
            this.writeIntConstraintLine("Language diversity", parametrization::getLanguageDiversity, "Soft reward per 2 talks that have the same timeslot and a different language");
            this.writeIntConstraintLine("Speaker preferred timeslot tag", parametrization::getSpeakerPreferredTimeslotTag, "Soft penalty per missing preferred tag in a talk's timeslot");
            this.writeIntConstraintLine("Speaker undesired timeslot tag", parametrization::getSpeakerUndesiredTimeslotTag, "Soft penalty per undesired tag in a talk's timeslot");
            this.writeIntConstraintLine("Talk preferred timeslot tag", parametrization::getTalkPreferredTimeslotTag, "Soft penalty per missing preferred tag in a talk's timeslot");
            this.writeIntConstraintLine("Talk undesired timeslot tag", parametrization::getTalkUndesiredTimeslotTag, "Soft penalty per undesired tag in a talk's timeslot");
            this.writeIntConstraintLine("Speaker preferred room tag", parametrization::getSpeakerPreferredRoomTag, "Soft penalty per missing preferred tag in a talk's room");
            this.writeIntConstraintLine("Speaker undesired room tag", parametrization::getSpeakerUndesiredRoomTag, "Soft penalty per undesired tag in a talk's room");
            this.writeIntConstraintLine("Talk preferred room tag", parametrization::getTalkPreferredRoomTag, "Soft penalty per missing preferred tag in a talk's room");
            this.writeIntConstraintLine("Talk undesired room tag", parametrization::getTalkUndesiredRoomTag, "Soft penalty per undesired tag in a talk's room");
            this.nextRow();
            this.writeIntConstraintLine("Talk type of timeslot", null, "Hard penalty per talk in a timeslot with an other talk type");
            this.writeIntConstraintLine("Room unavailable timeslot", null, "Hard penalty per talk with an unavailable room at its timeslot");
            this.writeIntConstraintLine("Room conflict", null, "Hard penalty per pair of talks in the same room in overlapping timeslots");
            this.writeIntConstraintLine("Speaker unavailable timeslot", null, "Hard penalty per talk with an unavailable speaker at its timeslot");
            this.writeIntConstraintLine("Speaker conflict", null, "Hard penalty per pair of talks with the same speaker in overlapping timeslots");
            this.writeIntConstraintLine("Speaker required timeslot tag", null, "Hard penalty per missing required tag in a talk's timeslot");
            this.writeIntConstraintLine("Speaker prohibited timeslot tag", null, "Hard penalty per prohibited tag in a talk's timeslot");
            this.writeIntConstraintLine("Talk required timeslot tag", null, "Hard penalty per missing required tag in a talk's timeslot");
            this.writeIntConstraintLine("Talk prohibited timeslot tag", null, "Hard penalty per prohibited tag in a talk's timeslot");
            this.writeIntConstraintLine("Speaker required room tag", null, "Hard penalty per missing required tag in a talk's room");
            this.writeIntConstraintLine("Speaker prohibited room tag", null, "Hard penalty per prohibited tag in a talk's room");
            this.writeIntConstraintLine("Talk required room tag", null, "Hard penalty per missing required tag in a talk's room");
            this.writeIntConstraintLine("Talk prohibited room tag", null, "Hard penalty per prohibited tag in a talk's room");
            this.autoSizeColumnsWithHeader();
        }

        private void writeTimeslotList() {
            this.nextSheet("Timeslots", 3, 1, false);
            this.nextRow();
            this.nextHeaderCell("Day");
            this.nextHeaderCell("Start");
            this.nextHeaderCell("End");
            this.nextHeaderCell("Talk types");
            this.nextHeaderCell("Tags");
            for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                this.nextRow();
                this.nextCell().setCellValue(AbstractXlsxSolutionFileIO.DAY_FORMATTER.format(timeslot.getDate()));
                this.nextCell().setCellValue(AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(timeslot.getStartDateTime()));
                this.nextCell().setCellValue(AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(timeslot.getEndDateTime()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", timeslot.getTalkTypeSet().stream().map(TalkType::getName).collect(Collectors.toList())));
                this.nextCell().setCellValue(String.join((CharSequence)", ", timeslot.getTagSet()));
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeRoomList() {
            this.nextSheet("Rooms", 1, 2, false);
            this.nextRow();
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.writeTimeslotDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Name");
            this.nextHeaderCell("Talk types");
            this.nextHeaderCell("Tags");
            this.writeTimeslotHoursHeaders();
            for (Room room : ((ConferenceSolution)this.solution).getRoomList()) {
                this.nextRow();
                this.nextCell().setCellValue(room.getName());
                this.nextCell().setCellValue(String.join((CharSequence)", ", room.getTalkTypeSet().stream().map(TalkType::getName).collect(Collectors.toList())));
                this.nextCell().setCellValue(String.join((CharSequence)", ", room.getTagSet()));
                for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                    this.nextCell(room.getUnavailableTimeslotSet().contains(timeslot) ? this.unavailableStyle : this.defaultStyle).setCellValue("");
                }
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeSpeakerList() {
            this.nextSheet("Speakers", 1, 2, false);
            this.nextRow();
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.writeTimeslotDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Name");
            this.nextHeaderCell("Required timeslot tags");
            this.nextHeaderCell("Preferred timeslot tags");
            this.nextHeaderCell("Prohibited timeslot tags");
            this.nextHeaderCell("Undesired timeslot tags");
            this.nextHeaderCell("Required room tags");
            this.nextHeaderCell("Preferred room tags");
            this.nextHeaderCell("Prohibited room tags");
            this.nextHeaderCell("Undesired room tags");
            this.writeTimeslotHoursHeaders();
            for (Speaker speaker : ((ConferenceSolution)this.solution).getSpeakerList()) {
                this.nextRow();
                this.nextCell().setCellValue(speaker.getName());
                this.nextCell().setCellValue(String.join((CharSequence)", ", speaker.getRequiredTimeslotTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", speaker.getPreferredTimeslotTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", speaker.getProhibitedTimeslotTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", speaker.getUndesiredTimeslotTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", speaker.getRequiredRoomTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", speaker.getPreferredRoomTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", speaker.getProhibitedRoomTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", speaker.getUndesiredRoomTagSet()));
                for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                    this.nextCell(speaker.getUnavailableTimeslotSet().contains(timeslot) ? this.unavailableStyle : this.defaultStyle).setCellValue("");
                }
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeTalkList() {
            this.nextSheet("Talks", 2, 1, false);
            this.nextRow();
            this.nextHeaderCell("Code");
            this.nextHeaderCell("Title");
            this.nextHeaderCell("Talk type");
            this.nextHeaderCell("Speakers");
            this.nextHeaderCell("Theme track tags");
            this.nextHeaderCell("Sector tags");
            this.nextHeaderCell("Audience types");
            this.nextHeaderCell("Audience level");
            this.nextHeaderCell("Content tags");
            this.nextHeaderCell("Language");
            this.nextHeaderCell("Required timeslot tags");
            this.nextHeaderCell("Preferred timeslot tags");
            this.nextHeaderCell("Prohibited timeslot tags");
            this.nextHeaderCell("Undesired timeslot tags");
            this.nextHeaderCell("Required room tags");
            this.nextHeaderCell("Preferred room tags");
            this.nextHeaderCell("Prohibited room tags");
            this.nextHeaderCell("Undesired room tags");
            this.nextHeaderCell("Pinned by user");
            this.nextHeaderCell("Timeslot day");
            this.nextHeaderCell("Start");
            this.nextHeaderCell("End");
            this.nextHeaderCell("Room");
            for (Talk talk : ((ConferenceSolution)this.solution).getTalkList()) {
                this.nextRow();
                this.nextCell().setCellValue(talk.getCode());
                this.nextCell().setCellValue(talk.getTitle());
                this.nextCell().setCellValue(talk.getTalkType().getName());
                this.nextCell().setCellValue(talk.getSpeakerList().stream().map(Speaker::getName).collect(Collectors.joining(", ")));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getThemeTrackTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getSectorTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getAudienceTypeSet()));
                this.nextCell().setCellValue((double)talk.getAudienceLevel());
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getContentTagSet()));
                this.nextCell().setCellValue(talk.getLanguage());
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getRequiredTimeslotTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getPreferredTimeslotTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getProhibitedTimeslotTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getUndesiredTimeslotTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getRequiredRoomTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getPreferredRoomTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getProhibitedRoomTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getUndesiredRoomTagSet()));
                this.nextCell(talk.isPinnedByUser() ? this.pinnedStyle : this.defaultStyle).setCellValue(talk.isPinnedByUser());
                this.nextCell().setCellValue(talk.getTimeslot() == null ? "" : AbstractXlsxSolutionFileIO.DAY_FORMATTER.format(talk.getTimeslot().getDate()));
                this.nextCell().setCellValue(talk.getTimeslot() == null ? "" : AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(talk.getTimeslot().getStartDateTime()));
                this.nextCell().setCellValue(talk.getTimeslot() == null ? "" : AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(talk.getTimeslot().getEndDateTime()));
                this.nextCell().setCellValue(talk.getRoom() == null ? "" : talk.getRoom().getName());
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeInfeasibleView() {
            if (((ConferenceSolution)this.solution).getScore() == null || ((ConferenceSolution)this.solution).getScore().isFeasible()) {
                return;
            }
            this.nextSheet("Infeasible view", 1, 1, true);
            this.nextRow();
            this.nextHeaderCell("Score");
            this.nextCell().setCellValue(((ConferenceSolution)this.solution).getScore() == null ? "Not yet solved" : ((ConferenceSolution)this.solution).getScore().toShortString());
            this.nextRow();
            this.nextRow();
            this.nextHeaderCell("Talk type");
            this.nextHeaderCell("Count");
            this.nextHeaderCell("Usable timeslots");
            this.nextHeaderCell("Usable rooms");
            this.nextHeaderCell("Usable sessions");
            Map talkTypeToCountMap = ((ConferenceSolution)this.solution).getTalkList().stream().collect(Collectors.groupingBy(Talk::getTalkType, LinkedHashMap::new, Collectors.counting()));
            for (Map.Entry entry : talkTypeToCountMap.entrySet()) {
                TalkType talkType = (TalkType)entry.getKey();
                long count = (Long)entry.getValue();
                this.nextRow();
                this.nextHeaderCell(talkType.getName());
                this.nextCell().setCellValue((double)count);
                int timeslotListSize = talkType.getCompatibleTimeslotSet().size();
                this.nextCell().setCellValue((double)timeslotListSize);
                int roomListSize = talkType.getCompatibleRoomSet().size();
                this.nextCell().setCellValue((double)roomListSize);
                int sessionCount = timeslotListSize * roomListSize;
                this.nextCell((long)sessionCount < count ? this.hardPenaltyStyle : this.defaultStyle).setCellValue((double)sessionCount);
            }
            this.nextRow();
            this.nextRow();
            this.nextHeaderCell("Total");
            int talkListSize = ((ConferenceSolution)this.solution).getTalkList().size();
            this.nextCell().setCellValue((double)talkListSize);
            int timeslotListSize = ((ConferenceSolution)this.solution).getTimeslotList().size();
            this.nextCell().setCellValue((double)timeslotListSize);
            int roomListSize = ((ConferenceSolution)this.solution).getRoomList().size();
            this.nextCell().setCellValue((double)roomListSize);
            int sessionCount = 0;
            for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                for (Room room : ((ConferenceSolution)this.solution).getRoomList()) {
                    if (Collections.disjoint(timeslot.getTalkTypeSet(), room.getTalkTypeSet()) || room.getUnavailableTimeslotSet().contains(timeslot)) continue;
                    ++sessionCount;
                }
            }
            this.nextCell(sessionCount < talkListSize ? this.hardPenaltyStyle : this.defaultStyle).setCellValue((double)sessionCount);
            this.autoSizeColumnsWithHeader();
        }

        private void writeRoomsView() {
            this.nextSheet("Rooms view", 1, 2, true);
            this.nextRow();
            this.nextHeaderCell("");
            this.writeTimeslotDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Room");
            this.writeTimeslotHoursHeaders();
            for (Room room : ((ConferenceSolution)this.solution).getRoomList()) {
                this.nextRow();
                this.currentRow.setHeightInPoints(3.0f * this.currentSheet.getDefaultRowHeightInPoints());
                this.nextCell().setCellValue(room.getName());
                List roomTalkList = ((ConferenceSolution)this.solution).getTalkList().stream().filter(talk -> talk.getRoom() == room).collect(Collectors.toList());
                Timeslot mergePreviousTimeslot = null;
                int mergeStart = -1;
                for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                    List<Talk> talkList = roomTalkList.stream().filter(talk -> talk.getTimeslot() == timeslot).collect(Collectors.toList());
                    if (talkList.isEmpty() && mergePreviousTimeslot != null && timeslot.getStartDateTime().compareTo(mergePreviousTimeslot.getEndDateTime()) < 0) {
                        this.nextCell();
                        continue;
                    }
                    if (mergePreviousTimeslot != null && mergeStart < this.currentColumnNumber) {
                        this.currentSheet.addMergedRegion(new CellRangeAddress(this.currentRowNumber, this.currentRowNumber, mergeStart, this.currentColumnNumber));
                    }
                    boolean unavailable = room.getUnavailableTimeslotSet().contains(timeslot) || Collections.disjoint(room.getTalkTypeSet(), timeslot.getTalkTypeSet());
                    this.nextTalkListCell(unavailable, talkList, talk -> talk.getCode() + ": " + talk.getTitle() + "\n  " + talk.getSpeakerList().stream().map(Speaker::getName).collect(Collectors.joining(", ")));
                    mergePreviousTimeslot = talkList.isEmpty() ? null : timeslot;
                    mergeStart = this.currentColumnNumber;
                }
                if (mergePreviousTimeslot == null || mergeStart >= this.currentColumnNumber) continue;
                this.currentSheet.addMergedRegion(new CellRangeAddress(this.currentRowNumber, this.currentRowNumber, mergeStart, this.currentColumnNumber));
            }
            this.currentSheet.autoSizeColumn(0);
            for (int i = 1; i < this.headerCellCount; ++i) {
                this.currentSheet.setColumnWidth(i, 5120);
            }
        }

        private void writeSpeakersView() {
            this.nextSheet("Speakers view", 1, 2, true);
            String[] filteredConstraintNames = new String[]{"Speaker unavailable timeslot", "Speaker conflict", "Speaker required timeslot tag", "Speaker prohibited timeslot tag", "Speaker preferred timeslot tag", "Speaker undesired timeslot tag", "Speaker required room tag", "Speaker prohibited room tag", "Speaker preferred room tag", "Speaker undesired room tag"};
            this.nextRow();
            this.nextHeaderCell("");
            this.writeTimeslotDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Speaker");
            this.writeTimeslotHoursHeaders();
            for (Speaker speaker : ((ConferenceSolution)this.solution).getSpeakerList()) {
                this.nextRow();
                this.nextCell().setCellValue(speaker.getName());
                List timeslotTalkList = ((ConferenceSolution)this.solution).getTalkList().stream().filter(talk -> talk.getSpeakerList().contains(speaker)).collect(Collectors.toList());
                Timeslot mergePreviousTimeslot = null;
                int mergeStart = -1;
                for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                    List<Talk> talkList = timeslotTalkList.stream().filter(talk -> talk.getTimeslot() == timeslot).collect(Collectors.toList());
                    if (talkList.isEmpty() && mergePreviousTimeslot != null && timeslot.getStartDateTime().compareTo(mergePreviousTimeslot.getEndDateTime()) < 0) {
                        this.nextCell();
                        continue;
                    }
                    if (mergePreviousTimeslot != null && mergeStart < this.currentColumnNumber) {
                        this.currentSheet.addMergedRegion(new CellRangeAddress(this.currentRowNumber, this.currentRowNumber, mergeStart, this.currentColumnNumber));
                    }
                    boolean unavailable = speaker.getUnavailableTimeslotSet().contains(timeslot);
                    this.nextTalkListCell(unavailable, talkList, filteredConstraintNames);
                    mergePreviousTimeslot = talkList.isEmpty() ? null : timeslot;
                    mergeStart = this.currentColumnNumber;
                }
                if (mergePreviousTimeslot == null || mergeStart >= this.currentColumnNumber) continue;
                this.currentSheet.addMergedRegion(new CellRangeAddress(this.currentRowNumber, this.currentRowNumber, mergeStart, this.currentColumnNumber));
            }
            this.currentSheet.autoSizeColumn(0);
            for (int i = 1; i < this.headerCellCount; ++i) {
                this.currentSheet.setColumnWidth(i, 5120);
            }
        }

        private void writeThemeTracksView() {
            this.nextSheet("Theme tracks view", 1, 2, true);
            String[] filteredConstraintNames = new String[]{"Theme track conflict", "Audience type theme track conflict"};
            this.nextRow();
            this.nextHeaderCell("");
            this.writeTimeslotDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Theme track tag");
            this.writeTimeslotHoursHeaders();
            Map tagToTimeslotToTalkListMap = ((ConferenceSolution)this.solution).getTalkList().stream().filter(talk -> talk.getTimeslot() != null).flatMap(talk -> talk.getThemeTrackTagSet().stream().map(tag -> Pair.of((Object)tag, (Object)Pair.of((Object)talk.getTimeslot(), (Object)talk)))).collect(Collectors.groupingBy(Pair::getLeft, Collectors.groupingBy(o -> (Timeslot)((Pair)o.getRight()).getLeft(), Collectors.mapping(o -> (Talk)((Pair)o.getRight()).getRight(), Collectors.toList()))));
            for (Map.Entry entry : tagToTimeslotToTalkListMap.entrySet()) {
                this.nextRow();
                this.nextHeaderCell(entry.getKey());
                Map timeslotToTalkListMap = entry.getValue();
                for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                    List<Talk> talkList = timeslotToTalkListMap.get(timeslot);
                    this.nextTalkListCell(talkList, filteredConstraintNames);
                }
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeSectorsView() {
            this.nextSheet("Sectors view", 1, 2, true);
            String[] filteredConstraintNames = new String[]{"Sector conflict"};
            this.nextRow();
            this.nextHeaderCell("");
            this.writeTimeslotDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Sector tag");
            this.writeTimeslotHoursHeaders();
            Map tagToTimeslotToTalkListMap = ((ConferenceSolution)this.solution).getTalkList().stream().filter(talk -> talk.getTimeslot() != null).flatMap(talk -> talk.getSectorTagSet().stream().map(tag -> Pair.of((Object)tag, (Object)Pair.of((Object)talk.getTimeslot(), (Object)talk)))).collect(Collectors.groupingBy(Pair::getLeft, Collectors.groupingBy(o -> (Timeslot)((Pair)o.getRight()).getLeft(), Collectors.mapping(o -> (Talk)((Pair)o.getRight()).getRight(), Collectors.toList()))));
            for (Map.Entry entry : tagToTimeslotToTalkListMap.entrySet()) {
                this.nextRow();
                this.nextHeaderCell(entry.getKey());
                Map timeslotToTalkListMap = entry.getValue();
                for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                    List<Talk> talkList = timeslotToTalkListMap.get(timeslot);
                    this.nextTalkListCell(talkList, filteredConstraintNames);
                }
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeAudienceTypesView() {
            this.nextSheet("Audience types view", 1, 2, true);
            String[] filteredConstraintNames = new String[]{"Audience type diversity", "Audience type theme track conflict"};
            this.nextRow();
            this.nextHeaderCell("");
            this.writeTimeslotDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Audience type");
            this.writeTimeslotHoursHeaders();
            Map audienceTypeToTimeslotToTalkListMap = ((ConferenceSolution)this.solution).getTalkList().stream().filter(talk -> talk.getTimeslot() != null).flatMap(talk -> talk.getAudienceTypeSet().stream().map(audienceType -> Pair.of((Object)audienceType, (Object)Pair.of((Object)talk.getTimeslot(), (Object)talk)))).collect(Collectors.groupingBy(Pair::getLeft, Collectors.groupingBy(o -> (Timeslot)((Pair)o.getRight()).getLeft(), Collectors.mapping(o -> (Talk)((Pair)o.getRight()).getRight(), Collectors.toList()))));
            for (Map.Entry entry : audienceTypeToTimeslotToTalkListMap.entrySet()) {
                this.nextRow();
                this.nextHeaderCell(entry.getKey());
                Map timeslotToTalkListMap = entry.getValue();
                for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                    List<Talk> talkList = timeslotToTalkListMap.get(timeslot);
                    this.nextTalkListCell(talkList, filteredConstraintNames);
                }
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeAudienceLevelsView() {
            this.nextSheet("Audience levels view", 1, 2, true);
            String[] filteredConstraintNames = new String[]{"Audience level diversity", "Audience level flow per content violation"};
            this.nextRow();
            this.nextHeaderCell("");
            this.writeTimeslotDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Audience level");
            this.writeTimeslotHoursHeaders();
            Map levelToTimeslotToTalkListMap = ((ConferenceSolution)this.solution).getTalkList().stream().filter(talk -> talk.getTimeslot() != null).map(talk -> Pair.of((Object)talk.getAudienceLevel(), (Object)Pair.of((Object)talk.getTimeslot(), (Object)talk))).collect(Collectors.groupingBy(Pair::getLeft, Collectors.groupingBy(o -> (Timeslot)((Pair)o.getRight()).getLeft(), Collectors.mapping(o -> (Talk)((Pair)o.getRight()).getRight(), Collectors.toList()))));
            for (Map.Entry entry : levelToTimeslotToTalkListMap.entrySet()) {
                this.nextRow();
                this.nextHeaderCell(Integer.toString(entry.getKey()));
                Map timeslotToTalkListMap = entry.getValue();
                for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                    List<Talk> talkList = timeslotToTalkListMap.get(timeslot);
                    this.nextTalkListCell(talkList, filteredConstraintNames);
                }
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeContentsView() {
            this.nextSheet("Contents view", 1, 2, true);
            String[] filteredConstraintNames = new String[]{"Audience level flow per content violation", "Content conflict"};
            this.nextRow();
            this.nextHeaderCell("");
            this.writeTimeslotDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Content tag");
            this.writeTimeslotHoursHeaders();
            Map tagToTimeslotToTalkListMap = ((ConferenceSolution)this.solution).getTalkList().stream().filter(talk -> talk.getTimeslot() != null).flatMap(talk -> talk.getContentTagSet().stream().map(tag -> Pair.of((Object)tag, (Object)Pair.of((Object)talk.getTimeslot(), (Object)talk)))).collect(Collectors.groupingBy(Pair::getLeft, Collectors.groupingBy(o -> (Timeslot)((Pair)o.getRight()).getLeft(), Collectors.mapping(o -> (Talk)((Pair)o.getRight()).getRight(), Collectors.toList()))));
            for (Map.Entry entry : tagToTimeslotToTalkListMap.entrySet()) {
                this.nextRow();
                this.nextHeaderCell(entry.getKey());
                Map timeslotToTalkListMap = entry.getValue();
                for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                    List<Talk> talkList = timeslotToTalkListMap.get(timeslot);
                    this.nextTalkListCell(talkList, (Talk talk) -> talk.getCode() + " (level " + talk.getAudienceLevel() + ")", filteredConstraintNames);
                }
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeLanguagesView() {
            this.nextSheet("Languages view", 1, 2, true);
            String[] filteredConstraintNames = new String[]{"Language diversity"};
            this.nextRow();
            this.nextHeaderCell("");
            this.writeTimeslotDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Language");
            this.writeTimeslotHoursHeaders();
            Map languageToTimeslotToTalkListMap = ((ConferenceSolution)this.solution).getTalkList().stream().filter(talk -> talk.getTimeslot() != null).map(talk -> Pair.of((Object)talk.getLanguage(), (Object)Pair.of((Object)talk.getTimeslot(), (Object)talk))).collect(Collectors.groupingBy(Pair::getLeft, Collectors.groupingBy(o -> (Timeslot)((Pair)o.getRight()).getLeft(), Collectors.mapping(o -> (Talk)((Pair)o.getRight()).getRight(), Collectors.toList()))));
            for (Map.Entry entry : languageToTimeslotToTalkListMap.entrySet()) {
                this.nextRow();
                this.nextHeaderCell(entry.getKey());
                Map timeslotToTalkListMap = entry.getValue();
                for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                    List<Talk> talkList = timeslotToTalkListMap.get(timeslot);
                    this.nextTalkListCell(talkList, filteredConstraintNames);
                }
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeScoreView() {
            this.nextSheet("Score view", 1, 1, true);
            this.nextHeaderCell("Score");
            this.nextCell().setCellValue(((ConferenceSolution)this.solution).getScore() == null ? "Not yet solved" : ((ConferenceSolution)this.solution).getScore().toShortString());
            this.nextRow();
            this.nextRow();
            this.nextHeaderCell("Constraint match");
            this.nextHeaderCell("Match score");
            this.nextHeaderCell("Total score");
            for (ConstraintMatchTotal constraintMatchTotal : this.constraintMatchTotalList) {
                this.nextRow();
                this.nextHeaderCell(constraintMatchTotal.getConstraintName());
                this.nextCell();
                this.nextCell().setCellValue(constraintMatchTotal.getScore().toShortString());
                ArrayList<ConstraintMatch> constraintMatchList = new ArrayList<ConstraintMatch>(constraintMatchTotal.getConstraintMatchSet());
                constraintMatchList.sort(Comparator.comparing(ConstraintMatch::getScore));
                for (ConstraintMatch constraintMatch : constraintMatchList) {
                    this.nextRow();
                    this.nextCell().setCellValue("    " + constraintMatch.getJustificationList().stream().filter(o -> o instanceof Talk).map(o -> ((Talk)o).getCode()).collect(Collectors.joining(", ")));
                    this.nextCell().setCellValue(constraintMatch.getScore().toShortString());
                    this.nextCell();
                    this.nextCell();
                }
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeTimeslotDaysHeaders() {
            LocalDate previousTimeslotDay = null;
            int mergeStart = -1;
            for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                LocalDate timeslotDay = timeslot.getDate();
                if (timeslotDay.equals(previousTimeslotDay)) {
                    this.nextHeaderCell("");
                    continue;
                }
                if (previousTimeslotDay != null) {
                    this.currentSheet.addMergedRegion(new CellRangeAddress(this.currentRowNumber, this.currentRowNumber, mergeStart, this.currentColumnNumber));
                }
                this.nextHeaderCell(AbstractXlsxSolutionFileIO.DAY_FORMATTER.format(timeslotDay));
                previousTimeslotDay = timeslotDay;
                mergeStart = this.currentColumnNumber;
            }
            if (previousTimeslotDay != null) {
                this.currentSheet.addMergedRegion(new CellRangeAddress(this.currentRowNumber, this.currentRowNumber, mergeStart, this.currentColumnNumber));
            }
        }

        private void writeTimeslotHoursHeaders() {
            for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                this.nextHeaderCell(AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(timeslot.getStartDateTime()) + "-" + AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(timeslot.getEndDateTime()));
            }
        }

        protected void nextTalkListCell(List<Talk> talkList, String[] filteredConstraintNames) {
            this.nextTalkListCell(false, talkList, filteredConstraintNames);
        }

        protected void nextTalkListCell(boolean unavailable, List<Talk> talkList, String[] filteredConstraintNames) {
            this.nextTalkListCell(unavailable, talkList, talk -> talk.getCode() + " @ " + (talk.getRoom() == null ? "No room" : talk.getRoom().getName()), filteredConstraintNames);
        }

        protected void nextTalkListCell(List<Talk> talkList, Function<Talk, String> stringFunction, String[] filteredConstraintNames) {
            this.nextTalkListCell(false, talkList, stringFunction, filteredConstraintNames);
        }

        protected void nextTalkListCell(boolean unavailable, List<Talk> talkList, Function<Talk, String> stringFunction) {
            this.nextTalkListCell(unavailable, talkList, stringFunction, null);
        }

        protected void nextTalkListCell(boolean unavailable, List<Talk> talkList, Function<Talk, String> stringFunction, String[] filteredConstraintNames) {
            List<String> filteredConstraintNameList;
            List<String> list = filteredConstraintNameList = filteredConstraintNames == null ? null : Arrays.asList(filteredConstraintNames);
            if (talkList == null) {
                talkList = Collections.emptyList();
            }
            HardSoftScore score = talkList.stream().map(this.indictmentMap::get).filter(Objects::nonNull).flatMap(indictment -> indictment.getConstraintMatchSet().stream()).filter(constraintMatch -> filteredConstraintNameList == null || filteredConstraintNameList.contains(constraintMatch.getConstraintName())).map(constraintMatch -> (HardSoftScore)constraintMatch.getScore()).filter(indictmentScore -> indictmentScore.getHardScore() < 0 || indictmentScore.getSoftScore() < 0).reduce(Score::add).orElse(HardSoftScore.ZERO);
            XSSFCell cell = talkList.stream().anyMatch(Talk::isPinnedByUser) ? this.nextCell(this.pinnedStyle) : (!score.isFeasible() ? this.nextCell(this.hardPenaltyStyle) : (unavailable ? this.nextCell(this.unavailableStyle) : (score.getSoftScore() < 0 ? this.nextCell(this.softPenaltyStyle) : this.nextCell(this.wrappedStyle))));
            if (!talkList.isEmpty()) {
                ClientAnchor anchor = this.creationHelper.createClientAnchor();
                anchor.setCol1(cell.getColumnIndex());
                anchor.setCol2(cell.getColumnIndex() + 4);
                anchor.setRow1(this.currentRow.getRowNum());
                anchor.setRow2(this.currentRow.getRowNum() + 4);
                Comment comment = this.currentDrawing.createCellComment(anchor);
                StringBuilder commentString = new StringBuilder(talkList.size() * 200);
                for (Talk talk : talkList) {
                    commentString.append(talk.getCode()).append(": ").append(talk.getTitle()).append("\n    ").append(talk.getSpeakerList().stream().map(Speaker::getName).collect(Collectors.joining(", "))).append(talk.isPinnedByUser() ? "\nPINNED BY USER" : "");
                    Indictment indictment2 = (Indictment)this.indictmentMap.get(talk);
                    if (indictment2 != null) {
                        commentString.append("\n").append(indictment2.getScore().toShortString()).append(" total");
                        Set constraintMatchSet = indictment2.getConstraintMatchSet();
                        List constraintNameList = constraintMatchSet.stream().map(ConstraintMatch::getConstraintName).distinct().collect(Collectors.toList());
                        for (String constraintName : constraintNameList) {
                            List filteredConstraintMatchList = constraintMatchSet.stream().filter(constraintMatch -> constraintMatch.getConstraintName().equals(constraintName)).collect(Collectors.toList());
                            Score sum = filteredConstraintMatchList.stream().map(ConstraintMatch::getScore).reduce(Score::add).orElse((Score)HardSoftScore.ZERO);
                            String justificationTalkCodes = filteredConstraintMatchList.stream().flatMap(constraintMatch -> constraintMatch.getJustificationList().stream()).filter(justification -> justification instanceof Talk && justification != talk).distinct().map(o -> ((Talk)o).getCode()).collect(Collectors.joining(", "));
                            commentString.append("\n    ").append(sum.toShortString()).append(" for ").append(filteredConstraintMatchList.size()).append(" ").append(constraintName).append("s").append("\n        ").append(justificationTalkCodes);
                        }
                    }
                    commentString.append("\n\n");
                }
                comment.setString(this.creationHelper.createRichTextString(commentString.toString()));
                cell.setCellComment(comment);
            }
            cell.setCellValue(talkList.stream().map(stringFunction).collect(Collectors.joining("\n")));
            this.currentRow.setHeightInPoints(Math.max(this.currentRow.getHeightInPoints(), (float)talkList.size() * this.currentSheet.getDefaultRowHeightInPoints()));
        }
    }

    private static class ConferenceSchedulingXlsxReader
    extends AbstractXlsxSolutionFileIO.AbstractXlsxReader<ConferenceSolution> {
        private Map<String, TalkType> totalTalkTypeMap;
        private Set<String> totalTimeslotTagSet;
        private Set<String> totalRoomTagSet;

        public ConferenceSchedulingXlsxReader(XSSFWorkbook workbook) {
            super(workbook);
        }

        @Override
        public ConferenceSolution read() {
            this.solution = new ConferenceSolution();
            this.totalTalkTypeMap = new HashMap<String, TalkType>();
            this.totalTimeslotTagSet = new HashSet<String>();
            this.totalRoomTagSet = new HashSet<String>();
            this.readConfiguration();
            this.readTimeslotList();
            this.readRoomList();
            this.readSpeakerList();
            this.readTalkList();
            ((ConferenceSolution)this.solution).getTimeslotList().sort(Comparator.comparing(Timeslot::getStartDateTime).thenComparing(Comparator.comparing(Timeslot::getEndDateTime).reversed()));
            return (ConferenceSolution)this.solution;
        }

        private void readConfiguration() {
            this.nextSheet("Configuration");
            this.nextRow();
            this.readHeaderCell("Conference name");
            ((ConferenceSolution)this.solution).setConferenceName(this.nextStringCell().getStringCellValue());
            if (!VALID_NAME_PATTERN.matcher(((ConferenceSolution)this.solution).getConferenceName()).matches()) {
                throw new IllegalStateException(this.currentPosition() + ": The conference name (" + ((ConferenceSolution)this.solution).getConferenceName() + ") must match to the regular expression (" + VALID_NAME_PATTERN + ").");
            }
            this.nextRow(true);
            this.readHeaderCell("Constraint");
            this.readHeaderCell("Weight");
            this.readHeaderCell("Description");
            ConferenceParametrization parametrization = new ConferenceParametrization();
            parametrization.setId(0L);
            this.readIntConstraintLine("Theme track conflict", parametrization::setThemeTrackConflict, "Soft penalty per common theme track of 2 talks that have an overlapping timeslot");
            this.readIntConstraintLine("Sector conflict", parametrization::setSectorConflict, "Soft penalty per common sector of 2 talks that have an overlapping timeslot");
            this.readIntConstraintLine("Audience type diversity", parametrization::setAudienceTypeDiversity, "Soft reward per 2 talks that have the same timeslot and a different audience type");
            this.readIntConstraintLine("Audience type theme track conflict", parametrization::setAudienceTypeThemeTrackConflict, "Soft penalty per 2 talks that have a common audience type, have a common theme track and have an overlapping timeslot");
            this.readIntConstraintLine("Audience level diversity", parametrization::setAudienceLevelDiversity, "Soft reward per 2 talks that have the same timeslot and a different audience level");
            this.readIntConstraintLine("Audience level flow per content violation", parametrization::setAudienceLevelFlowPerContentViolation, "Soft penalty per common content of 2 talks with a different audience level for which the easier talk isn't scheduled earlier than the other talk");
            this.readIntConstraintLine("Content conflict", parametrization::setContentConflict, "Soft penalty per common content of 2 talks that have an overlapping timeslot");
            this.readIntConstraintLine("Language diversity", parametrization::setLanguageDiversity, "Soft reward per 2 talks that have the same timeslot and a different language");
            this.readIntConstraintLine("Speaker preferred timeslot tag", parametrization::setSpeakerPreferredTimeslotTag, "Soft penalty per missing preferred tag in a talk's timeslot");
            this.readIntConstraintLine("Speaker undesired timeslot tag", parametrization::setSpeakerUndesiredTimeslotTag, "Soft penalty per undesired tag in a talk's timeslot");
            this.readIntConstraintLine("Talk preferred timeslot tag", parametrization::setTalkPreferredTimeslotTag, "Soft penalty per missing preferred tag in a talk's timeslot");
            this.readIntConstraintLine("Talk undesired timeslot tag", parametrization::setTalkUndesiredTimeslotTag, "Soft penalty per undesired tag in a talk's timeslot");
            this.readIntConstraintLine("Speaker preferred room tag", parametrization::setSpeakerPreferredRoomTag, "Soft penalty per missing preferred tag in a talk's room");
            this.readIntConstraintLine("Speaker undesired room tag", parametrization::setSpeakerUndesiredRoomTag, "Soft penalty per undesired tag in a talk's room");
            this.readIntConstraintLine("Talk preferred room tag", parametrization::setTalkPreferredRoomTag, "Soft penalty per missing preferred tag in a talk's room");
            this.readIntConstraintLine("Talk undesired room tag", parametrization::setTalkUndesiredRoomTag, "Soft penalty per undesired tag in a talk's room");
            this.readIntConstraintLine("Talk type of timeslot", null, "Hard penalty per talk in a timeslot with an other talk type");
            this.readIntConstraintLine("Room unavailable timeslot", null, "Hard penalty per talk with an unavailable room at its timeslot");
            this.readIntConstraintLine("Room conflict", null, "Hard penalty per pair of talks in the same room in overlapping timeslots");
            this.readIntConstraintLine("Speaker unavailable timeslot", null, "Hard penalty per talk with an unavailable speaker at its timeslot");
            this.readIntConstraintLine("Speaker conflict", null, "Hard penalty per pair of talks with the same speaker in overlapping timeslots");
            this.readIntConstraintLine("Speaker required timeslot tag", null, "Hard penalty per missing required tag in a talk's timeslot");
            this.readIntConstraintLine("Speaker prohibited timeslot tag", null, "Hard penalty per prohibited tag in a talk's timeslot");
            this.readIntConstraintLine("Talk required timeslot tag", null, "Hard penalty per missing required tag in a talk's timeslot");
            this.readIntConstraintLine("Talk prohibited timeslot tag", null, "Hard penalty per prohibited tag in a talk's timeslot");
            this.readIntConstraintLine("Speaker required room tag", null, "Hard penalty per missing required tag in a talk's room");
            this.readIntConstraintLine("Speaker prohibited room tag", null, "Hard penalty per prohibited tag in a talk's room");
            this.readIntConstraintLine("Talk required room tag", null, "Hard penalty per missing required tag in a talk's room");
            this.readIntConstraintLine("Talk prohibited room tag", null, "Hard penalty per prohibited tag in a talk's room");
            ((ConferenceSolution)this.solution).setParametrization(parametrization);
        }

        private void readTimeslotList() {
            this.nextSheet("Timeslots");
            this.nextRow(false);
            this.readHeaderCell("Day");
            this.readHeaderCell("Start");
            this.readHeaderCell("End");
            this.readHeaderCell("Talk types");
            this.readHeaderCell("Tags");
            ArrayList<TalkType> talkTypeList = new ArrayList<TalkType>();
            ArrayList<Timeslot> timeslotList = new ArrayList<Timeslot>(this.currentSheet.getLastRowNum() - 1);
            long id = 0L;
            long talkTypeId = 0L;
            while (this.nextRow()) {
                Timeslot timeslot = new Timeslot();
                timeslot.setId(id++);
                LocalDate day = LocalDate.parse(this.nextStringCell().getStringCellValue(), AbstractXlsxSolutionFileIO.DAY_FORMATTER);
                LocalTime startTime = LocalTime.parse(this.nextStringCell().getStringCellValue(), AbstractXlsxSolutionFileIO.TIME_FORMATTER);
                LocalTime endTime = LocalTime.parse(this.nextStringCell().getStringCellValue(), AbstractXlsxSolutionFileIO.TIME_FORMATTER);
                if (startTime.compareTo(endTime) >= 0) {
                    throw new IllegalStateException(this.currentPosition() + ": The startTime (" + startTime + ") must be less than the endTime (" + endTime + ").");
                }
                timeslot.setStartDateTime(LocalDateTime.of(day, startTime));
                timeslot.setEndDateTime(LocalDateTime.of(day, endTime));
                String[] talkTypeNames = this.nextStringCell().getStringCellValue().split(", ");
                LinkedHashSet<TalkType> talkTypeSet = new LinkedHashSet<TalkType>(talkTypeNames.length);
                for (String talkTypeName : talkTypeNames) {
                    TalkType talkType = this.totalTalkTypeMap.get(talkTypeName);
                    if (talkType == null) {
                        talkType = new TalkType(talkTypeId);
                        ++talkTypeId;
                        if (!VALID_TAG_PATTERN.matcher(talkTypeName).matches()) {
                            throw new IllegalStateException(this.currentPosition() + ": The timeslot (" + timeslot + ")'s talkType (" + talkTypeName + ") must match to the regular expression (" + VALID_TAG_PATTERN + ").");
                        }
                        talkType.setName(talkTypeName);
                        talkType.setCompatibleTimeslotSet(new LinkedHashSet<Timeslot>());
                        talkType.setCompatibleRoomSet(new LinkedHashSet<Room>());
                        this.totalTalkTypeMap.put(talkTypeName, talkType);
                        talkTypeList.add(talkType);
                    }
                    talkTypeSet.add(talkType);
                    talkType.getCompatibleTimeslotSet().add(timeslot);
                }
                if (talkTypeSet.isEmpty()) {
                    throw new IllegalStateException(this.currentPosition() + ": The timeslot (" + timeslot + ")'s talk types (" + timeslot.getTalkTypeSet() + ") must not be empty.");
                }
                timeslot.setTalkTypeSet(talkTypeSet);
                timeslot.setTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                for (String tag2 : timeslot.getTagSet()) {
                    if (VALID_TAG_PATTERN.matcher(tag2).matches()) continue;
                    throw new IllegalStateException(this.currentPosition() + ": The timeslot (" + timeslot + ")'s tag (" + tag2 + ") must match to the regular expression (" + VALID_TAG_PATTERN + ").");
                }
                this.totalTimeslotTagSet.addAll(timeslot.getTagSet());
                timeslotList.add(timeslot);
            }
            ((ConferenceSolution)this.solution).setTimeslotList(timeslotList);
            ((ConferenceSolution)this.solution).setTalkTypeList(talkTypeList);
        }

        private void readRoomList() {
            this.nextSheet("Rooms");
            this.nextRow(false);
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readTimeslotDaysHeaders();
            this.nextRow(false);
            this.readHeaderCell("Name");
            this.readHeaderCell("Talk types");
            this.readHeaderCell("Tags");
            this.readTimeslotHoursHeaders();
            ArrayList<Room> roomList = new ArrayList<Room>(this.currentSheet.getLastRowNum() - 1);
            long id = 0L;
            while (this.nextRow()) {
                LinkedHashSet<TalkType> talkTypeSet;
                Room room = new Room();
                room.setId(id++);
                room.setName(this.nextStringCell().getStringCellValue());
                if (!VALID_NAME_PATTERN.matcher(room.getName()).matches()) {
                    throw new IllegalStateException(this.currentPosition() + ": The room name (" + room.getName() + ") must match to the regular expression (" + VALID_NAME_PATTERN + ").");
                }
                String[] talkTypeNames = this.nextStringCell().getStringCellValue().split(", ");
                if (talkTypeNames.length == 0 || talkTypeNames.length == 1 && talkTypeNames[0].isEmpty()) {
                    talkTypeSet = new LinkedHashSet<TalkType>(this.totalTalkTypeMap.values());
                    for (TalkType talkType : talkTypeSet) {
                        talkType.getCompatibleRoomSet().add(room);
                    }
                } else {
                    talkTypeSet = new LinkedHashSet(talkTypeNames.length);
                    for (String talkTypeName : talkTypeNames) {
                        TalkType talkType = this.totalTalkTypeMap.get(talkTypeName);
                        if (talkType == null) {
                            throw new IllegalStateException(this.currentPosition() + ": The room (" + room + ")'s talkType (" + talkTypeName + ") does not exist in the talk types (" + this.totalTalkTypeMap.keySet() + ") of the other sheet (Timeslots).");
                        }
                        talkTypeSet.add(talkType);
                        talkType.getCompatibleRoomSet().add(room);
                    }
                }
                room.setTalkTypeSet(talkTypeSet);
                room.setTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                for (String tag2 : room.getTagSet()) {
                    if (VALID_TAG_PATTERN.matcher(tag2).matches()) continue;
                    throw new IllegalStateException(this.currentPosition() + ": The room (" + room + ")'s tag (" + tag2 + ") must match to the regular expression (" + VALID_TAG_PATTERN + ").");
                }
                this.totalRoomTagSet.addAll(room.getTagSet());
                LinkedHashSet<Timeslot> unavailableTimeslotSet = new LinkedHashSet<Timeslot>();
                for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                    XSSFCell cell = this.nextStringCell();
                    if (Objects.equals(this.extractColor(cell, UNAVAILABLE_COLOR), UNAVAILABLE_COLOR)) {
                        unavailableTimeslotSet.add(timeslot);
                    }
                    if (cell.getStringCellValue().isEmpty()) continue;
                    throw new IllegalStateException(this.currentPosition() + ": The cell (" + cell.getStringCellValue() + ") should be empty. Use the talks sheet pre-assign rooms and timeslots.");
                }
                room.setUnavailableTimeslotSet(unavailableTimeslotSet);
                roomList.add(room);
            }
            ((ConferenceSolution)this.solution).setRoomList(roomList);
        }

        private void readSpeakerList() {
            this.nextSheet("Speakers");
            this.nextRow(false);
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readTimeslotDaysHeaders();
            this.nextRow(false);
            this.readHeaderCell("Name");
            this.readHeaderCell("Required timeslot tags");
            this.readHeaderCell("Preferred timeslot tags");
            this.readHeaderCell("Prohibited timeslot tags");
            this.readHeaderCell("Undesired timeslot tags");
            this.readHeaderCell("Required room tags");
            this.readHeaderCell("Preferred room tags");
            this.readHeaderCell("Prohibited room tags");
            this.readHeaderCell("Undesired room tags");
            this.readTimeslotHoursHeaders();
            ArrayList<Speaker> speakerList = new ArrayList<Speaker>(this.currentSheet.getLastRowNum() - 1);
            long id = 0L;
            while (this.nextRow()) {
                Speaker speaker = new Speaker();
                speaker.setId(id++);
                speaker.setName(this.nextStringCell().getStringCellValue());
                if (!VALID_NAME_PATTERN.matcher(speaker.getName()).matches()) {
                    throw new IllegalStateException(this.currentPosition() + ": The speaker name (" + speaker.getName() + ") must match to the regular expression (" + VALID_NAME_PATTERN + ").");
                }
                speaker.setRequiredTimeslotTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyTimeslotTags(speaker.getRequiredTimeslotTagSet());
                speaker.setPreferredTimeslotTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyTimeslotTags(speaker.getPreferredTimeslotTagSet());
                speaker.setProhibitedTimeslotTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyTimeslotTags(speaker.getProhibitedTimeslotTagSet());
                speaker.setUndesiredTimeslotTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyTimeslotTags(speaker.getUndesiredTimeslotTagSet());
                speaker.setRequiredRoomTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyRoomTags(speaker.getRequiredRoomTagSet());
                speaker.setPreferredRoomTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyRoomTags(speaker.getPreferredRoomTagSet());
                speaker.setProhibitedRoomTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyRoomTags(speaker.getProhibitedRoomTagSet());
                speaker.setUndesiredRoomTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyRoomTags(speaker.getUndesiredRoomTagSet());
                LinkedHashSet<Timeslot> unavailableTimeslotSet = new LinkedHashSet<Timeslot>();
                for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                    XSSFCell cell = this.nextStringCell();
                    if (Objects.equals(this.extractColor(cell, UNAVAILABLE_COLOR), UNAVAILABLE_COLOR)) {
                        unavailableTimeslotSet.add(timeslot);
                    }
                    if (cell.getStringCellValue().isEmpty()) continue;
                    throw new IllegalStateException(this.currentPosition() + ": The cell (" + cell.getStringCellValue() + ") should be empty. Use the talks sheet pre-assign rooms and timeslots.");
                }
                speaker.setUnavailableTimeslotSet(unavailableTimeslotSet);
                speakerList.add(speaker);
            }
            ((ConferenceSolution)this.solution).setSpeakerList(speakerList);
        }

        private void readTalkList() {
            Map<String, Speaker> speakerMap = ((ConferenceSolution)this.solution).getSpeakerList().stream().collect(Collectors.toMap(Speaker::getName, speaker -> speaker));
            this.nextSheet("Talks");
            this.nextRow(false);
            this.readHeaderCell("Code");
            this.readHeaderCell("Title");
            this.readHeaderCell("Talk type");
            this.readHeaderCell("Speakers");
            this.readHeaderCell("Theme track tags");
            this.readHeaderCell("Sector tags");
            this.readHeaderCell("Audience types");
            this.readHeaderCell("Audience level");
            this.readHeaderCell("Content tags");
            this.readHeaderCell("Language");
            this.readHeaderCell("Required timeslot tags");
            this.readHeaderCell("Preferred timeslot tags");
            this.readHeaderCell("Prohibited timeslot tags");
            this.readHeaderCell("Undesired timeslot tags");
            this.readHeaderCell("Required room tags");
            this.readHeaderCell("Preferred room tags");
            this.readHeaderCell("Prohibited room tags");
            this.readHeaderCell("Undesired room tags");
            this.readHeaderCell("Pinned by user");
            this.readHeaderCell("Timeslot day");
            this.readHeaderCell("Start");
            this.readHeaderCell("End");
            this.readHeaderCell("Room");
            ArrayList<Talk> talkList = new ArrayList<Talk>(this.currentSheet.getLastRowNum() - 1);
            long id = 0L;
            Map timeslotMap = ((ConferenceSolution)this.solution).getTimeslotList().stream().collect(Collectors.toMap(timeslot -> Pair.of((Object)timeslot.getStartDateTime(), (Object)timeslot.getEndDateTime()), Function.identity()));
            Map roomMap = ((ConferenceSolution)this.solution).getRoomList().stream().collect(Collectors.toMap(Room::getName, Function.identity()));
            while (this.nextRow()) {
                String roomName;
                Talk talk = new Talk();
                talk.setId(id++);
                talk.setCode(this.nextStringCell().getStringCellValue());
                if (!VALID_CODE_PATTERN.matcher(talk.getCode()).matches()) {
                    throw new IllegalStateException(this.currentPosition() + ": The talk code (" + talk.getCode() + ") must match to the regular expression (" + VALID_CODE_PATTERN + ").");
                }
                talk.setTitle(this.nextStringCell().getStringCellValue());
                String talkTypeName = this.nextStringCell().getStringCellValue();
                TalkType talkType = this.totalTalkTypeMap.get(talkTypeName);
                if (talkType == null) {
                    throw new IllegalStateException(this.currentPosition() + ": The talk (" + talk + ")'s talkType (" + talkType + ") does not exist in the talk types (" + this.totalTalkTypeMap.keySet() + ") of the other sheet (Timeslots).");
                }
                talk.setTalkType(talkType);
                talk.setSpeakerList(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).map(speakerName -> {
                    Speaker speaker = (Speaker)speakerMap.get(speakerName);
                    if (speaker == null) {
                        throw new IllegalStateException(this.currentPosition() + ": The talk with code (" + talk.getCode() + ") has a speaker (" + speakerName + ") that doesn't exist in the speaker list.");
                    }
                    return speaker;
                }).collect(Collectors.toList()));
                talk.setThemeTrackTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                for (String tag2 : talk.getThemeTrackTagSet()) {
                    if (VALID_TAG_PATTERN.matcher(tag2).matches()) continue;
                    throw new IllegalStateException(this.currentPosition() + ": The talk (" + talk + ")'s theme tag (" + tag2 + ") must match to the regular expression (" + VALID_TAG_PATTERN + ").");
                }
                talk.setSectorTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                for (String tag2 : talk.getSectorTagSet()) {
                    if (VALID_TAG_PATTERN.matcher(tag2).matches()) continue;
                    throw new IllegalStateException(this.currentPosition() + ": The talk (" + talk + ")'s sector tag (" + tag2 + ") must match to the regular expression (" + VALID_TAG_PATTERN + ").");
                }
                talk.setAudienceTypeSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                for (String audienceType : talk.getAudienceTypeSet()) {
                    if (VALID_TAG_PATTERN.matcher(audienceType).matches()) continue;
                    throw new IllegalStateException(this.currentPosition() + ": The talk (" + talk + ")'s audience type (" + audienceType + ") must match to the regular expression (" + VALID_TAG_PATTERN + ").");
                }
                double audienceLevelDouble = this.nextNumericCell().getNumericCellValue();
                if (audienceLevelDouble <= 0.0 || audienceLevelDouble != Math.floor(audienceLevelDouble)) {
                    throw new IllegalStateException(this.currentPosition() + ": The talk with code (" + talk.getCode() + ")'s has an audience level (" + audienceLevelDouble + ") that isn't a strictly positive integer number.");
                }
                talk.setAudienceLevel((int)audienceLevelDouble);
                talk.setContentTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                for (String tag3 : talk.getContentTagSet()) {
                    if (VALID_TAG_PATTERN.matcher(tag3).matches()) continue;
                    throw new IllegalStateException(this.currentPosition() + ": The talk (" + talk + ")'s content tag (" + tag3 + ") must match to the regular expression (" + VALID_TAG_PATTERN + ").");
                }
                talk.setLanguage(this.nextStringCell().getStringCellValue());
                talk.setRequiredTimeslotTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyTimeslotTags(talk.getRequiredTimeslotTagSet());
                talk.setPreferredTimeslotTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyTimeslotTags(talk.getPreferredTimeslotTagSet());
                talk.setProhibitedTimeslotTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyTimeslotTags(talk.getProhibitedTimeslotTagSet());
                talk.setUndesiredTimeslotTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyTimeslotTags(talk.getUndesiredTimeslotTagSet());
                talk.setRequiredRoomTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyRoomTags(talk.getRequiredRoomTagSet());
                talk.setPreferredRoomTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyRoomTags(talk.getPreferredRoomTagSet());
                talk.setProhibitedRoomTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyRoomTags(talk.getProhibitedRoomTagSet());
                talk.setUndesiredRoomTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyRoomTags(talk.getUndesiredRoomTagSet());
                talk.setPinnedByUser(this.nextBooleanCell().getBooleanCellValue());
                String dateString = this.nextStringCell().getStringCellValue();
                String startTimeString = this.nextStringCell().getStringCellValue();
                String endTimeString = this.nextStringCell().getStringCellValue();
                if (!(dateString.isEmpty() && startTimeString.isEmpty() && endTimeString.isEmpty())) {
                    LocalDateTime endDateTime;
                    LocalDateTime startDateTime;
                    try {
                        startDateTime = LocalDateTime.of(LocalDate.parse(dateString, AbstractXlsxSolutionFileIO.DAY_FORMATTER), LocalTime.parse(startTimeString, AbstractXlsxSolutionFileIO.TIME_FORMATTER));
                        endDateTime = LocalDateTime.of(LocalDate.parse(dateString, AbstractXlsxSolutionFileIO.DAY_FORMATTER), LocalTime.parse(endTimeString, AbstractXlsxSolutionFileIO.TIME_FORMATTER));
                    }
                    catch (DateTimeParseException e) {
                        throw new IllegalStateException(this.currentPosition() + ": The talk with code (" + talk.getCode() + ") has a timeslot date (" + dateString + "), startTime (" + startTimeString + ") and endTime (" + endTimeString + ") that doesn't parse as a date or time.", e);
                    }
                    Timeslot timeslot2 = (Timeslot)timeslotMap.get(Pair.of((Object)startDateTime, (Object)endDateTime));
                    if (timeslot2 == null) {
                        throw new IllegalStateException(this.currentPosition() + ": The talk with code (" + talk.getCode() + ") has a timeslot date (" + dateString + "), startTime (" + startTimeString + ") and endTime (" + endTimeString + ") that doesn't exist in the other sheet (Timeslots).");
                    }
                    talk.setTimeslot(timeslot2);
                }
                if (!(roomName = this.nextStringCell().getStringCellValue()).isEmpty()) {
                    Room room = (Room)roomMap.get(roomName);
                    if (room == null) {
                        throw new IllegalStateException(this.currentPosition() + ": The talk with code (" + talk.getCode() + ") has a roomName (" + roomName + ") that doesn't exist in the other sheet (Rooms).");
                    }
                    talk.setRoom(room);
                }
                talkList.add(talk);
            }
            ((ConferenceSolution)this.solution).setTalkList(talkList);
        }

        private void verifyTimeslotTags(Set<String> timeslotTagSet) {
            for (String tag : timeslotTagSet) {
                if (this.totalTimeslotTagSet.contains(tag)) continue;
                throw new IllegalStateException(this.currentPosition() + ": The timeslot tag (" + tag + ") does not exist in the tags (" + this.totalTimeslotTagSet + ") of the other sheet (Timeslots).");
            }
        }

        private void verifyRoomTags(Set<String> roomTagSet) {
            for (String tag : roomTagSet) {
                if (this.totalRoomTagSet.contains(tag)) continue;
                throw new IllegalStateException(this.currentPosition() + ": The room tag (" + tag + ") does not exist in the tags (" + this.totalRoomTagSet + ") of the other sheet (Rooms).");
            }
        }

        private void readTimeslotDaysHeaders() {
            LocalDate previousTimeslotDay = null;
            for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                LocalDate timeslotDay = timeslot.getDate();
                if (timeslotDay.equals(previousTimeslotDay)) {
                    this.readHeaderCell("");
                    continue;
                }
                this.readHeaderCell(AbstractXlsxSolutionFileIO.DAY_FORMATTER.format(timeslotDay));
                previousTimeslotDay = timeslotDay;
            }
        }

        private void readTimeslotHoursHeaders() {
            for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                this.readHeaderCell(AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(timeslot.getStartDateTime()) + "-" + AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(timeslot.getEndDateTime()));
            }
        }
    }
}

