/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cheaptime.solver.move;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.examples.cheaptime.domain.CheapTimeSolution;
import org.optaplanner.examples.cheaptime.domain.TaskAssignment;

public class CheapTimePillarSlideMove
extends AbstractMove<CheapTimeSolution> {
    private final List<TaskAssignment> pillar;
    private final int startPeriodDiff;

    public CheapTimePillarSlideMove(List<TaskAssignment> pillar, int startPeriodDiff) {
        this.pillar = pillar;
        this.startPeriodDiff = startPeriodDiff;
    }

    public boolean isMoveDoable(ScoreDirector<CheapTimeSolution> scoreDirector) {
        return true;
    }

    public CheapTimePillarSlideMove createUndoMove(ScoreDirector<CheapTimeSolution> scoreDirector) {
        return new CheapTimePillarSlideMove(this.pillar, -this.startPeriodDiff);
    }

    protected void doMoveOnGenuineVariables(ScoreDirector<CheapTimeSolution> scoreDirector) {
        for (TaskAssignment taskAssignment : this.pillar) {
            scoreDirector.beforeVariableChanged((Object)taskAssignment, "startPeriod");
            taskAssignment.setStartPeriod(taskAssignment.getStartPeriod() + this.startPeriodDiff);
            scoreDirector.afterVariableChanged((Object)taskAssignment, "startPeriod");
        }
    }

    public CheapTimePillarSlideMove rebase(ScoreDirector<CheapTimeSolution> destinationScoreDirector) {
        return new CheapTimePillarSlideMove(CheapTimePillarSlideMove.rebaseList(this.pillar, destinationScoreDirector), this.startPeriodDiff);
    }

    public Collection<? extends Object> getPlanningEntities() {
        return Collections.singletonList(this.pillar);
    }

    public Collection<? extends Object> getPlanningValues() {
        ArrayList<Integer> startPeriodList = new ArrayList<Integer>(this.pillar.size());
        for (TaskAssignment taskAssignment : this.pillar) {
            startPeriodList.add(taskAssignment.getStartPeriod());
        }
        return Collections.singletonList(startPeriodList);
    }

    public String toString() {
        return this.pillar + " {" + (this.startPeriodDiff < 0 ? Integer.valueOf(this.startPeriodDiff) : "+" + this.startPeriodDiff) + "}";
    }
}

