/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cheaptime.solver.score;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.core.api.score.calculator.ConstraintMatchAwareIncrementalScoreCalculator;
import org.optaplanner.core.api.score.calculator.IncrementalScoreCalculator;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.impl.score.constraint.DefaultConstraintMatchTotal;
import org.optaplanner.examples.cheaptime.domain.CheapTimeSolution;
import org.optaplanner.examples.cheaptime.domain.Machine;
import org.optaplanner.examples.cheaptime.domain.PeriodPowerPrice;
import org.optaplanner.examples.cheaptime.domain.Resource;
import org.optaplanner.examples.cheaptime.domain.Task;
import org.optaplanner.examples.cheaptime.domain.TaskAssignment;
import org.optaplanner.examples.cheaptime.domain.TaskRequirement;
import org.optaplanner.examples.cheaptime.solver.CheapTimeCostCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheapTimeIncrementalScoreCalculator
implements ConstraintMatchAwareIncrementalScoreCalculator<CheapTimeSolution, HardMediumSoftLongScore>,
IncrementalScoreCalculator<CheapTimeSolution, HardMediumSoftLongScore> {
    protected static final String CONSTRAINT_PACKAGE = "org.optaplanner.examples.cheaptime.solver";
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private CheapTimeSolution cheapTimeSolution;
    private int resourceListSize;
    private int globalPeriodRangeTo;
    private MachinePeriodPart[][] machineToMachinePeriodListMap;
    private MachinePeriodPart[] unassignedMachinePeriodList;
    private long hardScore;
    private long mediumScore;
    private long softScore;
    private Machine oldMachine = null;
    private Integer oldStartPeriod = null;

    public void resetWorkingSolution(CheapTimeSolution solution) {
        this.cheapTimeSolution = solution;
        this.hardScore = 0L;
        this.mediumScore = 0L;
        this.softScore = 0L;
        if (solution.getGlobalPeriodRangeFrom() != 0) {
            throw new IllegalStateException("The globalPeriodRangeFrom (" + solution.getGlobalPeriodRangeFrom() + ") should be 0.");
        }
        this.resourceListSize = solution.getResourceList().size();
        this.globalPeriodRangeTo = solution.getGlobalPeriodRangeTo();
        List<Machine> machineList = solution.getMachineList();
        List<PeriodPowerPrice> periodPowerPriceList = solution.getPeriodPowerPriceList();
        this.machineToMachinePeriodListMap = new MachinePeriodPart[machineList.size()][];
        for (Machine machine : machineList) {
            MachinePeriodPart[] machinePeriodList = new MachinePeriodPart[this.globalPeriodRangeTo];
            for (int period = 0; period < this.globalPeriodRangeTo; ++period) {
                machinePeriodList[period] = new MachinePeriodPart(machine, periodPowerPriceList.get(period));
            }
            this.machineToMachinePeriodListMap[machine.getIndex()] = machinePeriodList;
        }
        this.unassignedMachinePeriodList = new MachinePeriodPart[this.globalPeriodRangeTo];
        for (int period = 0; period < this.globalPeriodRangeTo; ++period) {
            this.unassignedMachinePeriodList[period] = new MachinePeriodPart(null, periodPowerPriceList.get(period));
        }
        for (TaskAssignment taskAssignment : solution.getTaskAssignmentList()) {
            this.modifyStartPeriod(taskAssignment, null, taskAssignment.getStartPeriod());
        }
    }

    public void beforeEntityAdded(Object entity) {
    }

    public void afterEntityAdded(Object entity) {
        TaskAssignment taskAssignment = (TaskAssignment)entity;
        this.modifyStartPeriod(taskAssignment, null, taskAssignment.getStartPeriod());
    }

    public void beforeVariableChanged(Object entity, String variableName) {
        TaskAssignment taskAssignment = (TaskAssignment)entity;
        switch (variableName) {
            case "machine": {
                this.oldMachine = taskAssignment.getMachine();
                break;
            }
            case "startPeriod": {
                this.oldStartPeriod = taskAssignment.getStartPeriod();
                break;
            }
            default: {
                throw new IllegalArgumentException("The variableName (" + variableName + ") is not supported.");
            }
        }
    }

    public void afterVariableChanged(Object entity, String variableName) {
        TaskAssignment taskAssignment = (TaskAssignment)entity;
        switch (variableName) {
            case "machine": {
                this.modifyMachine(taskAssignment, this.oldMachine, taskAssignment.getMachine());
                break;
            }
            case "startPeriod": {
                this.modifyStartPeriod(taskAssignment, this.oldStartPeriod, taskAssignment.getStartPeriod());
                break;
            }
            default: {
                throw new IllegalArgumentException("The variableName (" + variableName + ") is not supported.");
            }
        }
    }

    public void beforeEntityRemoved(Object entity) {
        TaskAssignment taskAssignment = (TaskAssignment)entity;
        this.oldMachine = taskAssignment.getMachine();
        this.oldStartPeriod = taskAssignment.getStartPeriod();
    }

    public void afterEntityRemoved(Object entity) {
        TaskAssignment taskAssignment = (TaskAssignment)entity;
        this.modifyStartPeriod(taskAssignment, this.oldStartPeriod, null);
    }

    private void modifyMachine(TaskAssignment taskAssignment, Machine oldMachine, Machine newMachine) {
        MachinePeriodPart[] machinePeriodList;
        if (Objects.equals(oldMachine, newMachine)) {
            return;
        }
        Integer startPeriod = taskAssignment.getStartPeriod();
        if (startPeriod == null) {
            return;
        }
        Integer endPeriod = taskAssignment.getEndPeriod();
        if (oldMachine != null) {
            machinePeriodList = this.machineToMachinePeriodListMap[oldMachine.getIndex()];
            this.retractRange(taskAssignment, machinePeriodList, startPeriod, endPeriod, false);
        }
        if (newMachine != null) {
            machinePeriodList = this.machineToMachinePeriodListMap[newMachine.getIndex()];
            this.insertRange(taskAssignment, machinePeriodList, startPeriod, endPeriod, false);
        }
    }

    private void modifyStartPeriod(TaskAssignment taskAssignment, Integer oldStartPeriod, Integer newStartPeriod) {
        Machine machine;
        int insertEnd;
        int insertStart;
        int retractEnd;
        int retractStart;
        if (Objects.equals(oldStartPeriod, newStartPeriod)) {
            return;
        }
        Task task = taskAssignment.getTask();
        int duration = task.getDuration();
        if (oldStartPeriod == null) {
            retractStart = -1;
            retractEnd = -1;
            insertStart = newStartPeriod;
            insertEnd = insertStart + duration;
        } else if (newStartPeriod == null) {
            retractStart = oldStartPeriod;
            retractEnd = retractStart + duration;
            insertStart = -1;
            insertEnd = -1;
        } else {
            int overlap;
            retractStart = oldStartPeriod;
            retractEnd = retractStart + duration;
            insertStart = newStartPeriod;
            insertEnd = insertStart + duration;
            if (oldStartPeriod < newStartPeriod) {
                if (insertStart < retractEnd) {
                    overlap = retractEnd - insertStart;
                    retractEnd -= overlap;
                    insertStart += overlap;
                }
            } else if (retractStart < insertEnd) {
                overlap = insertEnd - retractStart;
                insertEnd -= overlap;
                retractStart += overlap;
            }
        }
        if (oldStartPeriod != null) {
            this.softScore += (long)oldStartPeriod.intValue();
        }
        if (newStartPeriod != null) {
            this.softScore -= (long)newStartPeriod.intValue();
        }
        MachinePeriodPart[] machinePeriodList = (machine = taskAssignment.getMachine()) != null ? this.machineToMachinePeriodListMap[machine.getIndex()] : this.unassignedMachinePeriodList;
        if (retractStart != retractEnd) {
            this.retractRange(taskAssignment, machinePeriodList, retractStart, retractEnd, true);
        }
        if (insertStart != insertEnd) {
            this.insertRange(taskAssignment, machinePeriodList, insertStart, insertEnd, true);
        }
    }

    private void retractRange(TaskAssignment taskAssignment, MachinePeriodPart[] machinePeriodList, int startPeriod, int endPeriod, boolean retractTaskCost) {
        int j;
        MachinePeriodPart machinePeriod;
        int i;
        long idleAvailable;
        MachinePeriodStatus previousStatus;
        long powerConsumptionMicros = taskAssignment.getTask().getPowerConsumptionMicros();
        long spinUpDownCostMicros = taskAssignment.getMachine().getSpinUpDownCostMicros();
        int idlePeriodStart = Integer.MIN_VALUE;
        if (startPeriod == 0) {
            previousStatus = MachinePeriodStatus.OFF;
            idleAvailable = Long.MIN_VALUE;
        } else {
            previousStatus = machinePeriodList[startPeriod - 1].status;
            if (previousStatus == MachinePeriodStatus.IDLE) {
                idleAvailable = spinUpDownCostMicros;
                for (i = startPeriod - 1; i >= 0; --i) {
                    machinePeriod = machinePeriodList[i];
                    if (machinePeriod.status.isActive()) {
                        idlePeriodStart = i + 1;
                        break;
                    }
                    machinePeriod.undoMakeIdle();
                    idleAvailable -= machinePeriod.machineCostMicros;
                }
                if (idleAvailable < 0L) {
                    throw new IllegalStateException("The range of idlePeriodStart (" + idlePeriodStart + ") to startPeriod (" + startPeriod + ") should have been IDLE because the idleAvailable (" + idleAvailable + ") is negative.");
                }
            } else {
                idleAvailable = Long.MIN_VALUE;
            }
        }
        for (i = startPeriod; i < endPeriod; ++i) {
            machinePeriod = machinePeriodList[i];
            machinePeriod.retractTaskAssignment(taskAssignment);
            if (retractTaskCost) {
                this.mediumScore += CheapTimeCostCalculator.multiplyTwoMicros(powerConsumptionMicros, machinePeriod.periodPowerPriceMicros);
            }
            if (machinePeriod.status.isActive()) {
                if (previousStatus == MachinePeriodStatus.OFF) {
                    if (machinePeriod.status != MachinePeriodStatus.SPIN_UP_AND_ACTIVE) {
                        machinePeriod.spinUp();
                    }
                } else if (previousStatus == MachinePeriodStatus.IDLE) {
                    for (j = idlePeriodStart; j < i; ++j) {
                        machinePeriodList[j].makeIdle();
                    }
                    idlePeriodStart = Integer.MIN_VALUE;
                    idleAvailable = Long.MIN_VALUE;
                }
                previousStatus = MachinePeriodStatus.STILL_ACTIVE;
                continue;
            }
            if (machinePeriod.status == MachinePeriodStatus.OFF) {
                if (previousStatus == MachinePeriodStatus.OFF) continue;
                if (previousStatus.isActive()) {
                    idlePeriodStart = i;
                    idleAvailable = spinUpDownCostMicros;
                }
                if ((idleAvailable -= machinePeriod.machineCostMicros) < 0L) {
                    previousStatus = MachinePeriodStatus.OFF;
                    idlePeriodStart = Integer.MIN_VALUE;
                    idleAvailable = Long.MIN_VALUE;
                    continue;
                }
                previousStatus = MachinePeriodStatus.IDLE;
                continue;
            }
            throw new IllegalStateException("Impossible status (" + (Object)((Object)machinePeriod.status) + ").");
        }
        if (endPeriod < this.globalPeriodRangeTo && machinePeriodList[endPeriod].status != MachinePeriodStatus.OFF && !previousStatus.isActive()) {
            for (i = endPeriod; i < this.globalPeriodRangeTo; ++i) {
                machinePeriod = machinePeriodList[i];
                if (machinePeriod.status.isActive()) {
                    if (previousStatus == MachinePeriodStatus.OFF) {
                        machinePeriod.spinUp();
                        break;
                    }
                    if (previousStatus != MachinePeriodStatus.IDLE) break;
                    for (j = idlePeriodStart; j < i; ++j) {
                        machinePeriodList[j].makeIdle();
                    }
                    break;
                }
                if (machinePeriod.status == MachinePeriodStatus.IDLE) {
                    machinePeriod.undoMakeIdle();
                    if (previousStatus != MachinePeriodStatus.IDLE || (idleAvailable -= machinePeriod.machineCostMicros) >= 0L) continue;
                    previousStatus = MachinePeriodStatus.OFF;
                    idlePeriodStart = Integer.MIN_VALUE;
                    idleAvailable = Long.MIN_VALUE;
                    continue;
                }
                throw new IllegalStateException("Impossible status (" + (Object)((Object)machinePeriod.status) + ").");
            }
        }
    }

    private void insertRange(TaskAssignment taskAssignment, MachinePeriodPart[] machinePeriodList, int startPeriod, int endPeriod, boolean insertTaskCost) {
        int i;
        MachinePeriodPart machinePeriod;
        long powerConsumptionMicros = taskAssignment.getTask().getPowerConsumptionMicros();
        MachinePeriodPart startMachinePeriod = machinePeriodList[startPeriod];
        boolean startIsOff = startMachinePeriod.status == MachinePeriodStatus.OFF;
        boolean lastIsOff = machinePeriodList[endPeriod - 1].status == MachinePeriodStatus.OFF;
        for (int i2 = startPeriod; i2 < endPeriod; ++i2) {
            MachinePeriodPart machinePeriod2 = machinePeriodList[i2];
            machinePeriod2.insertTaskAssignment(taskAssignment);
            if (insertTaskCost) {
                this.mediumScore -= CheapTimeCostCalculator.multiplyTwoMicros(powerConsumptionMicros, machinePeriod2.periodPowerPriceMicros);
            }
            if (machinePeriod2.status != MachinePeriodStatus.SPIN_UP_AND_ACTIVE || i2 == startPeriod) continue;
            machinePeriod2.undoSpinUp();
        }
        if (startIsOff) {
            long idleAvailable = taskAssignment.getMachine().getSpinUpDownCostMicros();
            int idlePeriodStart = Integer.MIN_VALUE;
            for (i = startPeriod - 1; i >= 0 && idleAvailable >= 0L; idleAvailable -= machinePeriod.machineCostMicros, --i) {
                machinePeriod = machinePeriodList[i];
                if (!machinePeriod.status.isActive()) continue;
                idlePeriodStart = i + 1;
                break;
            }
            if (idlePeriodStart >= 0) {
                for (i = idlePeriodStart; i < startPeriod; ++i) {
                    machinePeriodList[i].makeIdle();
                }
            } else {
                startMachinePeriod.spinUp();
            }
        }
        if (lastIsOff) {
            long idleAvailable = taskAssignment.getMachine().getSpinUpDownCostMicros();
            int idlePeriodEnd = Integer.MIN_VALUE;
            for (i = endPeriod; i < this.globalPeriodRangeTo && idleAvailable >= 0L; idleAvailable -= machinePeriod.machineCostMicros, ++i) {
                machinePeriod = machinePeriodList[i];
                if (!machinePeriod.status.isActive()) continue;
                idlePeriodEnd = i;
                machinePeriod.undoSpinUp();
                break;
            }
            if (idlePeriodEnd >= 0) {
                for (i = endPeriod; i < idlePeriodEnd; ++i) {
                    machinePeriodList[i].makeIdle();
                }
            }
        }
    }

    public HardMediumSoftLongScore calculateScore() {
        return HardMediumSoftLongScore.of((long)this.hardScore, (long)this.mediumScore, (long)this.softScore);
    }

    public void resetWorkingSolution(CheapTimeSolution workingSolution, boolean constraintMatchEnabled) {
        this.resetWorkingSolution(workingSolution);
    }

    public Collection<ConstraintMatchTotal<HardMediumSoftLongScore>> getConstraintMatchTotals() {
        List<Resource> resourceList = this.cheapTimeSolution.getResourceList();
        DefaultConstraintMatchTotal resourceCapacityMatchTotal = new DefaultConstraintMatchTotal(CONSTRAINT_PACKAGE, "resourceCapacity", (Score)HardMediumSoftLongScore.ZERO);
        DefaultConstraintMatchTotal spinUpDownMatchTotal = new DefaultConstraintMatchTotal(CONSTRAINT_PACKAGE, "spinUpDown", (Score)HardMediumSoftLongScore.ZERO);
        DefaultConstraintMatchTotal machineConsumptionMatchTotal = new DefaultConstraintMatchTotal(CONSTRAINT_PACKAGE, "machineConsumption", (Score)HardMediumSoftLongScore.ZERO);
        DefaultConstraintMatchTotal taskConsumptionMatchTotal = new DefaultConstraintMatchTotal(CONSTRAINT_PACKAGE, "taskConsumption", (Score)HardMediumSoftLongScore.ZERO);
        DefaultConstraintMatchTotal minimizeTaskStartPeriodMatchTotal = new DefaultConstraintMatchTotal(CONSTRAINT_PACKAGE, "minimizeTaskStartPeriod", (Score)HardMediumSoftLongScore.ZERO);
        long taskConsumptionWeight = this.mediumScore;
        for (Machine machine : this.cheapTimeSolution.getMachineList()) {
            for (int period = 0; period < this.globalPeriodRangeTo; ++period) {
                MachinePeriodPart machinePeriod = this.machineToMachinePeriodListMap[machine.getIndex()][period];
                for (int i = 0; i < machinePeriod.resourceAvailableList.length; ++i) {
                    int resourceAvailable = machinePeriod.resourceAvailableList[i];
                    if (resourceAvailable >= 0) continue;
                    resourceCapacityMatchTotal.addConstraintMatch(Arrays.asList(machine, period, resourceList.get(i)), (Score)HardMediumSoftLongScore.of((long)resourceAvailable, (long)0L, (long)0L));
                }
                if (machinePeriod.status == MachinePeriodStatus.SPIN_UP_AND_ACTIVE) {
                    spinUpDownMatchTotal.addConstraintMatch(Arrays.asList(machine, period), (Score)HardMediumSoftLongScore.of((long)0L, (long)(-machine.getSpinUpDownCostMicros()), (long)0L));
                    taskConsumptionWeight += machine.getSpinUpDownCostMicros();
                }
                if (machinePeriod.status == MachinePeriodStatus.OFF) continue;
                machineConsumptionMatchTotal.addConstraintMatch(Arrays.asList(machine, period), (Score)HardMediumSoftLongScore.of((long)0L, (long)(-machinePeriod.machineCostMicros), (long)0L));
                taskConsumptionWeight += machinePeriod.machineCostMicros;
            }
        }
        taskConsumptionMatchTotal.addConstraintMatch(Arrays.asList(new Object[0]), (Score)HardMediumSoftLongScore.of((long)0L, (long)taskConsumptionWeight, (long)0L));
        for (TaskAssignment taskAssignment : this.cheapTimeSolution.getTaskAssignmentList()) {
            Integer startPeriod = taskAssignment.getStartPeriod();
            if (startPeriod == null) continue;
            minimizeTaskStartPeriodMatchTotal.addConstraintMatch(Arrays.asList(taskAssignment), (Score)HardMediumSoftLongScore.of((long)0L, (long)0L, (long)(-startPeriod.intValue())));
        }
        ArrayList<ConstraintMatchTotal<HardMediumSoftLongScore>> constraintMatchTotalList = new ArrayList<ConstraintMatchTotal<HardMediumSoftLongScore>>(4);
        constraintMatchTotalList.add((ConstraintMatchTotal<HardMediumSoftLongScore>)resourceCapacityMatchTotal);
        constraintMatchTotalList.add((ConstraintMatchTotal<HardMediumSoftLongScore>)spinUpDownMatchTotal);
        constraintMatchTotalList.add((ConstraintMatchTotal<HardMediumSoftLongScore>)machineConsumptionMatchTotal);
        constraintMatchTotalList.add((ConstraintMatchTotal<HardMediumSoftLongScore>)taskConsumptionMatchTotal);
        constraintMatchTotalList.add((ConstraintMatchTotal<HardMediumSoftLongScore>)minimizeTaskStartPeriodMatchTotal);
        return constraintMatchTotalList;
    }

    public Map<Object, Indictment<HardMediumSoftLongScore>> getIndictmentMap() {
        return null;
    }

    private static enum MachinePeriodStatus {
        OFF,
        IDLE,
        SPIN_UP_AND_ACTIVE,
        STILL_ACTIVE;


        public boolean isActive() {
            return this == STILL_ACTIVE || this == SPIN_UP_AND_ACTIVE;
        }
    }

    private class MachinePeriodPart {
        private final Machine machine;
        private final int period;
        private final long periodPowerPriceMicros;
        private final long machineCostMicros;
        private int taskCount;
        private MachinePeriodStatus status;
        private int[] resourceAvailableList;

        private MachinePeriodPart(Machine machine, PeriodPowerPrice periodPowerPrice) {
            this.machine = machine;
            this.period = periodPowerPrice.getPeriod();
            this.periodPowerPriceMicros = periodPowerPrice.getPowerPriceMicros();
            this.taskCount = 0;
            this.status = MachinePeriodStatus.OFF;
            if (machine != null) {
                this.resourceAvailableList = new int[CheapTimeIncrementalScoreCalculator.this.resourceListSize];
                for (int i = 0; i < CheapTimeIncrementalScoreCalculator.this.resourceListSize; ++i) {
                    this.resourceAvailableList[i] = machine.getMachineCapacityList().get(i).getCapacity();
                }
                this.machineCostMicros = CheapTimeCostCalculator.multiplyTwoMicros(machine.getPowerConsumptionMicros(), this.periodPowerPriceMicros);
            } else {
                this.machineCostMicros = Long.MIN_VALUE;
            }
        }

        public void spinUp() {
            if (this.status != MachinePeriodStatus.STILL_ACTIVE) {
                throw new IllegalStateException("Impossible status (" + (Object)((Object)this.status) + ").");
            }
            CheapTimeIncrementalScoreCalculator.this.mediumScore -= this.machine.getSpinUpDownCostMicros();
            this.status = MachinePeriodStatus.SPIN_UP_AND_ACTIVE;
        }

        public void undoSpinUp() {
            if (this.status != MachinePeriodStatus.SPIN_UP_AND_ACTIVE) {
                throw new IllegalStateException("Impossible status (" + (Object)((Object)this.status) + ").");
            }
            CheapTimeIncrementalScoreCalculator.this.mediumScore += this.machine.getSpinUpDownCostMicros();
            this.status = MachinePeriodStatus.STILL_ACTIVE;
        }

        public void makeIdle() {
            if (this.status != MachinePeriodStatus.OFF) {
                throw new IllegalStateException("Impossible status (" + (Object)((Object)this.status) + ").");
            }
            CheapTimeIncrementalScoreCalculator.this.mediumScore -= this.machineCostMicros;
            this.status = MachinePeriodStatus.IDLE;
        }

        public void undoMakeIdle() {
            if (this.status != MachinePeriodStatus.IDLE) {
                throw new IllegalStateException("Impossible status (" + (Object)((Object)this.status) + ").");
            }
            CheapTimeIncrementalScoreCalculator.this.mediumScore += this.machineCostMicros;
            this.status = MachinePeriodStatus.OFF;
        }

        public void insertTaskAssignment(TaskAssignment taskAssignment) {
            if (this.machine == null) {
                return;
            }
            Task task = taskAssignment.getTask();
            if (this.status == MachinePeriodStatus.OFF) {
                CheapTimeIncrementalScoreCalculator.this.mediumScore -= this.machineCostMicros;
                this.status = MachinePeriodStatus.STILL_ACTIVE;
            } else if (this.status == MachinePeriodStatus.IDLE) {
                this.status = MachinePeriodStatus.STILL_ACTIVE;
            }
            ++this.taskCount;
            for (int i = 0; i < this.resourceAvailableList.length; ++i) {
                int resourceAvailable = this.resourceAvailableList[i];
                TaskRequirement taskRequirement = task.getTaskRequirementList().get(i);
                if (resourceAvailable < 0) {
                    CheapTimeIncrementalScoreCalculator.this.hardScore -= resourceAvailable;
                }
                if ((resourceAvailable -= taskRequirement.getResourceUsage()) < 0) {
                    CheapTimeIncrementalScoreCalculator.this.hardScore += resourceAvailable;
                }
                this.resourceAvailableList[i] = resourceAvailable;
            }
        }

        public void retractTaskAssignment(TaskAssignment taskAssignment) {
            if (this.machine == null) {
                return;
            }
            Task task = taskAssignment.getTask();
            if (this.status == MachinePeriodStatus.OFF || this.status == MachinePeriodStatus.IDLE) {
                throw new IllegalStateException("Impossible status (" + (Object)((Object)this.status) + ").");
            }
            --this.taskCount;
            if (this.taskCount == 0) {
                CheapTimeIncrementalScoreCalculator.this.mediumScore += this.machineCostMicros;
                if (this.status == MachinePeriodStatus.SPIN_UP_AND_ACTIVE) {
                    CheapTimeIncrementalScoreCalculator.this.mediumScore += this.machine.getSpinUpDownCostMicros();
                }
                this.status = MachinePeriodStatus.OFF;
            }
            for (int i = 0; i < this.resourceAvailableList.length; ++i) {
                int resourceAvailable = this.resourceAvailableList[i];
                TaskRequirement taskRequirement = task.getTaskRequirementList().get(i);
                if (resourceAvailable < 0) {
                    CheapTimeIncrementalScoreCalculator.this.hardScore -= resourceAvailable;
                }
                if ((resourceAvailable += taskRequirement.getResourceUsage()) < 0) {
                    CheapTimeIncrementalScoreCalculator.this.hardScore += resourceAvailable;
                }
                this.resourceAvailableList[i] = resourceAvailable;
            }
        }

        public String toString() {
            return this.status.name() + " (" + this.taskCount + " tasks)";
        }
    }
}

