/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.rocktour.domain;

import java.util.Map;

public class RockLocation {
    protected String cityName;
    protected double latitude;
    protected double longitude;
    protected Map<RockLocation, Long> drivingSecondsMap;

    public RockLocation() {
    }

    public RockLocation(String cityName, double latitude, double longitude) {
        this.cityName = cityName;
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public long getDrivingTimeTo(RockLocation location) {
        if (this == location) {
            return 0L;
        }
        return this.drivingSecondsMap.get(location);
    }

    public long getAirDistanceTo(RockLocation location) {
        double latitudeDifference = location.latitude - this.latitude;
        double longitudeDifference = location.longitude - this.longitude;
        double distance = Math.sqrt(latitudeDifference * latitudeDifference + longitudeDifference * longitudeDifference);
        return (long)(distance * 1000.0 + 0.5);
    }

    public String toString() {
        return this.cityName;
    }

    public String getCityName() {
        return this.cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public Map<RockLocation, Long> getDrivingSecondsMap() {
        return this.drivingSecondsMap;
    }

    public void setDrivingSecondsMap(Map<RockLocation, Long> drivingSecondsMap) {
        this.drivingSecondsMap = drivingSecondsMap;
    }
}

