/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.solver.score;

import java.util.Arrays;
import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.examples.examination.domain.Exam;
import org.optaplanner.examples.examination.domain.Examination;
import org.optaplanner.examples.examination.domain.ExaminationConstraintConfiguration;
import org.optaplanner.examples.examination.domain.LeadingExam;
import org.optaplanner.examples.examination.domain.Period;
import org.optaplanner.examples.examination.domain.PeriodPenalty;
import org.optaplanner.examples.examination.domain.PeriodPenaltyType;
import org.optaplanner.examples.examination.domain.Room;
import org.optaplanner.examples.examination.domain.RoomPenalty;
import org.optaplanner.examples.examination.domain.RoomPenaltyType;
import org.optaplanner.examples.examination.domain.Student;
import org.optaplanner.examples.examination.domain.Topic;
import org.optaplanner.examples.examination.domain.solver.TopicConflict;
import org.optaplanner.examples.examination.solver.score.ExaminationConstraintProvider;
import org.optaplanner.test.api.score.stream.ConstraintVerifier;

public class ExaminationConstraintProviderTest {
    private final ConstraintVerifier<ExaminationConstraintProvider, Examination> constraintVerifier = ConstraintVerifier.build((ConstraintProvider)new ExaminationConstraintProvider(), Examination.class, (Class[])new Class[]{Exam.class});
    private final Student student1 = new Student(1L);
    private final Student student2 = new Student(2L);
    private final Student student3 = new Student(3L);
    private final Student student4 = new Student(4L);

    @Test
    public void conflictingExamsInSamePeriodTest() {
        Topic topic1 = new Topic();
        Topic topic2 = new Topic();
        TopicConflict conflict = new TopicConflict(topic1, topic2, 2);
        Period period = new Period();
        LeadingExam exam1 = new LeadingExam().withTopic(topic1).withPeriod(period).withRoom(new Room());
        LeadingExam exam2 = new LeadingExam().withTopic(topic2).withPeriod(period).withRoom(new Room());
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::conflictingExamsInSamePeriod).given(new Object[]{conflict, exam1, exam2}).penalizesBy(2);
    }

    @Test
    public void periodDurationTooShortTest() {
        LeadingExam exam = new LeadingExam().withTopic(new Topic().withDuration(2).withStudentList(Arrays.asList(this.student1, this.student2))).withPeriod(new Period().withDuration(1)).withRoom(new Room());
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::periodDurationTooShort).given(new Object[]{exam}).penalizesBy(2);
    }

    @Test
    public void roomCapacityTooSmallSingleLargeExamTest() {
        Period period = new Period();
        Room room = new Room().withCapacity(2);
        LeadingExam exam = new LeadingExam().withTopic(new Topic().withStudentList(Arrays.asList(this.student1, this.student2, this.student3, this.student4))).withPeriod(period).withRoom(room);
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::roomCapacityTooSmall).given(new Object[]{period, exam, room}).penalizesBy(2);
    }

    @Test
    public void roomCapacityTooSmallTwoExamsTest() {
        Period period = new Period();
        Room room = new Room().withCapacity(2);
        LeadingExam exam1 = new LeadingExam().withTopic(new Topic().withStudentList(Arrays.asList(this.student1, this.student2))).withPeriod(period).withRoom(room);
        LeadingExam exam2 = new LeadingExam().withTopic(new Topic().withStudentList(Arrays.asList(this.student3, this.student4))).withPeriod(period).withRoom(room);
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::roomCapacityTooSmall).given(new Object[]{period, exam1, exam2, room}).penalizesBy(2);
    }

    @Test
    public void periodPenaltyTypeTest() {
        Topic topic1 = new Topic().withStudentList(Arrays.asList(this.student1, this.student2));
        Topic topic2 = new Topic().withStudentList(Arrays.asList(this.student1, this.student2));
        PeriodPenalty periodPenalty = new PeriodPenalty(topic1, topic2, PeriodPenaltyType.EXCLUSION);
        Period period = new Period().withPeriodIndex(1);
        LeadingExam exam1 = new LeadingExam().withTopic(topic1).withPeriod(period).withRoom(new Room());
        LeadingExam exam2 = new LeadingExam().withTopic(topic2).withPeriod(period).withRoom(new Room());
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::periodPenaltyExclusion).given(new Object[]{periodPenalty, exam1, exam2}).penalizesBy(4);
        periodPenalty.setPeriodPenaltyType(PeriodPenaltyType.EXAM_COINCIDENCE);
        exam2.setPeriod(new Period().withPeriodIndex(0));
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::periodPenaltyExamCoincidence).given(new Object[]{periodPenalty, exam1, exam2}).penalizesBy(4);
        periodPenalty.setPeriodPenaltyType(PeriodPenaltyType.AFTER);
        exam2.setPeriod(new Period().withPeriodIndex(2));
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::periodPenaltyAfter).given(new Object[]{periodPenalty, exam1, exam2}).penalizesBy(4);
        exam2.setPeriod(new Period().withPeriodIndex(0));
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::periodPenaltyAfter).given(new Object[]{periodPenalty, exam1, exam2}).penalizesBy(0);
    }

    @Test
    public void roomPenaltyExclusiveTest() {
        Topic topic1 = new Topic().withStudentList(Arrays.asList(this.student1, this.student2));
        Topic topic2 = new Topic().withStudentList(Arrays.asList(this.student3, this.student4));
        RoomPenalty penalty = new RoomPenalty().withTopic(topic1).withRoomPenaltyType(RoomPenaltyType.ROOM_EXCLUSIVE);
        Room room = new Room();
        Period period = new Period();
        LeadingExam exam1 = new LeadingExam().withPeriod(period).withRoom(room).withTopic(topic1);
        LeadingExam exam2 = new LeadingExam().withPeriod(period).withRoom(room).withTopic(topic2);
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::roomPenaltyExclusive).given(new Object[]{penalty, exam1, exam2}).penalizesBy(4);
    }

    @Test
    public void twoExamsInARowAndInADayTest() {
        Topic topic1 = new Topic();
        Topic topic2 = new Topic();
        TopicConflict conflict = new TopicConflict(topic1, topic2, 2);
        LeadingExam exam1 = new LeadingExam().withTopic(topic1).withPeriod(new Period().withPeriodIndex(0).withDayIndex(0)).withRoom(new Room());
        LeadingExam exam2 = new LeadingExam().withTopic(topic2).withPeriod(new Period().withPeriodIndex(2).withDayIndex(1)).withRoom(new Room());
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::twoExamsInARow).given(new Object[]{conflict, exam1, exam2}).penalizesBy(0);
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::twoExamsInADay).given(new Object[]{conflict, exam1, exam2}).penalizesBy(0);
        exam2.setPeriod(new Period().withPeriodIndex(1).withDayIndex(1));
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::twoExamsInARow).given(new Object[]{conflict, exam1, exam2}).penalizesBy(0);
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::twoExamsInADay).given(new Object[]{conflict, exam1, exam2}).penalizesBy(0);
        exam2.setPeriod(new Period().withPeriodIndex(2).withDayIndex(0));
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::twoExamsInARow).given(new Object[]{conflict, exam1, exam2}).penalizesBy(0);
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::twoExamsInADay).given(new Object[]{conflict, exam1, exam2}).penalizesBy(2);
        exam2.setPeriod(new Period().withPeriodIndex(1).withDayIndex(0));
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::twoExamsInARow).given(new Object[]{conflict, exam1, exam2}).penalizesBy(2);
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::twoExamsInADay).given(new Object[]{conflict, exam1, exam2}).penalizesBy(0);
    }

    @Test
    public void periodSpreadTest() {
        ExaminationConstraintConfiguration config = new ExaminationConstraintConfiguration().withPeriodSpreadLength(1);
        Topic topic1 = new Topic();
        Topic topic2 = new Topic();
        TopicConflict topicConflict = new TopicConflict(topic1, topic2, 3);
        LeadingExam exam1 = new LeadingExam().withTopic(topic1).withPeriod(new Period().withPeriodIndex(0)).withRoom(new Room());
        LeadingExam exam2 = new LeadingExam().withTopic(topic2).withPeriod(new Period().withPeriodIndex(0)).withRoom(new Room());
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::periodSpread).given(new Object[]{config, topicConflict, exam1, exam2}).penalizesBy(3);
        exam2.setPeriod(new Period().withPeriodIndex(1));
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::periodSpread).given(new Object[]{config, topicConflict, exam1, exam2}).penalizesBy(3);
        exam2.setPeriod(new Period().withPeriodIndex(2));
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::periodSpread).given(new Object[]{config, topicConflict, exam1, exam2}).penalizesBy(0);
    }

    @Test
    public void mixedDurations11Test() {
        Period period = new Period();
        Room room = new Room();
        LeadingExam exam1 = new LeadingExam().withId(1L).withTopic(new Topic().withId(1L).withDuration(1)).withPeriod(period).withRoom(room);
        LeadingExam exam2 = new LeadingExam().withId(2L).withTopic(new Topic().withId(2L).withDuration(1)).withPeriod(period).withRoom(room);
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::mixedDurations).given(new Object[]{exam1, exam2}).penalizesBy(0);
    }

    @Test
    public void mixedDurations12Test() {
        Period period = new Period();
        Room room = new Room();
        LeadingExam exam1 = new LeadingExam().withId(1L).withTopic(new Topic().withId(1L).withDuration(1)).withPeriod(period).withRoom(room);
        LeadingExam exam2 = new LeadingExam().withId(2L).withTopic(new Topic().withId(2L).withDuration(2)).withPeriod(period).withRoom(room);
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::mixedDurations).given(new Object[]{exam1, exam2}).penalizesBy(1);
    }

    @Test
    public void mixedDurations123Test() {
        Period period = new Period();
        Room room = new Room();
        LeadingExam exam1 = new LeadingExam().withId(1L).withTopic(new Topic().withId(1L).withDuration(1)).withPeriod(period).withRoom(room);
        LeadingExam exam2 = new LeadingExam().withId(2L).withTopic(new Topic().withId(2L).withDuration(2)).withPeriod(period).withRoom(room);
        LeadingExam exam3 = new LeadingExam().withId(3L).withTopic(new Topic().withId(3L).withDuration(3)).withPeriod(period).withRoom(room);
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::mixedDurations).given(new Object[]{exam1, exam2, exam3}).penalizesBy(2);
    }

    @Test
    public void mixedDurations113Test() {
        Period period = new Period();
        Room room = new Room();
        LeadingExam exam1 = new LeadingExam().withId(1L).withTopic(new Topic().withId(1L).withDuration(1)).withPeriod(period).withRoom(room);
        LeadingExam exam2 = new LeadingExam().withId(2L).withTopic(new Topic().withId(2L).withDuration(1)).withPeriod(period).withRoom(room);
        LeadingExam exam3 = new LeadingExam().withId(3L).withTopic(new Topic().withId(3L).withDuration(3)).withPeriod(period).withRoom(room);
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::mixedDurations).given(new Object[]{exam1, exam2, exam3}).penalizesBy(1);
    }

    @Test
    public void mixedDurations133Test() {
        Period period = new Period();
        Room room = new Room();
        LeadingExam exam1 = new LeadingExam().withId(1L).withTopic(new Topic().withId(1L).withDuration(1)).withPeriod(period).withRoom(room);
        LeadingExam exam2 = new LeadingExam().withId(2L).withTopic(new Topic().withId(2L).withDuration(3)).withPeriod(period).withRoom(room);
        LeadingExam exam3 = new LeadingExam().withId(3L).withTopic(new Topic().withId(3L).withDuration(3)).withPeriod(period).withRoom(room);
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::mixedDurations).given(new Object[]{exam1, exam2, exam3}).penalizesBy(1);
    }

    @Test
    public void mixedDurations131Test() {
        Period period = new Period();
        Room room = new Room();
        LeadingExam exam1 = new LeadingExam().withId(1L).withTopic(new Topic().withId(1L).withDuration(1)).withPeriod(period).withRoom(room);
        LeadingExam exam2 = new LeadingExam().withId(2L).withTopic(new Topic().withId(2L).withDuration(3)).withPeriod(period).withRoom(room);
        LeadingExam exam3 = new LeadingExam().withId(3L).withTopic(new Topic().withId(3L).withDuration(1)).withPeriod(period).withRoom(room);
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::mixedDurations).given(new Object[]{exam1, exam2, exam3}).penalizesBy(1);
    }

    @Test
    public void mixedDurations431Test() {
        Period period = new Period();
        Room room = new Room();
        LeadingExam exam1 = new LeadingExam().withId(1L).withTopic(new Topic().withId(1L).withDuration(4)).withPeriod(period).withRoom(room);
        LeadingExam exam2 = new LeadingExam().withId(2L).withTopic(new Topic().withId(2L).withDuration(3)).withPeriod(period).withRoom(room);
        LeadingExam exam3 = new LeadingExam().withId(3L).withTopic(new Topic().withId(3L).withDuration(1)).withPeriod(period).withRoom(room);
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::mixedDurations).given(new Object[]{exam1, exam2, exam3}).penalizesBy(2);
    }

    @Test
    public void mixedDurations411Test() {
        Period period = new Period();
        Room room = new Room();
        LeadingExam exam1 = new LeadingExam().withId(1L).withTopic(new Topic().withId(1L).withDuration(4)).withPeriod(period).withRoom(room);
        LeadingExam exam2 = new LeadingExam().withId(2L).withTopic(new Topic().withId(2L).withDuration(1)).withPeriod(period).withRoom(room);
        LeadingExam exam3 = new LeadingExam().withId(3L).withTopic(new Topic().withId(3L).withDuration(1)).withPeriod(period).withRoom(room);
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::mixedDurations).given(new Object[]{exam1, exam2, exam3}).penalizesBy(1);
    }

    @Test
    public void mixedDurations441Test() {
        Period period = new Period();
        Room room = new Room();
        LeadingExam exam1 = new LeadingExam().withId(1L).withTopic(new Topic().withId(1L).withDuration(4)).withPeriod(period).withRoom(room);
        LeadingExam exam2 = new LeadingExam().withId(2L).withTopic(new Topic().withId(2L).withDuration(4)).withPeriod(period).withRoom(room);
        LeadingExam exam3 = new LeadingExam().withId(3L).withTopic(new Topic().withId(3L).withDuration(1)).withPeriod(period).withRoom(room);
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::mixedDurations).given(new Object[]{exam1, exam2, exam3}).penalizesBy(1);
    }

    @Test
    public void frontLoadTest() {
        LeadingExam exam = new LeadingExam().withPeriod(new Period().withFrontLoadLast(true)).withTopic(new Topic().withFrontLoadLarge(true)).withRoom(new Room());
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::frontLoad).given(new Object[]{exam}).penalizesBy(1);
    }

    @Test
    public void periodPenaltyTest() {
        Period period = new Period().withPenalty(5);
        Room room = new Room();
        LeadingExam exam1 = new LeadingExam().withPeriod(period).withRoom(room);
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::periodPenalty).given(new Object[]{period, exam1}).penalizesBy(5);
        LeadingExam exam2 = new LeadingExam().withPeriod(period).withRoom(room);
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::periodPenalty).given(new Object[]{period, exam1, exam2}).penalizesBy(10);
    }

    @Test
    public void roomPenaltyTest() {
        Room room = new Room().withPenalty(5);
        LeadingExam exam1 = new LeadingExam().withRoom(room).withPeriod(new Period());
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::roomPenalty).given(new Object[]{room, exam1}).penalizesBy(5);
        LeadingExam exam2 = new LeadingExam().withRoom(room).withPeriod(new Period());
        this.constraintVerifier.verifyThat(ExaminationConstraintProvider::roomPenalty).given(new Object[]{room, exam1, exam2}).penalizesBy(10);
    }
}

