/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.machinereassignment.solver.drools;

import java.util.Comparator;
import java.util.Objects;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.machinereassignment.domain.MrService;

public class MrServiceMovedProcessesCount
implements Comparable<MrServiceMovedProcessesCount> {
    private static final Comparator<MrServiceMovedProcessesCount> COMPARATOR = Comparator.comparing(count -> count.service, Comparator.comparingLong(AbstractPersistable::getId)).thenComparingInt(count -> count.movedProcessesCount);
    private MrService service;
    private int movedProcessesCount;

    public MrServiceMovedProcessesCount(MrService service, int movedProcessesCount) {
        this.service = service;
        this.movedProcessesCount = movedProcessesCount;
    }

    public MrService getService() {
        return this.service;
    }

    public int getMovedProcessesCount() {
        return this.movedProcessesCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MrServiceMovedProcessesCount other = (MrServiceMovedProcessesCount)o;
        return Objects.equals(this.service, other.service) && this.movedProcessesCount == other.movedProcessesCount;
    }

    public int hashCode() {
        return Objects.hash(this.service, this.movedProcessesCount);
    }

    public Long getServiceId() {
        return this.service.getId();
    }

    public String toString() {
        return this.service + "=" + this.movedProcessesCount;
    }

    @Override
    public int compareTo(MrServiceMovedProcessesCount o) {
        return COMPARATOR.compare(this, o);
    }
}

