/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nqueens.solver.move;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.examples.nqueens.domain.NQueens;
import org.optaplanner.examples.nqueens.domain.Queen;
import org.optaplanner.examples.nqueens.domain.Row;

public class RowChangeMove
extends AbstractMove<NQueens> {
    private Queen queen;
    private Row toRow;

    public RowChangeMove(Queen queen, Row toRow) {
        this.queen = queen;
        this.toRow = toRow;
    }

    public boolean isMoveDoable(ScoreDirector<NQueens> scoreDirector) {
        return !Objects.equals(this.queen.getRow(), this.toRow);
    }

    public RowChangeMove createUndoMove(ScoreDirector<NQueens> scoreDirector) {
        return new RowChangeMove(this.queen, this.queen.getRow());
    }

    protected void doMoveOnGenuineVariables(ScoreDirector<NQueens> scoreDirector) {
        scoreDirector.beforeVariableChanged((Object)this.queen, "row");
        this.queen.setRow(this.toRow);
        scoreDirector.afterVariableChanged((Object)this.queen, "row");
    }

    public RowChangeMove rebase(ScoreDirector<NQueens> destinationScoreDirector) {
        return new RowChangeMove((Queen)destinationScoreDirector.lookUpWorkingObject((Object)this.queen), (Row)destinationScoreDirector.lookUpWorkingObject((Object)this.toRow));
    }

    public Collection<? extends Object> getPlanningEntities() {
        return Collections.singletonList(this.queen);
    }

    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toRow);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        RowChangeMove other = (RowChangeMove)((Object)o);
        return Objects.equals(this.queen, other.queen) && Objects.equals(this.toRow, other.toRow);
    }

    public int hashCode() {
        return Objects.hash(this.queen, this.toRow);
    }

    public String toString() {
        return this.queen + " {" + this.queen.getRow() + " -> " + this.toRow + "}";
    }
}

