/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cheaptime.optional.score.drools;

import java.util.Comparator;
import java.util.Objects;
import org.optaplanner.examples.cheaptime.domain.Machine;
import org.optaplanner.examples.common.domain.AbstractPersistable;

public class IdleCost
implements Comparable<IdleCost> {
    private static final Comparator<IdleCost> COMPARATOR = Comparator.comparing(IdleCost::getMachine, Comparator.comparingLong(AbstractPersistable::getId)).thenComparingInt(IdleCost::getActivePeriodAfterIdle).thenComparingLong(IdleCost::getCost);
    private final Machine machine;
    private final int activePeriodAfterIdle;
    private final long cost;

    public IdleCost(Machine machine, int activePeriodAfterIdle, long cost) {
        this.machine = machine;
        this.activePeriodAfterIdle = activePeriodAfterIdle;
        this.cost = cost;
    }

    public Machine getMachine() {
        return this.machine;
    }

    public int getActivePeriodAfterIdle() {
        return this.activePeriodAfterIdle;
    }

    public long getCost() {
        return this.cost;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdleCost other = (IdleCost)o;
        return Objects.equals(this.machine, other.machine) && this.activePeriodAfterIdle == other.activePeriodAfterIdle && this.cost == other.cost;
    }

    public int hashCode() {
        return Objects.hash(this.machine, this.activePeriodAfterIdle, this.cost);
    }

    @Override
    public int compareTo(IdleCost other) {
        return COMPARATOR.compare(this, other);
    }

    public String toString() {
        return "machine = " + this.machine + ", activePeriodAfterIdle = " + this.activePeriodAfterIdle + ", cost = " + this.cost;
    }
}

