/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.optional.partitioner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.partitionedsearch.partitioner.SolutionPartitioner;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.domain.CloudComputer;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;

public class CloudBalancePartitioner
implements SolutionPartitioner<CloudBalance> {
    private int partCount = 4;
    private int minimumProcessListSize = 25;

    public void setPartCount(int partCount) {
        this.partCount = partCount;
    }

    public void setMinimumProcessListSize(int minimumProcessListSize) {
        this.minimumProcessListSize = minimumProcessListSize;
    }

    public List<CloudBalance> splitWorkingSolution(ScoreDirector<CloudBalance> scoreDirector, Integer runnablePartThreadLimit) {
        CloudBalance part;
        CloudBalance originalSolution = (CloudBalance)scoreDirector.getWorkingSolution();
        List<CloudComputer> originalComputerList = originalSolution.getComputerList();
        List<CloudProcess> originalProcessList = originalSolution.getProcessList();
        int partCount = this.partCount;
        if (originalProcessList.size() / partCount < this.minimumProcessListSize) {
            partCount = originalProcessList.size() / this.minimumProcessListSize;
        }
        ArrayList<CloudBalance> partList = new ArrayList<CloudBalance>(partCount);
        for (int i = 0; i < partCount; ++i) {
            CloudBalance partSolution = new CloudBalance(originalSolution.getId(), new ArrayList<CloudComputer>(originalComputerList.size() / partCount + 1), new ArrayList<CloudProcess>(originalProcessList.size() / partCount + 1));
            partList.add(partSolution);
        }
        int partIndex = 0;
        HashMap<Long, Pair> idToPartIndexAndComputerMap = new HashMap<Long, Pair>(originalComputerList.size());
        for (CloudComputer originalComputer : originalComputerList) {
            part = (CloudBalance)partList.get(partIndex);
            CloudComputer computer = new CloudComputer(originalComputer.getId(), originalComputer.getCpuPower(), originalComputer.getMemory(), originalComputer.getNetworkBandwidth(), originalComputer.getCost());
            part.getComputerList().add(computer);
            idToPartIndexAndComputerMap.put(computer.getId(), Pair.of((Object)partIndex, (Object)computer));
            partIndex = (partIndex + 1) % partList.size();
        }
        partIndex = 0;
        for (CloudProcess originalProcess : originalProcessList) {
            part = (CloudBalance)partList.get(partIndex);
            CloudProcess process = new CloudProcess(originalProcess.getId(), originalProcess.getRequiredCpuPower(), originalProcess.getRequiredMemory(), originalProcess.getRequiredNetworkBandwidth());
            part.getProcessList().add(process);
            if (originalProcess.getComputer() != null) {
                Pair partIndexAndComputer = (Pair)idToPartIndexAndComputerMap.get(originalProcess.getComputer().getId());
                if (partIndexAndComputer == null) {
                    throw new IllegalStateException("The initialized process (" + originalProcess + ") has a computer (" + originalProcess.getComputer() + ") which doesn't exist in the originalSolution (" + originalSolution + ").");
                }
                if (partIndex != (Integer)partIndexAndComputer.getLeft()) {
                    throw new IllegalStateException("The initialized process (" + originalProcess + ") with partIndex (" + partIndex + ") has a computer (" + originalProcess.getComputer() + ") which belongs to another partIndex (" + partIndexAndComputer.getLeft() + ").");
                }
                process.setComputer((CloudComputer)partIndexAndComputer.getRight());
            }
            partIndex = (partIndex + 1) % partList.size();
        }
        return partList;
    }
}

