/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.experimental.impl;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.optaplanner.examples.common.experimental.api.Break;
import org.optaplanner.examples.common.experimental.api.ConsecutiveInfo;
import org.optaplanner.examples.common.experimental.api.Sequence;
import org.optaplanner.examples.common.experimental.impl.ConsecutiveSetTree;

class ConsecutiveDataImpl<Value_, Difference_ extends Comparable<Difference_>>
implements ConsecutiveInfo<Value_, Difference_> {
    private final ConsecutiveSetTree<Value_, ?, Difference_> sourceTree;

    protected ConsecutiveDataImpl(ConsecutiveSetTree<Value_, ?, Difference_> sourceTree) {
        this.sourceTree = sourceTree;
    }

    @Override
    public Iterable<Sequence<Value_, Difference_>> getConsecutiveSequences() {
        return this.sourceTree.getConsecutiveSequences();
    }

    @Override
    public Iterable<Break<Value_, Difference_>> getBreaks() {
        return this.sourceTree.getBreaks();
    }

    public String toString() {
        Stream.Builder<Sequence<Value_, Difference_>> streamBuilder = Stream.builder();
        for (Sequence<Value_, Difference_> sequence : this.getConsecutiveSequences()) {
            streamBuilder.add(sequence);
        }
        return streamBuilder.build().map(Object::toString).collect(Collectors.joining("; ", "ConsecutiveData [", "]"));
    }
}

