/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.machinereassignment.optional.score;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.examples.machinereassignment.domain.MrBalancePenalty;
import org.optaplanner.examples.machinereassignment.domain.MrGlobalPenaltyInfo;
import org.optaplanner.examples.machinereassignment.domain.MrMachine;
import org.optaplanner.examples.machinereassignment.domain.MrMachineCapacity;
import org.optaplanner.examples.machinereassignment.domain.MrProcessAssignment;
import org.optaplanner.examples.machinereassignment.domain.solver.MrServiceDependency;

public class MachineReassignmentConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory factory) {
        return new Constraint[]{this.maximumCapacity(factory), this.serviceConflict(factory), this.serviceLocationSpread(factory), this.serviceDependency(factory), this.transientUsage(factory), this.loadCost(factory), this.balanceCost(factory), this.processMoveCost(factory), this.serviceMoveCost(factory), this.machineMoveCost(factory)};
    }

    protected Constraint maximumCapacity(ConstraintFactory factory) {
        return factory.from(MrMachineCapacity.class).join(MrProcessAssignment.class, Joiners.equal(MrMachineCapacity::getMachine, MrProcessAssignment::getMachine)).groupBy((machineCapacity, processAssignment) -> machineCapacity.getMachine(), (machineCapacity, processAssignment) -> machineCapacity, ConstraintCollectors.sumLong((machineCapacity, processAssignment) -> processAssignment.getUsage(machineCapacity.getResource()))).filter((machine, machineCapacity, usage) -> machineCapacity.getMaximumCapacity() < usage).penalizeLong("maximumCapacity", (Score)HardSoftLongScore.ONE_HARD, (machine, machineCapacity, usage) -> usage - machineCapacity.getMaximumCapacity());
    }

    protected Constraint serviceConflict(ConstraintFactory factory) {
        return factory.fromUniquePair(MrProcessAssignment.class, Joiners.equal(MrProcessAssignment::getMachine, MrProcessAssignment::getMachine), Joiners.equal(MrProcessAssignment::getService, MrProcessAssignment::getService)).penalize("serviceConflict", (Score)HardSoftLongScore.ONE_HARD);
    }

    protected Constraint serviceLocationSpread(ConstraintFactory factory) {
        return factory.from(MrProcessAssignment.class).groupBy(MrProcessAssignment::getService, ConstraintCollectors.countDistinct(MrProcessAssignment::getLocation)).filter((service, distinctLocationCount) -> distinctLocationCount < service.getLocationSpread()).penalizeLong("serviceLocationSpread", (Score)HardSoftLongScore.ONE_HARD, (service, distinctLocationCount) -> service.getLocationSpread() - distinctLocationCount);
    }

    protected Constraint serviceDependency(ConstraintFactory factory) {
        return factory.from(MrServiceDependency.class).join(MrProcessAssignment.class, Joiners.equal(MrServiceDependency::getFromService, MrProcessAssignment::getService)).ifExists(MrProcessAssignment.class, Joiners.equal((serviceDependency, processFrom) -> serviceDependency.getToService(), MrProcessAssignment::getService), Joiners.filtering((serviceDependency, processFrom, processTo) -> !processFrom.getNeighborhood().equals(processTo.getNeighborhood()))).penalize("serviceDependency", (Score)HardSoftLongScore.ONE_HARD);
    }

    protected Constraint transientUsage(ConstraintFactory factory) {
        return factory.from(MrMachineCapacity.class).filter(MrMachineCapacity::isTransientlyConsumed).join(factory.from(MrProcessAssignment.class).filter(MrProcessAssignment::isMoved), Joiners.equal(MrMachineCapacity::getMachine, MrProcessAssignment::getOriginalMachine)).groupBy((machineCapacity, processAssignment) -> machineCapacity, ConstraintCollectors.sumLong((machineCapacity, processAssignment) -> processAssignment.getUsage(machineCapacity.getResource()))).filter((machineCapacity, usage) -> machineCapacity.getMaximumCapacity() < usage).penalizeLong("transientUsage", (Score)HardSoftLongScore.ONE_HARD, (machineCapacity, usage) -> usage - machineCapacity.getMaximumCapacity());
    }

    protected Constraint loadCost(ConstraintFactory factory) {
        return factory.from(MrMachineCapacity.class).join(MrProcessAssignment.class, Joiners.equal(MrMachineCapacity::getMachine, MrProcessAssignment::getMachine)).groupBy((machineCapacity, processAssignment) -> machineCapacity, ConstraintCollectors.sumLong((machineCapacity, processAssignment) -> processAssignment.getUsage(machineCapacity.getResource()))).filter((machineCapacity, usage) -> machineCapacity.getSafetyCapacity() < usage).penalizeLong("loadCost", (Score)HardSoftLongScore.ONE_SOFT, (machineCapacity, usage) -> (long)machineCapacity.getResource().getLoadCostWeight() * (usage - machineCapacity.getSafetyCapacity()));
    }

    protected Constraint balanceCost(ConstraintFactory factory) {
        return factory.from(MrBalancePenalty.class).join(MrProcessAssignment.class).groupBy((penalty, processAssignment) -> penalty, (penalty, processAssignment) -> processAssignment.getMachine(), ConstraintCollectors.sumLong((penalty, processAssignment) -> processAssignment.getUsage(penalty.getOriginResource())), ConstraintCollectors.sumLong((penalty, processAssignment) -> processAssignment.getUsage(penalty.getTargetResource()))).penalizeLong("balanceCost", (Score)HardSoftLongScore.ONE_SOFT, this::balanceCost);
    }

    private long balanceCost(MrBalancePenalty penalty, MrMachine machine, long originalUsage, long targetUsage) {
        long originalAvailability = machine.getMachineCapacity(penalty.getOriginResource()).getMaximumCapacity() - originalUsage;
        long targetAvailability = machine.getMachineCapacity(penalty.getTargetResource()).getMaximumCapacity() - targetUsage;
        long lackingAvailability = (long)penalty.getMultiplicand() * originalAvailability - targetAvailability;
        if (lackingAvailability <= 0L) {
            return 0L;
        }
        return lackingAvailability * (long)penalty.getWeight();
    }

    protected Constraint processMoveCost(ConstraintFactory factory) {
        return factory.from(MrProcessAssignment.class).filter(processAssignment -> processAssignment.isMoved() && processAssignment.getProcessMoveCost() > 0).join(MrGlobalPenaltyInfo.class, Joiners.filtering((processAssignment, penalty) -> penalty.getProcessMoveCostWeight() > 0)).penalize("processMoveCost", (Score)HardSoftLongScore.ONE_SOFT, (processAssignment, penalty) -> processAssignment.getProcessMoveCost() * penalty.getProcessMoveCostWeight());
    }

    protected Constraint serviceMoveCost(ConstraintFactory factory) {
        return factory.from(MrProcessAssignment.class).filter(MrProcessAssignment::isMoved).groupBy(MrProcessAssignment::getService, ConstraintCollectors.count()).groupBy(ConstraintCollectors.max((service, count) -> count)).join(MrGlobalPenaltyInfo.class).penalize("serviceMoveCost", (Score)HardSoftLongScore.ONE_SOFT, (count, penalty) -> count * penalty.getServiceMoveCostWeight());
    }

    protected Constraint machineMoveCost(ConstraintFactory factory) {
        return factory.from(MrProcessAssignment.class).filter(processAssignment -> processAssignment.isMoved() && processAssignment.getMachineMoveCost() > 0).join(MrGlobalPenaltyInfo.class, Joiners.filtering((processAssignment, penalty) -> penalty.getMachineMoveCostWeight() > 0)).penalize("machineMoveCost", (Score)HardSoftLongScore.ONE_SOFT, (processAssignment, penalty) -> processAssignment.getMachineMoveCost() * penalty.getMachineMoveCostWeight());
    }
}

