/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nurserostering.score.drools;

import java.time.DayOfWeek;
import java.util.Comparator;
import java.util.Objects;
import org.optaplanner.examples.nurserostering.domain.Employee;
import org.optaplanner.examples.nurserostering.domain.ShiftDate;
import org.optaplanner.examples.nurserostering.domain.WeekendDefinition;
import org.optaplanner.examples.nurserostering.domain.contract.Contract;

public class EmployeeConsecutiveAssignmentEnd
implements Comparable<EmployeeConsecutiveAssignmentEnd> {
    private static final Comparator<EmployeeConsecutiveAssignmentEnd> COMPARATOR = Comparator.comparing(EmployeeConsecutiveAssignmentEnd::getEmployee).thenComparing(EmployeeConsecutiveAssignmentEnd::getShiftDate);
    private Employee employee;
    private ShiftDate shiftDate;

    public static boolean isWeekendAndNotLastDayOfWeekend(Employee employee, ShiftDate shiftDate) {
        DayOfWeek dayOfWeek;
        WeekendDefinition weekendDefinition = employee.getContract().getWeekendDefinition();
        return weekendDefinition.isWeekend(dayOfWeek = shiftDate.getDayOfWeek()) && weekendDefinition.getLastDayOfWeekend() != dayOfWeek;
    }

    public static int getDistanceToLastDayOfWeekend(Employee employee, ShiftDate shiftDate) {
        WeekendDefinition weekendDefinition = employee.getContract().getWeekendDefinition();
        DayOfWeek dayOfWeek = shiftDate.getDayOfWeek();
        DayOfWeek lastDayOfWeekend = weekendDefinition.getLastDayOfWeekend();
        int distance = lastDayOfWeekend.getValue() - dayOfWeek.getValue();
        if (distance < 0) {
            distance += 7;
        }
        return distance;
    }

    public EmployeeConsecutiveAssignmentEnd(Employee employee, ShiftDate shiftDate) {
        this.employee = employee;
        this.shiftDate = shiftDate;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public ShiftDate getShiftDate() {
        return this.shiftDate;
    }

    public void setShiftDate(ShiftDate shiftDate) {
        this.shiftDate = shiftDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmployeeConsecutiveAssignmentEnd other = (EmployeeConsecutiveAssignmentEnd)o;
        return Objects.equals(this.employee, other.employee) && Objects.equals(this.shiftDate, other.shiftDate);
    }

    public int hashCode() {
        return Objects.hash(this.employee, this.shiftDate);
    }

    @Override
    public int compareTo(EmployeeConsecutiveAssignmentEnd other) {
        return COMPARATOR.compare(this, other);
    }

    public String toString() {
        return this.employee + " ... - " + this.shiftDate;
    }

    public Contract getContract() {
        return this.employee.getContract();
    }

    public int getShiftDateDayIndex() {
        return this.shiftDate.getDayIndex();
    }

    public boolean isWeekendAndNotLastDayOfWeekend() {
        return EmployeeConsecutiveAssignmentEnd.isWeekendAndNotLastDayOfWeekend(this.employee, this.shiftDate);
    }

    public int getDistanceToLastDayOfWeekend() {
        return EmployeeConsecutiveAssignmentEnd.getDistanceToLastDayOfWeekend(this.employee, this.shiftDate);
    }
}

