/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.optional.score;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.impl.domain.constraintweight.descriptor.ConstraintWeightDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.examples.common.persistence.AbstractXlsxSolutionFileIO;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceSolution;
import org.optaplanner.examples.conferencescheduling.domain.Room;
import org.optaplanner.examples.conferencescheduling.domain.Talk;
import org.optaplanner.examples.conferencescheduling.domain.Timeslot;
import org.optaplanner.examples.conferencescheduling.persistence.ConferenceSchedulingXlsxFileIO;
import org.optaplanner.test.impl.score.buildin.hardmediumsoft.HardMediumSoftScoreVerifier;

public class ConferenceSchedulingConstraintsXlsxTest {
    private static final String testFileName = "testConferenceSchedulingConstraints.xlsx";
    private static final HardMediumSoftScore unassignedScore = HardMediumSoftScore.ZERO;
    private static final ScoreDirectorFactoryConfig DRL_SCORE_DIRECTOR_FACTORY_CONFIG = new ScoreDirectorFactoryConfig().withScoreDrls(new String[]{"org/optaplanner/examples/conferencescheduling/optional/score/conferenceSchedulingConstraints.drl"});
    private static final SolverConfig SOLVER_CONFIG = SolverConfig.createFromXmlResource((String)"org/optaplanner/examples/conferencescheduling/conferenceSchedulingSolverConfig.xml").withScoreDirectorFactory(DRL_SCORE_DIRECTOR_FACTORY_CONFIG);
    private static final HardMediumSoftScoreVerifier<ConferenceSolution> SCORE_VERIFIER = new HardMediumSoftScoreVerifier(SolverFactory.create((SolverConfig)SOLVER_CONFIG));

    public static Collection<Object[]> testSheetParameters() {
        ArrayList<Object[]> arrayList;
        File testFile = new File(ConferenceSchedulingConstraintsXlsxTest.class.getResource(testFileName).getFile());
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(testFile));
        try {
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)in);
            ConferenceSolution initialSolution = new ConferenceSchedulingXlsxFileIO(false).read(testFile);
            TestConferenceSchedulingConstraintsReader reader = new TestConferenceSchedulingConstraintsReader(workbook, initialSolution);
            ArrayList<Object[]> parametersList = new ArrayList<Object[]>();
            Object[] parameters = reader.nextTestSheetParameters();
            while (parameters != null) {
                parametersList.add(parameters);
                parameters = reader.nextTestSheetParameters();
            }
            arrayList = parametersList;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | RuntimeException e) {
                throw new IllegalStateException("Failed reading inputSolutionFile (" + testFile.getName() + ").", e);
            }
        }
        ((InputStream)in).close();
        return arrayList;
    }

    @ParameterizedTest(name="{4}")
    @MethodSource(value={"testSheetParameters"})
    public void constraints(String constraintPackage, String constraintName, HardMediumSoftScore expectedScore, ConferenceSolution solution, String testSheetName) {
        SCORE_VERIFIER.assertHardWeight(constraintPackage, constraintName, expectedScore.getHardScore(), (Object)solution);
        SCORE_VERIFIER.assertMediumWeight(constraintPackage, constraintName, expectedScore.getMediumScore(), (Object)solution);
        SCORE_VERIFIER.assertSoftWeight(constraintPackage, constraintName, expectedScore.getSoftScore(), (Object)solution);
    }

    private static class TestConferenceSchedulingConstraintsReader
    extends AbstractXlsxSolutionFileIO.AbstractXlsxReader<ConferenceSolution, HardMediumSoftScore> {
        private final SolutionDescriptor<ConferenceSolution> solutionDescriptor = SolutionDescriptor.buildSolutionDescriptor(ConferenceSolution.class, (Class[])new Class[]{Talk.class});
        private final ConferenceSolution initialSolution;
        private int numberOfSheets;
        private int currentTestSheetIndex;
        private Map<String, Room> roomMap;
        private Map<Pair<LocalDateTime, LocalDateTime>, Timeslot> timeslotMap;
        private Map<Integer, LocalDate> columnIndexToDateMap;
        private Map<Integer, LocalTime> columnIndexToStartTimeMap;
        private Map<Integer, LocalTime> columnIndexToEndTimeMap;

        private TestConferenceSchedulingConstraintsReader(XSSFWorkbook workbook, ConferenceSolution initialSolution) {
            super(workbook, "org/optaplanner/examples/conferencescheduling/conferenceSchedulingSolverConfig.xml");
            this.numberOfSheets = workbook.getNumberOfSheets();
            this.currentTestSheetIndex = workbook.getSheetIndex("Talks") + 1;
            this.initialSolution = initialSolution;
            this.roomMap = initialSolution.getRoomList().stream().collect(Collectors.toMap(Room::getName, Function.identity()));
            this.timeslotMap = initialSolution.getTimeslotList().stream().collect(Collectors.toMap(timeslot -> Pair.of((Object)timeslot.getStartDateTime(), (Object)timeslot.getEndDateTime()), Function.identity()));
            this.columnIndexToDateMap = new HashMap<Integer, LocalDate>(this.timeslotMap.size());
            this.columnIndexToStartTimeMap = new HashMap<Integer, LocalTime>(this.timeslotMap.size());
            this.columnIndexToEndTimeMap = new HashMap<Integer, LocalTime>(this.timeslotMap.size());
        }

        public ConferenceSolution read() {
            return this.initialSolution;
        }

        private Object[] nextTestSheetParameters() {
            if (this.currentTestSheetIndex >= this.numberOfSheets) {
                return null;
            }
            this.nextSheet(this.workbook.getSheetName(this.currentTestSheetIndex++));
            String testSheetName = this.currentSheet.getSheetName();
            this.nextRow(false);
            this.readHeaderCell("Constraint package");
            String constraintPackage = this.nextStringCell().getStringCellValue();
            this.nextRow(false);
            this.readHeaderCell("Constraint name");
            String constraintName = this.nextStringCell().getStringCellValue();
            ConstraintWeightDescriptor constraintWeightDescriptor = this.solutionDescriptor.getConstraintConfigurationDescriptor().findConstraintWeightDescriptor(constraintPackage, constraintName);
            if (constraintWeightDescriptor == null) {
                throw new IllegalStateException(this.currentPosition() + ": There is no @" + ConstraintWeight.class.getSimpleName() + " for constraintPackage (" + constraintPackage + ") and constraintName (" + constraintName + ") in the constraintConfigurationClass (" + this.solutionDescriptor.getConstraintConfigurationDescriptor().getConstraintConfigurationClass() + ").");
            }
            this.nextRow(false);
            this.nextRow(false);
            this.readHeaderCell("Score weight multiplier");
            double weightMultiplierDouble = this.nextNumericCell().getNumericCellValue();
            if (weightMultiplierDouble != (double)((int)weightMultiplierDouble)) {
                throw new IllegalStateException(this.currentPosition() + ": The weightMultiplier (" + weightMultiplierDouble + ") must be an int.");
            }
            int weightMultiplier = (int)weightMultiplierDouble;
            ConferenceSolution solution = (ConferenceSolution)this.solutionDescriptor.getSolutionCloner().cloneSolution((Object)this.initialSolution);
            HardMediumSoftScore constraintScore = (HardMediumSoftScore)constraintWeightDescriptor.createExtractor().apply(solution);
            if (constraintScore.equals((Object)HardMediumSoftScore.ZERO)) {
                throw new IllegalStateException(this.currentPosition() + ": The constraintScore (" + constraintScore + ") of the @" + ConstraintWeight.class.getSimpleName() + " for constraintPackage (" + constraintPackage + ") and constraintName (" + constraintName + ") in the constraintConfigurationClass (" + this.solutionDescriptor.getConstraintConfigurationDescriptor().getConstraintConfigurationClass() + ") must not be zero.");
            }
            HardMediumSoftScore expectedScore = HardMediumSoftScore.of((int)(constraintScore.getHardScore() * weightMultiplier), (int)(constraintScore.getMediumScore() * weightMultiplier), (int)(constraintScore.getSoftScore() * weightMultiplier));
            SCORE_VERIFIER.assertHardWeight(constraintPackage, constraintName, unassignedScore.getHardScore(), (Object)solution);
            SCORE_VERIFIER.assertSoftWeight(constraintPackage, constraintName, unassignedScore.getSoftScore(), (Object)solution);
            this.nextRow();
            this.readTimeslotDays();
            this.nextRow(false);
            this.readHeaderCell("Room");
            this.readTimeslotHours();
            Map talkMap = solution.getTalkList().stream().collect(Collectors.toMap(Talk::getCode, Function.identity()));
            while (this.nextRow()) {
                String roomName = this.nextStringCell().getStringCellValue();
                Room room = this.roomMap.get(roomName);
                if (room == null) {
                    throw new IllegalStateException(this.currentPosition() + ": The room (" + roomName + ") does not exist in the room list.");
                }
                for (int i = 0; i < this.columnIndexToStartTimeMap.size(); ++i) {
                    LocalDateTime endDateTime;
                    String talkCode = this.nextCell().getStringCellValue();
                    if (talkCode.isEmpty()) continue;
                    Talk talk = (Talk)talkMap.get(talkCode);
                    if (talk == null) {
                        throw new IllegalStateException(this.currentPosition() + ": Talk (" + talkCode + ") does not exist in the talk list.");
                    }
                    LocalDateTime startDateTime = LocalDateTime.of(this.columnIndexToDateMap.get(this.currentColumnNumber), this.columnIndexToStartTimeMap.get(this.currentColumnNumber));
                    Timeslot timeslot = this.timeslotMap.get(Pair.of((Object)startDateTime, (Object)(endDateTime = LocalDateTime.of(this.columnIndexToDateMap.get(this.currentColumnNumber), this.columnIndexToEndTimeMap.get(this.currentColumnNumber)))));
                    if (timeslot == null) {
                        throw new IllegalStateException(this.currentPosition() + ": The timeslot with date (" + startDateTime.toLocalDate() + "), startTime (" + startDateTime.toLocalTime() + ") and endTime (" + endDateTime.toLocalTime() + ") doesn't exist in the other sheet (Timeslots).");
                    }
                    talk.setRoom(room);
                    talk.setTimeslot(timeslot);
                }
            }
            return new Object[]{constraintPackage, constraintName, expectedScore, solution, testSheetName};
        }

        private void readTimeslotDays() {
            this.columnIndexToDateMap.clear();
            String previousDateString = null;
            for (int i = 0; i < this.currentRow.getLastCellNum(); ++i) {
                XSSFCell cell = this.currentRow.getCell(i);
                if (cell.getStringCellValue().isEmpty() && previousDateString == null) continue;
                if (!cell.getStringCellValue().isEmpty()) {
                    previousDateString = cell.getStringCellValue();
                }
                try {
                    this.columnIndexToDateMap.put(i, LocalDate.parse(previousDateString, AbstractXlsxSolutionFileIO.DAY_FORMATTER));
                    continue;
                }
                catch (DateTimeParseException e) {
                    throw new IllegalStateException(this.currentPosition() + ": The date (" + cell.getStringCellValue() + ") does not parse as a date.");
                }
            }
        }

        private void readTimeslotHours() {
            this.columnIndexToStartTimeMap.clear();
            this.columnIndexToEndTimeMap.clear();
            StreamSupport.stream(this.currentRow.spliterator(), false).forEach(cell -> {
                if (!cell.getStringCellValue().isEmpty() && !cell.getStringCellValue().equals("Room")) {
                    String[] startAndEndTimeStringArray = cell.getStringCellValue().split("-");
                    try {
                        this.columnIndexToStartTimeMap.put(cell.getColumnIndex(), LocalTime.parse(startAndEndTimeStringArray[0], AbstractXlsxSolutionFileIO.TIME_FORMATTER));
                        this.columnIndexToEndTimeMap.put(cell.getColumnIndex(), LocalTime.parse(startAndEndTimeStringArray[1], AbstractXlsxSolutionFileIO.TIME_FORMATTER));
                    }
                    catch (DateTimeParseException e) {
                        throw new IllegalStateException(this.currentPosition() + ": The startTime (" + startAndEndTimeStringArray[0] + ") or endTime (" + startAndEndTimeStringArray[1] + ") doesn't parse as a time.", e);
                    }
                }
            });
        }
    }
}

