/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.score;

import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.domain.CloudComputer;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;
import org.optaplanner.examples.cloudbalancing.score.CloudBalancingConstraintProvider;
import org.optaplanner.test.api.score.stream.ConstraintVerifier;

public class CloudBalancingConstraintProviderTest {
    private final ConstraintVerifier<CloudBalancingConstraintProvider, CloudBalance> constraintVerifier = ConstraintVerifier.build((ConstraintProvider)new CloudBalancingConstraintProvider(), CloudBalance.class, (Class[])new Class[]{CloudProcess.class});

    @Test
    public void requiredCpuPowerTotal() {
        CloudComputer computer1 = new CloudComputer(1L, 1, 1, 1, 2);
        CloudComputer computer2 = new CloudComputer(2L, 2, 2, 2, 4);
        CloudProcess unassignedProcess = new CloudProcess(0L, 1, 1, 1);
        CloudProcess process1 = new CloudProcess(1L, 1, 1, 1);
        process1.setComputer(computer1);
        CloudProcess process2 = new CloudProcess(2L, 1, 1, 1);
        process2.setComputer(computer1);
        CloudProcess process3 = new CloudProcess(3L, 1, 1, 1);
        process3.setComputer(computer2);
        this.constraintVerifier.verifyThat(CloudBalancingConstraintProvider::requiredCpuPowerTotal).given(new Object[]{unassignedProcess, process1, process2, process3}).penalizesBy(1);
    }

    @Test
    public void requiredMemoryTotal() {
        CloudComputer computer1 = new CloudComputer(1L, 1, 1, 1, 2);
        CloudComputer computer2 = new CloudComputer(2L, 2, 2, 2, 4);
        CloudProcess unassignedProcess = new CloudProcess(0L, 1, 1, 1);
        CloudProcess process1 = new CloudProcess(1L, 1, 1, 1);
        process1.setComputer(computer1);
        CloudProcess process2 = new CloudProcess(2L, 1, 1, 1);
        process2.setComputer(computer1);
        CloudProcess process3 = new CloudProcess(3L, 1, 1, 1);
        process3.setComputer(computer2);
        this.constraintVerifier.verifyThat(CloudBalancingConstraintProvider::requiredMemoryTotal).given(new Object[]{unassignedProcess, process1, process2, process3}).penalizesBy(1);
    }

    @Test
    public void requiredNetworkBandwidthTotal() {
        CloudComputer computer1 = new CloudComputer(1L, 1, 1, 1, 2);
        CloudComputer computer2 = new CloudComputer(2L, 2, 2, 2, 4);
        CloudProcess unassignedProcess = new CloudProcess(0L, 1, 1, 1);
        CloudProcess process1 = new CloudProcess(1L, 1, 1, 1);
        process1.setComputer(computer1);
        CloudProcess process2 = new CloudProcess(2L, 1, 1, 1);
        process2.setComputer(computer1);
        CloudProcess process3 = new CloudProcess(3L, 1, 1, 1);
        process3.setComputer(computer2);
        this.constraintVerifier.verifyThat(CloudBalancingConstraintProvider::requiredNetworkBandwidthTotal).given(new Object[]{unassignedProcess, process1, process2, process3}).penalizesBy(1);
    }

    @Test
    public void computerCost() {
        CloudComputer computer1 = new CloudComputer(1L, 1, 1, 1, 2);
        CloudComputer computer2 = new CloudComputer(2L, 2, 2, 2, 4);
        CloudProcess unassignedProcess = new CloudProcess(0L, 1, 1, 1);
        CloudProcess process = new CloudProcess(1L, 1, 1, 1);
        process.setComputer(computer1);
        this.constraintVerifier.verifyThat(CloudBalancingConstraintProvider::computerCost).given(new Object[]{computer1, computer2, unassignedProcess, process}).penalizesBy(2);
    }
}

