/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.score;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceConstraintConfiguration;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceSolution;
import org.optaplanner.examples.conferencescheduling.domain.Room;
import org.optaplanner.examples.conferencescheduling.domain.Speaker;
import org.optaplanner.examples.conferencescheduling.domain.Talk;
import org.optaplanner.examples.conferencescheduling.domain.Timeslot;
import org.optaplanner.examples.conferencescheduling.score.ConferenceSchedulingConstraintProvider;
import org.optaplanner.test.api.score.stream.ConstraintVerifier;

public class ConferenceSchedulingConstraintProviderTest {
    private final ConstraintVerifier<ConferenceSchedulingConstraintProvider, ConferenceSolution> constraintVerifier = ConstraintVerifier.build((ConstraintProvider)new ConferenceSchedulingConstraintProvider(), ConferenceSolution.class, (Class[])new Class[]{Talk.class});
    private static final LocalDateTime START = LocalDateTime.of(2000, 2, 1, 9, 0);
    private static final Timeslot MONDAY_9_TO_10 = new Timeslot(1L).withStartDateTime(START).withEndDateTime(START.plusHours(1L)).withTagSet(Collections.singleton("a"));
    private static final Timeslot MONDAY_10_TO_11 = new Timeslot(2L).withStartDateTime(MONDAY_9_TO_10.getEndDateTime()).withEndDateTime(MONDAY_9_TO_10.getEndDateTime().plusHours(1L)).withTagSet(Collections.singleton("b"));
    private static final Timeslot MONDAY_11_TO_12 = new Timeslot(3L).withStartDateTime(MONDAY_10_TO_11.getEndDateTime()).withEndDateTime(MONDAY_10_TO_11.getEndDateTime().plusHours(1L)).withTagSet(Collections.singleton("c"));
    private static final Timeslot TUESDAY_9_TO_10 = new Timeslot(4L).withStartDateTime(START.plusDays(1L)).withEndDateTime(START.plusDays(1L).plusHours(1L)).withTagSet(Collections.singleton("c"));

    @Test
    public void roomUnavailableTimeslot() {
        Room room1 = new Room(1L).withUnavailableTimeslotSet(Collections.singleton(MONDAY_9_TO_10));
        Room room2 = new Room(2L).withUnavailableTimeslotSet(Collections.singleton(MONDAY_10_TO_11));
        Talk talk1 = new Talk(1L).withRoom(room1).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room2).withTimeslot(MONDAY_9_TO_10);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::roomUnavailableTimeslot).given(new Object[]{talk1, talk2}).penalizesBy(MONDAY_9_TO_10.getDurationInMinutes().intValue());
    }

    @Test
    public void roomConflict() {
        Room room = new Room(1L).withUnavailableTimeslotSet(Collections.singleton(MONDAY_9_TO_10));
        Talk talk1 = new Talk(1L).withRoom(room).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withTimeslot(MONDAY_9_TO_10);
        Talk talk3 = new Talk(3L).withRoom(room).withTimeslot(MONDAY_10_TO_11);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::roomConflict).given(new Object[]{talk1, talk2, talk3}).penalizesBy(MONDAY_9_TO_10.getDurationInMinutes().intValue());
    }

    @Test
    public void speakerUnavailableTimeslot() {
        Room room = new Room(0L);
        Speaker speaker1 = new Speaker(1L).withUnavailableTimeslotSet(Collections.singleton(MONDAY_9_TO_10));
        Speaker speaker2 = new Speaker(2L).withUnavailableTimeslotSet(Collections.singleton(MONDAY_10_TO_11));
        Talk talk1 = new Talk(1L).withRoom(room).withSpeakerList(Collections.singletonList(speaker1)).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withSpeakerList(Collections.singletonList(speaker2)).withTimeslot(MONDAY_9_TO_10);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::speakerUnavailableTimeslot).given(new Object[]{talk1, talk2}).penalizesBy(MONDAY_9_TO_10.getDurationInMinutes().intValue());
    }

    @Test
    public void speakerConflict() {
        Room room = new Room(0L);
        Speaker speaker = new Speaker(1L);
        Talk talk1 = new Talk(1L).withRoom(room).withSpeakerList(Collections.singletonList(speaker)).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withSpeakerList(Collections.singletonList(speaker)).withTimeslot(MONDAY_9_TO_10);
        Talk talk3 = new Talk(3L).withRoom(room).withSpeakerList(Collections.singletonList(speaker)).withTimeslot(MONDAY_10_TO_11);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::speakerConflict).given(new Object[]{speaker, talk1, talk2, talk3}).penalizesBy(MONDAY_9_TO_10.getDurationInMinutes().intValue());
    }

    @Test
    public void talkPrerequisiteTalks() {
        Room room = new Room(0L);
        Talk talk1 = new Talk(1L).withRoom(room).withPrerequisiteTalksCodesSet(Collections.emptySet()).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withPrerequisiteTalksCodesSet(Collections.singleton(talk1)).withTimeslot(MONDAY_9_TO_10);
        Talk talk3 = new Talk(3L).withRoom(room).withPrerequisiteTalksCodesSet(Collections.singleton(talk1)).withTimeslot(MONDAY_10_TO_11);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::talkPrerequisiteTalks).given(new Object[]{talk1, talk2, talk3}).penalizesBy(MONDAY_9_TO_10.getDurationInMinutes() * 2);
    }

    @Test
    public void talkMutuallyExclusiveTalksTags() {
        Room room = new Room(0L);
        Talk talk1 = new Talk(1L).withRoom(room).withMutuallyExclusiveTalksTagSet(Collections.emptySet()).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withMutuallyExclusiveTalksTagSet(new HashSet<String>(Arrays.asList("a", "b"))).withTimeslot(MONDAY_9_TO_10);
        Talk talk3 = new Talk(3L).withRoom(room).withMutuallyExclusiveTalksTagSet(new HashSet<String>(Arrays.asList("a", "b", "c"))).withTimeslot(MONDAY_9_TO_10);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::talkMutuallyExclusiveTalksTags).given(new Object[]{talk1, talk2, talk3}).penalizesBy(MONDAY_9_TO_10.getDurationInMinutes() * 2);
    }

    @Test
    public void consecutiveTalksPause() {
        Room room = new Room(0L);
        Speaker speaker1 = new Speaker(1L);
        Speaker speaker2 = new Speaker(2L);
        Talk talk1 = new Talk(1L).withRoom(room).withSpeakerList(Collections.singletonList(speaker1)).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withSpeakerList(Collections.singletonList(speaker1)).withTimeslot(MONDAY_10_TO_11);
        Talk talk3 = new Talk(3L).withRoom(room).withSpeakerList(Collections.singletonList(speaker1)).withTimeslot(MONDAY_11_TO_12);
        Talk talk4 = new Talk(4L).withRoom(room).withSpeakerList(Collections.singletonList(speaker2)).withTimeslot(MONDAY_9_TO_10);
        ConferenceConstraintConfiguration configuration = new ConferenceConstraintConfiguration(0L);
        configuration.setMinimumConsecutiveTalksPauseInMinutes(10);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::consecutiveTalksPause).given(new Object[]{configuration, talk1, talk2, talk3, talk4}).penalizesBy(MONDAY_9_TO_10.getDurationInMinutes() * 4);
    }

    @Test
    public void crowdControl() {
        Room room = new Room(0L);
        Talk talk1 = new Talk(1L).withRoom(room).withTimeslot(MONDAY_9_TO_10);
        talk1.setCrowdControlRisk(1);
        Talk talk2 = new Talk(2L).withRoom(room).withTimeslot(MONDAY_9_TO_10);
        talk2.setCrowdControlRisk(1);
        Talk talk3 = new Talk(3L).withRoom(room).withTimeslot(MONDAY_9_TO_10);
        talk3.setCrowdControlRisk(1);
        Talk talk4 = new Talk(4L).withRoom(room).withTimeslot(MONDAY_10_TO_11);
        talk4.setCrowdControlRisk(1);
        Talk talk5 = new Talk(5L).withRoom(room).withTimeslot(MONDAY_10_TO_11);
        talk5.setCrowdControlRisk(1);
        Talk noRiskTalk = new Talk(6L).withRoom(room).withTimeslot(MONDAY_10_TO_11);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::crowdControl).given(new Object[]{talk1, talk2, talk3, talk4, talk5, noRiskTalk}).penalizesBy(MONDAY_9_TO_10.getDurationInMinutes() * 3);
    }

    @Test
    public void speakerRequiredTimeslotTags() {
        Room room = new Room(0L);
        Speaker speaker1 = new Speaker(1L).withRequiredTimeslotTagSet(Collections.singleton("a"));
        Speaker speaker2 = new Speaker(1L).withRequiredTimeslotTagSet(Collections.singleton("x"));
        Talk talk1 = new Talk(1L).withRoom(room).withSpeakerList(Collections.singletonList(speaker1)).withRequiredTimeslotTagSet(new HashSet<String>(Arrays.asList("a", "b"))).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withSpeakerList(Collections.singletonList(speaker2)).withRequiredTimeslotTagSet(Collections.emptySet()).withTimeslot(MONDAY_10_TO_11);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::speakerRequiredTimeslotTags).given(new Object[]{talk1, talk2}).penalizesBy(MONDAY_10_TO_11.getDurationInMinutes().intValue());
    }

    @Test
    public void speakerProhibitedTimeslotTags() {
        Room room = new Room(0L);
        Speaker speaker1 = new Speaker(1L).withProhibitedTimeslotTagSet(Collections.singleton("a"));
        Speaker speaker2 = new Speaker(1L).withProhibitedTimeslotTagSet(Collections.singleton("x"));
        Talk talk1 = new Talk(1L).withRoom(room).withSpeakerList(Collections.singletonList(speaker1)).withProhibitedTimeslotTagSet(new HashSet<String>(Arrays.asList("a", "b"))).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withSpeakerList(Collections.singletonList(speaker2)).withProhibitedTimeslotTagSet(Collections.emptySet()).withTimeslot(MONDAY_10_TO_11);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::speakerProhibitedTimeslotTags).given(new Object[]{talk1, talk2}).penalizesBy(MONDAY_9_TO_10.getDurationInMinutes().intValue());
    }

    @Test
    public void talkRequiredTimeslotTags() {
        Room room = new Room(0L);
        Talk talk1 = new Talk(1L).withRoom(room).withRequiredTimeslotTagSet(new HashSet<String>(Arrays.asList("a", "b"))).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withRequiredTimeslotTagSet(Collections.emptySet()).withTimeslot(MONDAY_10_TO_11);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::talkRequiredTimeslotTags).given(new Object[]{talk1, talk2}).penalizesBy(MONDAY_10_TO_11.getDurationInMinutes().intValue());
    }

    @Test
    public void talkProhibitedTimeslotTags() {
        Room room = new Room(0L);
        Talk talk1 = new Talk(1L).withRoom(room).withProhibitedTimeslotTagSet(new HashSet<String>(Arrays.asList("a", "b"))).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withProhibitedTimeslotTagSet(Collections.emptySet()).withTimeslot(MONDAY_10_TO_11);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::talkProhibitedTimeslotTags).given(new Object[]{talk1, talk2}).penalizesBy(MONDAY_9_TO_10.getDurationInMinutes().intValue());
    }

    @Test
    public void speakerRequiredRoomTags() {
        Room room = new Room(0L).withTagSet(Collections.singleton("a"));
        Speaker speaker1 = new Speaker(1L).withRequiredRoomTagSet(Collections.singleton("a"));
        Speaker speaker2 = new Speaker(1L).withRequiredRoomTagSet(Collections.singleton("x"));
        Talk talk1 = new Talk(1L).withRoom(room).withSpeakerList(Collections.singletonList(speaker1)).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withSpeakerList(Collections.singletonList(speaker2)).withTimeslot(MONDAY_10_TO_11);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::speakerRequiredRoomTags).given(new Object[]{talk1, talk2}).penalizesBy(MONDAY_10_TO_11.getDurationInMinutes().intValue());
    }

    @Test
    public void speakerProhibitedRoomTags() {
        Room room = new Room(0L).withTagSet(Collections.singleton("a"));
        Speaker speaker1 = new Speaker(1L).withProhibitedRoomTagSet(Collections.singleton("a"));
        Speaker speaker2 = new Speaker(1L).withProhibitedRoomTagSet(Collections.singleton("x"));
        Talk talk1 = new Talk(1L).withRoom(room).withSpeakerList(Collections.singletonList(speaker1)).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withSpeakerList(Collections.singletonList(speaker2)).withTimeslot(MONDAY_10_TO_11);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::speakerProhibitedRoomTags).given(new Object[]{talk1, talk2}).penalizesBy(MONDAY_9_TO_10.getDurationInMinutes().intValue());
    }

    @Test
    public void talkRequiredRoomTags() {
        Room room = new Room(0L).withTagSet(Collections.singleton("a"));
        Talk talk1 = new Talk(1L).withRoom(room).withRequiredRoomTagSet(new HashSet<String>(Arrays.asList("a", "b"))).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withRequiredRoomTagSet(Collections.emptySet()).withTimeslot(MONDAY_10_TO_11);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::talkRequiredRoomTags).given(new Object[]{talk1, talk2}).penalizesBy(MONDAY_10_TO_11.getDurationInMinutes().intValue());
    }

    @Test
    public void talkProhibitedRoomTags() {
        Room room = new Room(0L).withTagSet(Collections.singleton("a"));
        Talk talk1 = new Talk(1L).withRoom(room).withProhibitedRoomTagSet(new HashSet<String>(Arrays.asList("a", "b"))).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withProhibitedRoomTagSet(Collections.emptySet()).withTimeslot(MONDAY_10_TO_11);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::talkProhibitedRoomTags).given(new Object[]{talk1, talk2}).penalizesBy(MONDAY_9_TO_10.getDurationInMinutes().intValue());
    }

    @Test
    public void publishedTimeslot() {
        Room room = new Room(0L);
        Talk talk1 = new Talk(1L).withRoom(room).withTimeslot(MONDAY_9_TO_10);
        talk1.setPublishedTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withTimeslot(MONDAY_10_TO_11);
        talk2.setPublishedTimeslot(MONDAY_9_TO_10);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::publishedTimeslot).given(new Object[]{talk1, talk2}).penalizesBy(1);
    }

    @Test
    public void publishedRoom() {
        Room room1 = new Room(0L);
        Room room2 = new Room(1L);
        Talk talk1 = new Talk(1L).withRoom(room1).withTimeslot(MONDAY_9_TO_10);
        talk1.setPublishedRoom(room1);
        Talk talk2 = new Talk(2L).withRoom(room1).withTimeslot(MONDAY_10_TO_11);
        talk2.setPublishedRoom(room2);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::publishedRoom).given(new Object[]{talk1, talk2}).penalizesBy(1);
    }

    @Test
    public void themeTrackConflict() {
        Room room = new Room(0L);
        Talk talk1 = new Talk(1L).withRoom(room).withThemeTrackTagSet(Collections.singleton("a")).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withThemeTrackTagSet(Collections.singleton("a")).withTimeslot(MONDAY_9_TO_10);
        Talk talk3 = new Talk(3L).withRoom(room).withThemeTrackTagSet(Collections.singleton("b")).withTimeslot(MONDAY_9_TO_10);
        Talk talk4 = new Talk(4L).withRoom(room).withThemeTrackTagSet(Collections.singleton("a")).withTimeslot(MONDAY_10_TO_11);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::themeTrackConflict).given(new Object[]{talk1, talk2, talk3, talk4}).penalizesBy(60);
    }

    @Test
    public void themeTrackRoomStability() {
        Room room1 = new Room(0L);
        Room room2 = new Room(1L);
        Talk talk1 = new Talk(1L).withRoom(room1).withThemeTrackTagSet(Collections.singleton("a")).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room2).withThemeTrackTagSet(Collections.singleton("a")).withTimeslot(MONDAY_10_TO_11);
        Talk talk3 = new Talk(3L).withRoom(room1).withThemeTrackTagSet(Collections.singleton("b")).withTimeslot(MONDAY_11_TO_12);
        Talk talk4 = new Talk(4L).withRoom(room2).withThemeTrackTagSet(Collections.singleton("a")).withTimeslot(TUESDAY_9_TO_10);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::themeTrackRoomStability).given(new Object[]{talk1, talk2, talk3, talk4}).penalizesBy(120);
    }

    @Test
    public void sectorConflict() {
        Room room = new Room(0L);
        Talk talk1 = new Talk(1L).withRoom(room).withSectorTagSet(Collections.singleton("a")).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withSectorTagSet(Collections.singleton("a")).withTimeslot(MONDAY_9_TO_10);
        Talk talk3 = new Talk(3L).withRoom(room).withSectorTagSet(Collections.singleton("b")).withTimeslot(MONDAY_9_TO_10);
        Talk talk4 = new Talk(4L).withRoom(room).withSectorTagSet(Collections.singleton("a")).withTimeslot(MONDAY_10_TO_11);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::sectorConflict).given(new Object[]{talk1, talk2, talk3, talk4}).penalizesBy(60);
    }

    @Test
    public void audienceTypeDiversity() {
        Room room = new Room(0L);
        Talk talk1 = new Talk(1L).withRoom(room).withAudienceTypeSet(Collections.singleton("a")).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withAudienceTypeSet(Collections.singleton("a")).withTimeslot(MONDAY_9_TO_10);
        Talk talk3 = new Talk(3L).withRoom(room).withAudienceTypeSet(Collections.singleton("b")).withTimeslot(MONDAY_9_TO_10);
        Talk talk4 = new Talk(4L).withRoom(room).withAudienceTypeSet(Collections.singleton("a")).withTimeslot(MONDAY_10_TO_11);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::audienceTypeDiversity).given(new Object[]{talk1, talk2, talk3, talk4}).rewardsWith(60);
    }

    @Test
    public void audienceTypeThemeTrackConflict() {
        Room room = new Room(0L);
        Talk talk1 = new Talk(1L).withRoom(room).withAudienceTypeSet(Collections.singleton("a")).withThemeTrackTagSet(Collections.singleton("b")).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withAudienceTypeSet(Collections.singleton("a")).withThemeTrackTagSet(Collections.singleton("a")).withTimeslot(MONDAY_9_TO_10);
        Talk talk3 = new Talk(3L).withRoom(room).withAudienceTypeSet(Collections.singleton("b")).withThemeTrackTagSet(Collections.singleton("a")).withTimeslot(MONDAY_9_TO_10);
        Talk talk4 = new Talk(4L).withRoom(room).withAudienceTypeSet(Collections.singleton("a")).withThemeTrackTagSet(Collections.singleton("a")).withTimeslot(MONDAY_10_TO_11);
        Talk talk5 = new Talk(5L).withRoom(room).withAudienceTypeSet(Collections.singleton("a")).withThemeTrackTagSet(Collections.singleton("b")).withTimeslot(MONDAY_9_TO_10);
        Talk talk6 = new Talk(6L).withRoom(room).withAudienceTypeSet(Collections.singleton("a")).withThemeTrackTagSet(Collections.singleton("c")).withTimeslot(MONDAY_9_TO_10);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::audienceTypeThemeTrackConflict).given(new Object[]{talk1, talk2, talk3, talk4, talk5, talk6}).penalizesBy(60);
    }

    @Test
    public void audienceLevelDiversity() {
        Room room = new Room(0L);
        Talk talk1 = new Talk(1L).withRoom(room).withAudienceLevel(1).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withAudienceLevel(1).withTimeslot(MONDAY_9_TO_10);
        Talk talk3 = new Talk(3L).withRoom(room).withAudienceLevel(2).withTimeslot(MONDAY_9_TO_10);
        Talk talk4 = new Talk(4L).withRoom(room).withAudienceLevel(1).withTimeslot(MONDAY_10_TO_11);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::audienceLevelDiversity).given(new Object[]{talk1, talk2, talk3, talk4}).rewardsWith(120);
    }

    @Test
    public void contentAudienceLevelFlowViolation() {
        Room room = new Room(0L);
        Talk talk1 = new Talk(1L).withRoom(room).withAudienceLevel(1).withContentTagSet(Collections.singleton("a")).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withAudienceLevel(2).withContentTagSet(Collections.singleton("a")).withTimeslot(MONDAY_9_TO_10);
        Talk talk3 = new Talk(3L).withRoom(room).withAudienceLevel(3).withContentTagSet(Collections.singleton("b")).withTimeslot(MONDAY_9_TO_10);
        Talk talk4 = new Talk(4L).withRoom(room).withAudienceLevel(1).withContentTagSet(Collections.singleton("a")).withTimeslot(MONDAY_10_TO_11);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::contentAudienceLevelFlowViolation).given(new Object[]{talk1, talk2, talk3, talk4}).penalizesBy(240);
    }

    @Test
    public void contentConflict() {
        Room room = new Room(0L);
        Talk talk1 = new Talk(1L).withRoom(room).withContentTagSet(Collections.singleton("a")).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withContentTagSet(Collections.singleton("a")).withTimeslot(MONDAY_9_TO_10);
        Talk talk3 = new Talk(3L).withRoom(room).withContentTagSet(Collections.singleton("b")).withTimeslot(MONDAY_9_TO_10);
        Talk talk4 = new Talk(4L).withRoom(room).withContentTagSet(Collections.singleton("a")).withTimeslot(MONDAY_10_TO_11);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::contentConflict).given(new Object[]{talk1, talk2, talk3, talk4}).penalizesBy(60);
    }

    @Test
    public void languageDiversity() {
        Room room = new Room(0L);
        Talk talk1 = new Talk(1L).withRoom(room).withLanguage("a").withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withLanguage("a").withTimeslot(MONDAY_9_TO_10);
        Talk talk3 = new Talk(3L).withRoom(room).withLanguage("b").withTimeslot(MONDAY_9_TO_10);
        Talk talk4 = new Talk(4L).withRoom(room).withLanguage("a").withTimeslot(MONDAY_10_TO_11);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::languageDiversity).given(new Object[]{talk1, talk2, talk3, talk4}).rewardsWith(120);
    }

    @Test
    public void sameDayTalks() {
        Room room = new Room(0L);
        Talk talk1 = new Talk(1L).withRoom(room).withContentTagSet(Collections.singleton("a")).withThemeTrackTagSet(Collections.singleton("a")).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(3L).withRoom(room).withContentTagSet(Collections.singleton("b")).withThemeTrackTagSet(Collections.singleton("a")).withTimeslot(TUESDAY_9_TO_10);
        Talk talk3 = new Talk(4L).withRoom(room).withContentTagSet(Collections.singleton("a")).withThemeTrackTagSet(Collections.singleton("a")).withTimeslot(TUESDAY_9_TO_10);
        Talk talk4 = new Talk(5L).withRoom(room).withContentTagSet(Collections.singleton("a")).withThemeTrackTagSet(Collections.singleton("b")).withTimeslot(MONDAY_9_TO_10);
        Talk talk5 = new Talk(7L).withRoom(room).withContentTagSet(Collections.singleton("b")).withThemeTrackTagSet(Collections.singleton("b")).withTimeslot(TUESDAY_9_TO_10);
        Talk talk6 = new Talk(8L).withRoom(room).withContentTagSet(Collections.singleton("a")).withThemeTrackTagSet(Collections.singleton("b")).withTimeslot(TUESDAY_9_TO_10);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::sameDayTalks).given(new Object[]{talk1, talk2, talk3, talk4, talk5, talk6}).penalizesBy(960);
    }

    @Test
    public void popularTalks() {
        Room smallerRoom = new Room(0L).withCapacity(10);
        Room biggerRoom = new Room(1L).withCapacity(20);
        Talk talk1 = new Talk(1L).withRoom(smallerRoom).withFavoriteCount(2).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(biggerRoom).withFavoriteCount(2).withTimeslot(MONDAY_9_TO_10);
        Talk talk3 = new Talk(3L).withRoom(biggerRoom).withFavoriteCount(1).withTimeslot(MONDAY_9_TO_10);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::popularTalks).given(new Object[]{talk1, talk2, talk3}).penalizesBy(120);
    }

    @Test
    public void speakerPreferredTimeslotTags() {
        Room room = new Room(0L);
        Speaker speaker1 = new Speaker(1L).withPreferredTimeslotTagSet(Collections.singleton("a"));
        Speaker speaker2 = new Speaker(1L).withPreferredTimeslotTagSet(Collections.singleton("x"));
        Talk talk1 = new Talk(1L).withRoom(room).withSpeakerList(Collections.singletonList(speaker1)).withPreferredTimeslotTagSet(new HashSet<String>(Arrays.asList("a", "b"))).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withSpeakerList(Collections.singletonList(speaker2)).withPreferredTimeslotTagSet(Collections.emptySet()).withTimeslot(MONDAY_10_TO_11);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::speakerPreferredTimeslotTags).given(new Object[]{talk1, talk2}).penalizesBy(MONDAY_10_TO_11.getDurationInMinutes().intValue());
    }

    @Test
    public void speakerUndesiredTimeslotTags() {
        Room room = new Room(0L);
        Speaker speaker1 = new Speaker(1L).withUndesiredTimeslotTagSet(Collections.singleton("a"));
        Speaker speaker2 = new Speaker(1L).withUndesiredTimeslotTagSet(Collections.singleton("x"));
        Talk talk1 = new Talk(1L).withRoom(room).withSpeakerList(Collections.singletonList(speaker1)).withUndesiredTimeslotTagSet(new HashSet<String>(Arrays.asList("a", "b"))).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withSpeakerList(Collections.singletonList(speaker2)).withUndesiredTimeslotTagSet(Collections.emptySet()).withTimeslot(MONDAY_10_TO_11);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::speakerUndesiredTimeslotTags).given(new Object[]{talk1, talk2}).penalizesBy(MONDAY_9_TO_10.getDurationInMinutes().intValue());
    }

    @Test
    public void talkPreferredTimeslotTags() {
        Room room = new Room(0L);
        Talk talk1 = new Talk(1L).withRoom(room).withPreferredTimeslotTagSet(new HashSet<String>(Arrays.asList("a", "b"))).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withPreferredTimeslotTagSet(Collections.emptySet()).withTimeslot(MONDAY_10_TO_11);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::talkPreferredTimeslotTags).given(new Object[]{talk1, talk2}).penalizesBy(MONDAY_10_TO_11.getDurationInMinutes().intValue());
    }

    @Test
    public void talkUndesiredTimeslotTags() {
        Room room = new Room(0L);
        Talk talk1 = new Talk(1L).withRoom(room).withUndesiredTimeslotTagSet(new HashSet<String>(Arrays.asList("a", "b"))).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withUndesiredTimeslotTagSet(Collections.emptySet()).withTimeslot(MONDAY_10_TO_11);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::talkUndesiredTimeslotTags).given(new Object[]{talk1, talk2}).penalizesBy(MONDAY_9_TO_10.getDurationInMinutes().intValue());
    }

    @Test
    public void speakerPreferredRoomTags() {
        Room room = new Room(0L).withTagSet(Collections.singleton("a"));
        Speaker speaker1 = new Speaker(1L).withPreferredRoomTagSet(Collections.singleton("a"));
        Speaker speaker2 = new Speaker(1L).withPreferredRoomTagSet(Collections.singleton("x"));
        Talk talk1 = new Talk(1L).withRoom(room).withSpeakerList(Collections.singletonList(speaker1)).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withSpeakerList(Collections.singletonList(speaker2)).withTimeslot(MONDAY_10_TO_11);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::speakerPreferredRoomTags).given(new Object[]{talk1, talk2}).penalizesBy(MONDAY_10_TO_11.getDurationInMinutes().intValue());
    }

    @Test
    public void speakerUndesiredRoomTags() {
        Room room = new Room(0L).withTagSet(Collections.singleton("a"));
        Speaker speaker1 = new Speaker(1L).withUndesiredRoomTagSet(Collections.singleton("a"));
        Speaker speaker2 = new Speaker(1L).withUndesiredRoomTagSet(Collections.singleton("x"));
        Talk talk1 = new Talk(1L).withRoom(room).withSpeakerList(Collections.singletonList(speaker1)).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withSpeakerList(Collections.singletonList(speaker2)).withTimeslot(MONDAY_10_TO_11);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::speakerUndesiredRoomTags).given(new Object[]{talk1, talk2}).penalizesBy(MONDAY_9_TO_10.getDurationInMinutes().intValue());
    }

    @Test
    public void talkPreferredRoomTags() {
        Room room = new Room(0L).withTagSet(Collections.singleton("a"));
        Talk talk1 = new Talk(1L).withRoom(room).withPreferredRoomTagSet(new HashSet<String>(Arrays.asList("a", "b"))).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withPreferredRoomTagSet(Collections.emptySet()).withTimeslot(MONDAY_10_TO_11);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::talkPreferredRoomTags).given(new Object[]{talk1, talk2}).penalizesBy(MONDAY_10_TO_11.getDurationInMinutes().intValue());
    }

    @Test
    public void talkUndesiredRoomTags() {
        Room room = new Room(0L).withTagSet(Collections.singleton("a"));
        Talk talk1 = new Talk(1L).withRoom(room).withUndesiredRoomTagSet(new HashSet<String>(Arrays.asList("a", "b"))).withTimeslot(MONDAY_9_TO_10);
        Talk talk2 = new Talk(2L).withRoom(room).withUndesiredRoomTagSet(Collections.emptySet()).withTimeslot(MONDAY_10_TO_11);
        this.constraintVerifier.verifyThat(ConferenceSchedulingConstraintProvider::talkUndesiredRoomTags).given(new Object[]{talk1, talk2}).penalizesBy(MONDAY_9_TO_10.getDurationInMinutes().intValue());
    }
}

