/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.pas.persistence;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionImporter;
import org.optaplanner.examples.common.persistence.SolutionConverter;
import org.optaplanner.examples.pas.domain.AdmissionPart;
import org.optaplanner.examples.pas.domain.Bed;
import org.optaplanner.examples.pas.domain.BedDesignation;
import org.optaplanner.examples.pas.domain.Department;
import org.optaplanner.examples.pas.domain.DepartmentSpecialism;
import org.optaplanner.examples.pas.domain.Equipment;
import org.optaplanner.examples.pas.domain.Gender;
import org.optaplanner.examples.pas.domain.GenderLimitation;
import org.optaplanner.examples.pas.domain.Night;
import org.optaplanner.examples.pas.domain.Patient;
import org.optaplanner.examples.pas.domain.PatientAdmissionSchedule;
import org.optaplanner.examples.pas.domain.PreferredPatientEquipment;
import org.optaplanner.examples.pas.domain.RequiredPatientEquipment;
import org.optaplanner.examples.pas.domain.Room;
import org.optaplanner.examples.pas.domain.RoomEquipment;
import org.optaplanner.examples.pas.domain.RoomSpecialism;
import org.optaplanner.examples.pas.domain.Specialism;

public class PatientAdmissionScheduleImporter
extends AbstractTxtSolutionImporter<PatientAdmissionSchedule> {
    public static void main(String[] args) {
        SolutionConverter<PatientAdmissionSchedule> converter = SolutionConverter.createImportConverter("pas", new PatientAdmissionScheduleImporter(), PatientAdmissionSchedule.class);
        converter.convertAll();
    }

    @Override
    public AbstractTxtSolutionImporter.TxtInputBuilder<PatientAdmissionSchedule> createTxtInputBuilder() {
        return new PatientAdmissionScheduleInputBuilder();
    }

    public static class PatientAdmissionScheduleInputBuilder
    extends AbstractTxtSolutionImporter.TxtInputBuilder<PatientAdmissionSchedule> {
        private static final Comparator<Room> ROOM_COMPARATOR = Comparator.comparing(Room::getDepartment, Comparator.comparingLong(AbstractPersistable::getId)).thenComparingLong(AbstractPersistable::getId);
        private static final Comparator<Bed> BED_COMPARATOR = Comparator.comparing(Bed::getRoom, ROOM_COMPARATOR).thenComparingInt(Bed::getIndexInRoom).thenComparingLong(AbstractPersistable::getId);
        private PatientAdmissionSchedule patientAdmissionSchedule;
        private int specialismListSize;
        private int departmentListSize;
        private int equipmentListSize;
        private int roomListSize;
        private int bedListSize;
        private int nightListSize;
        private int patientListSize;
        private Map<Long, Specialism> idToSpecialismMap = null;
        private Map<Long, Department> idToDepartmentMap = null;
        private Map<Integer, Equipment> indexToEquipmentMap = null;
        private Map<Long, Room> idToRoomMap = null;
        private Map<Integer, Night> indexToNightMap = null;

        @Override
        public PatientAdmissionSchedule readSolution() throws IOException {
            this.patientAdmissionSchedule = new PatientAdmissionSchedule();
            this.patientAdmissionSchedule.setId(0L);
            this.readSizes();
            this.readEmptyLine();
            this.readEmptyLine();
            this.readSpecialismList();
            this.readEmptyLine();
            this.readDepartmentListAndDepartmentSpecialismList();
            this.readEmptyLine();
            this.readEquipmentList();
            this.readEmptyLine();
            this.readRoomListAndRoomSpecialismListAndRoomEquipmentList();
            this.readEmptyLine();
            this.readBedList();
            this.readEmptyLine();
            this.generateNightList();
            this.readPatientListAndAdmissionPartListAndRequiredPatientEquipmentListAndPreferredPatientEquipmentList();
            this.readEmptyLine();
            this.readConstantLine("END\\.");
            this.createBedDesignationList();
            BigInteger possibleSolutionSize = BigInteger.valueOf(this.patientAdmissionSchedule.getBedList().size() + 1).pow(this.patientAdmissionSchedule.getAdmissionPartList().size());
            this.logger.info("PatientAdmissionSchedule {} has {} specialisms, {} equipments, {} departments, {} rooms, {} beds, {} nights, {} patients and {} admissions with a search space of {}.", new Object[]{this.getInputId(), this.patientAdmissionSchedule.getSpecialismList().size(), this.patientAdmissionSchedule.getEquipmentList().size(), this.patientAdmissionSchedule.getDepartmentList().size(), this.patientAdmissionSchedule.getRoomList().size(), this.patientAdmissionSchedule.getBedList().size(), this.patientAdmissionSchedule.getNightList().size(), this.patientAdmissionSchedule.getPatientList().size(), this.patientAdmissionSchedule.getAdmissionPartList().size(), AbstractSolutionImporter.getFlooredPossibleSolutionSize(possibleSolutionSize)});
            return this.patientAdmissionSchedule;
        }

        private void readSizes() throws IOException {
            this.readConstantLine("ARTICLE BENCHMARK DATA SET");
            this.roomListSize = this.readIntegerValue("Rooms:");
            this.equipmentListSize = this.readIntegerValue("Roomproperties:");
            this.bedListSize = this.readIntegerValue("Beds:");
            this.departmentListSize = this.readIntegerValue("Departments:");
            this.specialismListSize = this.readIntegerValue("Specialisms:");
            this.patientListSize = this.readIntegerValue("Patients:");
            this.nightListSize = this.readIntegerValue("Planning horizon:");
        }

        private void readSpecialismList() throws IOException {
            this.readConstantLine("SPECIALISMS:");
            ArrayList<Specialism> specialismList = new ArrayList<Specialism>(this.specialismListSize);
            this.idToSpecialismMap = new HashMap<Long, Specialism>(this.specialismListSize);
            for (int i = 0; i < this.specialismListSize; ++i) {
                String line = this.bufferedReader.readLine();
                String[] lineTokens = this.splitBySpace(line, 2);
                Specialism specialism = new Specialism();
                specialism.setId(Long.parseLong(lineTokens[0]));
                specialism.setName(lineTokens[1]);
                specialismList.add(specialism);
                this.idToSpecialismMap.put(specialism.getId(), specialism);
            }
            this.patientAdmissionSchedule.setSpecialismList(specialismList);
        }

        private void readDepartmentListAndDepartmentSpecialismList() throws IOException {
            this.readConstantLine("DEPARTMENTS:");
            ArrayList<Department> departmentList = new ArrayList<Department>(this.departmentListSize);
            this.idToDepartmentMap = new HashMap<Long, Department>(this.departmentListSize);
            ArrayList<DepartmentSpecialism> departmentSpecialismList = new ArrayList<DepartmentSpecialism>(this.departmentListSize * 5);
            long departmentSpecialismId = 0L;
            for (int i = 0; i < this.departmentListSize; ++i) {
                int maximumAge;
                String line = this.bufferedReader.readLine();
                String[] lineTokens = this.splitByPipelineAndTrim(line, 2);
                String[] departmentTokens = this.splitBySpace(lineTokens[0], 4);
                Department department = new Department();
                department.setId(Long.parseLong(departmentTokens[0]));
                department.setName(departmentTokens[1]);
                department.setRoomList(new ArrayList<Room>());
                int minimumAge = Integer.parseInt(departmentTokens[2]);
                if (minimumAge != 0) {
                    department.setMinimumAge(minimumAge);
                }
                if ((maximumAge = Integer.parseInt(departmentTokens[3])) != 0) {
                    department.setMaximumAge(maximumAge);
                }
                departmentList.add(department);
                this.idToDepartmentMap.put(department.getId(), department);
                String[] departmentSpecialismTokens = this.splitBySpace(lineTokens[1]);
                if (departmentSpecialismTokens.length % 2 != 0) {
                    throw new IllegalArgumentException("Read line (" + line + ") is expected to contain even number of tokens (" + departmentSpecialismTokens.length + ") after 1st pipeline (|) separated by a space ( ).");
                }
                for (int j = 0; j < departmentSpecialismTokens.length; j += 2) {
                    long specialismId = Long.parseLong(departmentSpecialismTokens[j + 1]);
                    if (specialismId == 0L) continue;
                    DepartmentSpecialism departmentSpecialism = new DepartmentSpecialism();
                    departmentSpecialism.setId(departmentSpecialismId);
                    departmentSpecialism.setDepartment(department);
                    departmentSpecialism.setPriority(Integer.parseInt(departmentSpecialismTokens[j]));
                    Specialism specialism = this.idToSpecialismMap.get(specialismId);
                    if (specialism == null) {
                        throw new IllegalArgumentException("Read line (" + line + ") has a non existing specialismId (" + specialismId + ").");
                    }
                    departmentSpecialism.setSpecialism(specialism);
                    departmentSpecialismList.add(departmentSpecialism);
                    ++departmentSpecialismId;
                }
            }
            Collections.sort(departmentList, Comparator.comparingLong(AbstractPersistable::getId));
            this.patientAdmissionSchedule.setDepartmentList(departmentList);
            this.patientAdmissionSchedule.setDepartmentSpecialismList(departmentSpecialismList);
        }

        private void readEquipmentList() throws IOException {
            this.readConstantLine("ROOMPROPERTIES:");
            ArrayList<Equipment> equipmentList = new ArrayList<Equipment>(this.equipmentListSize);
            this.indexToEquipmentMap = new HashMap<Integer, Equipment>(this.equipmentListSize);
            for (int i = 0; i < this.equipmentListSize; ++i) {
                String line = this.bufferedReader.readLine();
                String[] lineTokens = this.splitBySpace(line, 2);
                Equipment equipment = new Equipment();
                equipment.setId(Long.parseLong(lineTokens[0]));
                equipment.setName(lineTokens[1]);
                equipmentList.add(equipment);
                this.indexToEquipmentMap.put(i, equipment);
            }
            this.patientAdmissionSchedule.setEquipmentList(equipmentList);
        }

        private void readRoomListAndRoomSpecialismListAndRoomEquipmentList() throws IOException {
            this.readConstantLine("ROOMS:");
            ArrayList<Room> roomList = new ArrayList<Room>(this.roomListSize);
            this.idToRoomMap = new HashMap<Long, Room>(this.roomListSize);
            ArrayList<RoomSpecialism> roomSpecialismList = new ArrayList<RoomSpecialism>(this.roomListSize * 5);
            ArrayList<RoomEquipment> roomEquipmentList = new ArrayList<RoomEquipment>(this.roomListSize * 2);
            long roomSpecialismId = 0L;
            long roomEquipmentId = 0L;
            for (int i = 0; i < this.roomListSize; ++i) {
                String line = this.bufferedReader.readLine();
                String[] lineTokens = this.splitByPipelineAndTrim(line, 6);
                String[] roomTokens = this.splitBySpace(lineTokens[0], 2);
                Room room = new Room();
                room.setId(Long.parseLong(roomTokens[0]));
                room.setName(roomTokens[1]);
                room.setCapacity(Integer.parseInt(lineTokens[1]));
                Department department = this.idToDepartmentMap.get(Long.parseLong(lineTokens[2]));
                room.setDepartment(department);
                room.setGenderLimitation(GenderLimitation.valueOfCode(lineTokens[3]));
                room.setBedList(new ArrayList<Bed>());
                roomList.add(room);
                this.idToRoomMap.put(room.getId(), room);
                department.getRoomList().add(room);
                String[] roomSpecialismTokens = this.splitBySpace(lineTokens[4]);
                if (roomSpecialismTokens.length % 2 != 0) {
                    throw new IllegalArgumentException("Read line (" + line + ") is expected to contain even number of tokens (" + roomSpecialismTokens.length + ") after 4th pipeline (|) separated by a space ( ).");
                }
                ArrayList<RoomSpecialism> roomSpecialismListOfRoom = new ArrayList<RoomSpecialism>(roomSpecialismTokens.length / 2);
                for (int j = 0; j < roomSpecialismTokens.length; j += 2) {
                    int priority = Integer.parseInt(roomSpecialismTokens[j]);
                    long specialismId = Long.parseLong(roomSpecialismTokens[j + 1]);
                    if (specialismId == 0L) continue;
                    RoomSpecialism roomSpecialism = new RoomSpecialism();
                    roomSpecialism.setId(roomSpecialismId);
                    roomSpecialism.setRoom(room);
                    Specialism specialism = this.idToSpecialismMap.get(specialismId);
                    if (specialism == null) {
                        throw new IllegalArgumentException("Read line (" + line + ") has a non existing specialismId (" + specialismId + ").");
                    }
                    roomSpecialism.setSpecialism(specialism);
                    roomSpecialism.setPriority(priority);
                    roomSpecialismListOfRoom.add(roomSpecialism);
                    roomSpecialismList.add(roomSpecialism);
                    ++roomSpecialismId;
                }
                room.setRoomSpecialismList(roomSpecialismListOfRoom);
                ArrayList<RoomEquipment> roomEquipmentListOfRoom = new ArrayList<RoomEquipment>(this.equipmentListSize);
                String[] roomEquipmentTokens = this.splitBySpace(lineTokens[5]);
                if (roomEquipmentTokens.length != this.equipmentListSize) {
                    throw new IllegalArgumentException("Read line (" + line + ") is expected to contain equal number of tokens (" + roomEquipmentTokens.length + ") as equipmentListSize (" + this.equipmentListSize + ") after 5th pipeline (|).");
                }
                for (int j = 0; j < roomEquipmentTokens.length; ++j) {
                    int hasEquipment = Integer.parseInt(roomEquipmentTokens[j]);
                    if (hasEquipment == 1) {
                        RoomEquipment roomEquipment = new RoomEquipment();
                        roomEquipment.setId(roomEquipmentId);
                        roomEquipment.setRoom(room);
                        roomEquipment.setEquipment(this.indexToEquipmentMap.get(j));
                        roomEquipmentListOfRoom.add(roomEquipment);
                        roomEquipmentList.add(roomEquipment);
                        ++roomEquipmentId;
                        continue;
                    }
                    if (hasEquipment == 0) continue;
                    throw new IllegalArgumentException("Read line (" + line + ") is expected to have 0 or 1 hasEquipment (" + hasEquipment + ").");
                }
                room.setRoomEquipmentList(roomEquipmentListOfRoom);
            }
            Collections.sort(roomList, ROOM_COMPARATOR);
            this.patientAdmissionSchedule.setRoomList(roomList);
            this.patientAdmissionSchedule.setRoomSpecialismList(roomSpecialismList);
            this.patientAdmissionSchedule.setRoomEquipmentList(roomEquipmentList);
        }

        private void readBedList() throws IOException {
            this.readConstantLine("BEDS:");
            ArrayList<Bed> bedList = new ArrayList<Bed>(this.bedListSize);
            HashMap<Room, Integer> roomToLastIndexInRoomMap = new HashMap<Room, Integer>(this.roomListSize);
            for (int i = 0; i < this.bedListSize; ++i) {
                String line = this.bufferedReader.readLine();
                String[] lineTokens = this.splitBySpace(line, 2);
                Bed bed = new Bed();
                bed.setId(Long.parseLong(lineTokens[0]));
                Room room = this.idToRoomMap.get(Long.parseLong(lineTokens[1]));
                bed.setRoom(room);
                Integer indexInRoom = (Integer)roomToLastIndexInRoomMap.get(room);
                if (indexInRoom == null) {
                    indexInRoom = 0;
                } else {
                    Integer n = indexInRoom;
                    Integer n2 = indexInRoom = Integer.valueOf(indexInRoom + 1);
                }
                bed.setIndexInRoom(indexInRoom);
                roomToLastIndexInRoomMap.put(room, indexInRoom);
                bedList.add(bed);
                room.getBedList().add(bed);
            }
            Collections.sort(bedList, BED_COMPARATOR);
            this.patientAdmissionSchedule.setBedList(bedList);
        }

        private void generateNightList() {
            ArrayList<Night> nightList = new ArrayList<Night>(this.nightListSize);
            this.indexToNightMap = new HashMap<Integer, Night>(this.nightListSize);
            long nightId = 0L;
            for (int i = 0; i < this.nightListSize; ++i) {
                Night night = new Night();
                night.setId(nightId);
                night.setIndex(i);
                nightList.add(night);
                this.indexToNightMap.put(i, night);
                ++nightId;
            }
            this.patientAdmissionSchedule.setNightList(nightList);
        }

        private void readPatientListAndAdmissionPartListAndRequiredPatientEquipmentListAndPreferredPatientEquipmentList() throws IOException {
            this.readConstantLine("PATIENTS:");
            ArrayList<Patient> patientList = new ArrayList<Patient>(this.patientListSize);
            ArrayList<AdmissionPart> admissionPartList = new ArrayList<AdmissionPart>(this.patientListSize);
            ArrayList<RequiredPatientEquipment> requiredPatientEquipmentList = new ArrayList<RequiredPatientEquipment>(this.patientListSize * this.equipmentListSize);
            ArrayList<PreferredPatientEquipment> preferredPatientEquipmentList = new ArrayList<PreferredPatientEquipment>(this.patientListSize * this.equipmentListSize);
            long admissionPartId = 0L;
            long requiredPatientEquipmentId = 0L;
            long preferredPatientEquipmentId = 0L;
            for (int i = 0; i < this.patientListSize; ++i) {
                String line = this.bufferedReader.readLine();
                String[] lineTokens = this.splitByPipelineAndTrim(line, 6);
                String[] nightTokens = this.splitBySpace(lineTokens[1], 2);
                int firstNightIndex = Integer.parseInt(nightTokens[0]);
                int lastNightIndex = Integer.parseInt(nightTokens[1]);
                int patientNightListSize = lastNightIndex - firstNightIndex;
                if (firstNightIndex >= this.nightListSize || patientNightListSize == 0) continue;
                String[] patientTokens = this.splitBySpace(lineTokens[0], 4);
                Patient patient = new Patient();
                patient.setId(Long.parseLong(patientTokens[0]));
                patient.setName(patientTokens[1]);
                patient.setAge(Integer.parseInt(patientTokens[2]));
                patient.setGender(Gender.valueOfCode(patientTokens[3]));
                int preferredMaximumRoomCapacity = Integer.parseInt(lineTokens[3]);
                patient.setPreferredMaximumRoomCapacity(preferredMaximumRoomCapacity == 0 ? null : Integer.valueOf(preferredMaximumRoomCapacity));
                patientList.add(patient);
                String[] admissionPartTokens = this.splitBySpace(lineTokens[2]);
                int patientAdmissionPartListSize = Integer.parseInt(admissionPartTokens[0]);
                if (admissionPartTokens.length != patientAdmissionPartListSize * 2 + 1) {
                    throw new IllegalArgumentException("Read line (" + line + ") is expected to contain " + (patientAdmissionPartListSize * 2 + 1) + " number of tokens after 2th pipeline (|).");
                }
                int nextFirstNightIndex = firstNightIndex;
                for (int j = 1; j < admissionPartTokens.length; j += 2) {
                    Night admissionPartLastNight;
                    Specialism specialism;
                    long specialismId = Long.parseLong(admissionPartTokens[j]);
                    int admissionPartNightListSize = Integer.parseInt(admissionPartTokens[j + 1]);
                    if (nextFirstNightIndex >= this.nightListSize || admissionPartNightListSize == 0) {
                        nextFirstNightIndex += admissionPartNightListSize;
                        continue;
                    }
                    AdmissionPart admissionPart = new AdmissionPart();
                    admissionPart.setId(admissionPartId);
                    admissionPart.setPatient(patient);
                    Specialism specialism2 = specialism = specialismId == 0L ? null : this.idToSpecialismMap.get(specialismId);
                    if (specialism == null) {
                        throw new IllegalArgumentException("Read line (" + line + ") has a non existing specialismId (" + specialismId + ").");
                    }
                    admissionPart.setSpecialism(specialism);
                    int admissionPartFirstNightIndex = nextFirstNightIndex;
                    Night admissionPartFirstNight = this.indexToNightMap.get(admissionPartFirstNightIndex);
                    if (admissionPartFirstNight == null) {
                        throw new IllegalStateException("The admissionPartFirstNight was not found for admissionPartFirstNightIndex(" + admissionPartFirstNightIndex + ").");
                    }
                    admissionPart.setFirstNight(admissionPartFirstNight);
                    int admissionPartLastNightIndex = nextFirstNightIndex + admissionPartNightListSize - 1;
                    if (admissionPartLastNightIndex >= this.nightListSize) {
                        admissionPartLastNightIndex = this.nightListSize - 1;
                    }
                    if ((admissionPartLastNight = this.indexToNightMap.get(admissionPartLastNightIndex)) == null) {
                        throw new IllegalStateException("The admissionPartLastNight was not found for admissionPartLastNightIndex(" + admissionPartLastNightIndex + ").");
                    }
                    admissionPart.setLastNight(admissionPartLastNight);
                    admissionPartList.add(admissionPart);
                    ++admissionPartId;
                    nextFirstNightIndex += admissionPartNightListSize;
                }
                int admissionPartNightListSizeSum = nextFirstNightIndex - firstNightIndex;
                if (patientNightListSize != admissionPartNightListSizeSum) {
                    throw new IllegalArgumentException("Read line (" + line + ") has patientNightListSize (" + patientNightListSize + ") different from admissionPartNightListSizeSum(" + admissionPartNightListSizeSum + ")");
                }
                String[] requiredPatientEquipmentTokens = this.splitBySpace(lineTokens[4]);
                if (requiredPatientEquipmentTokens.length != this.equipmentListSize) {
                    throw new IllegalArgumentException("Read line (" + line + ") is expected to contain equal number of tokens (" + requiredPatientEquipmentTokens.length + ") as equipmentListSize (" + this.equipmentListSize + ") after 4th pipeline (|).");
                }
                ArrayList<RequiredPatientEquipment> requiredPatientEquipmentOfPatientList = new ArrayList<RequiredPatientEquipment>(this.equipmentListSize);
                for (int j = 0; j < requiredPatientEquipmentTokens.length; ++j) {
                    int hasEquipment = Integer.parseInt(requiredPatientEquipmentTokens[j]);
                    if (hasEquipment == 1) {
                        RequiredPatientEquipment requiredPatientEquipment = new RequiredPatientEquipment();
                        requiredPatientEquipment.setId(requiredPatientEquipmentId);
                        requiredPatientEquipment.setPatient(patient);
                        requiredPatientEquipment.setEquipment(this.indexToEquipmentMap.get(j));
                        requiredPatientEquipmentOfPatientList.add(requiredPatientEquipment);
                        requiredPatientEquipmentList.add(requiredPatientEquipment);
                        ++requiredPatientEquipmentId;
                        continue;
                    }
                    if (hasEquipment == 0) continue;
                    throw new IllegalArgumentException("Read line (" + line + ") is expected to have 0 or 1 hasEquipment (" + hasEquipment + ").");
                }
                patient.setRequiredPatientEquipmentList(requiredPatientEquipmentOfPatientList);
                String[] preferredPatientEquipmentTokens = this.splitBySpace(lineTokens[5]);
                if (preferredPatientEquipmentTokens.length != this.equipmentListSize) {
                    throw new IllegalArgumentException("Read line (" + line + ") is expected to contain equal number of tokens (" + preferredPatientEquipmentTokens.length + ") as equipmentListSize (" + this.equipmentListSize + ") after 5th pipeline (|).");
                }
                ArrayList<PreferredPatientEquipment> preferredPatientEquipmentOfPatientList = new ArrayList<PreferredPatientEquipment>(this.equipmentListSize);
                for (int j = 0; j < preferredPatientEquipmentTokens.length; ++j) {
                    int hasEquipment = Integer.parseInt(preferredPatientEquipmentTokens[j]);
                    if (hasEquipment == 1) {
                        boolean alreadyRequired;
                        boolean bl = alreadyRequired = Integer.parseInt(requiredPatientEquipmentTokens[j]) == 1;
                        if (alreadyRequired) continue;
                        PreferredPatientEquipment preferredPatientEquipment = new PreferredPatientEquipment();
                        preferredPatientEquipment.setId(preferredPatientEquipmentId);
                        preferredPatientEquipment.setPatient(patient);
                        preferredPatientEquipment.setEquipment(this.indexToEquipmentMap.get(j));
                        preferredPatientEquipmentOfPatientList.add(preferredPatientEquipment);
                        preferredPatientEquipmentList.add(preferredPatientEquipment);
                        ++preferredPatientEquipmentId;
                        continue;
                    }
                    if (hasEquipment == 0) continue;
                    throw new IllegalArgumentException("Read line (" + line + ") is expected to have 0 or 1 hasEquipment (" + hasEquipment + ").");
                }
                patient.setPreferredPatientEquipmentList(preferredPatientEquipmentOfPatientList);
            }
            this.patientAdmissionSchedule.setPatientList(patientList);
            this.patientAdmissionSchedule.setAdmissionPartList(admissionPartList);
            this.patientAdmissionSchedule.setRequiredPatientEquipmentList(requiredPatientEquipmentList);
            this.patientAdmissionSchedule.setPreferredPatientEquipmentList(preferredPatientEquipmentList);
        }

        private void createBedDesignationList() {
            List<AdmissionPart> admissionPartList = this.patientAdmissionSchedule.getAdmissionPartList();
            ArrayList<BedDesignation> bedDesignationList = new ArrayList<BedDesignation>(admissionPartList.size());
            long id = 0L;
            for (AdmissionPart admissionPart : admissionPartList) {
                BedDesignation bedDesignation = new BedDesignation();
                bedDesignation.setId(id);
                ++id;
                bedDesignation.setAdmissionPart(admissionPart);
                bedDesignationList.add(bedDesignation);
            }
            this.patientAdmissionSchedule.setBedDesignationList(bedDesignationList);
        }
    }
}

