/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.experimental.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Random;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.Test;
import org.optaplanner.examples.common.experimental.api.IntervalBreak;
import org.optaplanner.examples.common.experimental.api.IntervalCluster;
import org.optaplanner.examples.common.experimental.impl.IntervalBreakImpl;
import org.optaplanner.examples.common.experimental.impl.IntervalClusterImpl;
import org.optaplanner.examples.common.experimental.impl.IntervalSplitPoint;
import org.optaplanner.examples.common.experimental.impl.IntervalTree;
import org.optaplanner.examples.common.experimental.impl.IterableList;

public class IntervalTreeTest {
    private IntervalTree<Interval, Integer, Integer> getIntegerIntervalTree() {
        return new IntervalTree(Interval::getStart, Interval::getEnd, (a, b) -> b - a);
    }

    @Test
    public void testNonConsecutiveIntervals() {
        IntervalTree<Interval, Integer, Integer> tree = this.getIntegerIntervalTree();
        tree.add((Object)new Interval(0, 2));
        tree.add((Object)new Interval(3, 4));
        tree.add((Object)new Interval(5, 7));
        IterableList clusterList = new IterableList(tree.getConsecutiveIntervalData().getIntervalClusters());
        Assertions.assertThat(clusterList).hasSize(3);
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(0))).containsExactly((Object[])new Interval[]{new Interval(0, 2)});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(0)).hasOverlap()).isFalse();
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(1))).containsExactly((Object[])new Interval[]{new Interval(3, 4)});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(1)).hasOverlap()).isFalse();
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(2))).containsExactly((Object[])new Interval[]{new Interval(5, 7)});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(2)).hasOverlap()).isFalse();
        this.verifyBreaks(tree);
    }

    @Test
    public void testConsecutiveIntervals() {
        IntervalTree<Interval, Integer, Integer> tree = this.getIntegerIntervalTree();
        tree.add((Object)new Interval(0, 2));
        tree.add((Object)new Interval(2, 4));
        tree.add((Object)new Interval(4, 7));
        IterableList clusterList = new IterableList(tree.getConsecutiveIntervalData().getIntervalClusters());
        Assertions.assertThat(clusterList).hasSize(1);
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(0))).containsExactly((Object[])new Interval[]{new Interval(0, 2), new Interval(2, 4), new Interval(4, 7)});
        this.verifyBreaks(tree);
    }

    @Test
    public void testDuplicateIntervals() {
        IntervalTree<Interval, Integer, Integer> tree = this.getIntegerIntervalTree();
        Interval a = new Interval(0, 2);
        Interval b = new Interval(4, 7);
        tree.add((Object)a);
        tree.add((Object)a);
        tree.add((Object)b);
        IterableList clusterList = new IterableList(tree.getConsecutiveIntervalData().getIntervalClusters());
        Assertions.assertThat(clusterList).hasSize(2);
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(0))).containsExactly((Object[])new Interval[]{a, a});
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(1))).containsExactly((Object[])new Interval[]{b});
        this.verifyBreaks(tree);
    }

    @Test
    public void testIntervalRemoval() {
        IntervalTree<Interval, Integer, Integer> tree = this.getIntegerIntervalTree();
        Interval a = new Interval(0, 2);
        Interval b = new Interval(2, 4);
        Interval c = new Interval(4, 7);
        tree.add((Object)a);
        tree.add((Object)b);
        tree.add((Object)c);
        tree.remove((Object)b);
        IterableList clusterList = new IterableList(tree.getConsecutiveIntervalData().getIntervalClusters());
        Assertions.assertThat(clusterList).hasSize(2);
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(0))).containsExactly((Object[])new Interval[]{new Interval(0, 2)});
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(1))).containsExactly((Object[])new Interval[]{new Interval(4, 7)});
        this.verifyBreaks(tree);
    }

    @Test
    public void testIntervalAddUpdatingOldBreak() {
        IntervalTree<Interval, Integer, Integer> tree = this.getIntegerIntervalTree();
        Interval beforeAll = new Interval(1, 2);
        Interval newStart = new Interval(3, 8);
        Interval oldStart = new Interval(4, 5);
        Interval betweenOldAndNewStart = new Interval(6, 7);
        Interval afterAll = new Interval(9, 10);
        tree.add((Object)beforeAll);
        this.verifyBreaks(tree);
        tree.add((Object)afterAll);
        this.verifyBreaks(tree);
        tree.add((Object)oldStart);
        this.verifyBreaks(tree);
        tree.add((Object)betweenOldAndNewStart);
        this.verifyBreaks(tree);
        tree.add((Object)newStart);
        this.verifyBreaks(tree);
    }

    @Test
    public void testOverlappingInterval() {
        IntervalTree<Interval, Integer, Integer> tree = this.getIntegerIntervalTree();
        Interval a = new Interval(0, 2);
        Interval b = new Interval(1, 3);
        Interval c = new Interval(2, 4);
        Interval d = new Interval(5, 6);
        Interval e = new Interval(7, 9);
        Interval f = new Interval(7, 9);
        tree.add((Object)a);
        tree.add((Object)b);
        tree.add((Object)c);
        tree.add((Object)d);
        tree.add((Object)e);
        tree.add((Object)f);
        IterableList clusterList = new IterableList(tree.getConsecutiveIntervalData().getIntervalClusters());
        Assertions.assertThat(clusterList).hasSize(3);
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(0))).containsExactly((Object[])new Interval[]{a, b, c});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(0)).hasOverlap()).isTrue();
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(1))).containsExactly((Object[])new Interval[]{d});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(1)).hasOverlap()).isFalse();
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(2))).containsExactly((Object[])new Interval[]{e, f});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(2)).hasOverlap()).isTrue();
        this.verifyBreaks(tree);
        tree.remove((Object)b);
        clusterList = new IterableList(tree.getConsecutiveIntervalData().getIntervalClusters());
        Assertions.assertThat(clusterList).hasSize(3);
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(0))).containsExactly((Object[])new Interval[]{a, c});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(0)).hasOverlap()).isFalse();
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(1))).containsExactly((Object[])new Interval[]{d});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(1)).hasOverlap()).isFalse();
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(2))).containsExactly((Object[])new Interval[]{e, f});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(2)).hasOverlap()).isTrue();
        this.verifyBreaks(tree);
        tree.remove((Object)f);
        clusterList = new IterableList(tree.getConsecutiveIntervalData().getIntervalClusters());
        Assertions.assertThat(clusterList).hasSize(3);
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(0))).containsExactly((Object[])new Interval[]{a, c});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(0)).hasOverlap()).isFalse();
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(1))).containsExactly((Object[])new Interval[]{d});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(1)).hasOverlap()).isFalse();
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(2))).containsExactly((Object[])new Interval[]{e});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(2)).hasOverlap()).isFalse();
        this.verifyBreaks(tree);
        Interval g = new Interval(6, 7);
        tree.add((Object)g);
        clusterList = new IterableList(tree.getConsecutiveIntervalData().getIntervalClusters());
        Assertions.assertThat(clusterList).hasSize(2);
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(0))).containsExactly((Object[])new Interval[]{a, c});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(0)).hasOverlap()).isFalse();
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(1))).containsExactly((Object[])new Interval[]{d, g, e});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(1)).hasOverlap()).isFalse();
    }

    public void verifyBreaks(IntervalTree<Interval, Integer, Integer> tree) {
        IterableList clusterList = new IterableList(tree.getConsecutiveIntervalData().getIntervalClusters());
        IterableList breakList = new IterableList(tree.getConsecutiveIntervalData().getBreaks());
        if (clusterList.size() == 0) {
            return;
        }
        Assertions.assertThat(breakList).hasSize(clusterList.size() - 1);
        for (int i = 0; i < clusterList.size() - 1; ++i) {
            Assertions.assertThat((Iterable)((IntervalBreak)breakList.get(i)).getPreviousIntervalCluster()).isSameAs(clusterList.get(i));
            Assertions.assertThat((Iterable)((IntervalBreak)breakList.get(i)).getNextIntervalCluster()).isSameAs(clusterList.get(i + 1));
            Assertions.assertThat((Integer)((Integer)((IntervalBreak)breakList.get(i)).getPreviousIntervalClusterEnd())).isEqualTo((Object)((IntervalCluster)clusterList.get(i)).getEnd());
            Assertions.assertThat((Integer)((Integer)((IntervalBreak)breakList.get(i)).getNextIntervalClusterStart())).isEqualTo((Object)((IntervalCluster)clusterList.get(i + 1)).getStart());
            Assertions.assertThat((Integer)((Integer)((IntervalBreak)breakList.get(i)).getLength())).isEqualTo((Integer)((IntervalCluster)clusterList.get(i + 1)).getStart() - (Integer)((IntervalCluster)clusterList.get(i)).getEnd());
        }
    }

    @Test
    public void testRandomIntervals() {
        Random random = new Random(1L);
        for (int i = 0; i < 100; ++i) {
            HashMap intervalToInstanceMap = new HashMap();
            TreeSet<IntervalSplitPoint> splitPoints = new TreeSet<IntervalSplitPoint>();
            IntervalTree tree = new IntervalTree(Interval::getStart, Interval::getEnd, (a, b) -> b - a);
            for (int j = 0; j < 100; ++j) {
                String op;
                String old = this.formatIntervalTree((IntervalTree<Interval, Integer, Integer>)tree);
                int from = random.nextInt(5);
                int to = from + random.nextInt(5);
                Interval interval = (Interval)intervalToInstanceMap.computeIfAbsent(new Interval(from, to), Function.identity());
                org.optaplanner.examples.common.experimental.impl.Interval treeInterval = new org.optaplanner.examples.common.experimental.impl.Interval((Object)interval, Interval::getStart, Interval::getEnd);
                splitPoints.add(treeInterval.getStartSplitPoint());
                splitPoints.add(treeInterval.getEndSplitPoint());
                IntervalSplitPoint startSplitPoint = splitPoints.floor(treeInterval.getStartSplitPoint());
                IntervalSplitPoint endSplitPoint = splitPoints.floor(treeInterval.getEndSplitPoint());
                if (startSplitPoint.startIntervalToCountMap == null) {
                    startSplitPoint.createCollections();
                }
                if (endSplitPoint.endIntervalToCountMap == null) {
                    endSplitPoint.createCollections();
                }
                if (startSplitPoint.containsIntervalStarting(treeInterval) && random.nextBoolean()) {
                    op = "Remove";
                    startSplitPoint.removeIntervalStartingAtSplitPoint(treeInterval);
                    endSplitPoint.removeIntervalEndingAtSplitPoint(treeInterval);
                    if (startSplitPoint.isEmpty()) {
                        splitPoints.remove(startSplitPoint);
                    }
                    if (endSplitPoint.isEmpty()) {
                        splitPoints.remove(endSplitPoint);
                    }
                    tree.remove((Object)interval);
                } else {
                    op = "Add";
                    startSplitPoint.addIntervalStartingAtSplitPoint(treeInterval);
                    endSplitPoint.addIntervalEndingAtSplitPoint(treeInterval);
                    tree.add((Object)interval);
                }
                IntervalSplitPoint previous = null;
                IntervalSplitPoint current = splitPoints.isEmpty() ? null : (IntervalSplitPoint)splitPoints.first();
                ArrayList<IntervalClusterImpl> intervalClusterList = new ArrayList<IntervalClusterImpl>();
                ArrayList<IntervalBreakImpl> breakList = new ArrayList<IntervalBreakImpl>();
                while (current != null) {
                    intervalClusterList.add(new IntervalClusterImpl(splitPoints, (a, b) -> a - b, current));
                    if (previous != null) {
                        IntervalClusterImpl before = (IntervalClusterImpl)intervalClusterList.get(intervalClusterList.size() - 2);
                        IntervalClusterImpl after = (IntervalClusterImpl)intervalClusterList.get(intervalClusterList.size() - 1);
                        breakList.add(new IntervalBreakImpl((IntervalCluster)before, (IntervalCluster)after, (Comparable)Integer.valueOf((Integer)after.getStart() - (Integer)before.getEnd())));
                    }
                    previous = current;
                    current = splitPoints.higher(((IntervalClusterImpl)intervalClusterList.get(intervalClusterList.size() - 1)).getEndSplitPoint());
                }
                this.verifyBreaks((IntervalTree<Interval, Integer, Integer>)tree);
                ((IterableAssert)Assertions.assertThat((Iterable)tree.getConsecutiveIntervalData().getIntervalClusters()).as(op + " interval " + interval + " to " + old, new Object[0])).containsExactlyElementsOf(intervalClusterList);
                ((IterableAssert)Assertions.assertThat((Iterable)tree.getConsecutiveIntervalData().getBreaks()).as(op + " interval " + interval + " to " + old, new Object[0])).containsExactlyElementsOf(breakList);
            }
        }
    }

    private String formatIntervalTree(IntervalTree<Interval, Integer, Integer> intervalTree) {
        ArrayList listOfIntervalClusters = new ArrayList();
        for (IntervalCluster cluster2 : intervalTree.getConsecutiveIntervalData().getIntervalClusters()) {
            ArrayList<Interval> intervalsInCluster = new ArrayList<Interval>();
            for (Interval interval : cluster2) {
                intervalsInCluster.add(interval);
            }
            listOfIntervalClusters.add(intervalsInCluster);
        }
        return listOfIntervalClusters.stream().map(cluster -> cluster.stream().map(Interval::toString).collect(Collectors.joining(",", "[", "]"))).collect(Collectors.joining(";", "{", "}"));
    }

    private static class Interval {
        final int start;
        final int end;

        public Interval(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Interval interval = (Interval)o;
            return this.start == interval.start && this.end == interval.end;
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end);
        }

        public String toString() {
            return "(" + this.start + ", " + this.end + ")";
        }
    }
}

