/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.experimental.impl;

import java.util.Iterator;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.optaplanner.examples.common.experimental.impl.ConsecutiveIntervalInfoImpl;
import org.optaplanner.examples.common.experimental.impl.Interval;
import org.optaplanner.examples.common.experimental.impl.IntervalSplitPoint;
import org.optaplanner.examples.common.experimental.impl.IntervalTreeIterator;

public final class IntervalTree<Interval_, Point_ extends Comparable<Point_>, Difference_ extends Comparable<Difference_>> {
    private final Function<Interval_, Point_> startMapping;
    private final Function<Interval_, Point_> endMapping;
    private final TreeSet<IntervalSplitPoint<Interval_, Point_>> splitPointSet;
    private final ConsecutiveIntervalInfoImpl<Interval_, Point_, Difference_> consecutiveIntervalData;

    public IntervalTree(Function<Interval_, Point_> startMapping, Function<Interval_, Point_> endMapping, BiFunction<Point_, Point_, Difference_> differenceFunction) {
        this.startMapping = startMapping;
        this.endMapping = endMapping;
        this.splitPointSet = new TreeSet();
        this.consecutiveIntervalData = new ConsecutiveIntervalInfoImpl<Interval_, Point_, Difference_>(this.splitPointSet, differenceFunction);
    }

    public Interval<Interval_, Point_> getInterval(Interval_ intervalValue) {
        return new Interval<Interval_, Point_>(intervalValue, this.startMapping, this.endMapping);
    }

    public boolean isEmpty() {
        return this.splitPointSet.isEmpty();
    }

    public boolean contains(Interval_ o) {
        if (null == o || this.splitPointSet.isEmpty()) {
            return false;
        }
        Interval<Interval_, Point_> interval = this.getInterval(o);
        IntervalSplitPoint<Interval_, Point_> floorStartSplitPoint = this.splitPointSet.floor(interval.getStartSplitPoint());
        if (floorStartSplitPoint == null) {
            return false;
        }
        return floorStartSplitPoint.containsIntervalStarting(interval);
    }

    public Iterator<Interval_> iterator() {
        return new IntervalTreeIterator<Interval_, Point_>(this.splitPointSet);
    }

    public boolean add(Interval_ interval) {
        if (interval == null) {
            return false;
        }
        return this.add(this.getInterval(interval));
    }

    public boolean add(Interval<Interval_, Point_> interval) {
        boolean isChanged;
        IntervalSplitPoint<Interval_, Point_> startSplitPoint = interval.getStartSplitPoint();
        IntervalSplitPoint<Interval_, Point_> endSplitPoint = interval.getEndSplitPoint();
        IntervalSplitPoint<Interval_, Point_> flooredStartSplitPoint = this.splitPointSet.floor(startSplitPoint);
        if (flooredStartSplitPoint == null || !flooredStartSplitPoint.equals(startSplitPoint)) {
            this.splitPointSet.add(startSplitPoint);
            startSplitPoint.createCollections();
            isChanged = startSplitPoint.addIntervalStartingAtSplitPoint(interval);
        } else {
            isChanged = flooredStartSplitPoint.addIntervalStartingAtSplitPoint(interval);
        }
        IntervalSplitPoint<Interval_, Point_> ceilingEndSplitPoint = this.splitPointSet.ceiling(endSplitPoint);
        if (ceilingEndSplitPoint == null || !ceilingEndSplitPoint.equals(endSplitPoint)) {
            this.splitPointSet.add(endSplitPoint);
            endSplitPoint.createCollections();
            isChanged |= endSplitPoint.addIntervalEndingAtSplitPoint(interval);
        } else {
            isChanged |= ceilingEndSplitPoint.addIntervalEndingAtSplitPoint(interval);
        }
        if (isChanged) {
            this.consecutiveIntervalData.addInterval(interval);
        }
        return true;
    }

    public boolean remove(Interval_ interval) {
        if (interval == null) {
            return false;
        }
        return this.remove(this.getInterval(interval));
    }

    public boolean remove(Interval<Interval_, Point_> interval) {
        IntervalSplitPoint<Interval_, Point_> startSplitPoint = interval.getStartSplitPoint();
        IntervalSplitPoint<Interval_, Point_> endSplitPoint = interval.getEndSplitPoint();
        IntervalSplitPoint<Interval_, Point_> flooredStartSplitPoint = this.splitPointSet.floor(startSplitPoint);
        if (flooredStartSplitPoint == null || !flooredStartSplitPoint.containsIntervalStarting(interval)) {
            return false;
        }
        flooredStartSplitPoint.removeIntervalStartingAtSplitPoint(interval);
        if (flooredStartSplitPoint.isEmpty()) {
            this.splitPointSet.remove(flooredStartSplitPoint);
        }
        IntervalSplitPoint<Interval_, Point_> ceilEndSplitPoint = this.splitPointSet.ceiling(endSplitPoint);
        ceilEndSplitPoint.removeIntervalEndingAtSplitPoint(interval);
        if (ceilEndSplitPoint.isEmpty()) {
            this.splitPointSet.remove(ceilEndSplitPoint);
        }
        this.consecutiveIntervalData.removeInterval(interval);
        return true;
    }

    public ConsecutiveIntervalInfoImpl<Interval_, Point_, Difference_> getConsecutiveIntervalData() {
        return this.consecutiveIntervalData;
    }
}

