/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.domain.location.segmented;

import java.util.LinkedHashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.location.segmented.HubSegmentLocation;
import org.optaplanner.examples.vehiclerouting.domain.location.segmented.RoadSegmentLocation;

class RoadSegmentLocationTest {
    RoadSegmentLocationTest() {
    }

    @Test
    void getDistance() {
        long id = 0L;
        RoadSegmentLocation a = new RoadSegmentLocation(id++, 0.0, 0.0);
        RoadSegmentLocation b = new RoadSegmentLocation(id++, 0.0, 4.0);
        RoadSegmentLocation c = new RoadSegmentLocation(id++, 2.0, 0.0);
        RoadSegmentLocation d = new RoadSegmentLocation(id++, 100.0, 2.0);
        HubSegmentLocation x = new HubSegmentLocation(id++, 1.0, 0.0);
        HubSegmentLocation y = new HubSegmentLocation(id++, 1.0, 3.0);
        HubSegmentLocation z = new HubSegmentLocation(id++, 99.0, 3.0);
        a.setNearbyTravelDistanceMap(this.createNearbyTravelDistanceMap((Location)a, b, c));
        a.setHubTravelDistanceMap(this.createHubTravelDistanceMap((Location)a, x, y));
        b.setNearbyTravelDistanceMap(this.createNearbyTravelDistanceMap((Location)b, a));
        b.setHubTravelDistanceMap(this.createHubTravelDistanceMap((Location)b, x, y));
        c.setNearbyTravelDistanceMap(this.createNearbyTravelDistanceMap((Location)c, a));
        c.setHubTravelDistanceMap(this.createHubTravelDistanceMap((Location)c, x, y));
        d.setNearbyTravelDistanceMap(this.createNearbyTravelDistanceMap((Location)d, new RoadSegmentLocation[0]));
        d.setHubTravelDistanceMap(this.createHubTravelDistanceMap((Location)d, z));
        x.setNearbyTravelDistanceMap(this.createNearbyTravelDistanceMap((Location)x, a, b, c));
        x.setHubTravelDistanceMap(this.createHubTravelDistanceMap((Location)x, y, z));
        y.setNearbyTravelDistanceMap(this.createNearbyTravelDistanceMap((Location)y, a, b, c));
        y.setHubTravelDistanceMap(this.createHubTravelDistanceMap((Location)y, x, z));
        z.setNearbyTravelDistanceMap(this.createNearbyTravelDistanceMap((Location)z, d));
        z.setHubTravelDistanceMap(this.createHubTravelDistanceMap((Location)z, x, y));
        Assertions.assertThat((long)a.getDistanceTo((Location)b)).isEqualTo((long)this.sumOfArcs((Location)a, new Location[]{b}));
        Assertions.assertThat((long)a.getDistanceTo((Location)c)).isEqualTo((long)this.sumOfArcs((Location)a, new Location[]{c}));
        Assertions.assertThat((long)a.getDistanceTo((Location)d)).isEqualTo((long)this.sumOfArcs((Location)a, new Location[]{x, z, d}));
        Assertions.assertThat((long)b.getDistanceTo((Location)a)).isEqualTo((long)this.sumOfArcs((Location)b, new Location[]{a}));
        Assertions.assertThat((long)b.getDistanceTo((Location)c)).isEqualTo((long)this.sumOfArcs((Location)b, new Location[]{y, c}));
        Assertions.assertThat((long)b.getDistanceTo((Location)d)).isEqualTo((long)this.sumOfArcs((Location)b, new Location[]{y, z, d}));
        Assertions.assertThat((long)c.getDistanceTo((Location)a)).isEqualTo((long)this.sumOfArcs((Location)c, new Location[]{a}));
        Assertions.assertThat((long)c.getDistanceTo((Location)b)).isEqualTo((long)this.sumOfArcs((Location)c, new Location[]{y, b}));
        Assertions.assertThat((long)c.getDistanceTo((Location)d)).isEqualTo((long)this.sumOfArcs((Location)c, new Location[]{x, z, d}));
        Assertions.assertThat((long)d.getDistanceTo((Location)a)).isEqualTo((long)this.sumOfArcs((Location)d, new Location[]{z, x, a}));
        Assertions.assertThat((long)d.getDistanceTo((Location)b)).isEqualTo((long)this.sumOfArcs((Location)d, new Location[]{z, y, b}));
        Assertions.assertThat((long)d.getDistanceTo((Location)c)).isEqualTo((long)this.sumOfArcs((Location)d, new Location[]{z, x, c}));
    }

    protected int sumOfArcs(Location fromLocation, Location ... stopLocations) {
        Location previousLocation = fromLocation;
        int distance = 0;
        for (Location stopLocation : stopLocations) {
            distance += (int)(previousLocation.getAirDistanceDoubleTo(stopLocation) * 1000.0 + 0.5);
            previousLocation = stopLocation;
        }
        return distance;
    }

    private Map<HubSegmentLocation, Double> createHubTravelDistanceMap(Location fromLocation, HubSegmentLocation ... toLocations) {
        LinkedHashMap<HubSegmentLocation, Double> map = new LinkedHashMap<HubSegmentLocation, Double>(toLocations.length);
        for (HubSegmentLocation toLocation : toLocations) {
            map.put(toLocation, fromLocation.getAirDistanceDoubleTo((Location)toLocation));
        }
        return map;
    }

    protected Map<RoadSegmentLocation, Double> createNearbyTravelDistanceMap(Location fromLocation, RoadSegmentLocation ... toLocations) {
        LinkedHashMap<RoadSegmentLocation, Double> map = new LinkedHashMap<RoadSegmentLocation, Double>(toLocations.length);
        for (RoadSegmentLocation toLocation : toLocations) {
            map.put(toLocation, fromLocation.getAirDistanceDoubleTo((Location)toLocation));
        }
        return map;
    }
}

