/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.batchscheduling.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.valuerange.CountableValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRangeFactory;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.CustomShadowVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariableReference;
import org.optaplanner.examples.batchscheduling.app.BatchSchedulingApp;
import org.optaplanner.examples.batchscheduling.domain.Batch;
import org.optaplanner.examples.batchscheduling.domain.RoutePath;
import org.optaplanner.examples.batchscheduling.domain.Segment;
import org.optaplanner.examples.batchscheduling.domain.solver.PredecessorsDoneDateUpdatingVariableListener;
import org.optaplanner.examples.common.domain.AbstractPersistable;

@PlanningEntity
@XStreamAlias(value="PipeAllocation")
public class Allocation
extends AbstractPersistable {
    private Batch batch;
    private RoutePath routePath;
    private Segment segment;
    private Allocation predecessorAllocation;
    private Allocation successorAllocation;
    private Long delay;
    private Long predecessorsDoneDate;

    public Batch getBatch() {
        return this.batch;
    }

    public void setBatch(Batch batch) {
        this.batch = batch;
    }

    public RoutePath getRoutePath() {
        return this.routePath;
    }

    public void setRoutePath(RoutePath routePath) {
        this.routePath = routePath;
    }

    public Segment getSegment() {
        return this.segment;
    }

    public void setSegment(Segment segment) {
        this.segment = segment;
    }

    public Allocation getPredecessorAllocation() {
        return this.predecessorAllocation;
    }

    public void setPredecessorAllocation(Allocation predecessorAllocation) {
        this.predecessorAllocation = predecessorAllocation;
    }

    public Allocation getSuccessorAllocation() {
        return this.successorAllocation;
    }

    public void setSuccessorAllocation(Allocation successorAllocation) {
        this.successorAllocation = successorAllocation;
    }

    public void setDelay(Long delay) {
        this.delay = delay;
    }

    public void setPredecessorsDoneDate(Long predecessorsDoneDate) {
        this.predecessorsDoneDate = predecessorsDoneDate;
    }

    public Long getStartInjectionTime() {
        if (this.delay == null) {
            return null;
        }
        if (this.predecessorAllocation != null && this.predecessorsDoneDate != null) {
            return this.delay + this.predecessorsDoneDate;
        }
        return this.delay;
    }

    public Long getEndInjectionTime() {
        if (this.getStartInjectionTime() == null) {
            return null;
        }
        Double tempInjectionDouble = this.getBatch().getVolume() / (double)(this.getSegment().getFlowRate() * (float)BatchSchedulingApp.PERIODINTERVAL_IN_MINUTES.intValue());
        Long tempInjectionLong = tempInjectionDouble.longValue();
        int fractionalInjectionInt = (int)Math.round((tempInjectionDouble - (double)tempInjectionLong.longValue()) * 100.0);
        if (fractionalInjectionInt >= BatchSchedulingApp.FRACTIONAL_VOLUME_PERCENTAGE) {
            return this.getStartInjectionTime() + tempInjectionLong + 1L;
        }
        return this.getStartInjectionTime() + tempInjectionLong;
    }

    public Long getStartDeliveryTime() {
        if (this.getStartInjectionTime() == null) {
            return null;
        }
        Double tempTravelDouble = this.getSegment().getLength() * this.getSegment().getCrossSectionArea() / (this.getSegment().getFlowRate() * (float)BatchSchedulingApp.PERIODINTERVAL_IN_MINUTES.intValue());
        Long tempTravelLong = tempTravelDouble.longValue();
        int fractionalTravelInt = (int)Math.round((tempTravelDouble - (double)tempTravelLong.longValue()) * 100.0);
        if (fractionalTravelInt >= BatchSchedulingApp.FRACTIONAL_VOLUME_PERCENTAGE) {
            return this.getStartInjectionTime() + tempTravelLong + 1L;
        }
        return this.getStartInjectionTime() + tempTravelLong;
    }

    public Long getEndDeliveryTime() {
        if (this.getStartInjectionTime() == null) {
            return null;
        }
        Double tempTravelDouble = this.getSegment().getLength() * this.getSegment().getCrossSectionArea() / (this.getSegment().getFlowRate() * (float)BatchSchedulingApp.PERIODINTERVAL_IN_MINUTES.intValue());
        Long tempTravelLong = tempTravelDouble.longValue();
        int fractionalTravelInt = (int)Math.round((tempTravelDouble - (double)tempTravelLong.longValue()) * 100.0);
        tempTravelLong = fractionalTravelInt >= BatchSchedulingApp.FRACTIONAL_VOLUME_PERCENTAGE ? Long.valueOf(this.getStartInjectionTime() + tempTravelLong + 1L) : Long.valueOf(this.getStartInjectionTime() + tempTravelLong);
        Double tempDeliveryDouble = this.getBatch().getVolume() / (double)(this.getSegment().getFlowRate() * (float)BatchSchedulingApp.PERIODINTERVAL_IN_MINUTES.intValue());
        Long tempDeliveryLong = tempDeliveryDouble.longValue();
        int fractionalDeliveryInt = (int)Math.round((tempDeliveryDouble - (double)tempDeliveryLong.longValue()) * 100.0);
        if (fractionalDeliveryInt >= BatchSchedulingApp.FRACTIONAL_VOLUME_PERCENTAGE) {
            return tempTravelLong + tempDeliveryLong + 1L;
        }
        return tempTravelLong + tempDeliveryLong;
    }

    public String getLabel() {
        return "Label:: " + this.batch.getName() + " " + this.routePath.getPath() + " " + this.segment.getName();
    }

    public Boolean isFirst() {
        if (this.predecessorAllocation != null) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @PlanningVariable(nullable=true, valueRangeProviderRefs={"delayRange"})
    public Long getDelay() {
        return this.delay;
    }

    @CustomShadowVariable(variableListenerClass=PredecessorsDoneDateUpdatingVariableListener.class, sources={@PlanningVariableReference(variableName="delay")})
    public Long getPredecessorsDoneDate() {
        return this.predecessorsDoneDate;
    }

    @ValueRangeProvider(id="delayRange")
    public CountableValueRange<Long> getDelayRange() {
        if (this.getBatch().getDelayRangeValue() != null) {
            return ValueRangeFactory.createLongValueRange((long)0L, (long)this.getBatch().getDelayRangeValue());
        }
        return ValueRangeFactory.createLongValueRange((long)0L, (long)2000L);
    }
}

