/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.optional.score;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceConstraintConfiguration;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceSolution;
import org.optaplanner.examples.conferencescheduling.domain.Room;
import org.optaplanner.examples.conferencescheduling.domain.Speaker;
import org.optaplanner.examples.conferencescheduling.domain.Talk;
import org.optaplanner.examples.conferencescheduling.domain.TalkType;
import org.optaplanner.examples.conferencescheduling.domain.Timeslot;
import org.optaplanner.test.impl.score.buildin.hardmediumsoft.HardMediumSoftScoreVerifier;

@Disabled(value="Temporarily disabled until ScoreVerifier.assertPenalty() exists to avoid unneeded refactor")
class ConferenceSchedulingScoreHardConstraintTest {
    private HardMediumSoftScoreVerifier<ConferenceSolution> scoreVerifier = new HardMediumSoftScoreVerifier(SolverFactory.createFromXmlResource((String)"org/optaplanner/examples/conferencescheduling/conferenceSchedulingSolverConfig.xml"));

    ConferenceSchedulingScoreHardConstraintTest() {
    }

    @Test
    void talkHasUnavailableRoom() {
        TalkType talkType = new TalkType(0L, "type1");
        Talk talk1 = this.createTalk(1L).withTalkType(talkType);
        Talk talk2 = this.createTalk(2L).withTalkType(talkType);
        Timeslot slot1 = new Timeslot(1L).withTalkTypeSet(Collections.singleton(talkType));
        Timeslot slot2 = new Timeslot(2L).withTalkTypeSet(Collections.singleton(talkType));
        Room room1 = new Room(1L).withTalkTypeSet(Collections.emptySet());
        Room room2 = new Room(2L).withTalkTypeSet(Collections.emptySet());
        ConferenceSolution solution = new ConferenceSolution(1L).withConstraintConfiguration(new ConferenceConstraintConfiguration(1L)).withTalkTypeList(Collections.singletonList(talkType)).withTalkList(Arrays.asList(talk1, talk2)).withTimeslotList(Arrays.asList(slot1, slot2)).withRoomList(Arrays.asList(room1, room2)).withSpeakerList(Collections.emptyList());
        this.scoreVerifier.assertHardWeight("Room unavailable timeslot", 0, (Object)solution);
        room1.setUnavailableTimeslotSet(Collections.emptySet());
        talk1.withTimeslot(slot1).withRoom(room1);
        this.scoreVerifier.assertHardWeight("Room unavailable timeslot", 0, (Object)solution);
        room1.setUnavailableTimeslotSet(new HashSet<Timeslot>(Arrays.asList(slot2)));
        this.scoreVerifier.assertHardWeight("Room unavailable timeslot", 0, (Object)solution);
        room1.setUnavailableTimeslotSet(new HashSet<Timeslot>(Arrays.asList(slot1)));
        talk1.withTimeslot(slot1).withRoom(room1);
        this.scoreVerifier.assertHardWeight("Room unavailable timeslot", -10000, (Object)solution);
        room1.setUnavailableTimeslotSet(new HashSet<Timeslot>(Arrays.asList(slot1, slot2)));
        talk1.withTimeslot(slot1).withRoom(room1);
        this.scoreVerifier.assertHardWeight("Room unavailable timeslot", -10000, (Object)solution);
    }

    @Test
    void roomConflict() {
        TalkType talkType = new TalkType(0L, "type1");
        Talk talk1 = this.createTalk(1L).withTalkType(talkType);
        Talk talk2 = this.createTalk(2L).withTalkType(talkType);
        LocalDateTime start1 = LocalDateTime.of(2018, 1, 1, 9, 0);
        LocalDateTime end1 = LocalDateTime.of(2018, 1, 1, 10, 0);
        LocalDateTime start2 = LocalDateTime.of(2018, 1, 1, 9, 30);
        LocalDateTime end2 = LocalDateTime.of(2018, 1, 1, 10, 30);
        LocalDateTime start3 = LocalDateTime.of(2018, 1, 1, 10, 0);
        LocalDateTime end3 = LocalDateTime.of(2018, 1, 1, 11, 0);
        Timeslot slot1 = new Timeslot(1L).withTalkTypeSet(Collections.singleton(talkType)).withStartDateTime(start1).withEndDateTime(end1);
        Timeslot slot2 = new Timeslot(2L).withTalkTypeSet(Collections.singleton(talkType)).withStartDateTime(start2).withEndDateTime(end2);
        Timeslot slot3 = new Timeslot(3L).withTalkTypeSet(Collections.singleton(talkType)).withStartDateTime(start3).withEndDateTime(end3);
        Room room1 = new Room(1L).withTalkTypeSet(Collections.singleton(talkType)).withUnavailableTimeslotSet(Collections.emptySet());
        Room room2 = new Room(2L).withTalkTypeSet(Collections.singleton(talkType)).withUnavailableTimeslotSet(Collections.emptySet());
        ConferenceSolution solution = new ConferenceSolution(1L).withConstraintConfiguration(new ConferenceConstraintConfiguration(1L)).withTalkTypeList(Collections.singletonList(talkType)).withTalkList(Arrays.asList(talk1, talk2)).withTimeslotList(Arrays.asList(slot1, slot2, slot3)).withRoomList(Arrays.asList(room1, room2)).withSpeakerList(Collections.emptyList());
        this.scoreVerifier.assertHardWeight("Room conflict", 0, (Object)solution);
        talk1.withRoom(room1).withTimeslot(slot1);
        talk2.withRoom(room1).withTimeslot(slot3);
        this.scoreVerifier.assertHardWeight("Room conflict", 0, (Object)solution);
        talk1.withRoom(room2).withTimeslot(slot1);
        talk2.withRoom(room2).withTimeslot(slot2);
        this.scoreVerifier.assertHardWeight("Room conflict", -10, (Object)solution);
        talk1.withRoom(room1).withTimeslot(slot1);
        talk2.withRoom(room2).withTimeslot(slot2);
        this.scoreVerifier.assertHardWeight("Room conflict", 0, (Object)solution);
    }

    @Test
    void talkWithUnavailableSpeaker() {
        TalkType talkType = new TalkType(0L, "type1");
        Speaker speaker1 = new Speaker(1L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        Speaker speaker2 = new Speaker(2L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        Timeslot slot1 = new Timeslot(1L).withTalkTypeSet(Collections.singleton(talkType));
        Timeslot slot2 = new Timeslot(1L).withTalkTypeSet(Collections.singleton(talkType));
        Talk talk1 = this.createTalk(1L).withTalkType(talkType);
        ConferenceSolution solution = new ConferenceSolution(1L).withConstraintConfiguration(new ConferenceConstraintConfiguration(1L)).withTalkTypeList(Collections.singletonList(talkType)).withTalkList(Arrays.asList(talk1)).withTimeslotList(Arrays.asList(slot1)).withRoomList(Collections.emptyList()).withSpeakerList(Arrays.asList(speaker1, speaker2));
        this.scoreVerifier.assertHardWeight("Speaker unavailable timeslot", 0, (Object)solution);
        talk1.withSpeakerList(Arrays.asList(speaker1)).withTimeslot(slot1);
        speaker1.setUnavailableTimeslotSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker unavailable timeslot", 0, (Object)solution);
        speaker1.setUnavailableTimeslotSet(new HashSet<Timeslot>(Arrays.asList(slot2)));
        this.scoreVerifier.assertHardWeight("Speaker unavailable timeslot", 0, (Object)solution);
        talk1.withSpeakerList(Arrays.asList(speaker1, speaker2)).withTimeslot(slot1);
        this.scoreVerifier.assertHardWeight("Speaker unavailable timeslot", 0, (Object)solution);
        speaker2.setUnavailableTimeslotSet(new HashSet<Timeslot>(Arrays.asList(slot2)));
        this.scoreVerifier.assertHardWeight("Speaker unavailable timeslot", 0, (Object)solution);
        talk1.withSpeakerList(Arrays.asList(speaker1)).withTimeslot(slot1);
        speaker1.setUnavailableTimeslotSet(new HashSet<Timeslot>(Arrays.asList(slot1)));
        this.scoreVerifier.assertHardWeight("Speaker unavailable timeslot", -1, (Object)solution);
        speaker2.setUnavailableTimeslotSet(Collections.emptySet());
        talk1.withSpeakerList(Arrays.asList(speaker1, speaker2)).withTimeslot(slot1);
        this.scoreVerifier.assertHardWeight("Speaker unavailable timeslot", -1, (Object)solution);
        speaker2.setUnavailableTimeslotSet(new HashSet<Timeslot>(Arrays.asList(slot2)));
        this.scoreVerifier.assertHardWeight("Speaker unavailable timeslot", -1, (Object)solution);
        speaker2.setUnavailableTimeslotSet(new HashSet<Timeslot>(Arrays.asList(slot1, slot2)));
        this.scoreVerifier.assertHardWeight("Speaker unavailable timeslot", -1, (Object)solution);
    }

    @Test
    void speakerWithConflictingTimeslots() {
        TalkType talkType = new TalkType(0L, "type1");
        Speaker speaker1 = new Speaker(1L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        Talk talk1 = this.createTalk(1L).withTalkType(talkType);
        Talk talk2 = this.createTalk(2L).withTalkType(talkType);
        LocalDateTime start1 = LocalDateTime.of(2018, 1, 1, 9, 0);
        LocalDateTime end1 = LocalDateTime.of(2018, 1, 1, 10, 0);
        LocalDateTime start2 = LocalDateTime.of(2018, 1, 1, 9, 30);
        LocalDateTime end2 = LocalDateTime.of(2018, 1, 1, 10, 30);
        LocalDateTime start3 = LocalDateTime.of(2018, 1, 1, 10, 0);
        LocalDateTime end3 = LocalDateTime.of(2018, 1, 1, 11, 0);
        Timeslot slot1 = new Timeslot(1L).withTalkTypeSet(Collections.singleton(talkType)).withStartDateTime(start1).withEndDateTime(end1);
        Timeslot slot2 = new Timeslot(2L).withTalkTypeSet(Collections.singleton(talkType)).withStartDateTime(start2).withEndDateTime(end2);
        Timeslot slot3 = new Timeslot(3L).withTalkTypeSet(Collections.singleton(talkType)).withStartDateTime(start3).withEndDateTime(end3);
        ConferenceSolution solution = new ConferenceSolution(1L).withConstraintConfiguration(new ConferenceConstraintConfiguration(1L)).withTalkTypeList(Collections.singletonList(talkType)).withTalkList(Arrays.asList(talk1, talk2)).withTimeslotList(Arrays.asList(slot1, slot2, slot3)).withRoomList(Collections.emptyList()).withSpeakerList(Arrays.asList(speaker1));
        this.scoreVerifier.assertHardWeight("Speaker conflict", 0, (Object)solution);
        talk1.withSpeakerList(Arrays.asList(speaker1)).withTimeslot(slot1);
        talk2.withSpeakerList(Arrays.asList(speaker1)).withTimeslot(slot3);
        this.scoreVerifier.assertHardWeight("Speaker conflict", 0, (Object)solution);
        talk2.withTimeslot(slot2);
        this.scoreVerifier.assertHardWeight("Speaker conflict", -1, (Object)solution);
    }

    @Test
    void speakerRequiredTimeSlotTag() {
        String tag1 = "tag1";
        String tag2 = "tag2";
        String tag3 = "tag3";
        TalkType talkType = new TalkType(0L, "type1");
        Speaker speaker1 = new Speaker(1L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        Speaker speaker2 = new Speaker(2L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        Talk talk1 = this.createTalk(1L).withTalkType(talkType);
        LocalDateTime start1 = LocalDateTime.of(2018, 1, 1, 9, 0);
        LocalDateTime end1 = LocalDateTime.of(2018, 1, 1, 10, 0);
        Timeslot slot1 = new Timeslot(1L).withTalkTypeSet(Collections.singleton(talkType)).withStartDateTime(start1).withEndDateTime(end1);
        ConferenceSolution solution = new ConferenceSolution(1L).withConstraintConfiguration(new ConferenceConstraintConfiguration(1L)).withTalkTypeList(Collections.singletonList(talkType)).withTalkList(Arrays.asList(talk1)).withTimeslotList(Arrays.asList(slot1)).withRoomList(Collections.emptyList()).withSpeakerList(Arrays.asList(speaker1, speaker2));
        talk1.withSpeakerList(Arrays.asList(speaker1)).withTimeslot(slot1);
        slot1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tags", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tags", 0, (Object)solution);
        slot1.setTagSet(Collections.emptySet());
        speaker1.setRequiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tags", -1, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag2, tag3)));
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tags", -1, (Object)solution);
        speaker1.setRequiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tags", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tags", 0, (Object)solution);
        speaker1.setRequiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        slot1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tags", -2, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tags", -1, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tags", 0, (Object)solution);
        talk1.withSpeakerList(Arrays.asList(speaker1, speaker2));
        slot1.setTagSet(Collections.emptySet());
        speaker1.setRequiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        speaker2.setRequiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tags", -2, (Object)solution);
        slot1.setTagSet(Collections.emptySet());
        speaker1.setRequiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        speaker2.setRequiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tags", -4, (Object)solution);
        slot1.setTagSet(Collections.emptySet());
        speaker1.setRequiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        speaker2.setRequiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag3)));
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tags", -4, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tags", -2, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag2)));
        this.scoreVerifier.assertHardWeight("Speaker required timeslot tags", -3, (Object)solution);
    }

    @Test
    void speakerProhibitedTimeSlotTag() {
        String tag1 = "tag1";
        String tag2 = "tag2";
        String tag3 = "tag3";
        TalkType talkType = new TalkType(0L, "type1");
        Speaker speaker1 = new Speaker(1L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        Speaker speaker2 = new Speaker(2L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        Talk talk1 = this.createTalk(1L).withTalkType(talkType);
        LocalDateTime start1 = LocalDateTime.of(2018, 1, 1, 9, 0);
        LocalDateTime end1 = LocalDateTime.of(2018, 1, 1, 10, 0);
        Timeslot slot1 = new Timeslot(1L).withTalkTypeSet(Collections.singleton(talkType)).withStartDateTime(start1).withEndDateTime(end1);
        ConferenceSolution solution = new ConferenceSolution(1L).withConstraintConfiguration(new ConferenceConstraintConfiguration(1L)).withTalkTypeList(Collections.singletonList(talkType)).withTalkList(Arrays.asList(talk1)).withTimeslotList(Arrays.asList(slot1)).withRoomList(Collections.emptyList()).withSpeakerList(Arrays.asList(speaker1, speaker2));
        talk1.withSpeakerList(Arrays.asList(speaker1)).withTimeslot(slot1);
        slot1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tags", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tags", 0, (Object)solution);
        speaker1.setProhibitedTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        slot1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tags", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag2)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tags", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tags", -1, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tags", -1, (Object)solution);
        speaker1.setProhibitedTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        slot1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tags", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tags", -1, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tags", -2, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2, tag3)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tags", -2, (Object)solution);
        talk1.withSpeakerList(Arrays.asList(speaker1, speaker2));
        slot1.setTagSet(Collections.emptySet());
        speaker1.setProhibitedTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        speaker2.setProhibitedTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tags", 0, (Object)solution);
        speaker1.setProhibitedTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        speaker2.setProhibitedTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tags", -2, (Object)solution);
        speaker1.setProhibitedTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tags", -2, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tags", -3, (Object)solution);
        speaker2.setProhibitedTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tags", -4, (Object)solution);
        speaker2.setProhibitedTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag3)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tags", -3, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2, tag3)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited timeslot tags", -4, (Object)solution);
    }

    @Test
    void talkRequiredTimeslotTag() {
        String tag1 = "tag1";
        String tag2 = "tag2";
        TalkType talkType = new TalkType(0L, "type1");
        Talk talk1 = this.createTalk(1L);
        LocalDateTime start1 = LocalDateTime.of(2018, 1, 1, 9, 0);
        LocalDateTime end1 = LocalDateTime.of(2018, 1, 1, 10, 0);
        Timeslot slot1 = new Timeslot(1L).withTalkTypeSet(Collections.singleton(talkType)).withStartDateTime(start1).withEndDateTime(end1);
        ConferenceSolution solution = new ConferenceSolution(1L).withConstraintConfiguration(new ConferenceConstraintConfiguration(1L)).withTalkTypeList(Collections.singletonList(talkType)).withTalkList(Arrays.asList(talk1)).withTimeslotList(Arrays.asList(slot1)).withRoomList(Collections.emptyList()).withSpeakerList(Collections.emptyList());
        slot1.setTagSet(Collections.emptySet());
        talk1.withTimeslot(slot1);
        this.scoreVerifier.assertHardWeight("Talk required timeslot tags", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Talk required timeslot tags", 0, (Object)solution);
        talk1.withRequiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        slot1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Talk required timeslot tags", -1, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag2)));
        this.scoreVerifier.assertHardWeight("Talk required timeslot tags", -1, (Object)solution);
        talk1.withRequiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Talk required timeslot tags", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Talk required timeslot tags", 0, (Object)solution);
        slot1.setTagSet(Collections.emptySet());
        talk1.withRequiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Talk required timeslot tags", -2, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Talk required timeslot tags", -1, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Talk required timeslot tags", 0, (Object)solution);
    }

    @Test
    void talkProhibitedTimeslotTag() {
        String tag1 = "tag1";
        String tag2 = "tag2";
        TalkType talkType = new TalkType(0L, "type1");
        Talk talk1 = this.createTalk(1L);
        LocalDateTime start1 = LocalDateTime.of(2018, 1, 1, 9, 0);
        LocalDateTime end1 = LocalDateTime.of(2018, 1, 1, 10, 0);
        Timeslot slot1 = new Timeslot(1L).withTalkTypeSet(Collections.singleton(talkType)).withStartDateTime(start1).withEndDateTime(end1);
        ConferenceSolution solution = new ConferenceSolution(1L).withConstraintConfiguration(new ConferenceConstraintConfiguration(1L)).withTalkTypeList(Collections.singletonList(talkType)).withTalkList(Arrays.asList(talk1)).withTimeslotList(Arrays.asList(slot1)).withRoomList(Collections.emptyList()).withSpeakerList(Collections.emptyList());
        slot1.setTagSet(Collections.emptySet());
        talk1.withTimeslot(slot1);
        this.scoreVerifier.assertHardWeight("Talk prohibited timeslot tags", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Talk required timeslot tags", 0, (Object)solution);
        slot1.setTagSet(Collections.emptySet());
        talk1.withTimeslot(slot1).withProhibitedTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Talk prohibited timeslot tags", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag2)));
        this.scoreVerifier.assertHardWeight("Talk prohibited timeslot tags", 0, (Object)solution);
        talk1.withTimeslot(slot1).withProhibitedTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Talk prohibited timeslot tags", -1, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Talk prohibited timeslot tags", -1, (Object)solution);
        talk1.withTimeslot(slot1).withProhibitedTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        slot1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Talk prohibited timeslot tags", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Talk prohibited timeslot tags", -1, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Talk prohibited timeslot tags", -2, (Object)solution);
    }

    @Test
    void speakerRequiredRoomTag() {
        String tag1 = "tag1";
        String tag2 = "tag2";
        String tag3 = "tag3";
        TalkType talkType = new TalkType(0L, "type1");
        Room room1 = new Room(1L).withTalkTypeSet(Collections.singleton(talkType));
        Talk talk1 = this.createTalk(1L);
        Speaker speaker1 = new Speaker(1L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withRequiredRoomTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withPreferredRoomTagSet(Collections.emptySet()).withProhibitedRoomTagSet(Collections.emptySet()).withUndesiredRoomTagSet(Collections.emptySet());
        Speaker speaker2 = new Speaker(2L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withRequiredRoomTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withPreferredRoomTagSet(Collections.emptySet()).withProhibitedRoomTagSet(Collections.emptySet()).withUndesiredRoomTagSet(Collections.emptySet());
        ConferenceSolution solution = new ConferenceSolution(1L).withConstraintConfiguration(new ConferenceConstraintConfiguration(1L)).withTalkTypeList(Collections.singletonList(talkType)).withTalkList(Arrays.asList(talk1)).withTimeslotList(Collections.emptyList()).withRoomList(Arrays.asList(room1)).withSpeakerList(Arrays.asList(speaker1, speaker2));
        room1.setTagSet(Collections.emptySet());
        talk1.withSpeakerList(Arrays.asList(speaker1)).withRoom(room1);
        this.scoreVerifier.assertHardWeight("Speaker required room tags", 0, (Object)solution);
        speaker1.withRequiredRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker required room tags", -1, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag3)));
        this.scoreVerifier.assertHardWeight("Speaker required room tags", -1, (Object)solution);
        speaker1.withRequiredRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker required room tags", 0, (Object)solution);
        speaker1.withRequiredRoomTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker required room tags", -2, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker required room tags", -1, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker required room tags", 0, (Object)solution);
        talk1.withSpeakerList(Arrays.asList(speaker1, speaker2)).withRoom(room1);
        speaker1.withRequiredRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        speaker2.withRequiredRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker required room tags", -2, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker required room tags", 0, (Object)solution);
        speaker2.withRequiredRoomTagSet(new HashSet<String>(Arrays.asList(tag2)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker required room tags", -2, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker required room tags", -1, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker required room tags", 0, (Object)solution);
        speaker2.withRequiredRoomTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker required room tags", -3, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker required room tags", -1, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker required room tags", 0, (Object)solution);
    }

    @Test
    void speakerProhibitedRoomTag() {
        String tag1 = "tag1";
        String tag2 = "tag2";
        String tag3 = "tag3";
        TalkType talkType = new TalkType(0L, "type1");
        Room room1 = new Room(1L).withTalkTypeSet(Collections.singleton(talkType));
        Talk talk1 = this.createTalk(1L);
        Speaker speaker1 = new Speaker(1L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withRequiredRoomTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withPreferredRoomTagSet(Collections.emptySet()).withProhibitedRoomTagSet(Collections.emptySet()).withUndesiredRoomTagSet(Collections.emptySet());
        Speaker speaker2 = new Speaker(2L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withRequiredRoomTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withPreferredRoomTagSet(Collections.emptySet()).withProhibitedRoomTagSet(Collections.emptySet()).withUndesiredRoomTagSet(Collections.emptySet());
        ConferenceSolution solution = new ConferenceSolution(1L).withConstraintConfiguration(new ConferenceConstraintConfiguration(1L)).withTalkTypeList(Collections.singletonList(talkType)).withTalkList(Arrays.asList(talk1)).withTimeslotList(Collections.emptyList()).withRoomList(Arrays.asList(room1)).withSpeakerList(Arrays.asList(speaker1, speaker2));
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tags", 0, (Object)solution);
        room1.setTagSet(Collections.emptySet());
        talk1.withSpeakerList(Arrays.asList(speaker1)).withRoom(room1);
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tags", 0, (Object)solution);
        speaker1.withProhibitedRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tags", 0, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag3)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tags", 0, (Object)solution);
        speaker1.withProhibitedRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tags", -1, (Object)solution);
        speaker1.withProhibitedRoomTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tags", 0, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tags", -1, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tags", -2, (Object)solution);
        talk1.withSpeakerList(Arrays.asList(speaker1, speaker2)).withRoom(room1);
        speaker1.withProhibitedRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        speaker2.withProhibitedRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tags", 0, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tags", -2, (Object)solution);
        speaker2.withProhibitedRoomTagSet(new HashSet<String>(Arrays.asList(tag2)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tags", 0, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tags", -1, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tags", -2, (Object)solution);
        speaker2.withProhibitedRoomTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tags", 0, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tags", -2, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Speaker prohibited room tags", -3, (Object)solution);
    }

    @Test
    void talkRequiredRoomTag() {
        String tag1 = "tag1";
        String tag2 = "tag2";
        TalkType talkType = new TalkType(0L, "type1");
        Room room1 = new Room(1L).withTalkTypeSet(Collections.emptySet());
        Talk talk1 = this.createTalk(1L).withTalkType(talkType);
        ConferenceSolution solution = new ConferenceSolution(1L).withConstraintConfiguration(new ConferenceConstraintConfiguration(1L)).withTalkTypeList(Collections.singletonList(talkType)).withTalkList(Arrays.asList(talk1)).withTimeslotList(Collections.emptyList()).withRoomList(Collections.emptyList()).withSpeakerList(Collections.emptyList());
        room1.setTagSet(Collections.emptySet());
        talk1.withRoom(room1);
        this.scoreVerifier.assertHardWeight("Talk required room tags", 0, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Talk required room tags", 0, (Object)solution);
        talk1.withRequiredRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Talk required room tags", -1, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag2)));
        this.scoreVerifier.assertHardWeight("Talk required room tags", -1, (Object)solution);
        talk1.withRequiredRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Talk required room tags", 0, (Object)solution);
        room1.setTagSet(Collections.emptySet());
        talk1.withRequiredRoomTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Talk required room tags", -2, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Talk required room tags", -1, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Talk required room tags", 0, (Object)solution);
    }

    @Test
    void talkProhibitedRoomTag() {
        String tag1 = "tag1";
        String tag2 = "tag2";
        TalkType talkType = new TalkType(0L, "type1");
        Room room1 = new Room(1L).withTalkTypeSet(Collections.emptySet());
        Talk talk1 = this.createTalk(1L).withTalkType(talkType);
        ConferenceSolution solution = new ConferenceSolution(1L).withConstraintConfiguration(new ConferenceConstraintConfiguration(1L)).withTalkTypeList(Collections.singletonList(talkType)).withTalkList(Arrays.asList(talk1)).withTimeslotList(Collections.emptyList()).withRoomList(Collections.emptyList()).withSpeakerList(Collections.emptyList());
        room1.setTagSet(Collections.emptySet());
        talk1.withRoom(room1);
        this.scoreVerifier.assertHardWeight("Talk prohibited room tags", 0, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Talk prohibited room tags", 0, (Object)solution);
        talk1.withProhibitedRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertHardWeight("Talk prohibited room tags", 0, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag2)));
        this.scoreVerifier.assertHardWeight("Talk prohibited room tags", 0, (Object)solution);
        talk1.withProhibitedRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Talk prohibited room tags", -1, (Object)solution);
        room1.setTagSet(Collections.emptySet());
        talk1.withProhibitedRoomTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Talk prohibited room tags", 0, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertHardWeight("Talk prohibited room tags", -1, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertHardWeight("Talk prohibited room tags", -2, (Object)solution);
    }

    private Talk createTalk(long id) {
        return new Talk(id).withSpeakerList(Collections.emptyList()).withThemeTrackTagSet(Collections.emptySet()).withSectorTagSet(Collections.emptySet()).withAudienceTypeSet(Collections.emptySet()).withAudienceTypeSet(Collections.emptySet()).withContentTagSet(Collections.emptySet()).withRequiredRoomTagSet(Collections.emptySet()).withPreferredRoomTagSet(Collections.emptySet()).withProhibitedRoomTagSet(Collections.emptySet()).withUndesiredRoomTagSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet()).withMutuallyExclusiveTalksTagSet(Collections.emptySet()).withPrerequisiteTalksCodesSet(Collections.emptySet());
    }
}

