/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.curriculumcourse.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.examples.common.domain.AbstractPersistable;

@XStreamAlias(value="Timeslot")
public class Timeslot
extends AbstractPersistable {
    private static final String[] TIMES = new String[]{"08:00", "09:00", "10:00", "11:00", "13:00", "14:00", "15:00", "16:00", "17:00", "18:00"};
    private int timeslotIndex;

    public Timeslot(int timeslotIndex) {
        super(timeslotIndex);
        this.timeslotIndex = timeslotIndex;
    }

    public int getTimeslotIndex() {
        return this.timeslotIndex;
    }

    public void setTimeslotIndex(int timeslotIndex) {
        this.timeslotIndex = timeslotIndex;
    }

    public String getLabel() {
        String time = TIMES[this.timeslotIndex % TIMES.length];
        if (this.timeslotIndex > TIMES.length) {
            return "Timeslot " + this.timeslotIndex;
        }
        return time;
    }

    @Override
    public String toString() {
        return Integer.toString(this.timeslotIndex);
    }
}

