/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.optaplanner.core.api.score.calculator.EasyScoreCalculator;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.examples.common.TurtleTest;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.LoggingTest;

public abstract class SolveAllTurtleTest<Solution_>
extends LoggingTest {
    private static final String MOVE_THREAD_COUNT_OVERRIDE = System.getProperty("moveThreadCount");

    protected abstract List<File> getSolutionFiles(CommonApp<Solution_> var1);

    protected abstract CommonApp<Solution_> createCommonApp();

    protected abstract ProblemFactory<Solution_> createProblemFactory(CommonApp<Solution_> var1);

    @TestFactory
    @TurtleTest
    Stream<DynamicTest> runFastAndFullAssert() {
        CommonApp<Solution_> commonApp = this.createCommonApp();
        ProblemFactory<Solution_> problemFactory = this.createProblemFactory(commonApp);
        return this.getSolutionFiles(commonApp).stream().map(solutionFile -> DynamicTest.dynamicTest((String)solutionFile.getName(), () -> this.runFastAndFullAssert(SolveAllTurtleTest.buildSolverConfig(commonApp.getSolverConfigResource()), problemFactory.loadProblem((File)solutionFile))));
    }

    public void runFastAndFullAssert(SolverConfig solverConfig, Solution_ problem) {
        this.checkIfSupportsBavet(solverConfig);
        problem = this.buildAndSolve(solverConfig, EnvironmentMode.NON_INTRUSIVE_FULL_ASSERT, problem, 2L);
        problem = this.buildAndSolve(solverConfig, EnvironmentMode.FAST_ASSERT, problem, 5L);
        problem = this.buildAndSolve(solverConfig, EnvironmentMode.NON_INTRUSIVE_FULL_ASSERT, problem, 3L);
    }

    protected boolean supportsBavet() {
        return true;
    }

    protected void checkIfSupportsBavet(SolverConfig solverConfig) {
        ConstraintStreamImplType constraintStreamImplType = solverConfig.getScoreDirectorFactoryConfig().getConstraintStreamImplType();
        boolean isBavet = solverConfig.getScoreDirectorFactoryConfig().getConstraintProviderClass() != null && constraintStreamImplType == ConstraintStreamImplType.BAVET;
        Assumptions.assumeTrue((!isBavet || this.supportsBavet() ? 1 : 0) != 0, (String)("The test (" + this.getClass().getSimpleName() + ") does not support the CS-B."));
    }

    private static SolverConfig buildSolverConfig(String solverConfigResource) {
        SolverConfig solverConfig = SolverConfig.createFromXmlResource((String)solverConfigResource);
        if (solverConfig.getScoreDirectorFactoryConfig().getConstraintProviderClass() != null) {
            solverConfig.getScoreDirectorFactoryConfig().setConstraintStreamImplType(SolveAllTurtleTest.resolveConstraintStreamType());
        }
        solverConfig.setTerminationConfig(new TerminationConfig());
        if (MOVE_THREAD_COUNT_OVERRIDE != null) {
            solverConfig.setMoveThreadCount(MOVE_THREAD_COUNT_OVERRIDE);
        }
        return solverConfig;
    }

    private static ConstraintStreamImplType resolveConstraintStreamType() {
        String csImplProperty = System.getProperty("constraintStreamImplType", ConstraintStreamImplType.DROOLS.name()).trim().toUpperCase();
        return csImplProperty.equals(ConstraintStreamImplType.DROOLS.name()) ? ConstraintStreamImplType.DROOLS : ConstraintStreamImplType.BAVET;
    }

    private Solution_ buildAndSolve(SolverConfig solverConfig, EnvironmentMode environmentMode, Solution_ problem, long maximumMinutesSpent) {
        solverConfig.getTerminationConfig().setMinutesSpentLimit(Long.valueOf(maximumMinutesSpent));
        solverConfig.setEnvironmentMode(environmentMode);
        Class<EasyScoreCalculator> easyScoreCalculatorClass = this.overwritingEasyScoreCalculatorClass();
        if (easyScoreCalculatorClass != null && environmentMode.isAsserted()) {
            ScoreDirectorFactoryConfig assertionScoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
            assertionScoreDirectorFactoryConfig.setEasyScoreCalculatorClass(easyScoreCalculatorClass);
            solverConfig.getScoreDirectorFactoryConfig().setAssertionScoreDirectorFactory(assertionScoreDirectorFactoryConfig);
        }
        SolverFactory solverFactory = SolverFactory.create((SolverConfig)solverConfig);
        Solver solver = solverFactory.buildSolver();
        return (Solution_)solver.solve(problem);
    }

    protected Class<? extends EasyScoreCalculator> overwritingEasyScoreCalculatorClass() {
        return null;
    }

    static interface ProblemFactory<Solution_>
    extends Function<File, Solution_> {
        default public Solution_ loadProblem(File f) {
            return (Solution_)this.apply(f);
        }
    }
}

