/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.util.stream.Stream;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.impl.DefaultPlannerBenchmark;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.examples.common.app.CommonBenchmarkApp;

public abstract class AbstractBenchmarkConfigTest {
    protected abstract CommonBenchmarkApp getBenchmarkApp();

    @TestFactory
    @Execution(value=ExecutionMode.CONCURRENT)
    Stream<DynamicTest> testBenchmarkApp() {
        return this.getBenchmarkApp().getArgOptions().stream().map(argOption -> DynamicTest.dynamicTest((String)argOption.toString(), () -> AbstractBenchmarkConfigTest.buildPlannerBenchmark(argOption)));
    }

    private static void buildPlannerBenchmark(CommonBenchmarkApp.ArgOption argOption) {
        String benchmarkConfigResource = argOption.getBenchmarkConfigResource();
        PlannerBenchmarkFactory benchmarkFactory = !argOption.isTemplate() ? PlannerBenchmarkFactory.createFromXmlResource((String)benchmarkConfigResource) : PlannerBenchmarkFactory.createFromFreemarkerXmlResource((String)benchmarkConfigResource);
        PlannerBenchmark benchmark = benchmarkFactory.buildPlannerBenchmark();
        AbstractBenchmarkConfigTest.buildEverySolver(benchmark);
    }

    private static void buildEverySolver(PlannerBenchmark plannerBenchmark) {
        PlannerBenchmarkResult plannerBenchmarkResult = ((DefaultPlannerBenchmark)plannerBenchmark).getPlannerBenchmarkResult();
        for (SolverBenchmarkResult solverBenchmarkResult : plannerBenchmarkResult.getSolverBenchmarkResultList()) {
            SolverConfig solverConfig = solverBenchmarkResult.getSolverConfig();
            SolverFactory.create((SolverConfig)solverConfig).buildSolver();
        }
    }
}

