/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.business;

import java.util.Comparator;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.examples.common.business.AlphaNumericStringComparator;

class AlphaNumericStringComparatorTest {
    AlphaNumericStringComparatorTest() {
    }

    @Test
    void compare() {
        AlphaNumericStringComparator comparator = new AlphaNumericStringComparator();
        this.assertCompareEquals((Comparator)comparator, (Object)"aaa", (Object)"aaa");
        this.assertCompareLower((Comparator)comparator, (Object)"aaa", (Object)"aaaa");
        this.assertCompareLower((Comparator)comparator, (Object)"aaa", (Object)"aba");
        this.assertCompareLower((Comparator)comparator, (Object)"aaa", (Object)"ba");
        this.assertCompareEquals((Comparator)comparator, (Object)"a1", (Object)"a1");
        this.assertCompareEquals((Comparator)comparator, (Object)"a123", (Object)"a123");
        this.assertCompareLower((Comparator)comparator, (Object)"a1", (Object)"a2");
        this.assertCompareLower((Comparator)comparator, (Object)"a2", (Object)"a10");
        this.assertCompareLower((Comparator)comparator, (Object)"a99", (Object)"a100");
        this.assertCompareLower((Comparator)comparator, (Object)"2", (Object)"10");
        this.assertCompareLower((Comparator)comparator, (Object)"2a", (Object)"10a");
        this.assertCompareLower((Comparator)comparator, (Object)"a-2", (Object)"a-10");
        this.assertCompareLower((Comparator)comparator, (Object)"a-2.5", (Object)"a-10.0");
        this.assertCompareLower((Comparator)comparator, (Object)"a-0.5", (Object)"a-0.6");
    }

    public <T> void assertCompareEquals(Comparator<T> comparator, T a, T b) {
        SoftAssertions.assertSoftly(softly -> {
            ((ObjectAssert)softly.assertThat(a).usingComparator(comparator)).isEqualTo(b);
            ((ObjectAssert)softly.assertThat(b).usingComparator(comparator)).isEqualTo(a);
        });
    }

    public <T> void assertCompareLower(Comparator<T> comparator, T a, T b) {
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(comparator.compare(a, b)).isEqualTo(-1);
            softly.assertThat(comparator.compare(b, a)).isEqualTo(1);
        });
    }
}

