/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tennis.score;

import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.examples.tennis.domain.Day;
import org.optaplanner.examples.tennis.domain.Team;
import org.optaplanner.examples.tennis.domain.TeamAssignment;
import org.optaplanner.examples.tennis.domain.TennisSolution;
import org.optaplanner.examples.tennis.domain.UnavailabilityPenalty;
import org.optaplanner.examples.tennis.score.TennisConstraintProvider;
import org.optaplanner.test.api.score.stream.ConstraintVerifier;

class TennisConstraintProviderTest {
    private static final Day DAY0 = new Day(0L, 0);
    private static final Day DAY1 = new Day(1L, 1);
    private static final Day DAY2 = new Day(2L, 2);
    private static final Team TEAM0 = new Team(0L, "A");
    private static final Team TEAM1 = new Team(1L, "B");
    private static final Team TEAM2 = new Team(2L, "C");
    private final ConstraintVerifier<TennisConstraintProvider, TennisSolution> constraintVerifier = ConstraintVerifier.build((ConstraintProvider)new TennisConstraintProvider(), TennisSolution.class, (Class[])new Class[]{TeamAssignment.class});

    TennisConstraintProviderTest() {
    }

    @Test
    void oneAssignmentPerDayPerTeam() {
        TeamAssignment assignment1 = new TeamAssignment(0L, DAY0, 0);
        assignment1.setTeam(TEAM0);
        TeamAssignment assignment2 = new TeamAssignment(1L, DAY0, 1);
        assignment2.setTeam(TEAM0);
        TeamAssignment assignment3 = new TeamAssignment(2L, DAY0, 2);
        assignment3.setTeam(TEAM0);
        TeamAssignment assignment4 = new TeamAssignment(3L, DAY1, 0);
        assignment4.setTeam(TEAM1);
        TeamAssignment assignment5 = new TeamAssignment(4L, DAY2, 1);
        assignment5.setTeam(TEAM1);
        this.constraintVerifier.verifyThat(TennisConstraintProvider::oneAssignmentPerDatePerTeam).given(new Object[]{assignment1, assignment2, assignment3, assignment4, assignment5, TEAM0, TEAM1, TEAM2}).penalizesBy(3);
    }

    @Test
    void unavailabilityPenalty() {
        TeamAssignment assignment1 = new TeamAssignment(0L, DAY0, 0);
        assignment1.setTeam(TEAM0);
        TeamAssignment assignment2 = new TeamAssignment(1L, DAY1, 0);
        assignment2.setTeam(TEAM1);
        TeamAssignment assignment3 = new TeamAssignment(2L, DAY1, 1);
        assignment3.setTeam(TEAM1);
        TeamAssignment assignment4 = new TeamAssignment(3L, DAY2, 0);
        assignment4.setTeam(TEAM1);
        UnavailabilityPenalty unavailabilityPenalty1 = new UnavailabilityPenalty(0L, TEAM0, DAY0);
        UnavailabilityPenalty unavailabilityPenalty2 = new UnavailabilityPenalty(1L, TEAM1, DAY1);
        this.constraintVerifier.verifyThat(TennisConstraintProvider::unavailabilityPenalty).given(new Object[]{assignment1, assignment2, assignment3, assignment4, unavailabilityPenalty1, unavailabilityPenalty2}).penalizesBy(2);
    }

    @Test
    void fairAssignmentCountPerTeam() {
        TeamAssignment assignment1 = new TeamAssignment(0L, DAY0, 0);
        assignment1.setTeam(TEAM0);
        TeamAssignment assignment2 = new TeamAssignment(1L, DAY1, 0);
        assignment2.setTeam(TEAM1);
        TeamAssignment assignment3 = new TeamAssignment(2L, DAY2, 0);
        assignment3.setTeam(TEAM2);
        TeamAssignment assignment4 = new TeamAssignment(3L, DAY0, 0);
        assignment4.setTeam(TEAM2);
        this.constraintVerifier.verifyThat(TennisConstraintProvider::fairAssignmentCountPerTeam).given(new Object[]{assignment1, assignment2, assignment3}).penalizesBy(1732);
        this.constraintVerifier.verifyThat(TennisConstraintProvider::fairAssignmentCountPerTeam).given(new Object[]{assignment1, assignment2, assignment3, assignment4}).penalizesBy(2449);
    }

    @Test
    void evenlyConfrontationCount() {
        TeamAssignment assignment1 = new TeamAssignment(0L, DAY0, 0);
        assignment1.setTeam(TEAM0);
        TeamAssignment assignment2 = new TeamAssignment(1L, DAY0, 0);
        assignment2.setTeam(TEAM1);
        TeamAssignment assignment3 = new TeamAssignment(2L, DAY0, 0);
        assignment3.setTeam(TEAM2);
        TeamAssignment assignment4 = new TeamAssignment(3L, DAY0, 0);
        assignment4.setTeam(TEAM2);
        this.constraintVerifier.verifyThat(TennisConstraintProvider::evenlyConfrontationCount).given(new Object[]{assignment1, assignment2, assignment3}).penalizesBy(1732);
        this.constraintVerifier.verifyThat(TennisConstraintProvider::evenlyConfrontationCount).given(new Object[]{assignment1, assignment2, assignment3, assignment4}).penalizesBy(3000);
    }
}

