/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.swingui.realtime;

import java.util.ArrayList;
import org.optaplanner.core.api.solver.change.ProblemChange;
import org.optaplanner.core.api.solver.change.ProblemChangeDirector;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.domain.CloudComputer;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;

public class DeleteComputerProblemChange
implements ProblemChange<CloudBalance> {
    private final CloudComputer computer;

    public DeleteComputerProblemChange(CloudComputer computer) {
        this.computer = computer;
    }

    public void doChange(CloudBalance cloudBalance, ProblemChangeDirector problemChangeDirector) {
        CloudComputer workingComputer = (CloudComputer)problemChangeDirector.lookUpWorkingObjectOrFail((Object)this.computer);
        if (workingComputer == null) {
            throw new IllegalStateException("A computer " + this.computer + " does not exist. Maybe it has been already deleted.");
        }
        for (CloudProcess process : cloudBalance.getProcessList()) {
            if (process.getComputer() != workingComputer) continue;
            problemChangeDirector.changeVariable((Object)process, "computer", workingProcess -> workingProcess.setComputer(null));
        }
        ArrayList<CloudComputer> computerList = new ArrayList<CloudComputer>(cloudBalance.getComputerList());
        cloudBalance.setComputerList(computerList);
        problemChangeDirector.removeProblemFact((Object)workingComputer, computerList::remove);
    }
}

