/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.taskassigning.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningListVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.swingui.components.Labeled;
import org.optaplanner.examples.taskassigning.domain.Affinity;
import org.optaplanner.examples.taskassigning.domain.Customer;
import org.optaplanner.examples.taskassigning.domain.Skill;
import org.optaplanner.examples.taskassigning.domain.Task;

@PlanningEntity
@XStreamAlias(value="TaEmployee")
public class Employee
extends AbstractPersistable
implements Labeled {
    private String fullName;
    private Set<Skill> skillSet;
    private Map<Customer, Affinity> affinityMap;
    @PlanningListVariable(valueRangeProviderRefs={"taskRange"})
    private List<Task> tasks;

    public Employee() {
    }

    public Employee(long id, String fullName) {
        super(id);
        this.fullName = fullName;
        this.skillSet = new LinkedHashSet<Skill>();
        this.affinityMap = new LinkedHashMap<Customer, Affinity>();
        this.tasks = new ArrayList<Task>();
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Set<Skill> getSkillSet() {
        return this.skillSet;
    }

    public void setSkillSet(Set<Skill> skillSet) {
        this.skillSet = skillSet;
    }

    public Map<Customer, Affinity> getAffinityMap() {
        return this.affinityMap;
    }

    public void setAffinityMap(Map<Customer, Affinity> affinityMap) {
        this.affinityMap = affinityMap;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    public Affinity getAffinity(Customer customer) {
        Affinity affinity = this.affinityMap.get(customer);
        if (affinity == null) {
            affinity = Affinity.NONE;
        }
        return affinity;
    }

    public Integer getEndTime() {
        return this.tasks.isEmpty() ? 0 : this.tasks.get(this.tasks.size() - 1).getEndTime();
    }

    @Override
    public String getLabel() {
        return this.fullName;
    }

    public String getToolText() {
        StringBuilder toolText = new StringBuilder();
        toolText.append("<html><center><b>").append(this.fullName).append("</b><br/><br/>");
        toolText.append("Skills:<br/>");
        for (Skill skill : this.skillSet) {
            toolText.append(skill.getLabel()).append("<br/>");
        }
        toolText.append("</center></html>");
        return toolText.toString();
    }

    @Override
    public String toString() {
        return this.fullName;
    }
}

