/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.LoggingTest;
import org.optaplanner.examples.common.business.ProblemFileComparator;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;

public abstract class ImportDataFilesTest<Solution_>
extends LoggingTest {
    protected abstract AbstractSolutionImporter<Solution_> createSolutionImporter();

    protected abstract String getDataDirName();

    protected Predicate<File> dataFileInclusionFilter() {
        return file -> true;
    }

    private static List<File> getInputFiles(String dataDirName, AbstractSolutionImporter<?> solutionImporter) {
        File importDir = new File(CommonApp.determineDataDir((String)dataDirName), "import");
        ArrayList<File> fileList = solutionImporter.isInputFileDirectory() ? new ArrayList<File>(Arrays.asList(Objects.requireNonNull(importDir.listFiles((FileFilter)DirectoryFileFilter.INSTANCE)))) : new ArrayList(FileUtils.listFiles((File)importDir, (String[])new String[]{solutionImporter.getInputFileSuffix()}, (boolean)true));
        fileList.sort((Comparator<File>)new ProblemFileComparator());
        return fileList;
    }

    @TestFactory
    @Execution(value=ExecutionMode.CONCURRENT)
    Stream<DynamicTest> readSolution() {
        AbstractSolutionImporter solutionImporter = this.createSolutionImporter();
        return ImportDataFilesTest.getInputFiles(this.getDataDirName(), solutionImporter).stream().filter(this.dataFileInclusionFilter()).map(importFile -> DynamicTest.dynamicTest((String)importFile.getName(), () -> solutionImporter.readSolution(importFile)));
    }
}

