/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.score;

import java.util.stream.Stream;
import org.junit.jupiter.api.DisplayNameGeneration;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.provider.Arguments;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.examples.common.score.SimplifiedTestNameGenerator;
import org.optaplanner.test.api.score.stream.ConstraintVerifier;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@DisplayNameGeneration(value=SimplifiedTestNameGenerator.class)
public abstract class AbstractConstraintProviderTest<ConstraintProvider_ extends ConstraintProvider, Solution_> {
    private final ConstraintVerifier<ConstraintProvider_, Solution_> bavetConstraintVerifier = this.createConstraintVerifier().withConstraintStreamImplType(ConstraintStreamImplType.BAVET);
    private final ConstraintVerifier<ConstraintProvider_, Solution_> droolsWithoutAncConstraintVerifier = this.createConstraintVerifier().withConstraintStreamImplType(ConstraintStreamImplType.DROOLS).withDroolsAlphaNetworkCompilationEnabled(false);
    private final ConstraintVerifier<ConstraintProvider_, Solution_> droolsWithAncConstraintVerifier = this.createConstraintVerifier().withConstraintStreamImplType(ConstraintStreamImplType.DROOLS).withDroolsAlphaNetworkCompilationEnabled(true);

    protected abstract ConstraintVerifier<ConstraintProvider_, Solution_> createConstraintVerifier();

    protected final Stream<? extends Arguments> getDroolsAndBavetConstraintVerifierImpls() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{Named.named((String)"BAVET", this.bavetConstraintVerifier)}), Arguments.arguments((Object[])new Object[]{Named.named((String)"DROOLS (without ANC)", this.droolsWithoutAncConstraintVerifier)}), Arguments.arguments((Object[])new Object[]{Named.named((String)"DROOLS (with ANC)", this.droolsWithAncConstraintVerifier)}));
    }
}

