/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cheaptime.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.valuerange.CountableValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRangeFactory;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.cheaptime.domain.Machine;
import org.optaplanner.examples.cheaptime.domain.Period;
import org.optaplanner.examples.cheaptime.domain.Task;
import org.optaplanner.examples.cheaptime.domain.solver.TaskAssignmentDifficultyComparator;
import org.optaplanner.examples.common.domain.AbstractPersistable;

@PlanningEntity(difficultyComparatorClass=TaskAssignmentDifficultyComparator.class)
@XStreamAlias(value="CtTaskAssignment")
public class TaskAssignment
extends AbstractPersistable {
    private Task task;
    private Machine machine;
    private Integer startPeriod;

    public TaskAssignment() {
    }

    public TaskAssignment(Task task, Machine machine, Period start) {
        super(task.getId());
        this.task = task;
        this.machine = machine;
        this.startPeriod = start.getIndex();
    }

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    @PlanningVariable(valueRangeProviderRefs={"machineRange"})
    public Machine getMachine() {
        return this.machine;
    }

    public void setMachine(Machine machine) {
        this.machine = machine;
    }

    @PlanningVariable(valueRangeProviderRefs={"startPeriodRange"})
    public Integer getStartPeriod() {
        return this.startPeriod;
    }

    public void setStartPeriod(Integer startPeriod) {
        this.startPeriod = startPeriod;
    }

    public Integer getEndPeriod() {
        if (this.startPeriod == null) {
            return null;
        }
        return this.startPeriod + this.task.getDuration();
    }

    public String getLabel() {
        return this.task.getLabel();
    }

    @ValueRangeProvider(id="startPeriodRange")
    public CountableValueRange<Integer> getStartPeriodRange() {
        return ValueRangeFactory.createIntValueRange((int)this.task.getStartPeriodRangeFrom(), (int)this.task.getStartPeriodRangeTo());
    }
}

