/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.experimental.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Random;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.Test;
import org.optaplanner.examples.common.experimental.api.IntervalBreak;
import org.optaplanner.examples.common.experimental.api.IntervalCluster;
import org.optaplanner.examples.common.experimental.impl.Interval;
import org.optaplanner.examples.common.experimental.impl.IntervalBreakImpl;
import org.optaplanner.examples.common.experimental.impl.IntervalClusterImpl;
import org.optaplanner.examples.common.experimental.impl.IntervalSplitPoint;
import org.optaplanner.examples.common.experimental.impl.IntervalTree;
import org.optaplanner.examples.common.experimental.impl.IterableList;

class IntervalTreeTest {
    IntervalTreeTest() {
    }

    private IntervalTree<TestInterval, Integer, Integer> getIntegerIntervalTree() {
        return new IntervalTree(TestInterval::getStart, TestInterval::getEnd, (a, b) -> b - a);
    }

    @Test
    void testNonConsecutiveIntervals() {
        IntervalTree<TestInterval, Integer, Integer> tree = this.getIntegerIntervalTree();
        Interval a = tree.getInterval((Object)new TestInterval(0, 2));
        Interval b = tree.getInterval((Object)new TestInterval(3, 4));
        Interval c = tree.getInterval((Object)new TestInterval(5, 7));
        tree.add(a);
        tree.add(b);
        tree.add(c);
        IterableList clusterList = new IterableList(tree.getConsecutiveIntervalData().getIntervalClusters());
        Assertions.assertThat(clusterList).hasSize(3);
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(0))).containsExactly((Object[])new TestInterval[]{new TestInterval(0, 2)});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(0)).hasOverlap()).isFalse();
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(1))).containsExactly((Object[])new TestInterval[]{new TestInterval(3, 4)});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(1)).hasOverlap()).isFalse();
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(2))).containsExactly((Object[])new TestInterval[]{new TestInterval(5, 7)});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(2)).hasOverlap()).isFalse();
        this.verifyBreaks(tree);
    }

    @Test
    void testConsecutiveIntervals() {
        IntervalTree<TestInterval, Integer, Integer> tree = this.getIntegerIntervalTree();
        Interval a = tree.getInterval((Object)new TestInterval(0, 2));
        Interval b = tree.getInterval((Object)new TestInterval(2, 4));
        Interval c = tree.getInterval((Object)new TestInterval(4, 7));
        tree.add(a);
        tree.add(b);
        tree.add(c);
        IterableList clusterList = new IterableList(tree.getConsecutiveIntervalData().getIntervalClusters());
        Assertions.assertThat(clusterList).hasSize(1);
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(0))).containsExactly((Object[])new TestInterval[]{new TestInterval(0, 2), new TestInterval(2, 4), new TestInterval(4, 7)});
        this.verifyBreaks(tree);
    }

    @Test
    void testDuplicateIntervals() {
        IntervalTree<TestInterval, Integer, Integer> tree = this.getIntegerIntervalTree();
        Interval a = tree.getInterval((Object)new TestInterval(0, 2));
        Interval b = tree.getInterval((Object)new TestInterval(4, 7));
        tree.add(a);
        tree.add(a);
        tree.add(b);
        IterableList clusterList = new IterableList(tree.getConsecutiveIntervalData().getIntervalClusters());
        Assertions.assertThat(clusterList).hasSize(2);
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(0))).containsExactly((Object[])new TestInterval[]{(TestInterval)a.getValue(), (TestInterval)a.getValue()});
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(1))).containsExactly((Object[])new TestInterval[]{(TestInterval)b.getValue()});
        this.verifyBreaks(tree);
    }

    @Test
    void testIntervalRemoval() {
        IntervalTree<TestInterval, Integer, Integer> tree = this.getIntegerIntervalTree();
        TestInterval removedInterval = new TestInterval(2, 4);
        Interval a = tree.getInterval((Object)new TestInterval(0, 2));
        Interval b = tree.getInterval((Object)removedInterval);
        Interval c = tree.getInterval((Object)new TestInterval(4, 7));
        tree.add(a);
        tree.add(b);
        tree.add(c);
        removedInterval.setStart(10);
        removedInterval.setEnd(12);
        tree.remove(b);
        IterableList clusterList = new IterableList(tree.getConsecutiveIntervalData().getIntervalClusters());
        Assertions.assertThat(clusterList).hasSize(2);
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(0))).containsExactly((Object[])new TestInterval[]{new TestInterval(0, 2)});
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(1))).containsExactly((Object[])new TestInterval[]{new TestInterval(4, 7)});
        this.verifyBreaks(tree);
    }

    @Test
    void testIntervalAddUpdatingOldBreak() {
        IntervalTree<TestInterval, Integer, Integer> tree = this.getIntegerIntervalTree();
        TestInterval beforeAll = new TestInterval(1, 2);
        TestInterval newStart = new TestInterval(3, 8);
        TestInterval oldStart = new TestInterval(4, 5);
        TestInterval betweenOldAndNewStart = new TestInterval(6, 7);
        TestInterval afterAll = new TestInterval(9, 10);
        tree.add(tree.getInterval((Object)beforeAll));
        this.verifyBreaks(tree);
        tree.add(tree.getInterval((Object)afterAll));
        this.verifyBreaks(tree);
        tree.add(tree.getInterval((Object)oldStart));
        this.verifyBreaks(tree);
        tree.add(tree.getInterval((Object)betweenOldAndNewStart));
        this.verifyBreaks(tree);
        tree.add(tree.getInterval((Object)newStart));
        this.verifyBreaks(tree);
    }

    @Test
    void testOverlappingInterval() {
        IntervalTree<TestInterval, Integer, Integer> tree = this.getIntegerIntervalTree();
        Interval a = tree.getInterval((Object)new TestInterval(0, 2));
        TestInterval removedTestInterval1 = new TestInterval(1, 3);
        Interval removedInterval1 = tree.getInterval((Object)removedTestInterval1);
        Interval c = tree.getInterval((Object)new TestInterval(2, 4));
        Interval d = tree.getInterval((Object)new TestInterval(5, 6));
        Interval e = tree.getInterval((Object)new TestInterval(7, 9));
        TestInterval removedTestInterval2 = new TestInterval(7, 9);
        Interval removedInterval2 = tree.getInterval((Object)removedTestInterval2);
        tree.add(a);
        tree.add(removedInterval1);
        tree.add(c);
        tree.add(d);
        tree.add(e);
        tree.add(removedInterval2);
        IterableList clusterList = new IterableList(tree.getConsecutiveIntervalData().getIntervalClusters());
        Assertions.assertThat(clusterList).hasSize(3);
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(0))).containsExactly((Object[])new TestInterval[]{(TestInterval)a.getValue(), removedTestInterval1, (TestInterval)c.getValue()});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(0)).hasOverlap()).isTrue();
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(1))).containsExactly((Object[])new TestInterval[]{(TestInterval)d.getValue()});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(1)).hasOverlap()).isFalse();
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(2))).containsExactly((Object[])new TestInterval[]{(TestInterval)e.getValue(), removedTestInterval2});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(2)).hasOverlap()).isTrue();
        this.verifyBreaks(tree);
        removedTestInterval1.setStart(0);
        removedTestInterval1.setEnd(10);
        tree.remove(removedInterval1);
        clusterList = new IterableList(tree.getConsecutiveIntervalData().getIntervalClusters());
        Assertions.assertThat(clusterList).hasSize(3);
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(0))).containsExactly((Object[])new TestInterval[]{(TestInterval)a.getValue(), (TestInterval)c.getValue()});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(0)).hasOverlap()).isFalse();
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(1))).containsExactly((Object[])new TestInterval[]{(TestInterval)d.getValue()});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(1)).hasOverlap()).isFalse();
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(2))).containsExactly((Object[])new TestInterval[]{(TestInterval)e.getValue(), removedTestInterval2});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(2)).hasOverlap()).isTrue();
        this.verifyBreaks(tree);
        removedTestInterval2.setStart(2);
        removedTestInterval2.setEnd(4);
        tree.remove(removedInterval2);
        clusterList = new IterableList(tree.getConsecutiveIntervalData().getIntervalClusters());
        Assertions.assertThat(clusterList).hasSize(3);
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(0))).containsExactly((Object[])new TestInterval[]{(TestInterval)a.getValue(), (TestInterval)c.getValue()});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(0)).hasOverlap()).isFalse();
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(1))).containsExactly((Object[])new TestInterval[]{(TestInterval)d.getValue()});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(1)).hasOverlap()).isFalse();
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(2))).containsExactly((Object[])new TestInterval[]{(TestInterval)e.getValue()});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(2)).hasOverlap()).isFalse();
        this.verifyBreaks(tree);
        Interval g = tree.getInterval((Object)new TestInterval(6, 7));
        tree.add(g);
        clusterList = new IterableList(tree.getConsecutiveIntervalData().getIntervalClusters());
        Assertions.assertThat(clusterList).hasSize(2);
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(0))).containsExactly((Object[])new TestInterval[]{(TestInterval)a.getValue(), (TestInterval)c.getValue()});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(0)).hasOverlap()).isFalse();
        Assertions.assertThat((Iterable)((Iterable)clusterList.get(1))).containsExactly((Object[])new TestInterval[]{(TestInterval)d.getValue(), (TestInterval)g.getValue(), (TestInterval)e.getValue()});
        Assertions.assertThat((boolean)((IntervalCluster)clusterList.get(1)).hasOverlap()).isFalse();
    }

    public void verifyBreaks(IntervalTree<TestInterval, Integer, Integer> tree) {
        IterableList clusterList = new IterableList(tree.getConsecutiveIntervalData().getIntervalClusters());
        IterableList breakList = new IterableList(tree.getConsecutiveIntervalData().getBreaks());
        if (clusterList.size() == 0) {
            return;
        }
        Assertions.assertThat(breakList).hasSize(clusterList.size() - 1);
        for (int i = 0; i < clusterList.size() - 1; ++i) {
            Assertions.assertThat((Iterable)((IntervalBreak)breakList.get(i)).getPreviousIntervalCluster()).isSameAs(clusterList.get(i));
            Assertions.assertThat((Iterable)((IntervalBreak)breakList.get(i)).getNextIntervalCluster()).isSameAs(clusterList.get(i + 1));
            Assertions.assertThat((Integer)((Integer)((IntervalBreak)breakList.get(i)).getPreviousIntervalClusterEnd())).isEqualTo((Object)((IntervalCluster)clusterList.get(i)).getEnd());
            Assertions.assertThat((Integer)((Integer)((IntervalBreak)breakList.get(i)).getNextIntervalClusterStart())).isEqualTo((Object)((IntervalCluster)clusterList.get(i + 1)).getStart());
            Assertions.assertThat((Integer)((Integer)((IntervalBreak)breakList.get(i)).getLength())).isEqualTo((Integer)((IntervalCluster)clusterList.get(i + 1)).getStart() - (Integer)((IntervalCluster)clusterList.get(i)).getEnd());
        }
    }

    private static int intervalBreakCompare(IntervalBreak<TestInterval, Integer, Integer> a, IntervalBreak<TestInterval, Integer, Integer> b) {
        boolean out;
        if (a == b) {
            return 0;
        }
        if (a == null || b == null) {
            return a == null ? -1 : 1;
        }
        boolean bl = out = IntervalTreeTest.intervalClusterCompare((IntervalCluster<TestInterval, Integer, Integer>)a.getPreviousIntervalCluster(), (IntervalCluster<TestInterval, Integer, Integer>)b.getPreviousIntervalCluster()) == 0 && IntervalTreeTest.intervalClusterCompare((IntervalCluster<TestInterval, Integer, Integer>)a.getNextIntervalCluster(), (IntervalCluster<TestInterval, Integer, Integer>)b.getNextIntervalCluster()) == 0 && Objects.equals(a.getLength(), b.getLength());
        if (out) {
            return 0;
        }
        return a.hashCode() - b.hashCode();
    }

    private static int intervalClusterCompare(IntervalCluster<TestInterval, Integer, Integer> a, IntervalCluster<TestInterval, Integer, Integer> b) {
        boolean out;
        if (a == b) {
            return 0;
        }
        if (a == null || b == null) {
            return a == null ? -1 : 1;
        }
        if (!(a instanceof IntervalClusterImpl) || !(b instanceof IntervalClusterImpl)) {
            throw new IllegalArgumentException("Expected (" + a + ") and (" + b + ") to both be IntervalClusterImpl");
        }
        IntervalClusterImpl first = (IntervalClusterImpl)a;
        IntervalClusterImpl second = (IntervalClusterImpl)b;
        boolean bl = out = first.getStartSplitPoint().compareTo(second.getStartSplitPoint()) == 0 && first.getEndSplitPoint().compareTo(second.getEndSplitPoint()) == 0;
        if (out) {
            return 0;
        }
        return first.hashCode() - second.hashCode();
    }

    @Test
    void testRandomIntervals() {
        Random random = new Random(1L);
        for (int i = 0; i < 100; ++i) {
            HashMap<TestInterval, Interval> intervalToInstanceMap = new HashMap<TestInterval, Interval>();
            TreeSet<IntervalSplitPoint> splitPoints = new TreeSet<IntervalSplitPoint>();
            IntervalTree tree = new IntervalTree(TestInterval::getStart, TestInterval::getEnd, (a, b) -> b - a);
            for (int j = 0; j < 100; ++j) {
                String op;
                String old = this.formatIntervalTree((IntervalTree<TestInterval, Integer, Integer>)tree);
                int from = random.nextInt(5);
                int to = from + random.nextInt(5);
                TestInterval data = new TestInterval(from, to);
                Interval interval = intervalToInstanceMap.computeIfAbsent(data, arg_0 -> ((IntervalTree)tree).getInterval(arg_0));
                Interval treeInterval = new Interval((Object)data, TestInterval::getStart, TestInterval::getEnd);
                splitPoints.add(treeInterval.getStartSplitPoint());
                splitPoints.add(treeInterval.getEndSplitPoint());
                IntervalSplitPoint startSplitPoint = splitPoints.floor(treeInterval.getStartSplitPoint());
                IntervalSplitPoint endSplitPoint = splitPoints.floor(treeInterval.getEndSplitPoint());
                if (startSplitPoint.startIntervalToCountMap == null) {
                    startSplitPoint.createCollections();
                }
                if (endSplitPoint.endIntervalToCountMap == null) {
                    endSplitPoint.createCollections();
                }
                if (startSplitPoint.containsIntervalStarting(treeInterval) && random.nextBoolean()) {
                    op = "Remove";
                    startSplitPoint.removeIntervalStartingAtSplitPoint(treeInterval);
                    endSplitPoint.removeIntervalEndingAtSplitPoint(treeInterval);
                    if (startSplitPoint.isEmpty()) {
                        splitPoints.remove(startSplitPoint);
                    }
                    if (endSplitPoint.isEmpty()) {
                        splitPoints.remove(endSplitPoint);
                    }
                    tree.remove(interval);
                } else {
                    op = "Add";
                    startSplitPoint.addIntervalStartingAtSplitPoint(treeInterval);
                    endSplitPoint.addIntervalEndingAtSplitPoint(treeInterval);
                    tree.add(interval);
                }
                IntervalSplitPoint previous = null;
                IntervalSplitPoint current = splitPoints.isEmpty() ? null : (IntervalSplitPoint)splitPoints.first();
                ArrayList<IntervalClusterImpl> intervalClusterList = new ArrayList<IntervalClusterImpl>();
                ArrayList<IntervalBreakImpl> breakList = new ArrayList<IntervalBreakImpl>();
                while (current != null) {
                    intervalClusterList.add(new IntervalClusterImpl(splitPoints, (a, b) -> a - b, current));
                    if (previous != null) {
                        IntervalClusterImpl before = (IntervalClusterImpl)intervalClusterList.get(intervalClusterList.size() - 2);
                        IntervalClusterImpl after = (IntervalClusterImpl)intervalClusterList.get(intervalClusterList.size() - 1);
                        breakList.add(new IntervalBreakImpl((IntervalCluster)before, (IntervalCluster)after, (Comparable)Integer.valueOf((Integer)after.getStart() - (Integer)before.getEnd())));
                    }
                    previous = current;
                    current = splitPoints.higher(((IntervalClusterImpl)intervalClusterList.get(intervalClusterList.size() - 1)).getEndSplitPoint());
                }
                this.verifyBreaks((IntervalTree<TestInterval, Integer, Integer>)tree);
                ((IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)tree.getConsecutiveIntervalData().getIntervalClusters()).as(op + " interval " + interval + " to " + old, new Object[0])).usingElementComparator(IntervalTreeTest::intervalClusterCompare)).containsExactlyElementsOf(intervalClusterList);
                ((IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)tree.getConsecutiveIntervalData().getBreaks()).as(op + " interval " + interval + " to " + old, new Object[0])).usingElementComparator(IntervalTreeTest::intervalBreakCompare)).containsExactlyElementsOf(breakList);
            }
        }
    }

    private String formatIntervalTree(IntervalTree<TestInterval, Integer, Integer> intervalTree) {
        ArrayList listOfIntervalClusters = new ArrayList();
        for (IntervalCluster cluster2 : intervalTree.getConsecutiveIntervalData().getIntervalClusters()) {
            ArrayList<TestInterval> intervalsInCluster = new ArrayList<TestInterval>();
            for (TestInterval interval : cluster2) {
                intervalsInCluster.add(interval);
            }
            listOfIntervalClusters.add(intervalsInCluster);
        }
        return listOfIntervalClusters.stream().map(cluster -> cluster.stream().map(TestInterval::toString).collect(Collectors.joining(",", "[", "]"))).collect(Collectors.joining(";", "{", "}"));
    }

    private static class TestInterval {
        int start;
        int end;

        public TestInterval(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestInterval interval = (TestInterval)o;
            return this.start == interval.start && this.end == interval.end;
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end);
        }

        public String toString() {
            return "(" + this.start + ", " + this.end + ")";
        }
    }
}

