/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.coachshuttlegathering.score;

import java.util.function.Function;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.examples.coachshuttlegathering.domain.Bus;
import org.optaplanner.examples.coachshuttlegathering.domain.BusStop;
import org.optaplanner.examples.coachshuttlegathering.domain.Coach;
import org.optaplanner.examples.coachshuttlegathering.domain.Shuttle;
import org.optaplanner.examples.coachshuttlegathering.domain.StopOrHub;

public class CoachShuttleGatheringConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.coachStopLimit(constraintFactory), this.shuttleCapacity(constraintFactory), this.coachCapacity(constraintFactory), this.coachCapacityShuttleButNoShuttle(constraintFactory), this.transportTime(constraintFactory), this.shuttleDestinationIsCoachOrHub(constraintFactory), this.shuttleSetupCost(constraintFactory), this.distanceFromPrevious(constraintFactory), this.distanceBusStopToBusDestination(constraintFactory), this.distanceCoachDirectlyToDestination(constraintFactory)};
    }

    Constraint coachStopLimit(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Coach.class).join(BusStop.class, Joiners.equal(coach -> coach, BusStop::getBus)).groupBy((coach, busStop) -> coach, ConstraintCollectors.countBi()).filter((coach, stopCount) -> stopCount > coach.getStopLimit()).penalizeLong((Score)HardSoftLongScore.ONE_HARD, (coach, stopCount) -> (long)(stopCount - coach.getStopLimit()) * 1000000L).asConstraint("coachStopLimit");
    }

    Constraint shuttleCapacity(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Shuttle.class).filter(bus -> bus.getPassengerQuantityTotal() > bus.getCapacity()).penalizeLong((Score)HardSoftLongScore.ONE_HARD, bus -> (long)(bus.getPassengerQuantityTotal() - bus.getCapacity()) * 1000L).asConstraint("shuttleCapacity");
    }

    Constraint coachCapacity(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Coach.class).join(Shuttle.class).join(BusStop.class, Joiners.equal((coach, shuttle) -> shuttle.getDestination(), stop -> stop), Joiners.equal((coach, shuttle) -> coach, BusStop::getBus)).join(BusStop.class, Joiners.equal((coach, shuttle, stop) -> shuttle, BusStop::getBus)).groupBy((coach, shuttle, stop1, stop2) -> coach, ConstraintCollectors.sum((coach, shuttle, stop1, stop2) -> stop2.getPassengerQuantity())).filter((coach, shuttlePassengerQuantityTotal) -> coach.getPassengerQuantityTotal() + shuttlePassengerQuantityTotal > coach.getCapacity()).penalizeLong((Score)HardSoftLongScore.ONE_HARD, (coach, shuttlePassengerQuantityTotal) -> {
            int totalPassengerCount = coach.getPassengerQuantityTotal();
            int coachCapacity = coach.getCapacity();
            long penalty = Math.max(0L, (long)(totalPassengerCount + shuttlePassengerQuantityTotal - coachCapacity) * 1000L);
            return penalty -= Math.max(0L, (long)(totalPassengerCount - coachCapacity) * 1000L);
        }).asConstraint("coachCapacity");
    }

    Constraint coachCapacityShuttleButNoShuttle(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Coach.class).filter(coach -> coach.getPassengerQuantityTotal() > coach.getCapacity()).penalizeLong((Score)HardSoftLongScore.ONE_HARD, coach -> (long)(coach.getPassengerQuantityTotal() - coach.getCapacity()) * 1000L).asConstraint("coachCapacityShuttleButNoShuttle");
    }

    Constraint transportTime(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(BusStop.class).filter(busStop -> busStop.getTransportTimeToHub() != null && busStop.getTransportTimeRemainder() < 0).penalizeLong((Score)HardSoftLongScore.ONE_HARD, busStop -> -busStop.getTransportTimeRemainder().intValue()).asConstraint("transportTime");
    }

    Constraint shuttleDestinationIsCoachOrHub(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Shuttle.class).filter(shuttle -> shuttle.getDestination() != null).join(StopOrHub.class, Joiners.equal(Shuttle::getDestination, Function.identity())).filter((shuttle, stop) -> !stop.isVisitedByCoach()).penalizeLong((Score)HardSoftLongScore.ONE_HARD, (bus, stop) -> 1000000000L).asConstraint("shuttleDestinationIsCoachOrHub");
    }

    Constraint shuttleSetupCost(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Bus.class).filter(bus -> bus.getNextStop() != null).penalizeLong((Score)HardSoftLongScore.ONE_SOFT, Bus::getSetupCost).asConstraint("shuttleSetupCost");
    }

    Constraint distanceFromPrevious(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(BusStop.class).filter(bus -> bus.getPreviousBusOrStop() != null).penalizeLong((Score)HardSoftLongScore.ONE_SOFT, BusStop::getDistanceFromPreviousCost).asConstraint("distanceFromPrevious");
    }

    Constraint distanceBusStopToBusDestination(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(BusStop.class).filter(busStop -> busStop.getNextStop() == null).join(Bus.class, Joiners.equal(BusStop::getBus, Function.identity())).filter((busStop, bus) -> bus.getDestination() != null && bus.getNextStop() != null).penalizeLong((Score)HardSoftLongScore.ONE_SOFT, (busStop, bus) -> busStop.getDistanceToDestinationCost(bus.getDestination())).asConstraint("distanceBusStopToBusDestination");
    }

    Constraint distanceCoachDirectlyToDestination(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Coach.class).filter(coach -> coach.getDestination() != null && coach.getNextStop() == null).penalizeLong((Score)HardSoftLongScore.ONE_SOFT, Coach::getDistanceToDestinationCost).asConstraint("distanceCoachDirectlyToDestination");
    }
}

