/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.rocktour.score;

import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;
import org.optaplanner.examples.rocktour.domain.RockShow;

public class RockTourConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.requiredShow(constraintFactory), this.unassignedShow(constraintFactory), this.revenueOpportunity(constraintFactory), this.drivingTimeToShowPerSecond(constraintFactory), this.drivingTimeToBusArrivalPerSecond(constraintFactory), this.delayShowCostPerDay(constraintFactory), this.shortenDrivingTimePerMillisecondSquared(constraintFactory)};
    }

    private UniConstraintStream<RockShow> getShowWithoutDate(ConstraintFactory constraintFactory) {
        return constraintFactory.forEachIncludingNullVars(RockShow.class).filter(rockShow -> rockShow.getDate() == null);
    }

    private Constraint requiredShow(ConstraintFactory constraintFactory) {
        return this.getShowWithoutDate(constraintFactory).filter(RockShow::isRequired).penalizeConfigurable().asConstraint("Required show");
    }

    private Constraint unassignedShow(ConstraintFactory constraintFactory) {
        return this.getShowWithoutDate(constraintFactory).filter(rockShow -> rockShow.getBus() != null).penalizeConfigurable().asConstraint("Unassigned show");
    }

    private Constraint revenueOpportunity(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(RockShow.class).filter(rockShow -> rockShow.getDate() != null).rewardConfigurableLong(RockShow::getRevenueOpportunity).asConstraint("Revenue opportunity");
    }

    private Constraint delayShowCostPerDay(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(RockShow.class).filter(rockShow -> rockShow.getDate() != null).penalizeConfigurableLong(RockShow::getDaysAfterBusDeparture).asConstraint("Delay show cost per day");
    }

    private Constraint drivingTimeToShowPerSecond(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(RockShow.class).filter(rockShow -> rockShow.getPreviousStandstill() != null).penalizeConfigurableLong(RockShow::getDrivingTimeFromPreviousStandstill).asConstraint("Driving time to show per second");
    }

    private Constraint shortenDrivingTimePerMillisecondSquared(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(RockShow.class).filter(rockShow -> rockShow.getPreviousStandstill() != null).penalizeConfigurableLong(rockShow -> rockShow.getDrivingTimeFromPreviousStandstill() * rockShow.getDrivingTimeFromPreviousStandstill()).asConstraint("Shorten driving time per millisecond squared");
    }

    private Constraint drivingTimeToBusArrivalPerSecond(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(RockShow.class).filter(rockShow -> rockShow.getBus() != null).filter(rockShow -> rockShow.getNextShow() == null).penalizeConfigurableLong(RockShow::getDrivingTimeToBusArrivalLocation).asConstraint("Driving time to bus arrival per second");
    }
}

