/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.coachshuttlegathering.optional.score;

import java.util.Collections;
import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.examples.coachshuttlegathering.domain.Bus;
import org.optaplanner.examples.coachshuttlegathering.domain.BusHub;
import org.optaplanner.examples.coachshuttlegathering.domain.BusOrStop;
import org.optaplanner.examples.coachshuttlegathering.domain.BusStop;
import org.optaplanner.examples.coachshuttlegathering.domain.Coach;
import org.optaplanner.examples.coachshuttlegathering.domain.CoachShuttleGatheringSolution;
import org.optaplanner.examples.coachshuttlegathering.domain.Shuttle;
import org.optaplanner.examples.coachshuttlegathering.domain.StopOrHub;
import org.optaplanner.examples.coachshuttlegathering.domain.location.RoadLocation;
import org.optaplanner.examples.coachshuttlegathering.domain.location.RoadLocationArc;
import org.optaplanner.examples.coachshuttlegathering.optional.score.CoachShuttleGatheringConstraintProvider;
import org.optaplanner.test.api.score.stream.ConstraintVerifier;

public class CoachShuttleGatheringConstraintProviderTest {
    private final ConstraintVerifier<CoachShuttleGatheringConstraintProvider, CoachShuttleGatheringSolution> constraintVerifier = ConstraintVerifier.build((ConstraintProvider)new CoachShuttleGatheringConstraintProvider(), CoachShuttleGatheringSolution.class, (Class[])new Class[]{BusOrStop.class, StopOrHub.class, BusStop.class, Shuttle.class, Coach.class});

    @Test
    public void coachStopLimit() {
        Coach coach = new Coach();
        coach.setStopLimit(2);
        BusStop stop1 = new BusStop();
        stop1.setPreviousBusOrStop((BusOrStop)coach);
        stop1.setBus((Bus)coach);
        BusStop stop2 = new BusStop();
        stop2.setBus((Bus)coach);
        stop2.setPreviousBusOrStop((BusOrStop)coach);
        BusStop stop3 = new BusStop();
        stop3.setBus((Bus)coach);
        stop3.setPreviousBusOrStop((BusOrStop)coach);
        BusStop stop4 = new BusStop();
        stop4.setBus((Bus)coach);
        stop4.setPreviousBusOrStop((BusOrStop)coach);
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachStopLimit).given(new Object[]{coach, stop1}).penalizesBy(0L);
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachStopLimit).given(new Object[]{coach, stop1, stop2}).penalizesBy(0L);
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachStopLimit).given(new Object[]{coach, stop1, stop2, stop3}).penalizesBy(1000000L);
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachStopLimit).given(new Object[]{coach, stop1, stop2, stop3, stop4}).penalizesBy(2000000L);
    }

    @Test
    public void shuttleCapacity() {
        Shuttle shuttle = new Shuttle();
        BusStop destination = new BusStop();
        shuttle.setDestination((StopOrHub)destination);
        shuttle.setCapacity(2);
        shuttle.setPassengerQuantityTotal(Integer.valueOf(1));
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::shuttleCapacity).given(new Object[]{shuttle}).penalizesBy(0);
        shuttle.setPassengerQuantityTotal(Integer.valueOf(2));
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::shuttleCapacity).given(new Object[]{shuttle}).penalizesBy(0);
        shuttle.setPassengerQuantityTotal(Integer.valueOf(3));
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::shuttleCapacity).given(new Object[]{shuttle}).penalizesBy(1000L);
        shuttle.setPassengerQuantityTotal(Integer.valueOf(4));
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::shuttleCapacity).given(new Object[]{shuttle}).penalizesBy(2000L);
    }

    @Test
    public void coachCapacity() {
        Coach coach = new Coach();
        Shuttle shuttle = new Shuttle();
        BusStop transferStop = new BusStop();
        shuttle.setDestination((StopOrHub)transferStop);
        transferStop.setPreviousBusOrStop((BusOrStop)shuttle);
        transferStop.setBus((Bus)coach);
        BusStop shuttlePickup1 = new BusStop();
        shuttlePickup1.setPreviousBusOrStop((BusOrStop)transferStop);
        shuttlePickup1.setPassengerQuantity(1);
        shuttlePickup1.setBus((Bus)shuttle);
        BusStop shuttlePickup2 = new BusStop();
        shuttlePickup2.setPreviousBusOrStop((BusOrStop)transferStop);
        shuttlePickup2.setBus((Bus)shuttle);
        shuttlePickup2.setPassengerQuantity(2);
        BusStop shuttlePickup3 = new BusStop();
        shuttlePickup3.setPreviousBusOrStop((BusOrStop)transferStop);
        shuttlePickup3.setBus((Bus)shuttle);
        shuttlePickup3.setPassengerQuantity(3);
        coach.setCapacity(2);
        coach.setPassengerQuantityTotal(Integer.valueOf(0));
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachCapacity).given(new Object[]{coach, shuttle, transferStop}).penalizesBy(0L);
        coach.setPassengerQuantityTotal(Integer.valueOf(1));
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachCapacity).given(new Object[]{coach, shuttle, transferStop, shuttlePickup1}).penalizesBy(0L);
        coach.setPassengerQuantityTotal(Integer.valueOf(1));
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachCapacity).given(new Object[]{coach, shuttle, transferStop, shuttlePickup1, shuttlePickup2}).penalizesBy(2000L);
        coach.setPassengerQuantityTotal(Integer.valueOf(0));
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachCapacity).given(new Object[]{coach, shuttle, transferStop, shuttlePickup1, shuttlePickup2}).penalizesBy(1000L);
        coach.setPassengerQuantityTotal(Integer.valueOf(0));
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachCapacity).given(new Object[]{coach, shuttle, transferStop, shuttlePickup1, shuttlePickup2, shuttlePickup3}).penalizesBy(4000L);
        coach.setPassengerQuantityTotal(Integer.valueOf(3));
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachCapacity).given(new Object[]{coach, shuttle, transferStop, shuttlePickup1}).penalizesBy(2000L);
    }

    @Test
    public void coachCapacityCorrection() {
        Coach coach = new Coach();
        Shuttle shuttle = new Shuttle();
        BusStop transferStop = new BusStop();
        shuttle.setDestination((StopOrHub)transferStop);
        transferStop.setPreviousBusOrStop((BusOrStop)shuttle);
        transferStop.setBus((Bus)coach);
        BusStop shuttlePickup1 = new BusStop();
        shuttlePickup1.setPreviousBusOrStop((BusOrStop)transferStop);
        shuttlePickup1.setPassengerQuantity(1);
        shuttlePickup1.setBus((Bus)shuttle);
        BusStop shuttlePickup2 = new BusStop();
        shuttlePickup2.setPreviousBusOrStop((BusOrStop)transferStop);
        shuttlePickup2.setBus((Bus)shuttle);
        shuttlePickup2.setPassengerQuantity(2);
        BusStop shuttlePickup3 = new BusStop();
        shuttlePickup3.setPreviousBusOrStop((BusOrStop)transferStop);
        shuttlePickup3.setBus((Bus)shuttle);
        shuttlePickup3.setPassengerQuantity(3);
        coach.setCapacity(2);
        coach.setPassengerQuantityTotal(Integer.valueOf(0));
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachCapacityCorrection).given(new Object[]{coach, shuttle, transferStop}).rewardsWith(0L);
        coach.setPassengerQuantityTotal(Integer.valueOf(1));
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachCapacityCorrection).given(new Object[]{coach, shuttle, transferStop, shuttlePickup1}).rewardsWith(0L);
        coach.setPassengerQuantityTotal(Integer.valueOf(1));
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachCapacityCorrection).given(new Object[]{coach, shuttle, transferStop, shuttlePickup1, shuttlePickup2}).rewardsWith(0L);
        coach.setPassengerQuantityTotal(Integer.valueOf(0));
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachCapacityCorrection).given(new Object[]{coach, shuttle, transferStop, shuttlePickup1, shuttlePickup2}).rewardsWith(0L);
        coach.setPassengerQuantityTotal(Integer.valueOf(0));
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachCapacityCorrection).given(new Object[]{coach, shuttle, transferStop, shuttlePickup1, shuttlePickup2, shuttlePickup3}).rewardsWith(0L);
        coach.setPassengerQuantityTotal(Integer.valueOf(3));
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachCapacityCorrection).given(new Object[]{coach, shuttle, transferStop, shuttlePickup1}).rewardsWith(1000L);
    }

    @Test
    public void coachCapacityShuttleButNoShuttle() {
        Coach coach = new Coach();
        BusHub destination = new BusHub();
        coach.setDestination(destination);
        coach.setCapacity(2);
        coach.setPassengerQuantityTotal(Integer.valueOf(1));
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachCapacityShuttleButNoShuttle).given(new Object[]{coach}).penalizesBy(0);
        coach.setPassengerQuantityTotal(Integer.valueOf(2));
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachCapacityShuttleButNoShuttle).given(new Object[]{coach}).penalizesBy(0);
        coach.setPassengerQuantityTotal(Integer.valueOf(3));
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachCapacityShuttleButNoShuttle).given(new Object[]{coach}).penalizesBy(1000L);
        coach.setPassengerQuantityTotal(Integer.valueOf(4));
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachCapacityShuttleButNoShuttle).given(new Object[]{coach}).penalizesBy(2000L);
    }

    @Test
    public void transportTime() {
        Coach bus = new Coach();
        BusStop busStop = new BusStop();
        busStop.setPreviousBusOrStop((BusOrStop)bus);
        busStop.setBus((Bus)bus);
        busStop.setPassengerQuantity(0);
        busStop.setTransportTimeLimit(5);
        busStop.setTransportTimeToHub(null);
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::transportTime).given(new Object[]{busStop}).penalizesBy(0L);
        busStop.setTransportTimeToHub(Integer.valueOf(10));
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::transportTime).given(new Object[]{busStop}).penalizesBy(0L);
        busStop.setPassengerQuantity(1);
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::transportTime).given(new Object[]{busStop}).penalizesBy(5L);
    }

    @Test
    public void shuttleDestinationIsCoachOrHub() {
        Shuttle shuttle = new Shuttle();
        Coach coach = new Coach();
        BusStop destination = new BusStop();
        shuttle.setDestination((StopOrHub)destination);
        destination.setPreviousBusOrStop((BusOrStop)shuttle);
        destination.setBus((Bus)shuttle);
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::shuttleDestinationIsCoachOrHub).given(new Object[]{shuttle, destination}).penalizesBy(1000000000L);
        destination.setBus((Bus)coach);
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::shuttleDestinationIsCoachOrHub).given(new Object[]{shuttle, destination}).penalizesBy(0L);
    }

    @Test
    public void shuttleSetupCost() {
        Shuttle shuttle = new Shuttle();
        Coach coach = new Coach();
        BusStop destination = new BusStop();
        coach.setNextStop(destination);
        shuttle.setNextStop(destination);
        shuttle.setSetupCost(2);
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::shuttleSetupCost).given(new Object[]{shuttle}).penalizesBy(2L);
        shuttle.setSetupCost(3);
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::shuttleSetupCost).given(new Object[]{shuttle}).penalizesBy(3L);
        shuttle.setNextStop(null);
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::shuttleSetupCost).given(new Object[]{shuttle}).penalizesBy(0L);
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::shuttleSetupCost).given(new Object[]{coach}).penalizesBy(0L);
    }

    @Test
    public void distanceFromPrevious() {
        Coach bus = new Coach();
        BusStop busStop = new BusStop();
        RoadLocation busLocation = new RoadLocation(0L, 1.0, 0.0);
        RoadLocation busStopLocation = new RoadLocation(0L, 5.0, 0.0);
        RoadLocationArc distance = new RoadLocationArc();
        distance.setCoachDistance(1);
        distance.setCoachDuration(1);
        distance.setShuttleDistance(1);
        distance.setShuttleDuration(1);
        busStopLocation.setTravelDistanceMap(Collections.singletonMap(busLocation, distance));
        busLocation.setTravelDistanceMap(Collections.singletonMap(busStopLocation, distance));
        bus.setDepartureLocation(busLocation);
        busStop.setLocation(busStopLocation);
        bus.setMileageCost(1);
        busStop.setPreviousBusOrStop((BusOrStop)bus);
        busStop.setBus((Bus)bus);
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::distanceFromPrevious).given(new Object[]{busStop}).penalizesBy(1L);
    }

    @Test
    public void distanceBusStopToBusDestination() {
        Coach bus = new Coach();
        BusStop busStop = new BusStop();
        BusHub busHub = new BusHub();
        RoadLocation busHubLocation = new RoadLocation(0L, 1.0, 0.0);
        RoadLocation busStopLocation = new RoadLocation(0L, 5.0, 0.0);
        RoadLocationArc distance = new RoadLocationArc();
        distance.setCoachDistance(1);
        distance.setCoachDuration(1);
        distance.setShuttleDistance(1);
        distance.setShuttleDuration(1);
        busStopLocation.setTravelDistanceMap(Collections.singletonMap(busHubLocation, distance));
        busHubLocation.setTravelDistanceMap(Collections.singletonMap(busStopLocation, distance));
        busHub.setLocation(busHubLocation);
        bus.setDestination(busHub);
        bus.setNextStop(busStop);
        busStop.setLocation(busStopLocation);
        bus.setMileageCost(1);
        busStop.setPreviousBusOrStop((BusOrStop)bus);
        busStop.setBus((Bus)bus);
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::distanceBusStopToBusDestination).given(new Object[]{busStop, bus}).penalizesBy(1L);
    }

    @Test
    public void distanceCoachDirectlyToDestination() {
        Coach bus = new Coach();
        BusHub busHub = new BusHub();
        RoadLocation busHubLocation = new RoadLocation(0L, 1.0, 0.0);
        RoadLocation busLocation = new RoadLocation(0L, 5.0, 0.0);
        RoadLocationArc distance = new RoadLocationArc();
        distance.setCoachDistance(1);
        distance.setCoachDuration(1);
        distance.setShuttleDistance(1);
        distance.setShuttleDuration(1);
        busLocation.setTravelDistanceMap(Collections.singletonMap(busHubLocation, distance));
        busHubLocation.setTravelDistanceMap(Collections.singletonMap(busLocation, distance));
        bus.setDepartureLocation(busLocation);
        busHub.setLocation(busHubLocation);
        bus.setDestination(busHub);
        bus.setMileageCost(1);
        this.constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::distanceCoachDirectlyToDestination).given(new Object[]{bus}).penalizesBy(1L);
    }
}

