/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.pas.optional.score;

import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.examples.pas.domain.AdmissionPart;
import org.optaplanner.examples.pas.domain.Bed;
import org.optaplanner.examples.pas.domain.BedDesignation;
import org.optaplanner.examples.pas.domain.Department;
import org.optaplanner.examples.pas.domain.DepartmentSpecialism;
import org.optaplanner.examples.pas.domain.Equipment;
import org.optaplanner.examples.pas.domain.Gender;
import org.optaplanner.examples.pas.domain.GenderLimitation;
import org.optaplanner.examples.pas.domain.Night;
import org.optaplanner.examples.pas.domain.Patient;
import org.optaplanner.examples.pas.domain.PatientAdmissionSchedule;
import org.optaplanner.examples.pas.domain.PreferredPatientEquipment;
import org.optaplanner.examples.pas.domain.RequiredPatientEquipment;
import org.optaplanner.examples.pas.domain.Room;
import org.optaplanner.examples.pas.domain.RoomEquipment;
import org.optaplanner.examples.pas.domain.RoomSpecialism;
import org.optaplanner.examples.pas.domain.Specialism;
import org.optaplanner.examples.pas.optional.score.PatientAdmissionScheduleConstraintProvider;
import org.optaplanner.test.api.score.stream.ConstraintVerifier;

public class PatientAdmissionScheduleConstraintProviderTest {
    private static final Night ZERO_NIGHT = new Night(0);
    private static final Night FIVE_NIGHT = new Night(5);
    private static final Specialism DEFAULT_SPECIALISM = new Specialism();
    private final ConstraintVerifier<PatientAdmissionScheduleConstraintProvider, PatientAdmissionSchedule> constraintVerifier = ConstraintVerifier.build((ConstraintProvider)new PatientAdmissionScheduleConstraintProvider(), PatientAdmissionSchedule.class, (Class[])new Class[]{BedDesignation.class});

    private static Stream genderLimitationsProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{Gender.FEMALE, GenderLimitation.MALE_ONLY, PatientAdmissionScheduleConstraintProvider::femaleInMaleRoomConstraint}), Arguments.of((Object[])new Object[]{Gender.MALE, GenderLimitation.FEMALE_ONLY, PatientAdmissionScheduleConstraintProvider::maleInFemaleRoomConstraint}));
    }

    private static Stream departmentAgeLimitationProvider() {
        Department adultDepartment = new Department();
        adultDepartment.setMinimumAge(Integer.valueOf(18));
        adultDepartment.setId(Long.valueOf(1L));
        Department underageDepartment = new Department();
        underageDepartment.setMaximumAge(Integer.valueOf(18));
        underageDepartment.setId(Long.valueOf(1L));
        return Stream.of(Arguments.of((Object[])new Object[]{adultDepartment, 5, PatientAdmissionScheduleConstraintProvider::departmentMinimumAgeConstraint}), Arguments.of((Object[])new Object[]{underageDepartment, 42, PatientAdmissionScheduleConstraintProvider::departmentMaximumAgeConstraint}));
    }

    @ParameterizedTest
    @MethodSource(value={"genderLimitationsProvider"})
    public void genderRoomLimitationConstraintTest(Gender gender, GenderLimitation genderLimitation, BiFunction constraintFunction) {
        Room room = new Room();
        room.setGenderLimitation(genderLimitation);
        Bed bed = new Bed();
        bed.setRoom(room);
        Patient patient = new Patient();
        patient.setGender(gender);
        AdmissionPart genderAdmission = new AdmissionPart(patient, ZERO_NIGHT, FIVE_NIGHT, DEFAULT_SPECIALISM);
        BedDesignation genderLimitationDesignation = new BedDesignation(genderAdmission, bed);
        this.constraintVerifier.verifyThat(constraintFunction).given(new Object[]{genderLimitationDesignation}).penalizesBy(6);
    }

    @Test
    public void sameBedInSameNightConstraintTest() {
        Patient patient = new Patient();
        Bed bed = new Bed();
        AdmissionPart admissionPart = new AdmissionPart(patient, ZERO_NIGHT, FIVE_NIGHT, DEFAULT_SPECIALISM);
        BedDesignation designation = new BedDesignation(1L, admissionPart, bed);
        BedDesignation sameBedAndNightsDesignation = new BedDesignation(2L, admissionPart, bed);
        this.constraintVerifier.verifyThat(PatientAdmissionScheduleConstraintProvider::sameBedInSameNightConstraint).given(new Object[]{designation, sameBedAndNightsDesignation}).penalizesBy(6);
    }

    @ParameterizedTest
    @MethodSource(value={"departmentAgeLimitationProvider"})
    public void departmentAgeLimitationConstraintTest(Department department, int patientAge, BiFunction constraintFunction) {
        Room room = new Room();
        room.setDepartment(department);
        Patient patient = new Patient();
        patient.setAge(patientAge);
        Bed bed = new Bed();
        bed.setRoom(room);
        AdmissionPart admission = new AdmissionPart(patient, ZERO_NIGHT, FIVE_NIGHT, DEFAULT_SPECIALISM);
        BedDesignation designation = new BedDesignation(admission, bed);
        this.constraintVerifier.verifyThat(constraintFunction).given(new Object[]{designation, department}).penalizesBy(6);
    }

    @Test
    public void requiredPatientEquipmentConstraintTest() {
        Patient patient = new Patient();
        Room room = new Room();
        Equipment equipment1 = new Equipment();
        Equipment equipment2 = new Equipment();
        Bed bed = new Bed();
        bed.setRoom(room);
        AdmissionPart admission = new AdmissionPart(patient, ZERO_NIGHT, FIVE_NIGHT, DEFAULT_SPECIALISM);
        BedDesignation designation = new BedDesignation(admission, bed);
        RequiredPatientEquipment requiredPatientEquipment1 = new RequiredPatientEquipment();
        requiredPatientEquipment1.setPatient(patient);
        requiredPatientEquipment1.setEquipment(equipment1);
        RequiredPatientEquipment requiredPatientEquipment2 = new RequiredPatientEquipment();
        requiredPatientEquipment2.setPatient(patient);
        requiredPatientEquipment2.setEquipment(equipment2);
        RoomEquipment roomEquipment = new RoomEquipment();
        roomEquipment.setEquipment(equipment2);
        roomEquipment.setRoom(room);
        this.constraintVerifier.verifyThat(PatientAdmissionScheduleConstraintProvider::requiredPatientEquipmentConstraint).given(new Object[]{requiredPatientEquipment1, requiredPatientEquipment2, roomEquipment, designation}).penalizesBy(6);
    }

    @Test
    public void differentGenderInSameGenderRoomInSameNightConstraintTest() {
        Room room = new Room();
        room.setGenderLimitation(GenderLimitation.SAME_GENDER);
        Patient female = new Patient();
        female.setGender(Gender.FEMALE);
        Bed bed1 = new Bed();
        bed1.setRoom(room);
        AdmissionPart admissionPartFemale = new AdmissionPart(female, ZERO_NIGHT, FIVE_NIGHT, DEFAULT_SPECIALISM);
        BedDesignation bedDesignationFemale = new BedDesignation(1L, admissionPartFemale, bed1);
        Patient male = new Patient();
        male.setGender(Gender.MALE);
        Bed bed2 = new Bed();
        bed2.setRoom(room);
        AdmissionPart admissionPartMale = new AdmissionPart(male, ZERO_NIGHT, FIVE_NIGHT, DEFAULT_SPECIALISM);
        BedDesignation bedDesignationMale = new BedDesignation(2L, admissionPartMale, bed2);
        this.constraintVerifier.verifyThat(PatientAdmissionScheduleConstraintProvider::differentGenderInSameGenderRoomInSameNightConstraint).given(new Object[]{bedDesignationFemale, bedDesignationMale}).penalizesBy(6);
    }

    @Test
    public void assignEveryPatientToABedConstraintTest() {
        Patient patient = new Patient();
        AdmissionPart admissionPart = new AdmissionPart(patient, ZERO_NIGHT, FIVE_NIGHT, DEFAULT_SPECIALISM);
        BedDesignation bedUnassignedDesignation = new BedDesignation(2L, admissionPart, null);
        this.constraintVerifier.verifyThat(PatientAdmissionScheduleConstraintProvider::assignEveryPatientToABedConstraint).given(new Object[]{bedUnassignedDesignation}).penalizesBy(6);
    }

    @Test
    public void preferredMaximumRoomCapacityConstraintTest() {
        Patient patientWithRoomPreferences = new Patient();
        patientWithRoomPreferences.setPreferredMaximumRoomCapacity(Integer.valueOf(3));
        Room room = new Room();
        room.setCapacity(6);
        Bed assignedBedInExceedCapacity = new Bed();
        assignedBedInExceedCapacity.setRoom(room);
        AdmissionPart admissionPart = new AdmissionPart(patientWithRoomPreferences, ZERO_NIGHT, FIVE_NIGHT, DEFAULT_SPECIALISM);
        BedDesignation bedDesignation = new BedDesignation(admissionPart, assignedBedInExceedCapacity);
        this.constraintVerifier.verifyThat(PatientAdmissionScheduleConstraintProvider::preferredMaximumRoomCapacityConstraint).given(new Object[]{bedDesignation}).penalizesBy(6);
    }

    @Test
    public void preferredPatientEquipmentConstraintTest() {
        Patient patient = new Patient();
        Room room = new Room();
        Bed bed = new Bed();
        bed.setRoom(room);
        AdmissionPart admissionPart = new AdmissionPart(patient, ZERO_NIGHT, FIVE_NIGHT, DEFAULT_SPECIALISM);
        BedDesignation bedDesignation = new BedDesignation(admissionPart, bed);
        Equipment equipment1 = new Equipment();
        Equipment equipment2 = new Equipment();
        PreferredPatientEquipment preferredPatientEquipment1 = new PreferredPatientEquipment();
        preferredPatientEquipment1.setEquipment(equipment1);
        preferredPatientEquipment1.setPatient(patient);
        PreferredPatientEquipment preferredPatientEquipment2 = new PreferredPatientEquipment();
        preferredPatientEquipment2.setEquipment(equipment2);
        preferredPatientEquipment2.setPatient(patient);
        RoomEquipment roomEquippedOnlyByOneEq = new RoomEquipment();
        roomEquippedOnlyByOneEq.setEquipment(equipment2);
        roomEquippedOnlyByOneEq.setRoom(room);
        this.constraintVerifier.verifyThat(PatientAdmissionScheduleConstraintProvider::preferredPatientEquipmentConstraint).given(new Object[]{preferredPatientEquipment1, preferredPatientEquipment2, roomEquippedOnlyByOneEq, bedDesignation}).penalizesBy(6);
    }

    @Test
    public void departmentSpecialismConstraintTest() {
        Patient patient = new Patient();
        Department department = new Department();
        Room roomInDep = new Room();
        roomInDep.setDepartment(department);
        Bed bedInRoomInDep = new Bed();
        bedInRoomInDep.setRoom(roomInDep);
        Specialism spec1 = new Specialism();
        AdmissionPart admissionPartSpec1 = new AdmissionPart(patient, ZERO_NIGHT, FIVE_NIGHT, spec1);
        BedDesignation designationWithDepartmentSpecialism1 = new BedDesignation(admissionPartSpec1, bedInRoomInDep);
        Specialism spec2 = new Specialism();
        AdmissionPart admissionPartSpec2 = new AdmissionPart(patient, ZERO_NIGHT, FIVE_NIGHT, spec2);
        BedDesignation designationWithDepartmentSpecialism2 = new BedDesignation(admissionPartSpec2, bedInRoomInDep);
        DepartmentSpecialism departmentSpecialismWithOneSpec = new DepartmentSpecialism();
        departmentSpecialismWithOneSpec.setDepartment(department);
        departmentSpecialismWithOneSpec.setSpecialism(spec1);
        this.constraintVerifier.verifyThat(PatientAdmissionScheduleConstraintProvider::departmentSpecialismConstraint).given(new Object[]{designationWithDepartmentSpecialism1, designationWithDepartmentSpecialism2, departmentSpecialismWithOneSpec}).penalizesBy(6);
    }

    @Test
    public void roomSpecialismConstraintTest() {
        Patient patient = new Patient();
        Room roomInDep = new Room();
        Bed bedInDep = new Bed();
        bedInDep.setRoom(roomInDep);
        Specialism spec1 = new Specialism();
        AdmissionPart admissionPart = new AdmissionPart(patient, ZERO_NIGHT, FIVE_NIGHT, spec1);
        BedDesignation designationWithRoomSpecialism1 = new BedDesignation(2L, admissionPart, bedInDep);
        Specialism spec2 = new Specialism();
        AdmissionPart admissionPart2 = new AdmissionPart(patient, ZERO_NIGHT, FIVE_NIGHT, spec2);
        BedDesignation designationWithRoomSpecialism2 = new BedDesignation(2L, admissionPart2, bedInDep);
        RoomSpecialism roomSpecialism = new RoomSpecialism();
        roomSpecialism.setRoom(roomInDep);
        roomSpecialism.setSpecialism(spec1);
        this.constraintVerifier.verifyThat(PatientAdmissionScheduleConstraintProvider::roomSpecialismNotExistsConstraint).given(new Object[]{designationWithRoomSpecialism1, designationWithRoomSpecialism2, roomSpecialism}).penalizesBy(6);
    }

    @Test
    public void roomSpecialismNotFirstPriorityConstraintConstraintTest() {
        Patient patient = new Patient();
        Room roomInDep = new Room();
        Bed bedInDep = new Bed();
        bedInDep.setRoom(roomInDep);
        Specialism spec1 = new Specialism();
        AdmissionPart admissionPart1 = new AdmissionPart(patient, ZERO_NIGHT, FIVE_NIGHT, spec1);
        BedDesignation designationWithRoomSpecialism1 = new BedDesignation(admissionPart1, bedInDep);
        Specialism spec2 = new Specialism();
        AdmissionPart admissionPart2 = new AdmissionPart(patient, ZERO_NIGHT, FIVE_NIGHT, spec2);
        BedDesignation designationWithRoomSpecialism2 = new BedDesignation(admissionPart2, bedInDep);
        RoomSpecialism roomSpecialism = new RoomSpecialism();
        roomSpecialism.setRoom(roomInDep);
        roomSpecialism.setSpecialism(spec1);
        roomSpecialism.setPriority(2);
        this.constraintVerifier.verifyThat(PatientAdmissionScheduleConstraintProvider::roomSpecialismNotFirstPriorityConstraint).given(new Object[]{designationWithRoomSpecialism1, designationWithRoomSpecialism2, roomSpecialism}).penalizesBy(6);
    }
}

