/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nqueens.score;

import java.io.IOException;
import java.io.InputStream;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.examples.common.score.AbstractConstraintProviderTest;
import org.optaplanner.examples.common.score.ConstraintProviderTest;
import org.optaplanner.examples.nqueens.domain.Column;
import org.optaplanner.examples.nqueens.domain.NQueens;
import org.optaplanner.examples.nqueens.domain.Queen;
import org.optaplanner.examples.nqueens.domain.Row;
import org.optaplanner.examples.nqueens.score.NQueensConstraintProvider;
import org.optaplanner.persistence.xstream.impl.domain.solution.XStreamSolutionFileIO;
import org.optaplanner.test.api.score.stream.ConstraintVerifier;

class NQueensConstraintProviderTest
extends AbstractConstraintProviderTest<NQueensConstraintProvider, NQueens> {
    private final Row row1 = new Row(0);
    private final Row row2 = new Row(1);
    private final Row row3 = new Row(2);
    private final Column column1 = new Column(0);
    private final Column column2 = new Column(1);
    private final Column column3 = new Column(2);

    NQueensConstraintProviderTest() {
    }

    @ConstraintProviderTest
    void noHorizontalConflictWithOneQueen(ConstraintVerifier<NQueensConstraintProvider, NQueens> constraintVerifier) {
        Queen queen1 = new Queen(0L, this.row1, this.column1);
        constraintVerifier.verifyThat(NQueensConstraintProvider::horizontalConflict).given(new Object[]{queen1}).penalizesBy(0);
    }

    @ConstraintProviderTest
    void horizontalConflictWithTwoQueens(ConstraintVerifier<NQueensConstraintProvider, NQueens> constraintVerifier) {
        Queen queen1 = new Queen(0L, this.row1, this.column1);
        Queen queen2 = new Queen(1L, this.row1, this.column2);
        constraintVerifier.verifyThat(NQueensConstraintProvider::horizontalConflict).given(new Object[]{queen1, queen2}).penalizesBy(1);
    }

    @ConstraintProviderTest
    void horizontalConflictWithThreeQueens(ConstraintVerifier<NQueensConstraintProvider, NQueens> constraintVerifier) {
        Queen queen1 = new Queen(0L, this.row1, this.column1);
        Queen queen2 = new Queen(1L, this.row1, this.column2);
        Queen queen3 = new Queen(2L, this.row1, this.column3);
        constraintVerifier.verifyThat(NQueensConstraintProvider::horizontalConflict).given(new Object[]{queen1, queen2, queen3}).penalizesBy(3);
    }

    @ConstraintProviderTest
    void noAscendingDiagonalConflictWithOneQueen(ConstraintVerifier<NQueensConstraintProvider, NQueens> constraintVerifier) {
        Queen queen1 = new Queen(0L, this.row1, this.column1);
        constraintVerifier.verifyThat(NQueensConstraintProvider::ascendingDiagonalConflict).given(new Object[]{queen1}).penalizesBy(0);
    }

    @ConstraintProviderTest
    void ascendingDiagonalConflictWithTwoQueens(ConstraintVerifier<NQueensConstraintProvider, NQueens> constraintVerifier) {
        Queen queen1 = new Queen(0L, this.row1, this.column2);
        Queen queen2 = new Queen(1L, this.row2, this.column1);
        constraintVerifier.verifyThat(NQueensConstraintProvider::ascendingDiagonalConflict).given(new Object[]{queen1, queen2}).penalizesBy(1);
    }

    @ConstraintProviderTest
    void ascendingDiagonalConflictWithThreeQueens(ConstraintVerifier<NQueensConstraintProvider, NQueens> constraintVerifier) {
        Queen queen1 = new Queen(0L, this.row1, this.column3);
        Queen queen2 = new Queen(1L, this.row2, this.column2);
        Queen queen3 = new Queen(2L, this.row3, this.column1);
        constraintVerifier.verifyThat(NQueensConstraintProvider::ascendingDiagonalConflict).given(new Object[]{queen1, queen2, queen3}).penalizesBy(3);
    }

    @ConstraintProviderTest
    void noDescendingDiagonalConflictWithOneQueen(ConstraintVerifier<NQueensConstraintProvider, NQueens> constraintVerifier) {
        Queen queen1 = new Queen(0L, this.row1, this.column1);
        constraintVerifier.verifyThat(NQueensConstraintProvider::descendingDiagonalConflict).given(new Object[]{queen1}).penalizesBy(0);
    }

    @ConstraintProviderTest
    void descendingDiagonalConflictWithTwoQueens(ConstraintVerifier<NQueensConstraintProvider, NQueens> constraintVerifier) {
        Queen queen1 = new Queen(0L, this.row1, this.column1);
        Queen queen2 = new Queen(1L, this.row2, this.column2);
        constraintVerifier.verifyThat(NQueensConstraintProvider::descendingDiagonalConflict).given(new Object[]{queen1, queen2}).penalizesBy(1);
    }

    @ConstraintProviderTest
    void descendingDiagonalConflictWithThreeQueens(ConstraintVerifier<NQueensConstraintProvider, NQueens> constraintVerifier) {
        Queen queen1 = new Queen(0L, this.row1, this.column1);
        Queen queen2 = new Queen(1L, this.row2, this.column2);
        Queen queen3 = new Queen(2L, this.row3, this.column3);
        constraintVerifier.verifyThat(NQueensConstraintProvider::descendingDiagonalConflict).given(new Object[]{queen1, queen2, queen3}).penalizesBy(3);
    }

    private static NQueens readSolution(String resource) throws IOException {
        XStreamSolutionFileIO solutionFileIO = new XStreamSolutionFileIO(new Class[]{NQueens.class});
        try (InputStream inputStream = NQueensConstraintProviderTest.class.getResourceAsStream(resource);){
            NQueens nQueens = (NQueens)solutionFileIO.read(inputStream);
            return nQueens;
        }
    }

    @ConstraintProviderTest
    void givenSolutionMultipleConstraints(ConstraintVerifier<NQueensConstraintProvider, NQueens> constraintVerifier) throws IOException {
        constraintVerifier.verifyThat().givenSolution((Object)NQueensConstraintProviderTest.readSolution("256queensScore-30.xml")).scores((Score)SimpleScore.of((int)-30));
    }

    @ConstraintProviderTest
    void givenFactsMultipleConstraints(ConstraintVerifier<NQueensConstraintProvider, NQueens> constraintVerifier) {
        Queen queen1 = new Queen(0L, this.row1, this.column1);
        Queen queen2 = new Queen(1L, this.row2, this.column2);
        Queen queen3 = new Queen(2L, this.row3, this.column3);
        constraintVerifier.verifyThat().given(new Object[]{queen1, queen2, queen3}).scores((Score)SimpleScore.of((int)-3));
    }

    @Override
    protected ConstraintVerifier<NQueensConstraintProvider, NQueens> createConstraintVerifier() {
        return ConstraintVerifier.build((ConstraintProvider)new NQueensConstraintProvider(), NQueens.class, (Class[])new Class[]{Queen.class});
    }
}

