/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.persistence;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.segmented.HubSegmentLocation;
import org.optaplanner.examples.vehiclerouting.domain.location.segmented.RoadSegmentLocation;
import org.optaplanner.examples.vehiclerouting.persistence.VehicleRoutingSolutionFileIO;

class VehicleRoutingSolutionFileIOTest {
    private static final String SEGMENTED_VRP_RESOURCE = "vehiclerouting-segmented.json";

    VehicleRoutingSolutionFileIOTest() {
    }

    @Test
    void deserializeSegmentedLocations() throws IOException {
        VehicleRoutingSolution deserializedVehicleRoutingSolution = VehicleRoutingSolutionFileIOTest.readSolution(SEGMENTED_VRP_RESOURCE);
        List deserializedLocationList = deserializedVehicleRoutingSolution.getLocationList();
        HubSegmentLocation deserializedDepotSegmentLocation = (HubSegmentLocation)deserializedLocationList.get(0);
        HubSegmentLocation deserializedCustomerSegmentLocation = (HubSegmentLocation)deserializedLocationList.get(1);
        RoadSegmentLocation deserializedRoadSegmentLocation = (RoadSegmentLocation)deserializedLocationList.get(2);
        Assertions.assertThat((Map)deserializedDepotSegmentLocation.getHubTravelDistanceMap()).hasSize(1);
        Assertions.assertThat((Map)deserializedDepotSegmentLocation.getNearbyTravelDistanceMap()).hasSize(1);
        Assertions.assertThat((Map)deserializedCustomerSegmentLocation.getHubTravelDistanceMap()).hasSize(1);
        Assertions.assertThat((Map)deserializedCustomerSegmentLocation.getNearbyTravelDistanceMap()).hasSize(1);
        Assertions.assertThat((Map)deserializedRoadSegmentLocation.getHubTravelDistanceMap()).hasSize(2);
        IdentityHashMap identityMap = new IdentityHashMap();
        deserializedLocationList.forEach(location -> identityMap.put(location, location));
        deserializedVehicleRoutingSolution.getCustomerList().forEach(customer -> identityMap.put(customer.getLocation(), customer.getLocation()));
        deserializedDepotSegmentLocation.getHubTravelDistanceMap().keySet().forEach(segmentLocation -> identityMap.put(segmentLocation, segmentLocation));
        deserializedDepotSegmentLocation.getNearbyTravelDistanceMap().keySet().forEach(segmentLocation -> identityMap.put(segmentLocation, segmentLocation));
        deserializedCustomerSegmentLocation.getHubTravelDistanceMap().keySet().forEach(segmentLocation -> identityMap.put(segmentLocation, segmentLocation));
        deserializedCustomerSegmentLocation.getNearbyTravelDistanceMap().keySet().forEach(segmentLocation -> identityMap.put(segmentLocation, segmentLocation));
        deserializedRoadSegmentLocation.getHubTravelDistanceMap().keySet().forEach(segmentLocation -> identityMap.put(segmentLocation, segmentLocation));
        Assertions.assertThat(identityMap).hasSize(3);
    }

    private static VehicleRoutingSolution readSolution(String resource) throws IOException {
        URL resourceUrl = VehicleRoutingSolutionFileIOTest.class.getResource(resource);
        try {
            File file = Paths.get(Objects.requireNonNull(resourceUrl).toURI()).toFile();
            VehicleRoutingSolutionFileIO solutionFileIO = new VehicleRoutingSolutionFileIO();
            return solutionFileIO.read(file);
        }
        catch (URISyntaxException e) {
            throw new IOException("Unable to read the test resource ( " + resource + " ).", e);
        }
    }
}

